/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.combinebitmap;

import android.content.Context;
import android.graphics.Bitmap;
import com.yy.base.imageloader.ImageLoader;
import com.yy.hiyo.channel.combinebitmap.Builder;
import com.yy.hiyo.channel.combinebitmap.CompressHelper;
import java.util.ArrayList;

public class CombineHelper {
    public static CombineHelper init() {
        return SingletonHolder.instance;
    }

    private CombineHelper() {
    }

    private void loadByUrls(final Builder builder) {
        int subSize = builder.subSize;
        Bitmap defaultBitmap = null;
        if (builder.placeholder != 0) {
            defaultBitmap = CompressHelper.getInstance().compressResource(builder.context.getResources(), builder.placeholder, subSize, subSize);
        }
        final Bitmap placeHolderBitmap = defaultBitmap;
        final ArrayList bitmapList = new ArrayList();
        for (String url : builder.urls) {
            ImageLoader.loadBitmap((Context)builder.context, (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onLoadFailed(Exception e) {
                    bitmapList.add(placeHolderBitmap);
                }

                public void onResourceReady(Bitmap bitmap) {
                    bitmapList.add(bitmap);
                    if (bitmapList.size() == builder.urls.length) {
                        ArrayList<Bitmap> resultList = new ArrayList<Bitmap>();
                        for (Bitmap result : bitmapList) {
                            if (result == null) continue;
                            resultList.add(result);
                        }
                        Bitmap[] array = new Bitmap[builder.urls.length];
                        CombineHelper.this.setBitmap(builder, resultList.toArray(array));
                    }
                }
            });
        }
    }

    private void loadByResBitmaps(Builder builder) {
        int subSize = builder.subSize;
        Bitmap[] compressedBitmaps = new Bitmap[builder.count];
        for (int i = 0; i < builder.count; ++i) {
            if (builder.resourceIds != null) {
                compressedBitmaps[i] = CompressHelper.getInstance().compressResource(builder.context.getResources(), builder.resourceIds[i], subSize, subSize);
                continue;
            }
            if (builder.bitmaps == null) continue;
            compressedBitmaps[i] = CompressHelper.getInstance().compressResource(builder.bitmaps[i], subSize, subSize);
        }
        this.setBitmap(builder, compressedBitmaps);
    }

    public void load(Builder builder) {
        if (builder.progressListener != null) {
            builder.progressListener.onStart();
        }
        if (builder.urls != null) {
            this.loadByUrls(builder);
        } else {
            this.loadByResBitmaps(builder);
        }
    }

    private void setBitmap(Builder b, Bitmap[] bitmaps) {
        Bitmap result = b.layoutManager.combineBitmap(b.size, b.subSize, b.gap, b.gapColor, bitmaps);
        if (b.progressListener != null) {
            b.progressListener.onComplete(result);
        }
        if (b.imageView != null) {
            b.imageView.setImageBitmap(result);
        }
    }

    private static class SingletonHolder {
        private static final CombineHelper instance = new CombineHelper();

        private SingletonHolder() {
        }
    }
}

