/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.rolepermission;

import androidx.collection.ArraySet;
import com.yy.hiyo.channel.base.rolepermission.RolePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public enum RoleSession {
    NONE(1, RolePermission.INPUT),
    GUEST(1, RolePermission.INPUT, RolePermission.JOIN),
    MEMBER(5, RolePermission.INPUT, RolePermission.JOIN),
    VIP(5, RolePermission.INPUT, RolePermission.JOIN),
    MASTER(10, RolePermission.SET_ROLE, RolePermission.KICK_OUT_CHANNEL, RolePermission.UPDATE_JOIN_MODE, RolePermission.UPDATE_INPUT_MODE, RolePermission.BAN_INPUT, RolePermission.MANAGE_SEAT),
    OWNER(15, RolePermission.ADD_DELETE_CHANNEL, RolePermission.UPDATE_CHANNEL_NAME, RolePermission.UPDATE_CHANNEL_ANNOUNCEMENT, RolePermission.KICK_OUT_CHANNEL, RolePermission.SET_ROLE, RolePermission.UPDATE_JOIN_MODE, RolePermission.UPDATE_INPUT_MODE, RolePermission.BAN_INPUT, RolePermission.MANAGE_SEAT),
    ANCHOR_OWNER(15, RolePermission.ADD_DELETE_CHANNEL, RolePermission.UPDATE_CHANNEL_NAME, RolePermission.UPDATE_CHANNEL_ANNOUNCEMENT, RolePermission.KICK_OUT_CHANNEL, RolePermission.SET_ROLE, RolePermission.UPDATE_JOIN_MODE, RolePermission.UPDATE_INPUT_MODE, RolePermission.BAN_INPUT, RolePermission.MANAGE_SEAT),
    ANCHOR_MASTER(10, RolePermission.ADD_DELETE_CHANNEL, RolePermission.UPDATE_CHANNEL_NAME, RolePermission.UPDATE_CHANNEL_ANNOUNCEMENT, RolePermission.KICK_OUT_CHANNEL, RolePermission.SET_ROLE, RolePermission.UPDATE_JOIN_MODE, RolePermission.UPDATE_INPUT_MODE, RolePermission.BAN_INPUT, RolePermission.MANAGE_SEAT),
    ANCHOR_MEMBER(5, RolePermission.ADD_DELETE_CHANNEL, RolePermission.UPDATE_CHANNEL_NAME, RolePermission.UPDATE_CHANNEL_ANNOUNCEMENT, RolePermission.KICK_OUT_CHANNEL, RolePermission.SET_ROLE, RolePermission.UPDATE_JOIN_MODE, RolePermission.UPDATE_INPUT_MODE, RolePermission.BAN_INPUT, RolePermission.MANAGE_SEAT),
    ANCHOR_GUEST(1, RolePermission.ADD_DELETE_CHANNEL, RolePermission.UPDATE_CHANNEL_NAME, RolePermission.UPDATE_CHANNEL_ANNOUNCEMENT, RolePermission.KICK_OUT_CHANNEL, RolePermission.SET_ROLE, RolePermission.UPDATE_JOIN_MODE, RolePermission.UPDATE_INPUT_MODE, RolePermission.BAN_INPUT, RolePermission.MANAGE_SEAT);

    private final int mRole;
    private final Set<RolePermission> mPermissions;

    private RoleSession(int role, RolePermission ... permissions) {
        this.mRole = role;
        this.mPermissions = Collections.unmodifiableSet(new ArraySet(Arrays.asList(permissions)));
    }

    public int getRole() {
        return this.mRole;
    }

    public Set<RolePermission> getPermissions() {
        return this.mPermissions;
    }

    public boolean hasPermission(RolePermission permission) {
        return this.mPermissions.contains((Object)permission);
    }

    public static RoleSession getSession(int role, boolean isAnchor) {
        if (isAnchor) {
            switch (role) {
                case 15: {
                    return ANCHOR_OWNER;
                }
                case 10: {
                    return ANCHOR_MASTER;
                }
                case 5: {
                    return ANCHOR_MEMBER;
                }
            }
            return ANCHOR_GUEST;
        }
        switch (role) {
            case 15: {
                return OWNER;
            }
            case 10: {
                return MASTER;
            }
            case 5: {
                return MEMBER;
            }
        }
        return GUEST;
    }
}

