/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.js;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.appbase.yyuri.YYUriCode;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.bbs.PublishNotificationObj;
import com.yy.hiyo.channel.base.js.WebPostCallbackFactory;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.webwindow.WebWindow;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.json.JSONException;
import org.json.JSONObject;

public class JumpUriJsEvent
implements JsEvent {
    private static final String TAG = "JumpUriJsEvent";
    private final JsEventControllerCallback mControllerCallback;

    public JumpUriJsEvent(JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.jumpUri;
    }

    public void jsCall(final @NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                JumpUriJsEvent.this.jumpUri(param, callback, webHandler);
            }
        });
    }

    private void jumpUri(@NonNull String paramJson, final @Nullable IJsEventCallback callback, final IWebBusinessHandler webHandler) {
        block5: {
            try {
                int matchCode;
                JSONObject jo = JsonParser.obtainJSONObject((String)paramJson);
                final String uri = jo.optString("uri");
                final int exit = jo.optInt("exit");
                boolean needCallback = jo.optBoolean("callback", false);
                final String openUrlWhenExit = jo.optString("open_url_when_exit", "");
                Function1<PublishNotificationObj, Unit> notifyCallback = null;
                if (TextUtils.isEmpty((CharSequence)uri)) {
                    if (callback != null) {
                        BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                        callback.callJs((IJsParam)err);
                    }
                    return;
                }
                if (needCallback && (matchCode = ((IYYUriService)this.mControllerCallback.getService().getService(IYYUriService.class)).matchCode(uri)) == YYUriCode.toBbsPublishPostTool) {
                    notifyCallback = WebPostCallbackFactory.INSTANCE.buildCallback(webHandler);
                }
                final Function1<PublishNotificationObj, Unit> finalNotifyCallback = notifyCallback;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (exit == 1) {
                            webHandler.exit();
                        }
                        if (!FP.empty((CharSequence)openUrlWhenExit)) {
                            JumpUriJsEvent.this.observeWindowExit(openUrlWhenExit);
                        }
                        JumpUriJsEvent.this.jumpUrl(finalNotifyCallback, uri, webHandler);
                        if (callback != null) {
                            callback.callJs((IJsParam)BaseJsParam.successParam((String)"jump uri successfully"));
                        }
                    }
                });
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
                if (callback == null) break block5;
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                callback.callJs((IJsParam)err);
            }
        }
    }

    public void jumpUrl(Object finalNotifyCallback, String uri, IWebBusinessHandler webHandler) {
        String jumpUri = uri;
        String oriUrl = null;
        if (webHandler.getWebEnvSettings() != null) {
            oriUrl = webHandler.getWebEnvSettings().url;
        }
        if (!TextUtils.isEmpty((CharSequence)jumpUri) && jumpUri.startsWith("hago")) {
            jumpUri = URLUtils.addParam((String)uri, (String)"fromH5", (String)"true");
            if (!TextUtils.isEmpty((CharSequence)oriUrl)) {
                jumpUri = URLUtils.addParam((String)jumpUri, (String)"dl_param_2", (String)webHandler.getWebEnvSettings().url);
            }
        }
        if (finalNotifyCallback != null) {
            ((IYYUriService)this.mControllerCallback.getService().getService(IYYUriService.class)).handleUriString(jumpUri, finalNotifyCallback);
        } else {
            ((IYYUriService)this.mControllerCallback.getService().getService(IYYUriService.class)).handleUriString(jumpUri);
        }
    }

    private void observeWindowExit(final @NonNull String openUrlWhenExit) {
        DefaultWindow.IGlobalWindowMonitor monitor = new DefaultWindow.IGlobalWindowMonitor(){
            private DefaultWindow targetWindow = null;

            public void onShown(DefaultWindow window) {
                super.onShown(window);
                if (this.targetWindow == null) {
                    this.targetWindow = window;
                }
            }

            public void onDetach(DefaultWindow window) {
                super.onDetach(window);
                if (window == this.targetWindow) {
                    YYTaskExecutor.postToMainThread(() -> DefaultWindow.removeGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this));
                    if (!(window instanceof WebWindow) || !((WebWindow)window).disableOpenUrlWhenExit()) {
                        ((IYYUriService)ServiceManagerProxy.getService(IYYUriService.class)).handleUriString(openUrlWhenExit);
                    }
                }
            }
        };
        DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)monitor);
    }
}

