/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.db;

import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.service.IMsgService;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import java.util.ArrayList;
import java.util.List;

public class ChannelMsgData {
    public List<BaseImMsg> msgs;
    public int totalMsgNum;
    public String lastReadMsgId;
    public String lastMsgId;
    public String lastNotHiidenMsgId;
    public long unreadNum;
    public boolean inPage;
    public IMsgService.MsgAnchor mNextAnchor;

    public String toString() {
        if (!RuntimeContext.isInGray()) {
            return "";
        }
        return "ChannelMsgData{lastReadMsgId='" + this.lastReadMsgId + '\'' + "unreadNum='" + this.unreadNum + '\'' + "lastMsgId='" + this.lastMsgId + '\'' + "lastNotHiidenMsgId='" + this.lastNotHiidenMsgId + '\'' + "totalMsgNum='" + this.totalMsgNum + '\'' + "inPage='" + this.inPage + '\'' + "msgs='" + (this.msgs != null ? this.msgs.toString() : "") + '\'' + '}';
    }

    public int findMsgForIndex(String msgId) {
        if (StringUtils.isEmpty((String)msgId) || this.msgs == null || this.msgs.size() <= 0) {
            return -1;
        }
        BaseImMsg imMsg = null;
        for (int i = 0; i < this.msgs.size(); ++i) {
            imMsg = this.msgs.get(i);
            if (imMsg == null || !StringUtils.equal((String)imMsg.getMsgId(), (String)msgId)) continue;
            return i;
        }
        return -1;
    }

    public BaseImMsg findMsg(String msgId) {
        if (StringUtils.isEmpty((String)msgId)) {
            return null;
        }
        if (this.msgs != null && this.msgs.size() > 0) {
            for (BaseImMsg imMsg : this.msgs) {
                if (!StringUtils.equal((String)imMsg.getMsgId(), (String)msgId)) continue;
                return imMsg;
            }
        }
        return null;
    }

    public BaseImMsg findMsg(String msgId, int inLatestNum) {
        if (StringUtils.isEmpty((String)msgId)) {
            return null;
        }
        BaseImMsg imMsg = null;
        if (this.msgs != null && this.msgs.size() > 0) {
            int index = this.msgs.size() - inLatestNum;
            if (index < 0) {
                index = 0;
            }
            for (int i = index; i < this.msgs.size(); ++i) {
                imMsg = this.msgs.get(i);
                if (!StringUtils.equal((String)imMsg.getMsgId(), (String)msgId)) continue;
                return imMsg;
            }
        }
        return null;
    }

    public BaseImMsg findMsgByCseq(String cseqid, int inLatestNum) {
        if (StringUtils.isEmpty((String)cseqid)) {
            return null;
        }
        if (this.msgs != null && this.msgs.size() > 0) {
            int index = this.msgs.size() - inLatestNum;
            if (index < 0) {
                index = 0;
            }
            BaseImMsg imMsg = null;
            for (int i = index; i < this.msgs.size(); ++i) {
                imMsg = this.msgs.get(i);
                if (!StringUtils.equal((String)imMsg.getCseq(), (String)cseqid)) continue;
                return imMsg;
            }
        }
        return null;
    }

    public void removeMsg(BaseImMsg imMsg) {
        if (this.msgs != null && this.msgs.size() > 0) {
            this.msgs.remove(imMsg);
        }
    }

    public BaseImMsg getLastMsg() {
        if (this.msgs != null && this.msgs.size() > 0) {
            return this.msgs.get(this.msgs.size() - 1);
        }
        return null;
    }

    public String getLastMsgId() {
        BaseImMsg lastMsg = this.getLastMsg();
        String lastMsgId = lastMsg != null ? lastMsg.getMsgId() : "";
        return lastMsgId;
    }

    public BaseImMsg getLastNotHiddenMsg() {
        BaseImMsg imMsg = null;
        if (this.msgs != null && this.msgs.size() > 0) {
            for (int i = this.msgs.size() - 1; i >= 0; --i) {
                imMsg = this.msgs.get(i);
                if (imMsg == null || ChannelMsgData.containFlag(imMsg.getFlags(), 2)) continue;
                return imMsg;
            }
        }
        return null;
    }

    public boolean isAfter(String msgId, String idtocompare) {
        if (StringUtils.isEmpty((String)msgId) || StringUtils.isEmpty((String)idtocompare)) {
            return false;
        }
        if (this.msgs == null || this.msgs.size() <= 0) {
            return false;
        }
        int index = -1;
        int indextoCompare = Integer.MAX_VALUE;
        if (this.msgs != null && this.msgs.size() > 0) {
            BaseImMsg imMsg = null;
            for (int i = 0; i < this.msgs.size(); ++i) {
                imMsg = this.msgs.get(i);
                if (index == -1 && imMsg != null && StringUtils.equal((String)imMsg.getMsgId(), (String)msgId)) {
                    index = i;
                    if (indextoCompare != Integer.MAX_VALUE) break;
                }
                if (indextoCompare != Integer.MAX_VALUE || imMsg == null || !StringUtils.equal((String)imMsg.getMsgId(), (String)idtocompare)) continue;
                indextoCompare = i;
                if (index != -1) break;
            }
        }
        return index < indextoCompare;
    }

    public void addHistroyMsg(IMsgService.MsgAnchor anchor, List<BaseImMsg> msgs, IMsgService.MsgAnchor nextAnchor) {
        if (msgs == null || msgs.size() <= 0 || nextAnchor == null) {
            return;
        }
        if (this.msgs == null) {
            this.msgs = new ArrayList<BaseImMsg>();
        }
        if (this.mNextAnchor == null || this.mNextAnchor.getTimestamp() > nextAnchor.getTimestamp()) {
            this.mNextAnchor = nextAnchor;
            ArrayList<BaseImMsg> needDeleteMsgs = new ArrayList<BaseImMsg>(1);
            ArrayList<BaseImMsg> needDeleteMsgsFromCache = new ArrayList<BaseImMsg>(1);
            block0: for (BaseImMsg baseImMsg : msgs) {
                if (anchor == null || anchor.getTimestamp() <= 0L) {
                    BaseImMsg find = this.findMsg(baseImMsg.getMsgId());
                    if (find != null) {
                        needDeleteMsgsFromCache.add(find);
                    }
                    for (BaseImMsg baseImMsgTwo : msgs) {
                        if (baseImMsgTwo == baseImMsg || !StringUtils.equal((String)baseImMsgTwo.getMsgId(), (String)baseImMsg.getMsgId())) continue;
                        needDeleteMsgs.add(baseImMsg);
                        continue block0;
                    }
                    continue;
                }
                if (this.findMsg(baseImMsg.getMsgId()) != null) {
                    needDeleteMsgs.add(baseImMsg);
                    continue;
                }
                for (BaseImMsg baseImMsgTwo : msgs) {
                    if (baseImMsgTwo == baseImMsg || !StringUtils.equal((String)baseImMsgTwo.getMsgId(), (String)baseImMsg.getMsgId())) continue;
                    needDeleteMsgs.add(baseImMsg);
                    continue block0;
                }
            }
            if (needDeleteMsgsFromCache.size() > 0) {
                this.msgs.removeAll(needDeleteMsgsFromCache);
            }
            if (needDeleteMsgs.size() > 0) {
                msgs.removeAll(needDeleteMsgs);
            }
            this.msgs.addAll(0, msgs);
        }
    }

    public BaseImMsg getAheadMsg(BaseImMsg msg) {
        if (msg == null) {
            return null;
        }
        if (this.msgs == null || this.msgs.size() <= 0) {
            return null;
        }
        int index = this.msgs.indexOf(msg);
        if (index >= 1) {
            return this.msgs.get(index - 1);
        }
        return null;
    }

    public static boolean containFlag(int inputFlag, int matchFlags) {
        return inputFlag == matchFlags || (inputFlag & matchFlags) > 0;
    }

    public static boolean containFlag(long flag, int matchFlags) {
        return flag == (long)matchFlags || (flag & (long)matchFlags) > 0L;
    }

    public List<BaseImMsg> getAllMsgs() {
        return this.msgs;
    }

    public void addMsg(BaseImMsg msg) {
        if (this.msgs == null) {
            this.msgs = new ArrayList<BaseImMsg>();
        }
        this.msgs.add(msg);
        if (this.msgs.size() > 500) {
            this.msgs.remove(0);
        }
    }

    public void onTrimMemory() {
        if (this.msgs != null && this.msgs.size() > 500) {
            this.msgs = this.msgs.subList(this.msgs.size() - 500, this.msgs.size());
        }
    }
}

