/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.bean.plugins;

import android.annotation.SuppressLint;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

@DontProguardClass
public class ChannelPluginData
extends KvoSource {
    private static final String TAG = "ChannelPluginData";
    public static final String kvo_id = "id";
    @KvoFieldAnnotation(name="id")
    private String id;
    private long template;
    private long version;
    public int mode;
    public static final String kvo_isStarted = "isStarted";
    @KvoFieldAnnotation(name="isStarted")
    private boolean isStarted;
    private String joinCtx;
    private String joinUrl;
    private Map<String, Object> ext = new HashMap<String, Object>();

    private ChannelPluginData() {
    }

    @SuppressLint(value={"SwitchIntDef"})
    public ChannelPluginData(int mode, String id2) {
        this.mode = mode;
        this.id = id2;
        if (FP.empty((CharSequence)id2)) {
            switch (mode) {
                case 1: {
                    this.id = "base";
                    break;
                }
                case 10: {
                    this.id = "chat";
                    break;
                }
                default: {
                    if (!RuntimeContext.sIsDebuggable) break;
                    throw new IllegalStateException("ChannelPluginData, mode: " + mode + ", plugin id is null");
                }
            }
        }
    }

    public void update(ChannelPluginData from) {
        this.mode = from.mode;
        this.id = from.id;
        this.version = from.version;
        this.template = from.template;
        this.ext = from.ext;
        this.joinCtx = from.joinCtx;
        this.joinUrl = from.joinUrl;
        MLog.error((Object)TAG, (String)"update ext:%s, hash:%s", (Object[])new Object[]{this.getExtInfo(), ((Object)((Object)this)).hashCode()});
        this.setStarted(from.isStarted);
    }

    public void update(String id2, long template, long version) {
        if (version > 0L) {
            this.version = version;
        }
        this.template = template;
        if (StringUtils.isNotEmpty((String)id2)) {
            this.id = id2;
        }
    }

    public void update(boolean isStarted, String joinCtx, String joinUrl) {
        MLog.info((Object)TAG, (String)"update isStarted %s, joinCtx %s, joinUrl %s", (Object[])new Object[]{isStarted, joinCtx, joinUrl});
        this.joinCtx = joinCtx;
        this.joinUrl = joinUrl;
        this.setStarted(isStarted);
    }

    public void update(String joinCtx, String joinUrl) {
        MLog.info((Object)TAG, (String)"update joinCtx %s, joinUrl %s", (Object[])new Object[]{joinCtx, joinUrl});
        this.joinCtx = joinCtx;
        this.joinUrl = joinUrl;
    }

    public String getId() {
        return this.id;
    }

    public int getMode() {
        return this.mode;
    }

    public String getPluginId() {
        return this.id;
    }

    public long getTemplate() {
        return this.template;
    }

    public void setTemplate(long template) {
        this.template = template;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    private void setStarted(boolean started) {
        this.setValue(kvo_isStarted, started);
    }

    public String getJoinCtx() {
        return this.joinCtx;
    }

    public String getJoinUrl() {
        return this.joinUrl;
    }

    public <T> T getExt(String key, T defaultValue) {
        Object value = this.ext.get(key);
        try {
            if (value != null) {
                return (T)value;
            }
            return defaultValue;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return defaultValue;
        }
    }

    public void putExt(String key, Object value) {
        this.ext.put(key, value);
    }

    public boolean isVideoMode() {
        return this.getExt("is_video_open", false);
    }

    public String getVideoRoundId() {
        return this.getExt("round_id", "");
    }

    public String toString() {
        return "ChannelPluginData{id='" + this.id + '\'' + ", template=" + this.template + ", version=" + this.version + ", mode=" + this.mode + ", isvideo=" + this.isVideoMode() + ", isStarted=" + this.isStarted + ", joinCtx='" + this.joinCtx + '\'' + ", joinUrl='" + this.joinUrl + '\'' + ", ext='" + this.getExtInfo() + '\'' + '}';
    }

    private String getExtInfo() {
        Object o = this.ext.get("extString");
        Object o1 = this.ext.get("plugin_launcher");
        return "ext=" + o + ", ext2=" + o1;
    }
}

