/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.bean;

import android.graphics.Color;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.DontProguardClass;
import net.ihago.channel.srv.mgr.Background;

@DontProguardClass
public class ThemeItemBean {
    public static final int THEME_ERROR = -1;
    public static final int TYPE_THEME_NORMAL = 0;
    public static final int TYPE_THEME_ACTIVITY = 1;
    private int themeId;
    private String url;
    private boolean isSelected;
    private String titleColor;
    private String preUrl;
    private long expire;
    private String tag;
    private int type;
    private boolean isDynamic;
    private String svgaUrl;

    public int getThemeId() {
        return this.themeId;
    }

    public void setThemeId(int themeId) {
        this.themeId = themeId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public String getTitleColor() {
        if (TextUtils.isEmpty((CharSequence)this.titleColor)) {
            return "";
        }
        try {
            Color.parseColor((String)this.titleColor);
        }
        catch (Exception e) {
            FeatureLog.i((String)"FTVoiceRoomTheme", (String)"color parse fail%s", (Object[])new Object[]{this.titleColor});
            return "";
        }
        return this.titleColor;
    }

    public void setTitleColor(String titleColor) {
        this.titleColor = titleColor;
    }

    public static ThemeItemBean toThemeItemBean(Background theme) {
        if (theme == null) {
            return null;
        }
        ThemeItemBean themeItemBean = new ThemeItemBean();
        themeItemBean.setTitleColor(theme.title_color);
        themeItemBean.setThemeId(theme.id);
        themeItemBean.setUrl(theme.bg_url);
        themeItemBean.setPreUrl(theme.preview_url);
        themeItemBean.setExpire(theme.expire);
        return themeItemBean;
    }

    public String getPreUrl() {
        return this.preUrl;
    }

    public void setPreUrl(String preUrl) {
        this.preUrl = preUrl;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public String getSvgaUrl() {
        return this.svgaUrl;
    }

    public void setSvgaUrl(String svgaUrl) {
        this.svgaUrl = svgaUrl;
    }

    public String toString() {
        if (!RuntimeContext.sIsDebuggable) {
            return String.valueOf(this.themeId);
        }
        return "ThemeItemBean{themeId=" + this.themeId + ", url='" + this.url + '\'' + ", isSelected=" + this.isSelected + ", titleColor='" + this.titleColor + '\'' + ", preUrl='" + this.preUrl + '\'' + ", expire=" + this.expire + ", tag='" + this.tag + '\'' + ", type=" + this.type + '}';
    }
}

