/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.bean;

import androidx.collection.LongSparseArray;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.SimpleCardInfo;
import java.util.ArrayList;
import java.util.List;
import net.ihago.channel.srv.mgr.CardInfo;
import net.ihago.channel.srv.mgr.ComerFlagInfo;
import net.ihago.channel.srv.mgr.WearingInfo;

public class OnlineInfo {
    private long onlineTotalNum;
    private List<Long> onlineUids = new ArrayList<Long>();
    private List<Long> vipUids;
    private LongSparseArray<List<Integer>> wearingsMap = new LongSparseArray();
    private LongSparseArray<List<SimpleCardInfo>> userCardMap = new LongSparseArray();
    private LongSparseArray<Integer> potentialMap = new LongSparseArray();

    public long getOnlineTotalNum() {
        return this.onlineTotalNum;
    }

    public void setOnlineTotalNum(long onlineTotalNum) {
        this.onlineTotalNum = onlineTotalNum;
    }

    public List<Long> getOnlineUids() {
        return this.onlineUids;
    }

    public List<Long> getVips() {
        return this.vipUids == null ? new ArrayList(0) : this.vipUids;
    }

    public void setOnlineUids(List<Long> onlineUids) {
        this.onlineUids = onlineUids;
    }

    public void setVipUids(List<Long> vipUids) {
        this.vipUids = vipUids;
    }

    public LongSparseArray<List<Integer>> getWearingsMap() {
        return this.wearingsMap;
    }

    public LongSparseArray<List<SimpleCardInfo>> getUserCardMap() {
        return this.userCardMap;
    }

    public void setWearingsMap(List<WearingInfo> wearingInfos) {
        for (WearingInfo wearingInfo : wearingInfos) {
            this.wearingsMap.put(wearingInfo.uid.longValue(), (Object)wearingInfo.medal_ids);
        }
    }

    public void setUserCardMap(List<CardInfo> uid_cards) {
        for (CardInfo cardInfo : uid_cards) {
            this.userCardMap.put(cardInfo.uid.longValue(), this.buildSimpleCardInfoList(cardInfo.cards));
        }
    }

    private List<SimpleCardInfo> buildSimpleCardInfoList(List<biz.SimpleCardInfo> cards) {
        ArrayList<SimpleCardInfo> list = new ArrayList<SimpleCardInfo>();
        for (biz.SimpleCardInfo cardInfo : cards) {
            list.add(new SimpleCardInfo(cardInfo.card_type, cardInfo.level, cardInfo.name, cardInfo.fid, cardInfo.sub_type));
        }
        return list;
    }

    public void addUser(long uid) {
        if (!this.onlineUids.contains(uid)) {
            this.onlineUids.add(uid);
        }
    }

    public String toString() {
        if (ChannelDefine.sUnEnableLog) {
            return "" + this.onlineTotalNum;
        }
        return "OnlineInfo{onlineTotalNum='" + this.onlineTotalNum + '\'' + ", onlineUids='" + (this.onlineUids != null ? this.onlineUids.toString() : "") + '\'' + ", vipUids='" + (this.vipUids != null ? this.vipUids.toString() : "") + '\'' + ", medalIds='" + (this.wearingsMap != null ? this.wearingsMap.toString() : "") + '\'' + '}';
    }

    public void setPotentialMap(List<ComerFlagInfo> uid_comer_flags) {
        this.potentialMap.clear();
        for (ComerFlagInfo info : uid_comer_flags) {
            this.potentialMap.put(info.uid.longValue(), (Object)info.comer_flag);
        }
    }

    public LongSparseArray<Integer> getPotentialMap() {
        return this.potentialMap;
    }
}

