/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.bean;

import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CrossRegionConfig;
import com.yy.appbase.unifyconfig.config.CrossRegionConfigData;
import com.yy.appbase.unifyconfig.config.DisablePluginConfig;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.LiveCodeRate;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.SimpleCardInfo;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ihago.channel.srv.mgr.NotifyGlobalLeave;

@DontProguardClass
public class NotifyDataDefine {

    @DontProguardClass
    public static final class ChannelRoomPartyEntry
    extends AbsSignal {
        public int pluginType = -1;
        public String avatar = "";
        public String nick = "";
    }

    @DontProguardClass
    public static class ChannelLightEffect
    extends AbsSignal {
        @SerializedName(value="channel_light_effect")
        public String lightValue;

        public String toString() {
            return "NotifyDataDefine.ChannelLightEffect{lightValue='" + this.lightValue + '}';
        }
    }

    @DontProguardClass
    public static class ChannelShowPermit
    extends AbsSignal {
        @SerializedName(value="channel_show_permit")
        public int channelShowPermit;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.ChannelShowPermit{channelShowPermit='" + this.channelShowPermit + '}';
        }
    }

    @DontProguardClass
    public static final class SetAllMemeberDistrub
    extends AbsSignal {
        public String cid;
        @SerializedName(value="member_count")
        public long memberCount;
        @SerializedName(value="op_uid")
        public long optUid;

        public String toString() {
            return "SetAllMemeberDistrub{cid='" + this.cid + '\'' + ", memberCount=" + this.memberCount + ", optUid=" + this.optUid + '}';
        }
    }

    @DontProguardClass
    public static final class FamilyShowNotify
    extends AbsSignal {
        public String cid;
        public long uid;

        public String toString() {
            return "FamilyShowNotify{cid='" + this.cid + '\'' + ", uid=" + this.uid + '}';
        }
    }

    public static class LockAllSeatNotify {
        public boolean lock;
        public String cid;
    }

    @Keep
    public static class GlobalLeaveNotify {
        public long uid;
        public int pluginMode;
        public String pluginId;

        public static GlobalLeaveNotify from(NotifyGlobalLeave data) {
            GlobalLeaveNotify notify = new GlobalLeaveNotify();
            notify.uid = data.uid;
            notify.pluginMode = data.plugin_info.type;
            notify.pluginId = data.plugin_info.pid;
            return notify;
        }

        public boolean isForceQuit(int mode, String pluginId) {
            CrossRegionConfigData configData;
            AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.CROSS_REGION_CONFIG);
            if (config instanceof CrossRegionConfig && (configData = ((CrossRegionConfig)config).getData()) != null && configData.getDisablePlugin() != null) {
                List pluginConfigs = configData.getDisablePlugin();
                if (!FP.empty((Collection)pluginConfigs)) {
                    for (DisablePluginConfig item : pluginConfigs) {
                        if (item.getMode() != mode) continue;
                        if (item.getDisableAll()) {
                            return true;
                        }
                        return !FP.empty((Collection)item.getDisableIds()) && item.getDisableIds().contains(pluginId);
                    }
                }
                return false;
            }
            return ChannelDefine.CROSS_REGION_DEFAULT_DISABLE_MODE.contains(this.pluginMode);
        }

        @Keep
        public String toString() {
            return "GlobalLeaveNotify{uid=" + this.uid + ", pluginMode=" + this.pluginMode + ", pluginId='" + this.pluginId + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class NotifyUserInfo {
        public long uid;
        public String nick;
        public String avatar;
        public int inviteType = 1;
    }

    @DontProguardClass
    public static final class SetTags
    extends AbsSignal {
        @Nullable
        public List<String> tags;
    }

    @DontProguardClass
    public static final class Challenge
    extends AbsSignal {
        @SerializedName(value="type")
        public int type;
        @SerializedName(value="nick")
        public String nick;
        @SerializedName(value="uid")
        public long uid;
        @SerializedName(value="fUid")
        public long fUid;
        @SerializedName(value="fNick")
        public String fNick;
        @SerializedName(value="gid")
        public String gid;
    }

    @DontProguardClass
    public static final class KickOff
    extends AbsSignal {
        @SerializedName(value="uid")
        public long uid;
        @SerializedName(value="nick")
        public String nick;
    }

    @DontProguardClass
    public static final class SpeakBan
    extends AbsSignal {
        @SerializedName(value="time")
        public long time;
        @SerializedName(value="only_this")
        public boolean onlyThis;
        @SerializedName(value="uid")
        public long uid;
        @SerializedName(value="nick")
        public String nick;
        @SerializedName(value="banned")
        public boolean banned;
    }

    public static class NotifyRoomAnchorTxtMsg {
        public long anchorUid = 0L;
        public String cid;
        public String text;
    }

    public static class UserArGift {
        public long uid;
        public boolean close;
    }

    public static class NotifyRemindPlayerEnter {
        public long enterUid;
    }

    public static class BgmUpdateNotify {
        public boolean bgmEnable;
    }

    public static class BgmPlayNotify {
        public long uid;
        public boolean playState;
        public boolean manual;
        public String ownerCid;
    }

    public static class SwitchLBSNotify {
        public boolean isOpen;
        public long operUid;
        public double longitude;
        public double latitude;
    }

    public static class ChannelUpgradeNotify {
        public int version;
        public String cid;
    }

    public static class LeaveAndReEnterNotify {
    }

    public static class KTVStatusNotify {
        public boolean isOpen;
    }

    public static class VideoStatusNotify {
        public boolean isOpen;
        public List<LiveCodeRate> mLiveCodeRateList;
        public String roundId = "";
    }

    public static class RadioStationNotify {
        public long fromUid;
    }

    public static class UnSupportVersionNotify {
        public int minVersion;
    }

    public static class MuteInvalidMicNotify {
        public ArrayList<Long> uids;
    }

    public static class GameFinishNotify {
    }

    public static class PluginStatusStartNotify {
        public ChannelPluginData pluginData;
        public long uid;
    }

    public static class PluginStatusReadyNotify {
        public long uid;
        public int seat;
        public boolean ready;
    }

    public static class SwitchPluginNotify {
        public ChannelPluginData pluginData;

        public SwitchPluginNotify(ChannelPluginData data) {
            this.pluginData = data;
        }
    }

    public static class OpenVoiceChatNotify {
        public long operUid;
    }

    public static class RoleJoinModeChangeNotify {
        public int mode;
    }

    public static class ProbeNotify {
        public String cid;
        public String data;

        public ProbeNotify(String cid, String data) {
            this.cid = cid;
            this.data = data;
        }
    }

    public static class NewThemeNotify {
        public ThemeItemBean theme;
    }

    public static class SetThemeNotify {
        public String cid;
        public ThemeItemBean theme;
    }

    public static class QuickMatchSuccessNotify {
        public String cid;
        public List<Long> uids;
    }

    public static class UnlockSeatNotify {
        public int seat = 1;
    }

    public static class LockSeatNotify {
        public int seat = 1;
        public long uid = 2L;
    }

    public static class UserSeatChangeNotify {
        public long uid;
        public int oldSeat;
        public int newSeat;
    }

    public static class SetVideoNotify {
        public int seat;
        public long uid;
        public int videoBan;
        public int videoCloseBy;

        public boolean isVideoBanned() {
            return this.videoBan == 1;
        }
    }

    public static class SetMicNotify {
        public int seat;
        public long uid;
        public int micBan;
        public int micCloseBy;

        public boolean isMicBanned() {
            return this.micBan == 1;
        }
    }

    public static class SitDownPlzAcceptNotify {
        public long uid;
        public boolean accept;
        public int seat;
    }

    public static class SitDownPlzNotify {
        public String plzId;
    }

    public static class StandUpPlzNotify {
    }

    public static class SitDownNotify {
        public long uid;
        public int seat;
    }

    public static class StandUpNotify {
        public long uid;
        public int seat;
    }

    public static class SeatsChangeNotify {
        public List<SeatUser> seatList;

        public SeatsChangeNotify(List<SeatUser> users) {
            this.seatList = new ArrayList<SeatUser>(users);
        }
    }

    public static class ChannelLockNotify {
        public boolean lock;
        public String pwdToken;
    }

    @DontProguardClass
    public static class LeaveNotify {
        public long user;
    }

    @DontProguardClass
    public static class JoinNotify {
        public long user;
        public String icon;
        public String nick;
        public long seat;
        public long iconframeID;
        public int sex = 6;
        public boolean isBBSEnter;
        public int source;
        public boolean isNobleEnter;
        public String nobleIcon;
        public int userType;
        public boolean isGuest;
        public boolean isInUserLabelWhiteList;
        public long labelId;
        @Nullable
        public List<SimpleCardInfo> cards;
    }

    @DontProguardClass
    public static class SetPicSendMode
    extends AbsSignal {
        @SerializedName(value="pic_send_mod")
        public int picSendMode;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetPicSendMode{picSendMode='" + this.picSendMode + '}';
        }
    }

    @DontProguardClass
    public static class SetHiddenChannelTitle
    extends AbsSignal {
        @SerializedName(value="show_channel_title")
        public boolean showChannelTitle;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetHiddenChannelTitle{showChannelTitle='" + this.showChannelTitle + '}';
        }
    }

    @DontProguardClass
    public static class SetHiddenChannelNick
    extends AbsSignal {
        @SerializedName(value="hidden_channel_nick")
        public boolean hiddenChannelNick;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetHiddenChannelNick{hiddenChannelNick='" + this.hiddenChannelNick + '}';
        }
    }

    @DontProguardClass
    public static class InviteApproveStatus
    extends AbsSignal {
        @SerializedName(value="set_id")
        public String setId;
        @SerializedName(value="expire_ts")
        public long expireTs;
        @SerializedName(value="inviter_uinfo")
        public NotifyUserInfo inviterUserInfo;
        @SerializedName(value="ch_notify")
        public boolean chNotify;
        public int channelType;
        public String channelAvatar;
        @SerializedName(value="accept")
        public boolean accept;
        public int version;
        @SerializedName(value="invitee_uinfo")
        public NotifyUserInfo inviteeUserInfo;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.InviteApprove{setId='" + this.setId + '\'' + ",expireTs='" + this.expireTs + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class InviteApprove
    extends AbsSignal {
        @SerializedName(value="set_id")
        public String setId;
        @SerializedName(value="expire_ts")
        public long expireTs;
        @SerializedName(value="inviter_uinfo")
        public NotifyUserInfo inviteUserInfo;
        @SerializedName(value="ch_notify")
        public boolean chNotify;
        public int channelType;
        public String channelAvatar;
        @SerializedName(value="invitee_nick")
        public String inviteeNick;
        public int version;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.InviteApprove{setId='" + this.setId + '\'' + ",expireTs='" + this.expireTs + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetTag
    extends AbsSignal {
        public String tag;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetTag{tag='" + this.tag + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class ClosePlugin
    extends AbsSignal {
        @SerializedName(value="type")
        public int mode;
        @SerializedName(value="pid")
        public String pluginId;
        public long ver;
        public long templ;
        public String ctx;
        public String ext;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.OpenPlugin{pluginId='" + this.pluginId + '\'' + ",mode='" + this.mode + '\'' + ",ver='" + this.ver + '\'' + ",templ='" + this.templ + '\'' + ",ctx='" + this.ctx + '\'' + ",ext='" + this.ext + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class OpenPlugin
    extends AbsSignal {
        @SerializedName(value="type")
        public int mode;
        @SerializedName(value="pid")
        public String pluginId;
        public long ver;
        public long templ;
        public String ctx;
        public String ext;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.OpenPlugin{pluginId='" + this.pluginId + '\'' + ",mode='" + this.mode + '\'' + ",ver='" + this.ver + '\'' + ",templ='" + this.templ + '\'' + ",ctx='" + this.ctx + '\'' + ",ext='" + this.ext + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class OpenOrCloseVoiceChat
    extends AbsSignal {
        public boolean open;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.OpenOrCloseVoiceChat{open='" + this.open + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetRemark
    extends AbsSignal {
        public String remark;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetRemark{remark='" + this.remark + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class UserRoleChange
    extends AbsSignal {
        public String type;
        public long uid;
        public String nick;
        @SerializedName(value="role")
        public int roleType;
        @SerializedName(value="old_role")
        public int oldRoleType;
        @SerializedName(value="auto_approve")
        public boolean autoApprove;
        @SerializedName(value="oper_muid")
        public long masterUid;
        public String masterNick;
        public String masterAvatar;
        @SerializedName(value="changed_uinfo")
        public NotifyUserInfo changedUserInfo;
        @SerializedName(value="operator_uinfo")
        public NotifyUserInfo operatorUserInfo;
        @SerializedName(value="ch_notify")
        public boolean chNotify;
        public int channelType;
        public String channelAvatar;
        public int version;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.UserRoleChange{type='" + this.type + '\'' + ",uid='" + this.uid + '\'' + ",roleType='" + this.roleType + '\'' + ",masterUid='" + this.masterUid + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class AcceptRole
    extends AbsSignal {
        @SerializedName(value="set_id")
        public String roleSetId;
        public String reason;
        public boolean accept;
        public long uid;
        public String nick;
        @SerializedName(value="role")
        public int roleType;
        public long masterUid;
        public String masterNick;
        public String masterAvatar;
        @SerializedName(value="inviter_uinfo")
        public NotifyUserInfo inviterUserInfo;
        @SerializedName(value="invitee_uinfo")
        public NotifyUserInfo inviteeUserInfo;
        @SerializedName(value="ch_notify")
        public boolean chNotify;
        public int channelType;
        public String channelAvatar;
        public int version;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.AcceptRole{roleSetId='" + this.roleSetId + '\'' + ",accept='" + this.accept + '\'' + ",roleType='" + this.roleType + '\'' + ",masterUid='" + this.masterUid + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetRole
    extends AbsSignal {
        @SerializedName(value="set_id")
        public String setId;
        @SerializedName(value="expire_ts")
        public long expireTime;
        public int role;
        public long uid;
        public long masterUid;
        public String masterNick;
        public String masterAvatar;
        @SerializedName(value="inviter_uinfo")
        public NotifyUserInfo inviterUserInfo;
        @SerializedName(value="ch_notify")
        public boolean chNotify;
        public int channelType;
        public String channelAvatar;
        public int version;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "SetRole{setId='" + this.setId + '\'' + ", role=" + this.role + ", uid=" + this.uid + ", masterUid=" + this.masterUid + ", masterNick='" + this.masterNick + '\'' + ", masterAvatar='" + this.masterAvatar + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class JoinApprove
    extends AbsSignal {
        @SerializedName(value="apply_id")
        public String applyId;
        public String reason;
        public boolean accept;
        @SerializedName(value="uid")
        public long applyerUid;
        @SerializedName(value="nick")
        public String applyerNick;
        @SerializedName(value="role")
        public int roleType;
        @SerializedName(value="avatar")
        public String applyAvatar;
        @SerializedName(value="apply_uinfo")
        public NotifyUserInfo applyUserInfo;
        @SerializedName(value="approve_uinfo")
        public NotifyUserInfo approveUserInfo;
        @SerializedName(value="ch_notify")
        public boolean chNotify;
        public long masterUid;
        public String masterNick;
        public String masterAvatar;
        public int channelType;
        public String channelAvatar;
        public int version;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.JoinApprove{applyId='" + this.applyId + '\'' + ",accept='" + this.accept + '\'' + ",roleType='" + this.roleType + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class JoinApply
    extends AbsSignal {
        @SerializedName(value="apply_id")
        public String applyId;
        public String reason;
        @SerializedName(value="expire_ts")
        public long expireTs;
        public long applyerUid;
        public String applyerNick;
        public String applyAvatar;
        @SerializedName(value="apply_uinfo")
        public NotifyUserInfo applyUserInfo;
        @SerializedName(value="ch_notify")
        public boolean chNotify;
        public int channelType;
        public String channelAvatar;
        public int version;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.JoinApply{applyId='" + this.applyId + '\'' + ",expireTs='" + this.expireTs + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetVoiceOpenMode
    extends AbsSignal {
        @SerializedName(value="mode")
        public int mode;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetVoiceOpenMode{mode='" + this.mode + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetJoinChannelMode
    extends AbsSignal {
        @SerializedName(value="mode")
        public int mode;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetJoinChannelMode{mode='" + this.mode + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetJoinMode
    extends AbsSignal {
        @SerializedName(value="mode")
        public int joinmode;
        public String password;
        @SerializedName(value="pwd_token")
        public String pwdToken;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetJoinMode{joinmode='" + this.joinmode + '\'' + "password='" + this.password + '\'' + "pwdToken='" + this.pwdToken + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetGuestSpeakLimit
    extends AbsSignal {
        @SerializedName(value="guest_speak_limit")
        public int guestSpeakLimit;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetGuestSpeakLimit{guestSpeakLimit='" + this.guestSpeakLimit + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetVoiceEnterMode
    extends AbsSignal {
        @SerializedName(value="voice_enter_mode")
        public int voiceEnterMode;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetVoiceEnterMode{voiceEnterMode='" + this.voiceEnterMode + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetSpeakMode
    extends AbsSignal {
        public int mode;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetSpeakMode{mode='" + this.mode + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class Extention {
        @SerializedName(value="nick")
        public String nick = "";
        @SerializedName(value="cid")
        public String cid = "";
        @SerializedName(value="pid")
        public String pid = "";
        @SerializedName(value="uid")
        public long uid;
        @SerializedName(value="ver")
        public String ver;
    }

    @DontProguardClass
    public static class ChannelRobotAtMsg
    extends AbsSignal {
        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "";
        }
    }

    @DontProguardClass
    public static class ChannelRobotSystemMsg
    extends AbsSignal {
        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "";
        }
    }

    @DontProguardClass
    public static class ChannelRobotTATMsg
    extends AbsSignal {
        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "";
        }
    }

    @DontProguardClass
    public static class ChannelRobotWelcomeMsg
    extends AbsSignal {
        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "";
        }
    }

    @DontProguardClass
    public static class SubSecondOnline
    extends AbsSignal {
        @SerializedName(value="pid")
        public String parentId;
        @SerializedName(value="cid")
        public String channelId;
        @SerializedName(value="online")
        public int online;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SubSecondOnline{parentId='" + this.parentId + '\'' + "channelId=" + this.channelId + '\'' + "online=" + this.online + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SubFirstOnline
    extends AbsSignal {
        @SerializedName(value="pid")
        public String parentId;
        @SerializedName(value="cid")
        public String channelId;
        @SerializedName(value="online")
        public int online;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SubFirstOnline{parentId='" + this.parentId + '\'' + "channelId=" + this.channelId + '\'' + "online=" + this.online + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class AnchorSitDown
    extends AbsSignal {
        @SerializedName(value="pid")
        public String parentId;
        @SerializedName(value="cid")
        public String channelId;
        @SerializedName(value="sit_down_uid")
        public long sitDownUid;
        @SerializedName(value="gid")
        public String gid;
        @SerializedName(value="plugin_type")
        public int pluginType;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.AnchorSitDown{parentId='" + this.parentId + '\'' + "channelId=" + this.channelId + '\'' + "sitDownUid=" + this.sitDownUid + '\'' + "gid=" + this.gid + '\'' + "pluginType=" + this.pluginType + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class ChannelNewMember
    extends AbsSignal {
        @SerializedName(value="member_uid")
        public long memberID;
        @SerializedName(value="title")
        public String title;
        @SerializedName(value="content")
        public String content;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "ChannelNewMember{memberID=" + this.memberID + ", title='" + this.title + '\'' + ", content='" + this.content + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class ChannelNewPost
    extends AbsSignal {
        @SerializedName(value="post_uid")
        public long postUid;
        @SerializedName(value="pid")
        public String postId;
        @SerializedName(value="cid")
        public String channelId;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.ChannelNewPost{postUid='" + this.postUid + '\'' + "postId='" + this.postId + '\'' + "channelId=" + this.channelId + '}';
        }
    }

    @DontProguardClass
    public static class SetAnnouncement
    extends AbsSignal {
        @SerializedName(value="bulletin")
        public String announcement;
        public int type;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetAnnouncement{announcement='" + this.announcement + '\'' + "type='" + this.type + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetName
    extends AbsSignal {
        public String name;
        public int type;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetName{name='" + this.name + '\'' + "type='" + this.type + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SetPrivacyMode
    extends AbsSignal {
        @SerializedName(value="is_private")
        public boolean isPrivateMode;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.SetPrivacyMode{privateMode='" + this.isPrivateMode + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class DisbandGroup
    extends AbsSignal {
        public String cid;
        @SerializedName(value="ch_notify")
        public boolean chNotify;
        public String fromNick;
        public int channelType;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.CreateGroup{,cid='" + this.cid + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class CreateGroup
    extends AbsSignal {
        public String cid;
        public String name;
        @SerializedName(value="is_private")
        public boolean isPrivateMode;

        public String toString() {
            if (ChannelDefine.sUnEnableLog) {
                return "";
            }
            return "NotifyDataDefine.CreateGroup{cid='" + this.cid + '\'' + ",name='" + this.name + '\'' + ",privateMode='" + this.isPrivateMode + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class SignalContext {
        public String cid;
        public String pid;
        @SerializedName(value="uid")
        public long uid;
        @SerializedName(value="nick")
        public String operNick;
        public long ver;
        public String cname;
        public long time;
        public String msgId;
        public String pwd;
        public long seqId;
        public long channelOwnerId;
        public String channelSource;
    }

    @DontProguardClass
    public static class AbsSignal {
        private SignalContext context;
        private String cName;
        private String cId;
        private String seqId;

        public long getSignalVer() {
            if (this.context != null) {
                return this.context.ver;
            }
            return -1L;
        }

        public String getChannelId() {
            if (this.context != null) {
                return this.context.cid;
            }
            return "";
        }

        public String getChannelParentId() {
            if (this.context != null) {
                return this.context.pid;
            }
            return "";
        }

        public long getUid() {
            if (this.context != null) {
                return this.context.uid;
            }
            return -1L;
        }

        public String getOperNick() {
            if (this.context != null) {
                return this.context.operNick;
            }
            return "";
        }

        public String getCname() {
            if (this.context != null) {
                return this.context.cname;
            }
            return "";
        }

        public long getTime() {
            if (this.context != null) {
                return this.context.time;
            }
            return -1L;
        }

        public String getMsgId() {
            if (this.context != null) {
                return this.context.msgId;
            }
            return "";
        }

        public String getPwd() {
            if (this.context != null) {
                return this.context.pwd;
            }
            return "";
        }

        public long getSeqId() {
            if (this.context != null) {
                return this.context.seqId;
            }
            return 0L;
        }

        public long getChannelOwnerId() {
            if (this.context != null) {
                return this.context.channelOwnerId;
            }
            return 0L;
        }

        public String getChannelSource() {
            if (this.context != null) {
                return this.context.channelSource;
            }
            return "";
        }

        public void updateSignalContext(SignalContext context) {
            this.context = context;
            if (context != null) {
                this.cId = context.cid;
                this.cName = context.cname;
                this.seqId = context.seqId + "";
            } else {
                this.cId = "";
                this.cName = "";
                this.seqId = "0";
            }
        }
    }
}

