/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.bean;

import biz.ChannelMember;
import com.google.gson.annotations.SerializedName;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.channel.base.ChannelDefine;

@DontProguardClass
public class ChannelUser {
    @SerializedName(value="n")
    public long uid;
    @SerializedName(value="r")
    public int roleType;
    @SerializedName(value="t")
    public long time;
    @SerializedName(value="mrm")
    public int msgReceiveMode = 1;
    @SerializedName(value="i")
    public long inviter;
    @SerializedName(value="s")
    public int source;
    @SerializedName(value="rm")
    public String remark = "";
    public int title = 0;
    public int status = 0;
    public boolean isShowChannelNick = true;
    public boolean isShowChannelTitle = true;
    public String channelTitleName = "";
    public String channelTitleBg = "";

    public static ChannelUser obtain(long uid, int roleType, String remark) {
        ChannelUser user = new ChannelUser();
        user.uid = uid;
        user.roleType = roleType;
        user.remark = remark;
        return user;
    }

    public static ChannelUser obtain(long uid, int roleType) {
        ChannelUser user = new ChannelUser();
        user.uid = uid;
        user.roleType = roleType;
        return user;
    }

    public static ChannelUser obtain(long uid, long time, int roleType) {
        ChannelUser user = new ChannelUser();
        user.uid = uid;
        user.time = time;
        user.roleType = roleType;
        return user;
    }

    public static ChannelUser obtain(ChannelMember member) {
        ChannelUser user = new ChannelUser();
        user.uid = member.uid;
        user.time = member.time;
        user.roleType = member.role;
        if (member.msg_receive_mode > 0) {
            user.msgReceiveMode = member.msg_receive_mode;
        }
        user.remark = member.remark;
        user.inviter = member.inviter;
        user.source = member.source;
        user.title = member.title;
        return user;
    }

    public static ChannelUser obtain(long uid, int roleType, String remark, int title, int status) {
        ChannelUser user = new ChannelUser();
        user.uid = uid;
        user.roleType = roleType;
        user.remark = remark;
        user.title = title;
        user.status = status;
        return user;
    }

    public String toString() {
        if (ChannelDefine.sUnEnableLog) {
            return "ChannelUser{roleType='" + this.roleType + '\'' + '}';
        }
        return "ChannelUser{uid='" + this.uid + '\'' + ", time='" + this.time + '\'' + ", roleType='" + this.roleType + '\'' + ", msgReceiveMode='" + this.msgReceiveMode + '\'' + ", remark='" + this.remark + '\'' + ", inviter='" + this.inviter + '\'' + ", source='" + this.source + '\'' + ", title='" + this.title + '\'' + ", isShowChannelNick='" + this.isShowChannelNick + '\'' + ", isShowChannelTitle='" + this.isShowChannelTitle + '\'' + '}';
    }
}

