/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import biz.CCuteInfo;
import biz.CDynamic;
import biz.CInfo;
import biz.ChannelCarouselType;
import biz.ChannelMember;
import biz.MediaToken;
import biz.PluginInfo;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.bbs.base.bean.TagBean;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.CInterregion;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelDynamicInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelTag;
import com.yy.hiyo.channel.base.bean.ChannelTagItem;
import com.yy.hiyo.channel.base.bean.ChannelUser;
import com.yy.hiyo.channel.base.bean.EnterInfo;
import com.yy.hiyo.channel.base.bean.GangUpRecommendInfo;
import com.yy.hiyo.channel.base.bean.MediaTokenInfo;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.OnlineInfo;
import com.yy.hiyo.channel.base.bean.OnlineWithStatusInfo;
import com.yy.hiyo.channel.base.bean.SameCityInfo;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.ihago.base.tag.Tag;
import net.ihago.channel.srv.mgr.BBSUser;
import net.ihago.channel.srv.mgr.Background;
import net.ihago.channel.srv.mgr.EnterUserInfo;
import net.ihago.online.srv.online.OnlineStatus;
import org.json.JSONObject;

public class BaseRequestManager {
    private static final String TAG = "BaseRequestManager";
    public static final int ERROR_TYPE_TIMEOUT = 99;
    public static final int ERROR_TYPE_DATA_FROM_SERVER = 98;
    private static IChannelCenterService sChannelService;

    public static ChannelUser obtainChannelUser(ChannelMember channelMember) {
        ChannelUser user = new ChannelUser();
        user.uid = channelMember.uid;
        user.inviter = channelMember.inviter;
        user.remark = channelMember.remark;
        user.source = channelMember.source;
        user.roleType = channelMember.role;
        user.msgReceiveMode = channelMember.msg_receive_mode;
        user.time = channelMember.time;
        return user;
    }

    public static MyJoinChannelItem obtainJoinChannelItem(CInfo item) {
        MyJoinChannelItem groupSummay = new MyJoinChannelItem();
        groupSummay.cid = item.cid;
        groupSummay.name = item.name;
        groupSummay.ownerUid = item.owner;
        groupSummay.version = item.version;
        groupSummay.time = item.created_time;
        groupSummay.channelAvatar = item.avatar;
        groupSummay.isPrivate = item.is_private;
        groupSummay.firstType = item.first_type;
        groupSummay.secondType = item.second_type;
        groupSummay.region = new CInterregion();
        if (item.inter_region != null) {
            groupSummay.region.region = item.inter_region.region;
            groupSummay.region.countryCode = item.inter_region.country_code;
        }
        groupSummay.permissionRole = item.post_sync_role == 0 ? 1 : item.post_sync_role;
        if (item.ccute_info != null) {
            groupSummay.cvid = item.ccute_info.vcid;
        }
        if (item.is_city.booleanValue()) {
            SameCityInfo sameCityInfo;
            groupSummay.sameCityInfo = sameCityInfo = new SameCityInfo(item.location_tude, item.country, item.city, item.location);
        }
        if (item.tags != null && item.tags.size() > 0 && item.tags.get(0) != null) {
            TagBean tagBean;
            Tag tag = (Tag)item.tags.get(0);
            groupSummay.tag = tagBean = TagBean.newBuilder().id(tag.tid).text(tag.text).build();
        }
        groupSummay.source = FP.empty((CharSequence)item.source) ? "hago.channel" : item.source;
        groupSummay.indieGameId = item.indie_gameid;
        groupSummay.carouselType = item.carousel_type;
        return groupSummay;
    }

    public static void statMetric(String key, long useTime, boolean success, long errorCode) {
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn() || SettingFlags.getBoolean((String)"groupmetrics", (boolean)false)) {
            if (!(success || ProtoManager.getInstance().isWSConnected() && NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext))) {
                HiidoStatis.reportAppMonitorReturnCode((String)key, (long)useTime, (String)String.valueOf(250));
            } else {
                HiidoStatis.reportAppMonitorReturnCode((String)key, (long)useTime, (String)String.valueOf(success ? 0L : errorCode));
            }
        }
    }

    public static CInfo obtianCInfo(ChannelInfo channelInfo) {
        CInfo.Builder cInfoBuilder = new CInfo.Builder();
        cInfoBuilder.cid(channelInfo.gid);
        cInfoBuilder.pid(channelInfo.pid);
        cInfoBuilder.creator(Long.valueOf(channelInfo.creator));
        cInfoBuilder.owner(Long.valueOf(channelInfo.ownerUid));
        cInfoBuilder.is_private(Boolean.valueOf(channelInfo.isPrivate));
        cInfoBuilder.offical(Boolean.valueOf(channelInfo.isOffcial));
        cInfoBuilder.name(channelInfo.name);
        cInfoBuilder.bulletin(channelInfo.announcement);
        cInfoBuilder.password(channelInfo.password);
        cInfoBuilder.speak_mode(Integer.valueOf(channelInfo.speakMode));
        cInfoBuilder.enter_mode(Integer.valueOf(channelInfo.enterMode));
        cInfoBuilder.join_mode(Integer.valueOf(channelInfo.joinMode));
        cInfoBuilder.voice_mode(Integer.valueOf(channelInfo.openVoiceChatMode));
        cInfoBuilder.channel_voice_enter_mode(Integer.valueOf(channelInfo.voiceEnterMode));
        cInfoBuilder.guest_speak_limit(Integer.valueOf(channelInfo.guestSpeakLimitBitmask));
        cInfoBuilder.created_time(Long.valueOf(channelInfo.createTime));
        cInfoBuilder.post_sync_content(Integer.valueOf(channelInfo.postSyncContent));
        cInfoBuilder.post_sync_role(Integer.valueOf(channelInfo.postSyncRole));
        cInfoBuilder.post_oper_role(Integer.valueOf(channelInfo.postOperRole));
        cInfoBuilder.avatar(channelInfo.avatar);
        cInfoBuilder.version(Integer.valueOf(channelInfo.version));
        cInfoBuilder.master_play_bgm(Integer.valueOf(channelInfo.mBgmMode));
        cInfoBuilder.inter_region(new biz.CInterregion("1", "1"));
        cInfoBuilder.room_avatar(channelInfo.roomAvatar);
        if (StringUtils.isNotEmpty((String)channelInfo.cvid)) {
            cInfoBuilder.ccute_info(new CCuteInfo.Builder().vcid(channelInfo.cvid).build());
        }
        if (channelInfo.theme != null) {
            cInfoBuilder.current_bg_themeid(Integer.valueOf(channelInfo.theme.getThemeId()));
        }
        if (channelInfo.partyTheme != null) {
            cInfoBuilder.party_bg(Integer.valueOf(channelInfo.partyTheme.getThemeId()));
        }
        if (channelInfo.tag != null && channelInfo.tag.getTags() != null && channelInfo.tag.getTags().size() > 0) {
            for (ChannelTagItem item : channelInfo.tag.getTags()) {
                if (item == null) continue;
                Tag.Builder tagBuilder = new Tag.Builder();
                tagBuilder.tid(StringUtils.notNull((String)item.getTagId()));
                cInfoBuilder.tags(Collections.singletonList(tagBuilder.build()));
            }
        }
        cInfoBuilder.disband_expire_second(Long.valueOf(channelInfo.disbandExpireSecond));
        if (channelInfo.isSameCity && null != channelInfo.sameCityInfo) {
            cInfoBuilder.is_city(Boolean.valueOf(true));
            cInfoBuilder.location_tude(channelInfo.sameCityInfo.getLocationTude());
            cInfoBuilder.country(channelInfo.sameCityInfo.getCountry());
            cInfoBuilder.city(channelInfo.sameCityInfo.getCity());
            cInfoBuilder.location(channelInfo.sameCityInfo.getLocation());
        }
        if (channelInfo.lockEnterMode != -1) {
            cInfoBuilder.lock_enter_mode(Integer.valueOf(channelInfo.lockEnterMode));
        }
        if (channelInfo.region != null) {
            cInfoBuilder.inter_region(new biz.CInterregion(channelInfo.region.region, channelInfo.region.countryCode));
        }
        cInfoBuilder.source(channelInfo.source);
        cInfoBuilder.join_pay_level(Long.valueOf(channelInfo.joinPayLevel));
        cInfoBuilder.join_active_time(Long.valueOf(channelInfo.joinActiveTime));
        cInfoBuilder.first_type(Integer.valueOf(channelInfo.firstType));
        cInfoBuilder.second_type(Integer.valueOf(channelInfo.secondType));
        cInfoBuilder.room_show_type(Integer.valueOf(channelInfo.roomShowType));
        cInfoBuilder.channel_show_permit(Integer.valueOf(channelInfo.channelShowPermit));
        cInfoBuilder.relate(Boolean.valueOf(channelInfo.relate));
        cInfoBuilder.light_effect(channelInfo.lightEffect);
        cInfoBuilder.indie_gameid(channelInfo.indieGameId);
        cInfoBuilder.background_img(channelInfo.chatBg);
        cInfoBuilder.hidden_channel_nick(Boolean.valueOf(true));
        return cInfoBuilder.build();
    }

    public static ThemeItemBean obtianBgInfo(Background background) {
        ThemeItemBean themeItemBean = new ThemeItemBean();
        themeItemBean.setThemeId(background.id);
        themeItemBean.setPreUrl(background.preview_url);
        themeItemBean.setUrl(background.bg_url);
        themeItemBean.setExpire(background.expire);
        themeItemBean.setTitleColor(background.title_color);
        themeItemBean.setType(background.type);
        themeItemBean.setSvgaUrl(background.svga_url);
        themeItemBean.setDynamic(background.dynamic_type == 1);
        return themeItemBean;
    }

    public static EnterInfo obtainEnterInfo(net.ihago.channel.srv.mgr.EnterInfo info) {
        EnterInfo enterInfo = new EnterInfo(info.open_game_type, info.open_game_id);
        return enterInfo;
    }

    public static ChannelPluginData obtainPluginData(PluginInfo pluginInfo, String from, String cid) {
        JSONObject json;
        ChannelPluginData channelPluginData = new ChannelPluginData(pluginInfo.type, pluginInfo.pid);
        channelPluginData.setTemplate(pluginInfo.templ);
        channelPluginData.setVersion(pluginInfo.ver);
        channelPluginData.update(false, pluginInfo.ctx, "");
        channelPluginData.putExt("extString", pluginInfo.ext);
        if (channelPluginData.mode == 14 && !FP.empty((CharSequence)pluginInfo.ext)) {
            try {
                json = JsonParser.obtainJSONObject((String)pluginInfo.ext);
                Boolean isVideoOpen = json.optBoolean("is_video_open", false);
                String roundId = json.optString("round_id", "");
                Boolean isKTVOpen = json.optBoolean("is_ktv_open", false);
                channelPluginData.putExt("is_video_open", isVideoOpen);
                channelPluginData.putExt("round_id", roundId);
                channelPluginData.putExt("is_ktv_open", isKTVOpen);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parse json:%s, Exception %s", (Object[])new Object[]{pluginInfo.ext, e});
            }
        }
        if (channelPluginData.mode == 15 && !FP.empty((CharSequence)pluginInfo.ext)) {
            try {
                json = JsonParser.obtainJSONObject((String)pluginInfo.ext);
                Boolean isKTVOpen = json.optBoolean("is_ktv_open", false);
                channelPluginData.putExt("is_ktv_open", isKTVOpen);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parse json:%s, Exception %s", (Object[])new Object[]{pluginInfo.ext, e});
            }
        }
        if (StringUtils.isEmpty((String)channelPluginData.getId()) && StringUtils.isNotEmpty((String)from)) {
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("sfield", cid);
            statContent.put("sfieldtwo", "fromserver");
            statContent.put("sfieldthree", from);
            statContent.put("ifield", pluginInfo.type.intValue());
            statContent.put("perftype", "switchPlugin");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
        return channelPluginData;
    }

    public static MediaTokenInfo obtainMediaTokenInfo(MediaToken info) {
        return MediaTokenInfo.of(info.token.toByteArray(), info.expire);
    }

    public static ChannelInfo obtianChannelInfo(CInfo cInfo) {
        ChannelTag tag;
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.pid = cInfo.pid;
        channelInfo.gid = cInfo.cid;
        channelInfo.creator = cInfo.creator;
        channelInfo.ownerUid = cInfo.owner;
        channelInfo.isPrivate = cInfo.is_private;
        channelInfo.isOffcial = cInfo.offical;
        channelInfo.name = cInfo.name;
        channelInfo.announcement = cInfo.bulletin;
        channelInfo.password = cInfo.password;
        channelInfo.mBgmMode = cInfo.master_play_bgm;
        channelInfo.notAutoInviteMicro = cInfo.not_auto_invite_micro;
        if (cInfo.speak_mode > 0) {
            channelInfo.speakMode = cInfo.speak_mode;
        }
        if (cInfo.join_mode > 0) {
            channelInfo.joinMode = cInfo.join_mode;
        }
        if (cInfo.enter_mode > 0) {
            channelInfo.enterMode = cInfo.enter_mode;
        }
        if (cInfo.voice_mode > 0) {
            channelInfo.openVoiceChatMode = cInfo.voice_mode;
        }
        channelInfo.voiceEnterMode = cInfo.channel_voice_enter_mode;
        channelInfo.guestSpeakLimitBitmask = cInfo.guest_speak_limit;
        channelInfo.createTime = cInfo.created_time;
        channelInfo.cvid = cInfo.ccute_info != null ? cInfo.ccute_info.vcid : "";
        channelInfo.postSyncContent = cInfo.post_sync_content;
        channelInfo.postSyncRole = cInfo.post_sync_role;
        channelInfo.postOperRole = cInfo.post_oper_role;
        channelInfo.tag = tag = new ChannelTag();
        tag.setTags(new ArrayList<ChannelTagItem>(1));
        channelInfo.avatar = cInfo.avatar;
        channelInfo.version = cInfo.version;
        channelInfo.roomAvatar = cInfo.room_avatar;
        channelInfo.carouselType = cInfo.carousel_type;
        if (sChannelService == null) {
            sChannelService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
        }
        if (sChannelService != null) {
            if (cInfo.carousel_type.intValue() == ChannelCarouselType.CCT_OFFICIAL.getValue() || cInfo.carousel_type.intValue() == ChannelCarouselType.CCT_UNION.getValue()) {
                sChannelService.appendLunMicChannel(cInfo.cid, cInfo.carousel_type);
            } else {
                sChannelService.appendNonLunMicChannel(cInfo.cid);
            }
        }
        if (!FP.empty((Collection)cInfo.tags)) {
            Tag from = (Tag)cInfo.tags.get(0);
            ChannelTagItem tagItem = new ChannelTagItem(from.tid);
            tag.update(tagItem, true, null);
        }
        channelInfo.disbandExpireSecond = cInfo.disband_expire_second;
        if (cInfo.is_city.booleanValue()) {
            SameCityInfo sameCityInfo;
            channelInfo.isSameCity = true;
            channelInfo.sameCityInfo = sameCityInfo = new SameCityInfo(cInfo.location_tude, cInfo.country, cInfo.city, cInfo.location);
        }
        channelInfo.type = cInfo.channel_type;
        channelInfo.region = new CInterregion();
        if (cInfo.inter_region != null) {
            channelInfo.region.region = cInfo.inter_region.region;
            channelInfo.region.countryCode = cInfo.inter_region.country_code;
        }
        channelInfo.source = cInfo.source;
        channelInfo.joinPayLevel = cInfo.join_pay_level;
        channelInfo.joinActiveTime = cInfo.join_active_time;
        channelInfo.roomShowType = cInfo.room_show_type;
        channelInfo.channelShowPermit = cInfo.channel_show_permit;
        channelInfo.firstType = cInfo.first_type;
        channelInfo.secondType = cInfo.second_type;
        channelInfo.relate = cInfo.relate;
        channelInfo.lightEffect = cInfo.light_effect;
        channelInfo.indieGameId = cInfo.indie_gameid;
        channelInfo.chatBg = cInfo.background_img;
        channelInfo.isShowChannelNick = cInfo.hidden_channel_nick == false;
        channelInfo.isShowChannelTitle = cInfo.show_channel_title;
        channelInfo.highActiveTitle = cInfo.high_active_title;
        channelInfo.midActiveTitle = cInfo.mid_active_title;
        channelInfo.lowActiveTitle = cInfo.low_active_title;
        channelInfo.carouselType = cInfo.carousel_type;
        return channelInfo;
    }

    public static ChannelDetailInfo obtianChannelInfo(CInfo cInfo, CDynamic dynamicInfo) {
        ChannelDetailInfo detailInfo = new ChannelDetailInfo();
        detailInfo.baseInfo = BaseRequestManager.obtianChannelInfo(cInfo);
        detailInfo.dynamicInfo = new ChannelDynamicInfo();
        if (dynamicInfo != null) {
            detailInfo.dynamicInfo.onlines = dynamicInfo.onlines.intValue();
        }
        return detailInfo;
    }

    public static CInfo obtianSeletorCInfo() {
        ChannelInfo channelInfo = new ChannelInfo();
        channelInfo.pid = "1";
        channelInfo.gid = "1";
        channelInfo.creator = 1L;
        channelInfo.ownerUid = 1L;
        channelInfo.isPrivate = true;
        channelInfo.isOffcial = true;
        channelInfo.name = "1";
        channelInfo.announcement = "1";
        channelInfo.password = "1";
        channelInfo.speakMode = 1;
        channelInfo.joinMode = 1;
        channelInfo.enterMode = 1;
        channelInfo.openVoiceChatMode = 1;
        channelInfo.createTime = 1L;
        channelInfo.avatar = "1";
        ChannelTag tag = new ChannelTag();
        ChannelTagItem firstTag = new ChannelTagItem();
        firstTag.setTagId("1");
        firstTag.setName("1");
        tag.setTags(new ArrayList<ChannelTagItem>(1));
        tag.getTags().add(firstTag);
        channelInfo.tag = tag;
        channelInfo.themeId = 1;
        channelInfo.cvid = "1";
        channelInfo.isSameCity = true;
        channelInfo.sameCityInfo = new SameCityInfo("1", "1", "1", "1");
        channelInfo.disbandExpireSecond = 1L;
        channelInfo.version = 1;
        ThemeItemBean themeItemBean = new ThemeItemBean();
        themeItemBean.setThemeId(1);
        channelInfo.partyTheme = themeItemBean;
        channelInfo.mBgmMode = 1;
        channelInfo.region = new CInterregion("1", "1");
        channelInfo.source = "1";
        channelInfo.joinPayLevel = 1L;
        channelInfo.joinActiveTime = 1L;
        channelInfo.roomShowType = 1;
        channelInfo.channelShowPermit = 1;
        channelInfo.firstType = 1;
        channelInfo.secondType = 1;
        channelInfo.relate = true;
        channelInfo.voiceEnterMode = 1;
        channelInfo.roomAvatar = "1";
        channelInfo.indieGameId = "1";
        channelInfo.chatBg = "1";
        channelInfo.lowActiveTitle = "";
        channelInfo.midActiveTitle = "";
        channelInfo.highActiveTitle = "";
        channelInfo.isShowChannelTitle = true;
        channelInfo.isShowChannelNick = true;
        return BaseRequestManager.obtianCInfo(channelInfo);
    }

    public static ChannelMember obtainSeletor(ChannelUser channelUser) {
        ChannelMember.Builder builder = new ChannelMember.Builder();
        builder.role(Integer.valueOf(channelUser.roleType));
        builder.uid(Long.valueOf(channelUser.uid));
        builder.inviter(Long.valueOf(channelUser.inviter));
        builder.msg_receive_mode(Integer.valueOf(channelUser.msgReceiveMode));
        builder.remark(channelUser.remark == null ? "" : channelUser.remark);
        builder.source(Integer.valueOf(channelUser.source));
        builder.time(Long.valueOf(channelUser.time));
        builder.title(Integer.valueOf(channelUser.title));
        return builder.build();
    }

    public static EnterUserInfo obtainUser(UserInfoKS userInfoBean, long iconFrame, long matchUid, int entry, String postId, long uid, long roomGameMatchUid) {
        EnterUserInfo.Builder builder = new EnterUserInfo.Builder();
        if (userInfoBean != null) {
            builder.nick(userInfoBean.nick);
            builder.url(userInfoBean.avatar);
            builder.sex(Integer.valueOf(userInfoBean.sex));
        }
        builder.icon_frame(Long.valueOf(iconFrame));
        if (entry == 41) {
            builder.bbs_user(BaseRequestManager.obtainBBSUser(postId, uid));
        } else {
            builder.radio_uids(Collections.singletonList(matchUid));
        }
        builder.interested_player(Long.valueOf(roomGameMatchUid));
        return builder.build();
    }

    public static BBSUser obtainBBSUser(String postId, long uid) {
        BBSUser.Builder builder = new BBSUser.Builder();
        builder.uid(Long.valueOf(uid));
        builder.post_id(postId);
        return builder.build();
    }

    public static List<SeatUser> obtainSeats(List<biz.SeatUser> seatUsers) {
        ArrayList<SeatUser> seats = new ArrayList<SeatUser>();
        if (seatUsers != null && seatUsers.size() > 0) {
            for (biz.SeatUser seatUser : seatUsers) {
                SeatUser seat = new SeatUser();
                seat.index = seatUser.seat;
                seat.uid = seatUser.uid;
                seat.status = seatUser.status;
                seat.ts = seatUser.ts;
                seats.add(seat);
            }
        }
        return seats;
    }

    public static interface IIsBannedCallBack {
        public void banned(String var1, long var2, long var4, long var6);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetAllMembersCallBack {
        public void onSuccess(String var1, long var2, List<ChannelMember> var4, List<OnlineStatus> var5);

        public void onTopGroupNotExist(String var1, int var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetGangUpRecommendListCallback {
        public void onSuccess(@NonNull List<GangUpRecommendInfo> var1);

        public void onError(int var1, String var2);
    }

    public static interface IGetChannelInfoCallBack {
        public void onSuccess(ChannelInfo var1, int var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetTopAndSubGroupInfosCallBack {
        public void onSuccess(List<CInfo> var1, List<CDynamic> var2, List<Integer> var3, List<Integer> var4, ThemeItemBean var5);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetRoleListCallBack {
        public void onSuccess(List<ChannelUser> var1, ProtoManager.Page var2, ProtoManager.Page var3);

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface IGetUserListWithWithStatusCallBack {
        public void onSuccess(OnlineWithStatusInfo var1, ProtoManager.Page var2, ProtoManager.Page var3);

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface IGetUserListWithTotalCallBack {
        public void onSuccess(OnlineInfo var1, ProtoManager.Page var2, ProtoManager.Page var3);

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface IGetUserListCallBack {
        public void onSuccess(ArrayList<ChannelUser> var1, HashMap<Integer, Long> var2);

        public void onError(int var1, String var2, Exception var3);
    }

    public static interface IRequestCallBack {
        public void onSuccess();

        default public void updateLimit(String toast) {
        }

        default public void limitNoToast() {
        }

        default public void onFailUnauthorized() {
        }

        default public void onContainSensitiveWord() {
        }

        public void onError(int var1, String var2, Exception var3);

        default public void onRecommendTagUpdate(@Nullable String tagId) {
        }
    }

    public static interface ICreateGroupCallBack {
    }
}

