/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base;

import android.net.Uri;
import android.os.Message;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import biz.SourceEntry;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.ChannelTimingStat;
import com.yy.hiyo.channel.base.ChannelGameBaseInfo;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.service.IChannel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.channel.srv.mgr.ShowInfo;

public class EnterParam
implements Serializable {
    private static final String JOIN_ROOM_SESSION_KEY = "joinrskey";
    public String roomId = "";
    public int channelType = 0;
    public int entry = 0;
    public EntryInfo entryInfo;
    public ChannelGameBaseInfo gameInfo;
    public boolean isBackToList;
    public int sex;
    private static final int SIZE_INIT = 2;
    public HashMap<String, Object> extra;
    public String password;
    public String pwdToken;
    public boolean isRejoin;
    public long headIcon;
    public boolean isQuickMatch;
    public boolean isVipSeat;
    public long matchedUid;
    public int subPage;
    public boolean joinChannel = false;
    public boolean hideInfoPage = false;
    public long enterStartTime = 0L;
    public long cardId;
    public ICallBack callBack;
    public String postId;
    public String postToken;
    public String postPageSource;
    public boolean isShowGamePanel = false;
    public boolean isRoom = false;
    public boolean openParty = false;
    public boolean backToChannelList = false;
    public boolean canAutoOpenDrawerList = true;
    public long showShortTipsUid = 0L;
    public long showTipsUid = 0L;
    public ShowInfo showInfo;
    public String backRoomId;
    public boolean isInvited = false;
    public List<String> matchGameIds = null;
    public ChannelTimingStat mChannelTimingStat = new ChannelTimingStat();
    public long roomGameMatchUid = 0L;
    public String roomGameMatchNick;
    public String roomGameMatchAvatar;
    public String inGameId = "";
    public CreateChannelParams mFromCreateParams = null;
    public boolean forceExitGame = false;
    public String joinMemberFrom = "0";
    public long enterUid;
    public boolean swipeEnd;
    public boolean joinLoadingHasShown;
    public String activityId;
    public String activityExtend;
    public String brctPublishId;
    public String preSource = "";
    public boolean skipGroupInfoPage = false;
    public boolean isLudoNewUser = false;
    public GuideGameConfig guideGameConfig;
    public boolean forceShowHomePage = false;
    private static IAB joinTypeABValue = null;
    private static IAB middlePhoneEnableAni = null;

    public void clear() {
        this.roomId = "";
        this.entry = 0;
        this.entryInfo = null;
        this.gameInfo = null;
        this.isBackToList = false;
        this.isQuickMatch = false;
        this.isVipSeat = false;
        this.matchedUid = 0L;
        this.cardId = -1L;
        this.matchGameIds = null;
        this.openParty = false;
        this.backToChannelList = false;
        this.callBack = null;
        this.showInfo = null;
        this.backRoomId = "";
        this.roomGameMatchUid = 0L;
        this.roomGameMatchNick = "";
        this.roomGameMatchAvatar = null;
        this.inGameId = "";
        this.swipeEnd = false;
        this.enterUid = 0L;
        this.joinLoadingHasShown = false;
        this.activityId = null;
        this.activityExtend = null;
        this.brctPublishId = "";
        this.guideGameConfig = null;
    }

    public EnterParam() {
    }

    public static String createJoinSession() {
        int sessionIndex = SettingFlags.getIntValue((String)JOIN_ROOM_SESSION_KEY, (int)0);
        SettingFlags.setIntValue((String)JOIN_ROOM_SESSION_KEY, (int)(++sessionIndex));
        return "" + System.currentTimeMillis() + SystemClock.uptimeMillis() + sessionIndex;
    }

    public EnterParam(Builder builder) {
        this.gameInfo = builder.gameInfo;
        this.entry = builder.entry;
        this.entryInfo = builder.entryInfo;
        this.extra = builder.extra == null ? new HashMap(0) : builder.extra;
        this.roomId = StringUtils.ensureNotNull((String)builder.roomId);
        this.password = StringUtils.ensureNotNull((String)builder.password);
        this.pwdToken = StringUtils.ensureNotNull((String)builder.pwdToken);
        this.isRejoin = builder.isRejoin;
        this.headIcon = builder.headIconId;
        this.isQuickMatch = builder.isQuickMatch;
        this.isBackToList = builder.isBackToList;
        this.sex = builder.sex;
        this.isVipSeat = builder.isVipSeat;
        this.matchedUid = builder.matchedUid;
        this.cardId = builder.cardId;
        this.postId = builder.postId;
        this.postToken = builder.postToken;
        this.postPageSource = builder.postPageSource;
        this.matchGameIds = builder.matchGameIds;
        this.openParty = builder.openParty;
        this.callBack = builder.callBack;
        this.backToChannelList = builder.backToChannelList;
        this.joinChannel = builder.joinChannel;
        this.showTipsUid = builder.showTipsUid;
        this.showShortTipsUid = builder.showShortTipsUid;
        this.showInfo = builder.showInfo;
        this.backRoomId = builder.backRoomId;
        this.isInvited = builder.isinVited;
        this.roomGameMatchUid = builder.roomGameMatchUid;
        this.roomGameMatchNick = builder.roomGameMatchNick;
        this.roomGameMatchAvatar = builder.roomGameMatchAvatar;
        this.inGameId = builder.inGameId;
        this.joinMemberFrom = builder.joinMemberFrom;
        this.activityId = builder.activityId;
        this.activityExtend = builder.activityExtend;
        this.enterUid = builder.enterUid;
        this.preSource = builder.preSource;
        this.skipGroupInfoPage = builder.skipGroupInfoPage;
    }

    public EnterParam(EnterParam enterParam) {
        HashMap<String, Object> hashMap;
        this.gameInfo = enterParam.gameInfo;
        this.entry = enterParam.entry;
        if (enterParam.extra == null) {
            HashMap<String, Object> hashMap2;
            hashMap = hashMap2;
            super(0);
        } else {
            hashMap = enterParam.extra;
        }
        this.extra = hashMap;
        this.roomId = StringUtils.ensureNotNull((String)enterParam.roomId);
        this.password = StringUtils.ensureNotNull((String)enterParam.password);
        this.pwdToken = StringUtils.ensureNotNull((String)enterParam.pwdToken);
        this.isRejoin = enterParam.isRejoin;
        this.headIcon = enterParam.headIcon;
        this.isQuickMatch = enterParam.isQuickMatch;
        this.isBackToList = enterParam.isBackToList;
        this.sex = enterParam.sex;
        this.isVipSeat = enterParam.isVipSeat;
        this.matchedUid = enterParam.matchedUid;
        this.enterStartTime = enterParam.enterStartTime;
        this.cardId = enterParam.cardId;
        this.postId = enterParam.postId;
        this.postToken = enterParam.postToken;
        this.postPageSource = enterParam.postPageSource;
        this.matchGameIds = enterParam.matchGameIds;
        this.openParty = enterParam.openParty;
        this.backToChannelList = enterParam.backToChannelList;
        this.canAutoOpenDrawerList = enterParam.canAutoOpenDrawerList;
        this.mChannelTimingStat = enterParam.mChannelTimingStat;
        this.joinChannel = enterParam.joinChannel;
        this.showTipsUid = enterParam.showTipsUid;
        this.showShortTipsUid = enterParam.showShortTipsUid;
        this.showInfo = enterParam.showInfo;
        this.backRoomId = enterParam.backRoomId;
        this.inGameId = enterParam.inGameId;
        this.joinMemberFrom = enterParam.joinMemberFrom;
        this.joinLoadingHasShown = enterParam.joinLoadingHasShown;
        this.activityId = enterParam.activityId;
        this.activityExtend = enterParam.activityExtend;
        this.skipGroupInfoPage = enterParam.skipGroupInfoPage;
    }

    public <T> T getExtra(String key, T defaultValue) {
        if (this.extra == null) {
            return defaultValue;
        }
        Object value = this.extra.get(key);
        if (value != null && (value.getClass().isInstance(defaultValue) || defaultValue == null)) {
            return (T)value;
        }
        return defaultValue;
    }

    public void setExtra(String key, Object value) {
        if (null == this.extra) {
            this.extra = new HashMap();
        }
        this.extra.put(key, value);
    }

    public static EnterParam obtain(String cid, int from) {
        return EnterParam.obtain(cid, from, null, null);
    }

    public static EnterParam obtain(String cid, int from, String password) {
        return EnterParam.obtain(cid, from, password, null);
    }

    public static EnterParam obtain(String cid, int from, String password, String pwdToken) {
        return EnterParam.obtain(cid, from, password, pwdToken, null);
    }

    public static EnterParam obtain(String cid, int from, String password, String pwdToken, ICallBack callBack) {
        Builder enterChannelParams = EnterParam.of(cid);
        enterChannelParams.entry = from;
        enterChannelParams.password = password;
        enterChannelParams.pwdToken = pwdToken;
        enterChannelParams.callBack = callBack;
        return enterChannelParams.build();
    }

    public static Builder of(@NonNull String roomId) {
        return new Builder().roomId(roomId).putExtra("JOIN_SESSION", EnterParam.createJoinSession());
    }

    public static Builder of(@NonNull ChannelGameBaseInfo gameInfo) {
        return new Builder().gameInfo(gameInfo).putExtra("JOIN_SESSION", EnterParam.createJoinSession());
    }

    public static Builder of(String channelId, String postId, long uid) {
        return new Builder().roomId(channelId).setPostId(postId).matchedUid(uid).putExtra("JOIN_SESSION", EnterParam.createJoinSession());
    }

    public static Builder of(String channelId, String postId, String postToken, long uid, String postPageSource) {
        return new Builder().roomId(channelId).setPostId(postId).matchedUid(uid).setPostToken(postToken).setPostPageSource(postPageSource).putExtra("JOIN_SESSION", EnterParam.createJoinSession());
    }

    public static Builder of(String gid, int template, String ver) {
        ChannelGameBaseInfo info = null;
        if (StringUtils.isNotEmpty((String)gid)) {
            info = new ChannelGameBaseInfo(gid, template, ver);
        }
        return EnterParam.of(info);
    }

    public static Builder of(List<String> gameIds) {
        return new Builder().matchGameIds(gameIds).putExtra("JOIN_SESSION", EnterParam.createJoinSession());
    }

    public String toString() {
        if (!RuntimeContext.isInGray()) {
            return "EnterParam{roomId='" + this.roomId + '\'' + ", isQuickMatch=" + this.isQuickMatch + ", gameId=" + (this.gameInfo != null ? this.gameInfo.gid : "") + '}';
        }
        return "EnterParam{roomId='" + this.roomId + '\'' + ", entry=" + this.entry + ", gameInfo=" + this.gameInfo + ", isBackToList=" + this.isBackToList + ", sex=" + this.sex + ", password='" + this.password + '\'' + ", pwdToken='" + this.pwdToken + '\'' + ", isRejoin=" + this.isRejoin + ", headIcon=" + this.headIcon + ", isQuickMatch=" + this.isQuickMatch + ", matchedUid=" + this.matchedUid + ", isVipSeat=" + this.isVipSeat + ", openParty=" + this.openParty + ", openChannelList=" + this.backToChannelList + ", postId=" + this.postId + ", postToken=" + this.postToken + ", postPageSource=" + this.postPageSource + ", matchedUid=" + this.matchedUid + ", pluginType=" + this.getExtra("pluginType", 0) + ", subCId:%s" + this.getExtra("subChannelId", "") + ", mFromCreateParams=" + this.mFromCreateParams + ", swipeEnd=" + this.swipeEnd + ", activityId=" + this.activityId + ", activityExtend=" + this.activityExtend + ", backRoomId=" + this.backRoomId + '}';
    }

    public static boolean useTextChannelAndVoiceCoexistence() {
        return SettingFlags.getBoolean((String)"keyvoiceandtextchannelExist", (boolean)true);
    }

    public static void openBackChannelAndParty(IChannel channel, String backChannelId) {
        MLog.info((Object)"EnterParam", (String)"openBackChannelAndParty backChannelId:%s, cid:%s", (Object[])new Object[]{backChannelId, channel.getChannelId()});
        if (!FP.empty((CharSequence)backChannelId)) {
            EnterParam enterChannelParams = EnterParam.of(backChannelId).entry(47).putExtra("show_window_animation", false).putExtra("subChannelId", channel.getChannelId()).openParty(false).build();
            Message msg = Message.obtain();
            msg.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
            msg.obj = enterChannelParams;
            MsgDispatcher.getInstance().sendMessage(msg);
        } else {
            MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL, 1, -1, (Object)channel.getChannelId());
        }
    }

    public boolean isFromChannelParty() {
        EnterParam e;
        Uri deepLinkUri;
        boolean result;
        boolean bl = result = this.entry == 45;
        if (!result && null != (deepLinkUri = (Uri)this.getExtra("deep_link", null))) {
            result = deepLinkUri.getBooleanQueryParameter("isBackToGroup", false);
        }
        if (!result && this.entry == 23 && this.showInfo != null && this.showInfo.show_type == 2) {
            result = true;
        }
        if (!result && (e = this.getExtra("bring_to_front_params", new EnterParam())) != null) {
            result = e.entry == 45;
        }
        return result;
    }

    public boolean isFromTeamUpGuide() {
        return this.entry == JoinChannelFrom.SE_TEAM_UP_DDL;
    }

    public boolean isFromMainListenTogether() {
        if (!this.extra.containsKey("JOIN_GROUP_FROM")) {
            return false;
        }
        return JoinChannelFrom.SE_MAIN_LISTEN_TOGETHER == this.getExtra("JOIN_GROUP_FROM", 0);
    }

    public static boolean isGameOpenEntry(int entry) {
        return entry == JoinChannelFrom.SE_GAME_ENTRY || entry == 117 || entry == 118;
    }

    public static IAB getJoinTypeABValue() {
        if (joinTypeABValue != null) {
            return joinTypeABValue;
        }
        if (NewABDefine.CHANNEL_VIDEO_JOIN_TYPE.isTestValid()) {
            joinTypeABValue = NewABDefine.CHANNEL_VIDEO_JOIN_TYPE.getTest();
        }
        return joinTypeABValue;
    }

    public static IAB getMiddlePhoneEnableAni() {
        if (middlePhoneEnableAni != null) {
            return middlePhoneEnableAni;
        }
        if (NewABDefine.CHANNEL_MIDDLE_PHONE_ENABLE_ANI.isTestValid()) {
            middlePhoneEnableAni = NewABDefine.CHANNEL_MIDDLE_PHONE_ENABLE_ANI.getTest();
        }
        return middlePhoneEnableAni;
    }

    public static class GuideGameConfig {
        public String gid = "";

        public GuideGameConfig(String gid) {
            this.gid = gid;
        }
    }

    public static interface ICallBack {
        public static final int ERRORCODE_GUEST_NEED_LOGIN = 1000000;
        public static final int REFUSE_PRIVACY_AGREEMENT = 1000001;
        public static final int CANCEL = 1000002;
        public static final int NET_NOT_CONNECT = 1000003;

        public void onSuccess();

        public void onError(int var1, String var2);
    }

    public static class JoinChannelFrom {
        public static final int ERENone = 0;
        public static final int EREHomeRoom = 1;
        public static final int EREHomeGame = 2;
        public static final int ERERoomList = 3;
        public static final int EREGameList = 4;
        public static final int EREGameRand = 5;
        public static final int EREInsidePush = 6;
        public static final int EREShare = 7;
        public static final int EREUinfo = 8;
        public static final int EREHistory = 9;
        public static final int EREIcon = 10;
        public static final int EREFollow = 11;
        public static final int EREQuickJoin = 12;
        public static final int EREStepUinfo = 13;
        public static final int EREPush = 14;
        public static final int EREAggregationNearby = 15;
        public static final int EREAggregationKTV = 16;
        public static final int EREAggregationOper = 17;
        public static final int EREFullServerPush = 18;
        public static final int EREChannelList = 19;
        public static final int ERERadioStation = 20;
        public static final int EREChannelNotice = 22;
        public static final int EREFromCreate = 23;
        public static final int EREChannelSwitch = 24;
        public static final int EREAggregationTopic = 25;
        public static final int ERERandomGameDialog = 26;
        public static final int EREMyJoinedChannelList = 27;
        public static final int ERESubChannelList = 28;
        public static final int EREReturnFromGame = 29;
        public static final int ERESearchUserResult = 30;
        public static final int ERESearchChannelResult = 31;
        public static final int ERETabMyChannel = 32;
        public static final int ERETabRecommend = 33;
        public static final int ERETabGame = 34;
        public static final int ERETabTopicSquare = 35;
        public static final int EREFriendRecommend = 36;
        public static final int MY_CHANNEL_POST = 37;
        public static final int ERETabRadio = 38;
        public static final int ERGameUserToChannel = 39;
        public static final int EREAPPLAYER = 40;
        public static final int EREBBSPOST = 41;
        public static final int EREOtherTab = 42;
        public static final int SE_SEARCH_RECOMMEND = 43;
        public static final int SE_NEW_USER_GUIDE = 44;
        public static final int SE_CHANNEL_PARTY = 45;
        public static final int SE_PARTY_BACK_TO_CHANNEL = 47;
        public static final int SE_OFFICIAL_RECOMMEND = 48;
        public static final int SE_RANDOM_POPUP = 49;
        public static final int ImRecomChannel = 50;
        public static final int EREPartyMaster = 52;
        public static final int SE_BACK_USER = 53;
        public static final int ProfileMyChannel = 54;
        public static final int ProfileOtherChannel = 55;
        public static final int SE_SCREEN_SHARE = 56;
        public static final int SE_CHANNEL_SETTING = 57;
        public static final int SE_CHANNEL_MORE_PAGE = 58;
        public static final int SE_SEARCH_PAGE = 59;
        public static final int SAME_CITY = 60;
        public static final int SE_SIDE_LIST_RECOM = 61;
        public static final int GAME_GROUP = 62;
        public static final int SE_HOME_PARTY_SECOND = 64;
        public static final int MUSIC_BAND_LIST = 65;
        public static final int SE_GENERAL_MATCH = 66;
        public static final int SE_MULTI_VIDEO_MAIN_PAGE = 67;
        public static final int SE_MULTI_VIDEO_LIST = 68;
        public static final int SE_MY_JOIN_CHANNEL_NEW = 69;
        public static final int QUICKJOIN_FROM_DEEPLINK_BUY = 70;
        public static final int QUICKJOIN_FROM_DEEPLINK_ACTIVITY = 71;
        public static final int SE_IM_DISCOVERY_PAGE = 72;
        public static final int SE_BBS_FOLLOW_TAB_TOP = 73;
        public static final int SE_BBS_POST_INFO = 74;
        public static final int SE_RADIO_LIVE_END_RECOMMEND = 75;
        public static final int FAMILY_LIVING_ROOM_LIST = 101;
        public static final int VOICE_ROOM_FAMILY_CHANNEL_TICKET_MSG = 102;
        public static final int VOICE_ROOM_FAMILY_CHANNEL_GIFT_MSG = 103;
        public static final int RESUME_FROM_TEXT_GROUP = 104;
        public static final int ENTER_FROM_NEARBY = 105;
        public static final int CHAT_TAB_QUICKJOIN = 106;
        public static final int SE_IM_RECOMMEND_HOT = 110;
        public static final int SE_MULTIVIDEO_PREVIEW_PAGE = SourceEntry.SE_MULTIVIDEO_PREVIEW_PAGE.getValue();
        public static final int SE_IM_PLUS = SourceEntry.SE_IM_PLUS.getValue();
        public static final int SE_ADDRESS_BOOK_DISCOVERY = SourceEntry.SE_ADDRESS_BOOK_DISCOVERY.getValue();
        public static final int SE_PLATFORM_FIND_GAME = SourceEntry.SE_PLATFORM_FIND_GAME.getValue();
        public static final int SE_MULTI_VIDEO_TAB_MODULE = SourceEntry.SE_MULTI_VIDEO_TAB_MODULE.getValue();
        public static final int SE_MULTI_VIDEO_TAB_QUICK_JOIN = SourceEntry.SE_MULTI_VIDEO_TAB_QUICK_JOIN.getValue();
        public static final int SE_MULTI_VIDEO_GENERAL_ROOM_CHANGE = 114;
        public static final int SE_GAME_ENTRY = SourceEntry.SE_LUDO_GAME.getValue();
        public static final int SE_TAG_DETAIL_ENTRY = SourceEntry.SE_TAG_DETAIL.getValue();
        public static final int SE_GAME_MY_CHANNEL = 117;
        public static final int SE_GAME_RECOMMEND_LIST = 118;
        public static final int SE_BBS_DISCOVERY_PEOPLE = 119;
        public static final int LOW_ACT_GUIDE_ROOM = 121;
        public static final int LOW_ACT_PUSH_GUIDE = 122;
        public static final int LOW_ACT_PUSH_GIFT_GUIDE = 123;
        public static final int SE_NEWBIE_QUICK_JOIN_MODULE = SourceEntry.SE_NEWBIE_QUICK_JOIN_MODULE.getValue();
        public static final int LOW_ACT_DAY_TWO_TOAST = SourceEntry.SE_LOW_ACT_DAY_TWO_TOAST.getValue();
        public static final int SE_SOCIAL_MATCH_FIRST = 125;
        public static final int SE_SOCIAL_MATCH_SECOND = 126;
        public static final int EXIT_RECOMMEND_GOOD_ROOMS = 127;
        public static final int SE_FAMILY_CALL = 130;
        public static final int SE_ADD_NEW_FRIEND = 139;
        public static final int SE_MAIN_LISTEN_TOGETHER = SourceEntry.SE_MAIN_LISTEN_TOGETHER.getValue();
        public static final int SE_GAME_OVER_GUIDE = 141;
        public static final int SE_AUDIO_ROOM_PK_TOP = 142;
        public static final int SE_PUSH_PLATFORM = 143;
        public static final int SE_IM_LIST = 145;
        public static final int SE_FAMILY_DETAIL_PAGE = 147;
        public static final int SE_HOMEPAGE_FAMILY_LIST = 148;
        public static final int SE_FIND_FRIEND_BROADCAST = SourceEntry.SE_FRIEND_BROADCAST.getValue();
        public static final int SE_IM_SHARE_CLICK = 154;
        public static final int SE_FLOAT_RECOM = 155;
        public static final int SE_PK_ENTRY = 156;
        public static final int ENTER_HOME_RECENT = 158;
        public static final int ENTER_FOLLOWER_ONLINE = 159;
        public static final int SE_PARTY_GAME_PAGE_LIST = SourceEntry.SE_PARTY_GAME_PAGE_LIST.getValue();
        public static final int SE_HOMEPAGE_ROOM_TYPE_LIST = 162;
        public static final int SE_ASSIST_GAME_CHANGE_ROOM = 163;
        public static final int SE_HOME_LIVE_SPECIAL = 164;
        public static final int SE_HOME_CHAT_SPECIAL = 165;
        public static final int SE_TODAY = 166;
        public static final int SE_CHANNEL_BBS_POST = SourceEntry.SE_CHANNEL_BBS_POST.getValue();
        public static final int SE_BBS_IMG_ENTER = SourceEntry.SE_BBS_IMG_ENTER.getValue();
        public static final int SE_BBS_VIDEO_ENTER = SourceEntry.SE_BBS_VIDEO_ENTER.getValue();
        public static final int SE_TEAM_UP_DDL = SourceEntry.SE_TEAM_UP_DDL.getValue();
        public static final int SE_PLAY_WITH_FRIENDS = 177;
        public static final int SE_IM_CHAT = 178;
        public static final int SE_PARTY_GAME_QUICK_JOIN = 179;
        public static final int SE_GAME_UP_LIST = 181;
    }

    public static final class Builder {
        private int entry = 0;
        private EntryInfo entryInfo;
        public ChannelGameBaseInfo gameInfo;
        private HashMap<String, Object> extra;
        private String roomId;
        private String password;
        private String pwdToken;
        private boolean isRejoin;
        private long headIconId;
        private boolean isQuickMatch;
        private boolean isBackToList;
        private int sex;
        private String join;
        private boolean isVipSeat;
        private long matchedUid;
        private long cardId;
        private ICallBack callBack;
        private boolean openParty;
        private boolean backToChannelList;
        private boolean canAutoOpenDrawerList = true;
        private boolean joinChannel = false;
        private long showTipsUid = 0L;
        private long showShortTipsUid = 0L;
        private ShowInfo showInfo;
        private String backRoomId;
        private boolean isinVited = false;
        private String postId;
        private String postToken;
        private String postPageSource;
        private List<String> matchGameIds;
        private String inGameId;
        private long roomGameMatchUid = 0L;
        private String roomGameMatchNick = "";
        private String roomGameMatchAvatar = null;
        private String joinMemberFrom = "0";
        private String activityId = null;
        private String activityExtend = null;
        private long enterUid = 0L;
        private String preSource = "";
        private boolean skipGroupInfoPage = false;

        private Builder() {
        }

        public Builder callback(ICallBack val) {
            this.callBack = val;
            return this;
        }

        public Builder gameInfo(ChannelGameBaseInfo val) {
            this.gameInfo = val;
            return this;
        }

        public Builder entry(int from) {
            this.entry = from;
            return this;
        }

        public Builder entryInfo(EntryInfo entryInfo) {
            this.entryInfo = entryInfo;
            return this;
        }

        public Builder putExtra(String key, Object value) {
            if (this.extra == null) {
                this.extra = new HashMap(2);
            }
            this.extra.put(key, value);
            return this;
        }

        public Builder putExtraAll(Map<String, Object> map) {
            if (map == null) {
                return null;
            }
            if (this.extra == null) {
                this.extra = new HashMap(2);
            }
            this.extra.putAll(map);
            return this;
        }

        public Builder roomId(String val) {
            this.roomId = val;
            return this;
        }

        public Builder password(String val) {
            this.password = val;
            return this;
        }

        public Builder pwdToken(String val) {
            this.pwdToken = val;
            return this;
        }

        public Builder isRejoin(boolean val) {
            this.isRejoin = val;
            return this;
        }

        public Builder headIcon(long headIconId) {
            this.headIconId = headIconId;
            return this;
        }

        public Builder isQuickMatch(boolean isQuickMatch) {
            this.isQuickMatch = isQuickMatch;
            return this;
        }

        public Builder isBackToList(boolean isBackToList) {
            this.isBackToList = isBackToList;
            return this;
        }

        public Builder sex(int sex) {
            this.sex = sex;
            return this;
        }

        public Builder isVipSeat(boolean isVipSeat) {
            this.isVipSeat = isVipSeat;
            return this;
        }

        public Builder matchedUid(long uid) {
            this.matchedUid = uid;
            return this;
        }

        public Builder cardId(long cardId) {
            this.cardId = cardId;
            return this;
        }

        public Builder setPostId(String postId) {
            this.postId = postId;
            return this;
        }

        public Builder setPostToken(String postToken) {
            this.postToken = postToken;
            return this;
        }

        public Builder setPostPageSource(String postPageSource) {
            this.postPageSource = postPageSource;
            return this;
        }

        public Builder matchGameIds(List<String> matchGameIds) {
            this.matchGameIds = matchGameIds;
            return this;
        }

        public Builder openParty(boolean openParty) {
            this.openParty = openParty;
            return this;
        }

        public Builder openChannelList(boolean isOpen) {
            this.backToChannelList = isOpen;
            return this;
        }

        public Builder canAutoOpenDrawerList(boolean canOpen) {
            this.canAutoOpenDrawerList = canOpen;
            return this;
        }

        public Builder showTipsUis(long uid) {
            this.showTipsUid = uid;
            return this;
        }

        public Builder showShortTipsUid(long uid) {
            this.showShortTipsUid = uid;
            return this;
        }

        public Builder joinChannel(boolean joinChannel) {
            this.joinChannel = joinChannel;
            return this;
        }

        public Builder isInvited(boolean isinVited) {
            this.isinVited = isinVited;
            return this;
        }

        public Builder showInfo(ShowInfo showInfo) {
            this.showInfo = showInfo;
            return this;
        }

        public Builder backRoomId(String backRoomId) {
            this.backRoomId = backRoomId;
            return this;
        }

        public Builder roomGameMatchUid(long roomGameMatchUid) {
            this.roomGameMatchUid = roomGameMatchUid;
            return this;
        }

        public Builder roomGameMachNick(String roomGameMatchNick) {
            this.roomGameMatchNick = roomGameMatchNick;
            return this;
        }

        public Builder roomGameMatchAvatar(String roomGameMatchAvatar) {
            this.roomGameMatchAvatar = roomGameMatchAvatar;
            return this;
        }

        public Builder inGameId(String inGameId) {
            this.inGameId = inGameId;
            return this;
        }

        public Builder joinMemberFrom(String from) {
            this.joinMemberFrom = from;
            return this;
        }

        public Builder activity(String activityId) {
            this.activityId = activityId;
            return this;
        }

        public Builder activityExtend(String activityExtend) {
            this.activityExtend = activityExtend;
            return this;
        }

        public Builder enterUid(long enterUid) {
            this.enterUid = enterUid;
            return this;
        }

        public Builder preSource(String preSource) {
            this.preSource = preSource;
            return this;
        }

        public Builder skipGroupInfoPage(boolean skipGroupInfoPage) {
            this.skipGroupInfoPage = skipGroupInfoPage;
            return this;
        }

        public EnterParam build() {
            return new EnterParam(this);
        }
    }
}

