/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.widget;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import androidx.annotation.DrawableRes;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.base.R;
import com.yy.hiyo.channel.base.widget.OnAnimationListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u0000 x2\u00020\u0001:\u0003xyzB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020C2\u0006\u0010G\u001a\u00020HH\u0014J\u0010\u0010I\u001a\u00020C2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010J\u001a\u00020*2\u0006\u0010K\u001a\u00020LH\u0004J\u0010\u0010M\u001a\u00020>2\u0006\u0010N\u001a\u00020*H\u0002J(\u0010M\u001a\u00020>2\u0006\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020\tH\u0002J\u0006\u0010T\u001a\u00020\fJ\b\u0010U\u001a\u00020CH\u0014J\u000e\u0010V\u001a\u00020C2\u0006\u0010W\u001a\u00020\fJ\u0012\u0010X\u001a\u00020C2\b\u0010Y\u001a\u0004\u0018\u00010LH\u0016J\u0010\u0010Z\u001a\u00020C2\u0006\u0010[\u001a\u00020\tH\u0016J\u0010\u0010\\\u001a\u00020C2\u0006\u0010]\u001a\u00020\tH\u0016J\u001a\u0010^\u001a\u00020C2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\t0_J\u001a\u0010`\u001a\u00020C2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020\"0_J\u000e\u0010a\u001a\u00020C2\u0006\u0010b\u001a\u00020\u001eJ\u000e\u0010c\u001a\u00020C2\u0006\u0010d\u001a\u00020eJ\u000e\u0010f\u001a\u00020C2\u0006\u0010g\u001a\u00020hJ\u000e\u0010i\u001a\u00020C2\u0006\u0010j\u001a\u00020\tJ\u0010\u0010k\u001a\u00020C2\b\b\u0001\u0010l\u001a\u00020\tJ\u000e\u0010m\u001a\u00020C2\u0006\u0010n\u001a\u00020\tJ\u000e\u0010o\u001a\u00020C2\u0006\u0010O\u001a\u00020\tJ\u001a\u0010p\u001a\u00020C2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020>0_J\u000e\u0010q\u001a\u00020C2\u0006\u0010r\u001a\u00020@J\u0010\u0010s\u001a\u00020C2\u0006\u0010t\u001a\u00020\tH\u0016J\b\u0010u\u001a\u00020CH\u0016J\u0006\u0010v\u001a\u00020CJ\u0006\u0010w\u001a\u00020CR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\u00020\t2\u0006\u00100\u001a\u00020\t@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010%\"\u0004\b3\u0010'R\u001a\u00104\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010%\"\u0004\b6\u0010'R\u001a\u00107\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010%\"\u0004\b9\u0010'R\u001a\u0010:\u001a\u00020\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010%\"\u0004\b<\u0010'R\u0016\u0010=\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lcom/yy/hiyo/channel/base/widget/ScanAnimLayout;", "Lcom/yy/base/memoryrecycle/views/YYRelativeLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isAnimating", "", "()Z", "setAnimating", "(Z)V", "isAutoStart", "setAutoStart", "isUpdatedTranslateRange", "mAnimDuration", "", "getMAnimDuration", "()J", "setMAnimDuration", "(J)V", "mColorEvaluator", "Lcom/yy/hiyo/channel/base/widget/ScanAnimLayout$Evaluator;", "mGroup", "Lcom/yy/hiyo/channel/base/widget/ScanAnimLayout$ShimmerGroup;", "mListener", "Lcom/yy/hiyo/channel/base/widget/OnAnimationListener;", "mMaskPaint", "Landroid/graphics/Paint;", "mMatrixEvaluator", "Landroid/graphics/Matrix;", "mRepeatCount", "getMRepeatCount", "()I", "setMRepeatCount", "(I)V", "mScanMaskAngle", "mScanMaskBitmap", "Landroid/graphics/Bitmap;", "getMScanMaskBitmap", "()Landroid/graphics/Bitmap;", "setMScanMaskBitmap", "(Landroid/graphics/Bitmap;)V", "mScanMaskCenterWidth", "value", "mScanMaskColor", "getMScanMaskColor", "setMScanMaskColor", "mScanMaskHeight", "getMScanMaskHeight", "setMScanMaskHeight", "mScanMaskResId", "getMScanMaskResId", "setMScanMaskResId", "mScanMaskWidth", "getMScanMaskWidth", "setMScanMaskWidth", "mShaderEvaluator", "Landroid/graphics/Shader;", "mTimeInterpolator", "Landroid/animation/TimeInterpolator;", "mTranslateRange", "customizePaint", "", "animatedValue", "", "dispatchDraw", "canvas", "Landroid/graphics/Canvas;", "dispatchDrawUsingPaint", "drawableToBitmap", "drawable", "Landroid/graphics/drawable/Drawable;", "getShimmerShader", "bitmap", "width", "angle", "", "shadowWidth", "shadowCenter", "isScanAnimating", "onDetachedFromWindow", "setAnimAutoStart", "isAuto", "setBackground", "background", "setBackgroundColor", "color", "setBackgroundResource", "resid", "setColorEvaluator", "Lkotlin/Function1;", "setMatrixEvaluator", "setOnAnimationListener", "listener", "setPaintColorFilter", "filter", "Landroid/graphics/ColorFilter;", "setPaintXFermode", "mode", "Landroid/graphics/Xfermode;", "setRepeatCount", "count", "setScanMaskDrawable", "resId", "setScanMaskHeight", "height", "setScanMaskWidth", "setShaderEvaluator", "setTimeInterpolator", "interpolator", "setVisibility", "visibility", "startScanAnimation", "stopScanAnimation", "updateTranslateRange", "Companion", "Evaluator", "ShimmerGroup", "channel-base_release"})
public class ScanAnimLayout
extends YYRelativeLayout {
    private long mAnimDuration;
    private int mRepeatCount;
    private boolean isAnimating;
    private boolean isAutoStart;
    private int mScanMaskWidth;
    private int mScanMaskHeight;
    private ShimmerGroup mGroup;
    private int mScanMaskAngle;
    private int mScanMaskCenterWidth;
    @Nullable
    private Bitmap mScanMaskBitmap;
    private int mScanMaskResId;
    private TimeInterpolator mTimeInterpolator;
    private Evaluator<? extends Shader> mShaderEvaluator;
    private Evaluator<Integer> mColorEvaluator;
    private Evaluator<? extends Matrix> mMatrixEvaluator;
    private int mTranslateRange;
    private boolean isUpdatedTranslateRange;
    private final Paint mMaskPaint;
    private int mScanMaskColor;
    private OnAnimationListener mListener;
    private static final String TAG = "ScanAnimLayout";
    private static final int DEFAULT_DURATION = 1000;
    private static final int DEFAULT_SHADOW_WIDTH;
    private static final int DEFAULT_SHADOW_HEIGHT;
    private static final int DEFAULT_ANGLE = 20;
    private static final int DEFAULT_COLOR;
    private static final int DEFAULT_CENTER_WIDTH;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    protected final long getMAnimDuration() {
        return this.mAnimDuration;
    }

    protected final void setMAnimDuration(long l) {
        this.mAnimDuration = l;
    }

    protected final int getMRepeatCount() {
        return this.mRepeatCount;
    }

    protected final void setMRepeatCount(int n) {
        this.mRepeatCount = n;
    }

    protected final boolean isAnimating() {
        return this.isAnimating;
    }

    protected final void setAnimating(boolean bl) {
        this.isAnimating = bl;
    }

    protected final boolean isAutoStart() {
        return this.isAutoStart;
    }

    protected final void setAutoStart(boolean bl) {
        this.isAutoStart = bl;
    }

    protected final int getMScanMaskWidth() {
        return this.mScanMaskWidth;
    }

    protected final void setMScanMaskWidth(int n) {
        this.mScanMaskWidth = n;
    }

    protected final int getMScanMaskHeight() {
        return this.mScanMaskHeight;
    }

    protected final void setMScanMaskHeight(int n) {
        this.mScanMaskHeight = n;
    }

    @Nullable
    protected final Bitmap getMScanMaskBitmap() {
        return this.mScanMaskBitmap;
    }

    protected final void setMScanMaskBitmap(@Nullable Bitmap bitmap) {
        this.mScanMaskBitmap = bitmap;
    }

    protected final int getMScanMaskResId() {
        return this.mScanMaskResId;
    }

    protected final void setMScanMaskResId(int n) {
        this.mScanMaskResId = n;
    }

    protected final int getMScanMaskColor() {
        return this.mScanMaskColor;
    }

    protected final void setMScanMaskColor(int value) {
        this.mMaskPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(value, PorterDuff.Mode.SRC_IN));
        this.mScanMaskColor = value;
    }

    public final void setScanMaskDrawable(@DrawableRes int resId) {
        Drawable drawable2;
        if (this.mScanMaskResId == resId) {
            return;
        }
        this.mScanMaskResId = resId;
        Drawable drawable3 = drawable2 = ResourceUtils.getDrawable((int)resId);
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable3, (String)"drawable");
        this.mScanMaskBitmap = this.drawableToBitmap(drawable3);
    }

    protected void onDetachedFromWindow() {
        this.stopScanAnimation();
        super.onDetachedFromWindow();
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (!this.isAnimating || this.getWidth() <= 0 || this.getHeight() <= 0) {
            super.dispatchDraw(canvas);
        } else {
            this.dispatchDrawUsingPaint(canvas);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            if (this.isAutoStart) {
                this.startScanAnimation();
            }
        } else if (!this.isShown()) {
            this.stopScanAnimation();
        }
    }

    public final void stopScanAnimation() {
        ShimmerGroup shimmerGroup = this.mGroup;
        if (shimmerGroup != null) {
            shimmerGroup.removeView$channel_base_release(this);
        }
        this.isAnimating = false;
    }

    public void startScanAnimation() {
        block6: {
            int n;
            if (this.isAnimating || this.getWidth() <= 0 || !this.isShown()) break block6;
            this.isAnimating = true;
            if (this.mGroup == null) {
                this.mGroup = new ShimmerGroup();
            }
            if (this.mShaderEvaluator == null) {
                if (this.mScanMaskBitmap != null) {
                    Bitmap bitmap = this.mScanMaskBitmap;
                    if (bitmap == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mMaskPaint.setShader(this.getShimmerShader(bitmap));
                } else {
                    this.mMaskPaint.setShader(this.getShimmerShader(this.getWidth(), this.mScanMaskAngle, this.mScanMaskWidth, this.mScanMaskCenterWidth));
                }
            }
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            ScanAnimLayout scanAnimLayout = this;
            boolean bl = false;
            scanAnimLayout.mTranslateRange = n = Math.max(n2, n3);
            ShimmerGroup shimmerGroup = this.mGroup;
            if (shimmerGroup != null) {
                shimmerGroup.addView$channel_base_release(this, this.mAnimDuration, this.mTimeInterpolator, this.mRepeatCount);
            }
        }
    }

    private final void dispatchDrawUsingPaint(Canvas canvas) {
        ShimmerGroup shimmerGroup = this.mGroup;
        if (shimmerGroup == null) {
            return;
        }
        ShimmerGroup shimmerGroup2 = shimmerGroup;
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.saveLayer(null, null);
        } else {
            canvas.saveLayer(null, null, 31);
        }
        super.dispatchDraw(canvas);
        this.customizePaint(shimmerGroup2.getAnimatedValue$channel_base_release());
        canvas.drawPaint(this.mMaskPaint);
        canvas.restore();
    }

    private final void customizePaint(float animatedValue) {
        block2: {
            Evaluator<? extends Shader> it;
            boolean bl;
            boolean bl2;
            Evaluator<Object> evaluator;
            Evaluator<? extends Shader> evaluator2 = this.mShaderEvaluator;
            if (evaluator2 != null) {
                evaluator = evaluator2;
                bl2 = false;
                bl = false;
                it = evaluator;
                boolean bl3 = false;
                this.mMaskPaint.setShader(it.evaluate(animatedValue));
            }
            Evaluator<Integer> evaluator3 = this.mColorEvaluator;
            if (evaluator3 != null) {
                evaluator = evaluator3;
                bl2 = false;
                bl = false;
                it = evaluator;
                boolean bl4 = false;
                this.setMScanMaskColor(((Number)it.evaluate(animatedValue)).intValue());
            }
            Evaluator<? extends Matrix> evaluator4 = this.mMatrixEvaluator;
            if (evaluator4 == null) break block2;
            evaluator = evaluator4;
            bl2 = false;
            bl = false;
            it = evaluator;
            boolean bl5 = false;
            this.mMaskPaint.getShader().setLocalMatrix((Matrix)it.evaluate(animatedValue));
        }
    }

    @NotNull
    protected final Bitmap drawableToBitmap(@NotNull Drawable drawable2) {
        Intrinsics.checkParameterIsNotNull((Object)drawable2, (String)"drawable");
        Bitmap bitmap = Bitmap.createBitmap((int)this.mScanMaskWidth, (int)this.mScanMaskHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, this.mScanMaskWidth, this.mScanMaskHeight);
        drawable2.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    private final Shader getShimmerShader(int width, double angle, int shadowWidth, int shadowCenter) {
        float shadowWidthPercent = (float)shadowWidth / 2.0f / (float)width;
        float shadowCenterPercent = (float)shadowCenter / 2.0f / (float)width;
        double angleInRadians = Math.toRadians(angle);
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = false;
        double d = Math.cos(angleInRadians);
        float f3 = (float)d * (float)width;
        bl = false;
        double d2 = Math.sin(angleInRadians);
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        float[] fArray = new float[]{0.5f - shadowWidthPercent, 0.5f - shadowCenterPercent, 0.5f + shadowCenterPercent, 0.5f + shadowWidthPercent};
        int[] nArray = new int[]{0, -16777216, -16777216, 0};
        float f4 = (float)d2 * (float)width;
        float f5 = f3;
        float f6 = f;
        float f7 = f2;
        return (Shader)new LinearGradient(f7, f6, f5, f4, nArray, fArray, tileMode);
    }

    private final Shader getShimmerShader(Bitmap bitmap) {
        return (Shader)new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
    }

    public final void setMatrixEvaluator(@NotNull Function1<? super Float, ? extends Matrix> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.mMatrixEvaluator = new Evaluator<Matrix>(value){
            final /* synthetic */ Function1 $value;

            @NotNull
            public Matrix evaluate(float fraction) {
                return (Matrix)this.$value.invoke((Object)Float.valueOf(fraction));
            }
            {
                this.$value = $captured_local_variable$0;
            }
        };
    }

    public final void setShaderEvaluator(@NotNull Function1<? super Float, ? extends Shader> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.mShaderEvaluator = new Evaluator<Shader>(value){
            final /* synthetic */ Function1 $value;

            @NotNull
            public Shader evaluate(float fraction) {
                return (Shader)this.$value.invoke((Object)Float.valueOf(fraction));
            }
            {
                this.$value = $captured_local_variable$0;
            }
        };
    }

    public final void setColorEvaluator(@NotNull Function1<? super Float, Integer> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.mColorEvaluator = new Evaluator<Integer>(value){
            final /* synthetic */ Function1 $value;

            @NotNull
            public Integer evaluate(float fraction) {
                return (Integer)this.$value.invoke((Object)Float.valueOf(fraction));
            }
            {
                this.$value = $captured_local_variable$0;
            }
        };
    }

    public final void setRepeatCount(int count) {
        this.mRepeatCount = count;
    }

    public final void setAnimAutoStart(boolean isAuto) {
        this.isAutoStart = isAuto;
    }

    public final void setScanMaskWidth(int width) {
        this.mScanMaskWidth = width;
    }

    public final void setScanMaskHeight(int height) {
        this.mScanMaskHeight = height;
    }

    public final void setOnAnimationListener(@NotNull OnAnimationListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.mListener = listener;
    }

    public final boolean isScanAnimating() {
        return this.isAnimating;
    }

    public final void setTimeInterpolator(@NotNull TimeInterpolator interpolator) {
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
        this.mTimeInterpolator = interpolator;
    }

    public final void setPaintXFermode(@NotNull Xfermode mode) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        this.mMaskPaint.setXfermode(mode);
    }

    public final void setPaintColorFilter(@NotNull ColorFilter filter) {
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        this.mMaskPaint.setColorFilter(filter);
    }

    public final void updateTranslateRange() {
        if (this.getWidth() > 0 && this.mTranslateRange != this.getWidth()) {
            this.mTranslateRange = this.getWidth();
            this.isUpdatedTranslateRange = true;
        }
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        if (RuntimeContext.sIsDebuggable && SystemUtils.isShowEnvSetting()) {
            throw (Throwable)new IllegalStateException("Setting background is not supported and will affect the sweep effect");
        }
    }

    public void setBackground(@Nullable Drawable background) {
        super.setBackground(background);
        if (RuntimeContext.sIsDebuggable && SystemUtils.isShowEnvSetting()) {
            throw (Throwable)new IllegalStateException("Setting background is not supported and will affect the sweep effect");
        }
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        if (RuntimeContext.sIsDebuggable && SystemUtils.isShowEnvSetting()) {
            throw (Throwable)new IllegalStateException("Setting background is not supported and will affect the sweep effect");
        }
    }

    public ScanAnimLayout(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public ScanAnimLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanAnimLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.mScanMaskResId = -1;
        this.mTimeInterpolator = (TimeInterpolator)new AccelerateInterpolator();
        this.mMatrixEvaluator = new Evaluator<Matrix>(this){
            final /* synthetic */ ScanAnimLayout this$0;

            @NotNull
            public Matrix evaluate(float fraction) {
                Matrix matrix = new Matrix();
                boolean bl = false;
                boolean bl2 = false;
                Matrix $this$apply = matrix;
                boolean bl3 = false;
                float translateX = fraction * (float)ScanAnimLayout.access$getMTranslateRange$p(this.this$0);
                MLog.debug((Object)"ScanAnimLayout", (String)("translateX: " + translateX), (Object[])new Object[0]);
                $this$apply.setTranslate(translateX, 0.0f);
                return matrix;
            }
            {
                this.this$0 = $outer;
            }
        };
        Paint paint2 = new Paint();
        ScanAnimLayout scanAnimLayout = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint2;
        boolean bl3 = false;
        $this$apply.setDither(true);
        $this$apply.setFilterBitmap(true);
        $this$apply.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        scanAnimLayout.mMaskPaint = paint = paint2;
        this.setWillNotDraw(false);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ScanAnimLayout, defStyle, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.theme.obtainStyl\u2026nAnimLayout, defStyle, 0)");
        TypedArray attributes = typedArray;
        try {
            this.mScanMaskAngle = attributes.getInteger(R.styleable.ScanAnimLayout_scan_mask_angle, 20);
            this.mAnimDuration = attributes.getInteger(R.styleable.ScanAnimLayout_scan_animation_duration, 1000);
            this.setMScanMaskColor(attributes.getColor(R.styleable.ScanAnimLayout_scan_mask_color, ResourceUtils.getColor((int)DEFAULT_COLOR)));
            this.mScanMaskWidth = attributes.getDimensionPixelSize(R.styleable.ScanAnimLayout_scan_mask_width, this.getResources().getDimensionPixelSize(DEFAULT_SHADOW_WIDTH));
            this.mScanMaskHeight = attributes.getDimensionPixelSize(R.styleable.ScanAnimLayout_scan_mask_height, this.getResources().getDimensionPixelSize(DEFAULT_SHADOW_HEIGHT));
            this.mScanMaskCenterWidth = attributes.getDimensionPixelSize(R.styleable.ScanAnimLayout_scan_mask_center_width, this.getResources().getDimensionPixelSize(DEFAULT_CENTER_WIDTH));
            this.isAutoStart = attributes.getBoolean(R.styleable.ScanAnimLayout_scan_auto_start, false);
            this.mRepeatCount = attributes.getInt(R.styleable.ScanAnimLayout_scan_mask_repeat_count, 0);
            Drawable drawable2 = attributes.getDrawable(R.styleable.ScanAnimLayout_scan_mask_drawable);
            if (drawable2 != null) {
                this.mScanMaskBitmap = this.drawableToBitmap(drawable2);
            }
        }
        finally {
            attributes.recycle();
        }
        if (this.isAutoStart && this.getVisibility() == 0) {
            this.startScanAnimation();
        }
    }

    static {
        Companion = new Companion(null);
        DEFAULT_SHADOW_WIDTH = R.dimen.scan_mask_width_default;
        DEFAULT_SHADOW_HEIGHT = R.dimen.scan_mask_height_default;
        DEFAULT_COLOR = R.color.white;
        DEFAULT_CENTER_WIDTH = R.dimen.scan_mask_width_center_default;
    }

    public static final /* synthetic */ void access$setMTranslateRange$p(ScanAnimLayout $this, int n) {
        $this.mTranslateRange = n;
    }

    public static final /* synthetic */ OnAnimationListener access$getMListener$p(ScanAnimLayout $this) {
        return $this.mListener;
    }

    public static final /* synthetic */ void access$setMListener$p(ScanAnimLayout $this, OnAnimationListener onAnimationListener) {
        $this.mListener = onAnimationListener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/yy/hiyo/channel/base/widget/ScanAnimLayout$Evaluator;", "T", "", "evaluate", "fraction", "", "(F)Ljava/lang/Object;", "channel-base_release"})
    public static interface Evaluator<T> {
        public T evaluate(float var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0015\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001cJ \u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J \u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0017H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/yy/hiyo/channel/base/widget/ScanAnimLayout$ShimmerGroup;", "", "(Lcom/yy/hiyo/channel/base/widget/ScanAnimLayout;)V", "animatedValue", "", "getAnimatedValue$channel_base_release", "()F", "setAnimatedValue$channel_base_release", "(F)V", "animatedViews", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/ref/WeakReference;", "Lcom/yy/hiyo/channel/base/widget/ScanAnimLayout;", "valueAnimator", "Landroid/animation/ValueAnimator;", "addView", "", "layout", "animationDuration", "", "timeInterpolator", "Landroid/animation/TimeInterpolator;", "repeatCount", "", "addView$channel_base_release", "checkResetValueAnimator", "invalidateViews", "removeView", "removeView$channel_base_release", "setValueAnimator", "animRepeatCount", "startAnimator", "channel-base_release"})
    public final class ShimmerGroup {
        private final CopyOnWriteArrayList<WeakReference<ScanAnimLayout>> animatedViews = new CopyOnWriteArrayList();
        private ValueAnimator valueAnimator;
        private float animatedValue;

        public final float getAnimatedValue$channel_base_release() {
            return this.animatedValue;
        }

        public final void setAnimatedValue$channel_base_release(float f) {
            this.animatedValue = f;
        }

        public final void addView$channel_base_release(@NotNull ScanAnimLayout layout2, long animationDuration, @NotNull TimeInterpolator timeInterpolator, int repeatCount) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)layout2), (String)"layout");
            Intrinsics.checkParameterIsNotNull((Object)timeInterpolator, (String)"timeInterpolator");
            CollectionsKt.removeAll((List)this.animatedViews, (Function1)((Function1)new Function1<WeakReference<ScanAnimLayout>, Boolean>(layout2){
                final /* synthetic */ ScanAnimLayout $layout;

                public final boolean invoke(WeakReference<ScanAnimLayout> it) {
                    return Intrinsics.areEqual((Object)((Object)((ScanAnimLayout)((Object)it.get()))), (Object)((Object)this.$layout)) || it.get() == null;
                }
                {
                    this.$layout = scanAnimLayout;
                    super(1);
                }
            }));
            this.animatedViews.add(new WeakReference<ScanAnimLayout>(layout2));
            this.startAnimator(animationDuration, timeInterpolator, repeatCount);
        }

        public final void removeView$channel_base_release(@NotNull ScanAnimLayout layout2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)layout2), (String)"layout");
            CollectionsKt.removeAll((List)this.animatedViews, (Function1)((Function1)new Function1<WeakReference<ScanAnimLayout>, Boolean>(layout2){
                final /* synthetic */ ScanAnimLayout $layout;

                public final boolean invoke(WeakReference<ScanAnimLayout> it) {
                    return Intrinsics.areEqual((Object)((Object)((ScanAnimLayout)((Object)it.get()))), (Object)((Object)this.$layout)) || it.get() == null;
                }
                {
                    this.$layout = scanAnimLayout;
                    super(1);
                }
            }));
            ValueAnimator valueAnimator = this.valueAnimator;
            if (valueAnimator != null) {
                if (valueAnimator.isStarted()) {
                    if (this.animatedViews.isEmpty()) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                            final /* synthetic */ ShimmerGroup this$0;

                            public final void run() {
                                if (ShimmerGroup.access$getAnimatedViews$p(this.this$0).isEmpty()) {
                                    ValueAnimator valueAnimator = ShimmerGroup.access$getValueAnimator$p(this.this$0);
                                    if (valueAnimator != null) {
                                        valueAnimator.removeAllUpdateListeners();
                                    }
                                    ValueAnimator valueAnimator2 = ShimmerGroup.access$getValueAnimator$p(this.this$0);
                                    if (valueAnimator2 != null) {
                                        valueAnimator2.end();
                                    }
                                    ShimmerGroup.access$setValueAnimator$p(this.this$0, null);
                                }
                            }
                            {
                                this.this$0 = shimmerGroup;
                            }
                        }, (long)500L);
                    }
                }
            }
        }

        private final void startAnimator(long animationDuration, TimeInterpolator timeInterpolator, int animRepeatCount) {
            if (this.valueAnimator != null) {
                ValueAnimator valueAnimator = this.valueAnimator;
                if (valueAnimator == null) {
                    Intrinsics.throwNpe();
                }
                if (!valueAnimator.isRunning()) {
                    ValueAnimator valueAnimator2 = this.valueAnimator;
                    if (valueAnimator2 == null) {
                        Intrinsics.throwNpe();
                    }
                    valueAnimator2.start();
                }
                return;
            }
            this.setValueAnimator(animationDuration, timeInterpolator, animRepeatCount);
        }

        private final void setValueAnimator(long animationDuration, TimeInterpolator timeInterpolator, int animRepeatCount) {
            ValueAnimator valueAnimator;
            float from = (float)(-ScanAnimLayout.this.getMScanMaskWidth()) / (float)ScanAnimLayout.this.mTranslateRange;
            MLog.debug((Object)ScanAnimLayout.TAG, (String)("setValueAnimator, from: " + from), (Object[])new Object[0]);
            ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{from, 1.0f});
            ShimmerGroup shimmerGroup = this;
            boolean bl = false;
            boolean bl2 = false;
            ValueAnimator $this$apply = valueAnimator2;
            boolean bl3 = false;
            $this$apply.setInterpolator(timeInterpolator);
            $this$apply.setDuration(animationDuration);
            $this$apply.setRepeatCount(animRepeatCount);
            $this$apply.addListener(new Animator.AnimatorListener(this, timeInterpolator, animationDuration, animRepeatCount){
                final /* synthetic */ ShimmerGroup this$0;
                final /* synthetic */ TimeInterpolator $timeInterpolator$inlined;
                final /* synthetic */ long $animationDuration$inlined;
                final /* synthetic */ int $animRepeatCount$inlined;
                {
                    this.this$0 = shimmerGroup;
                    this.$timeInterpolator$inlined = timeInterpolator;
                    this.$animationDuration$inlined = l;
                    this.$animRepeatCount$inlined = n;
                }

                public void onAnimationRepeat(@Nullable Animator animation) {
                    OnAnimationListener onAnimationListener = ScanAnimLayout.access$getMListener$p(this.this$0.ScanAnimLayout.this);
                    if (onAnimationListener != null) {
                        onAnimationListener.onAnimationRepeat();
                    }
                    ShimmerGroup.access$checkResetValueAnimator(this.this$0);
                }

                public void onAnimationEnd(@Nullable Animator animation) {
                    OnAnimationListener onAnimationListener = ScanAnimLayout.access$getMListener$p(this.this$0.ScanAnimLayout.this);
                    if (onAnimationListener != null) {
                        onAnimationListener.onAnimationEnd();
                    }
                    this.this$0.ScanAnimLayout.this.setAnimating(false);
                }

                public void onAnimationCancel(@Nullable Animator animation) {
                    OnAnimationListener onAnimationListener = ScanAnimLayout.access$getMListener$p(this.this$0.ScanAnimLayout.this);
                    if (onAnimationListener != null) {
                        onAnimationListener.onAnimationCancel();
                    }
                    this.this$0.ScanAnimLayout.this.setAnimating(false);
                }

                public void onAnimationStart(@Nullable Animator animation) {
                    OnAnimationListener onAnimationListener = ScanAnimLayout.access$getMListener$p(this.this$0.ScanAnimLayout.this);
                    if (onAnimationListener != null) {
                        onAnimationListener.onAnimationStart();
                    }
                    this.this$0.ScanAnimLayout.this.setAnimating(true);
                }
            });
            $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, timeInterpolator, animationDuration, animRepeatCount){
                final /* synthetic */ ShimmerGroup this$0;
                final /* synthetic */ TimeInterpolator $timeInterpolator$inlined;
                final /* synthetic */ long $animationDuration$inlined;
                final /* synthetic */ int $animRepeatCount$inlined;
                {
                    this.this$0 = shimmerGroup;
                    this.$timeInterpolator$inlined = timeInterpolator;
                    this.$animationDuration$inlined = l;
                    this.$animRepeatCount$inlined = n;
                }

                public final void onAnimationUpdate(ValueAnimator animation) {
                    ValueAnimator valueAnimator = animation;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                    }
                    ShimmerGroup.access$invalidateViews(this.this$0, ((Float)object).floatValue());
                }
            });
            $this$apply.start();
            shimmerGroup.valueAnimator = valueAnimator = valueAnimator2;
        }

        private final void invalidateViews(float animatedValue) {
            this.animatedValue = animatedValue;
            Iterator<WeakReference<ScanAnimLayout>> iterator = this.animatedViews.iterator();
            boolean bl = false;
            boolean bl2 = false;
            Iterator<WeakReference<ScanAnimLayout>> $this$with = iterator;
            boolean bl3 = false;
            Iterator<WeakReference<ScanAnimLayout>> $this$forEach$iv = $this$with;
            boolean $i$f$forEach = false;
            Iterator<WeakReference<ScanAnimLayout>> iterator2 = $this$forEach$iv;
            boolean bl4 = false;
            Iterator<WeakReference<ScanAnimLayout>> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                WeakReference<ScanAnimLayout> element$iv;
                WeakReference<ScanAnimLayout> it = element$iv = iterator3.next();
                boolean bl5 = false;
                if ((ScanAnimLayout)((Object)it.get()) != null) {
                    ScanAnimLayout scanAnimLayout;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    ScanAnimLayout view = scanAnimLayout;
                    boolean bl8 = false;
                    ScanAnimLayout scanAnimLayout2 = view;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)scanAnimLayout2), (String)"view");
                    if (scanAnimLayout2.isShown()) {
                        view.invalidate();
                        continue;
                    }
                    view.stopScanAnimation();
                    continue;
                }
                $this$with.remove();
            }
        }

        private final void checkResetValueAnimator() {
            if (ScanAnimLayout.this.isUpdatedTranslateRange && this.valueAnimator != null) {
                ValueAnimator valueAnimator = this.valueAnimator;
                if (valueAnimator == null) {
                    Intrinsics.throwNpe();
                }
                if (valueAnimator.getRepeatCount() == -1) {
                    ScanAnimLayout.this.isUpdatedTranslateRange = false;
                    ValueAnimator valueAnimator2 = this.valueAnimator;
                    if (valueAnimator2 == null) {
                        Intrinsics.throwNpe();
                    }
                    valueAnimator2.removeAllUpdateListeners();
                    ValueAnimator valueAnimator3 = this.valueAnimator;
                    if (valueAnimator3 == null) {
                        Intrinsics.throwNpe();
                    }
                    valueAnimator3.removeAllListeners();
                    ValueAnimator valueAnimator4 = this.valueAnimator;
                    if (valueAnimator4 == null) {
                        Intrinsics.throwNpe();
                    }
                    long l = valueAnimator4.getDuration();
                    ValueAnimator valueAnimator5 = this.valueAnimator;
                    if (valueAnimator5 == null) {
                        Intrinsics.throwNpe();
                    }
                    TimeInterpolator timeInterpolator = valueAnimator5.getInterpolator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)timeInterpolator, (String)"valueAnimator!!.interpolator");
                    this.setValueAnimator(l, timeInterpolator, -1);
                }
            }
        }

        public static final /* synthetic */ CopyOnWriteArrayList access$getAnimatedViews$p(ShimmerGroup $this) {
            return $this.animatedViews;
        }

        public static final /* synthetic */ ValueAnimator access$getValueAnimator$p(ShimmerGroup $this) {
            return $this.valueAnimator;
        }

        public static final /* synthetic */ void access$setValueAnimator$p(ShimmerGroup $this, ValueAnimator valueAnimator) {
            $this.valueAnimator = valueAnimator;
        }

        public static final /* synthetic */ void access$checkResetValueAnimator(ShimmerGroup $this) {
            $this.checkResetValueAnimator();
        }

        public static final /* synthetic */ void access$invalidateViews(ShimmerGroup $this, float animatedValue) {
            $this.invalidateViews(animatedValue);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/yy/hiyo/channel/base/widget/ScanAnimLayout$Companion;", "", "()V", "DEFAULT_ANGLE", "", "DEFAULT_CENTER_WIDTH", "DEFAULT_COLOR", "DEFAULT_DURATION", "DEFAULT_SHADOW_HEIGHT", "DEFAULT_SHADOW_WIDTH", "TAG", "", "channel-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

