/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.alphaplayer;

import android.content.Context;
import android.view.ViewGroup;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.appbase.extensions.ViewExtensionsKt;
import com.yy.appbase.resource.file.LoadStatus;
import com.yy.appbase.resource.file.ResLoadMetric;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.dres.ResDownloadUtils;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.ChannelAlphaVideoConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.ui.GPUInfoManager;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.channel.base.alphaplayer.AlphaVideoPlayer;
import com.yy.hiyo.channel.base.alphaplayer.AlphaVideoPlayerKt;
import com.yy.hiyo.video.base.IVideoPlayerService;
import com.yy.hiyo.video.base.player.IVideoPlayListener;
import com.yy.hiyo.video.base.player.IVideoPlayer;
import com.yy.hiyo.video.base.player.PlayOption;
import com.yy.hiyo.video.base.player.SimpleVideoPlayListener;
import com.yy.hiyo.video.base.player.VideoPlayerParam;
import com.yy.hiyo.videorecord.IVideoPlayService;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 62\u00020\u0001:\u0003678B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J$\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J$\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00180$H\u0002J2\u0010&\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00180$H\u0002J\"\u0010*\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ$\u0010+\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J,\u0010,\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010-\u001a\u00020%2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J*\u0010/\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020%2\b\u00103\u001a\u0004\u0018\u00010\u0004H\u0002J \u00104\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u00100\u001a\u0002012\u0006\u00105\u001a\u000201H\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/yy/hiyo/channel/base/alphaplayer/AlphaVideoPlayer;", "", "()V", "cacheDir", "", "kotlin.jvm.PlatformType", "getCacheDir", "()Ljava/lang/String;", "cacheDir$delegate", "Lkotlin/Lazy;", "download", "Lcom/yy/appbase/service/dres/ResDownloadUtils;", "getDownload", "()Lcom/yy/appbase/service/dres/ResDownloadUtils;", "download$delegate", "foreTextureView", "", "getForeTextureView", "()Z", "setForeTextureView", "(Z)V", "player", "Lcom/yy/hiyo/video/base/player/IVideoPlayer;", "copyCacheFile", "", "url", "destroy", "downloadAndPlay", "container", "Landroid/view/ViewGroup;", "listener", "Lcom/yy/hiyo/video/base/player/IVideoPlayListener;", "getSamplerFilter", "context", "Landroid/content/Context;", "action", "Lkotlin/Function1;", "", "getSamplerFilterFromConfig", "gpuList", "", "Lcom/yy/appbase/unifyconfig/config/ChannelAlphaVideoConfig$GPUSampleFilterConfig;", "play", "playInThread", "playVideo", "source", "removeBadFileCache", "reportFail", "duration", "", "code", "msg", "reportSuccess", "fileSize", "Companion", "ListenerWrap", "PlayerListenerWrap", "channel-base_release"})
public final class AlphaVideoPlayer {
    private IVideoPlayer player;
    private boolean foreTextureView;
    private final Lazy cacheDir$delegate = LazyKt.lazy((Function0)cacheDir.2.INSTANCE);
    private final Lazy download$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResDownloadUtils>(this){
        final /* synthetic */ AlphaVideoPlayer this$0;

        @NotNull
        public final ResDownloadUtils invoke() {
            String string2 = AlphaVideoPlayer.access$getCacheDir$p(this.this$0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cacheDir");
            return new ResDownloadUtils(string2);
        }
        {
            this.this$0 = alphaVideoPlayer;
            super(0);
        }
    }));
    private static final String TAG = "AlphaVideoPlayer";
    private static volatile int playerCount;
    public static final Companion Companion;

    public final boolean getForeTextureView() {
        return this.foreTextureView;
    }

    public final void setForeTextureView(boolean bl) {
        this.foreTextureView = bl;
    }

    private final String getCacheDir() {
        Lazy lazy = this.cacheDir$delegate;
        AlphaVideoPlayer alphaVideoPlayer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final ResDownloadUtils getDownload() {
        Lazy lazy = this.download$delegate;
        AlphaVideoPlayer alphaVideoPlayer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ResDownloadUtils)lazy.getValue();
    }

    public final void play(@NotNull ViewGroup container, @NotNull String url, @Nullable IVideoPlayListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        boolean $i$f$onWork = false;
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(this, container, url, listener){
                final /* synthetic */ AlphaVideoPlayer this$0;
                final /* synthetic */ ViewGroup $container$inlined;
                final /* synthetic */ String $url$inlined;
                final /* synthetic */ IVideoPlayListener $listener$inlined;
                {
                    this.this$0 = alphaVideoPlayer;
                    this.$container$inlined = viewGroup;
                    this.$url$inlined = string2;
                    this.$listener$inlined = iVideoPlayListener;
                }

                public final void run() {
                    boolean bl = false;
                    AlphaVideoPlayer.access$playInThread(this.this$0, this.$container$inlined, this.$url$inlined, this.$listener$inlined);
                }
            });
        } else {
            boolean bl = false;
            this.playInThread(container, url, listener);
        }
    }

    public static /* synthetic */ void play$default(AlphaVideoPlayer alphaVideoPlayer, ViewGroup viewGroup, String string2, IVideoPlayListener iVideoPlayListener, int n, Object object) {
        if ((n & 4) != 0) {
            iVideoPlayListener = null;
        }
        alphaVideoPlayer.play(viewGroup, string2, iVideoPlayListener);
    }

    private final void playInThread(ViewGroup container, String url, IVideoPlayListener listener) {
        String path = this.getDownload().getFilePath(url);
        if (CommonExtensionsKt.isNotNullOrEmpty((String)path)) {
            MLog.debug((Object)TAG, (String)("ull = " + url + " video has cache : " + path), (Object[])new Object[0]);
            long start = System.currentTimeMillis();
            String string2 = path;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            this.playVideo(container, string2, VideoPlayerParam.Source.Companion.getURL_PROTO_FILE(), listener);
            ResLoadMetric.report$default((String)"video", (long)(System.currentTimeMillis() - start), (LoadStatus)LoadStatus.HAVE_CACHE, null, (int)8, null);
        } else {
            this.downloadAndPlay(container, url, listener);
        }
    }

    static /* synthetic */ void playInThread$default(AlphaVideoPlayer alphaVideoPlayer, ViewGroup viewGroup, String string2, IVideoPlayListener iVideoPlayListener, int n, Object object) {
        if ((n & 4) != 0) {
            iVideoPlayListener = null;
        }
        alphaVideoPlayer.playInThread(viewGroup, string2, iVideoPlayListener);
    }

    private final void downloadAndPlay(ViewGroup container, String url, IVideoPlayListener listener) {
        long start = System.currentTimeMillis();
        this.getDownload().fetchFile(url, (ICommonCallback)new ICommonCallback<String>(this, container, listener, url, start){
            final /* synthetic */ AlphaVideoPlayer this$0;
            final /* synthetic */ ViewGroup $container;
            final /* synthetic */ IVideoPlayListener $listener;
            final /* synthetic */ String $url;
            final /* synthetic */ long $start;

            public void onSuccess(@Nullable String data, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                if (CommonExtensionsKt.isNotNullOrEmpty((String)data)) {
                    String string2 = data;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    AlphaVideoPlayer.access$playVideo(this.this$0, this.$container, string2, VideoPlayerParam.Source.Companion.getURL_PROTO_FILE(), this.$listener);
                    boolean $i$f$onWork = false;
                    if (YYTaskExecutor.isMainThread()) {
                        YYTaskExecutor.execute((Runnable)new Runnable(this, data){
                            final /* synthetic */ downloadAndPlay.1 this$0;
                            final /* synthetic */ String $data$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$data$inlined = string2;
                            }

                            public final void run() {
                                boolean bl = false;
                                long size = YYFileUtils.getFileSize((File)new File(this.$data$inlined));
                                AlphaVideoPlayer.access$reportSuccess(this.this$0.this$0, this.this$0.$url, System.currentTimeMillis() - this.this$0.$start, size);
                            }
                        });
                    } else {
                        boolean bl = false;
                        long size = YYFileUtils.getFileSize((File)new File(data));
                        AlphaVideoPlayer.access$reportSuccess(this.this$0, this.$url, System.currentTimeMillis() - this.$start, size);
                    }
                } else {
                    MLog.error((Object)"AlphaVideoPlayer", (String)"fetchFile onSuccess but data is empty", (Object[])new Object[0]);
                    IVideoPlayListener iVideoPlayListener = this.$listener;
                    if (iVideoPlayListener == null) {
                        iVideoPlayListener = (IVideoPlayListener)new SimpleVideoPlayListener();
                    }
                    ListenerWrap listenerWrap = this.this$0.new ListenerWrap(iVideoPlayListener, this.$url);
                    AlphaVideoPlayer.access$playVideo(this.this$0, this.$container, this.$url, VideoPlayerParam.Source.Companion.getURL_PROTO_USER(), listenerWrap);
                    boolean $i$f$onWork = false;
                    if (YYTaskExecutor.isMainThread()) {
                        YYTaskExecutor.execute((Runnable)new Runnable(this){
                            final /* synthetic */ downloadAndPlay.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                AlphaVideoPlayer.access$reportFail(this.this$0.this$0, this.this$0.$url, System.currentTimeMillis() - this.this$0.$start, -1, "success but path is empty");
                            }
                        });
                    } else {
                        boolean bl = false;
                        AlphaVideoPlayer.access$reportFail(this.this$0, this.$url, System.currentTimeMillis() - this.$start, -1, "success but path is empty");
                    }
                }
            }

            public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                MLog.error((Object)"AlphaVideoPlayer", (String)"fetchFile onFail errCode: %d, msg: %s", (Object[])new Object[]{errCode, msg});
                IVideoPlayListener iVideoPlayListener = this.$listener;
                if (iVideoPlayListener == null) {
                    iVideoPlayListener = (IVideoPlayListener)new SimpleVideoPlayListener();
                }
                ListenerWrap listenerWrap = this.this$0.new ListenerWrap(iVideoPlayListener, this.$url);
                AlphaVideoPlayer.access$playVideo(this.this$0, this.$container, this.$url, VideoPlayerParam.Source.Companion.getURL_PROTO_USER(), listenerWrap);
                boolean $i$f$onWork = false;
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute((Runnable)new Runnable(this, errCode, msg){
                        final /* synthetic */ downloadAndPlay.1 this$0;
                        final /* synthetic */ int $errCode$inlined;
                        final /* synthetic */ String $msg$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$errCode$inlined = n;
                            this.$msg$inlined = string2;
                        }

                        public final void run() {
                            boolean bl = false;
                            AlphaVideoPlayer.access$reportFail(this.this$0.this$0, this.this$0.$url, System.currentTimeMillis() - this.this$0.$start, this.$errCode$inlined, this.$msg$inlined);
                        }
                    });
                } else {
                    boolean bl = false;
                    AlphaVideoPlayer.access$reportFail(this.this$0, this.$url, System.currentTimeMillis() - this.$start, errCode, msg);
                }
            }
            {
                this.this$0 = $outer;
                this.$container = $captured_local_variable$1;
                this.$listener = $captured_local_variable$2;
                this.$url = $captured_local_variable$3;
                this.$start = $captured_local_variable$4;
            }
        });
    }

    static /* synthetic */ void downloadAndPlay$default(AlphaVideoPlayer alphaVideoPlayer, ViewGroup viewGroup, String string2, IVideoPlayListener iVideoPlayListener, int n, Object object) {
        if ((n & 4) != 0) {
            iVideoPlayListener = null;
        }
        alphaVideoPlayer.downloadAndPlay(viewGroup, string2, iVideoPlayListener);
    }

    private final void playVideo(ViewGroup container, String url, int source, IVideoPlayListener listener) {
        VideoPlayerParam param = new VideoPlayerParam(url, source);
        Context context = container.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"container.context");
        this.getSamplerFilter(context, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, param, container, url, listener){
            final /* synthetic */ AlphaVideoPlayer this$0;
            final /* synthetic */ VideoPlayerParam $param;
            final /* synthetic */ ViewGroup $container;
            final /* synthetic */ String $url;
            final /* synthetic */ IVideoPlayListener $listener;

            public final void invoke(int it) {
                MLog.info((Object)"AlphaVideoPlayer", (String)("getSamplerFilter: result = " + it), (Object[])new Object[0]);
                this.$param.setSamplerFilter(it);
                String string2 = AlphaVideoPlayer.access$getCacheDir$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cacheDir");
                this.$param.setCacheDir(string2);
                AlphaVideoPlayer.access$setPlayer$p(this.this$0, ((IVideoPlayerService)ServiceManagerProxy.getService(IVideoPlayerService.class)).createPlayer(this.$param));
                PlayOption option = new PlayOption();
                option.setNumberOfLoops(0);
                option.setMp4WithAlpha(true);
                option.setZOrderOnTop(true);
                option.setForeTextureView(this.this$0.getForeTextureView());
                ViewExtensionsKt.onUi((Object)this.this$0, (Function0)((Function0)new Function0<Unit>(this, option){
                    final /* synthetic */ playVideo.1 this$0;
                    final /* synthetic */ PlayOption $option;

                    public final void invoke() {
                        IVideoPlayer iVideoPlayer = AlphaVideoPlayer.access$getPlayer$p(this.this$0.this$0);
                        if (iVideoPlayer == null) {
                            Intrinsics.throwNpe();
                        }
                        ViewGroup viewGroup = this.this$0.$container;
                        AlphaVideoPlayer alphaVideoPlayer = this.this$0.this$0;
                        String string2 = this.this$0.$url;
                        IVideoPlayListener iVideoPlayListener = this.this$0.$listener;
                        if (iVideoPlayListener == null) {
                            iVideoPlayListener = (IVideoPlayListener)new SimpleVideoPlayListener();
                        }
                        iVideoPlayer.startPlay(viewGroup, this.$option, (IVideoPlayListener)alphaVideoPlayer.new PlayerListenerWrap(string2, iVideoPlayListener));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$option = playOption;
                        super(0);
                    }
                }));
                int n = AlphaVideoPlayer.access$getPlayerCount$cp();
                AlphaVideoPlayer.access$setPlayerCount$cp(n + 1);
                SettingFlags.setIntValue((String)"key_alpha_video_count", (int)AlphaVideoPlayer.access$getPlayerCount$cp());
            }
            {
                this.this$0 = alphaVideoPlayer;
                this.$param = videoPlayerParam;
                this.$container = viewGroup;
                this.$url = string2;
                this.$listener = iVideoPlayListener;
                super(1);
            }
        }));
    }

    static /* synthetic */ void playVideo$default(AlphaVideoPlayer alphaVideoPlayer, ViewGroup viewGroup, String string2, int n, IVideoPlayListener iVideoPlayListener, int n2, Object object) {
        if ((n2 & 8) != 0) {
            iVideoPlayListener = null;
        }
        alphaVideoPlayer.playVideo(viewGroup, string2, n, iVideoPlayListener);
    }

    public final void destroy() {
        IVideoPlayer iVideoPlayer = this.player;
        if (iVideoPlayer != null) {
            iVideoPlayer.destroy();
        }
        int n = playerCount;
        playerCount = n + -1;
        SettingFlags.setIntValue((String)"key_alpha_video_count", (int)playerCount);
    }

    private final void copyCacheFile(String url) {
        block1: {
            File[] files2;
            IService iService = ServiceManagerProxy.getService(IVideoPlayService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)iService, (String)"ServiceManagerProxy.getS\u2026oPlayService::class.java)");
            String videoDir = ((IVideoPlayService)iService).getVideoCacheDir();
            CharSequence charSequence = videoDir;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                MLog.error((Object)TAG, (String)"copyCacheFile videoDir is null or empty", (Object[])new Object[0]);
                return;
            }
            String urlMd5 = MD5Utils.getMD5String((String)url);
            Object object = new File(videoDir);
            boolean bl3 = false;
            boolean bl4 = false;
            Object it = object;
            boolean bl5 = false;
            Object object2 = it.isDirectory() ? object : null;
            Object object3 = files2 = object2 != null ? object2.listFiles(new FilenameFilter(urlMd5){
                final /* synthetic */ String $urlMd5;

                public final boolean accept(File dir, String name) {
                    return StringUtils.equalsIgnoreCase((String)name, (String)this.$urlMd5);
                }
                {
                    this.$urlMd5 = string2;
                }
            }) : null;
            if (files2 == null || (object3 = object3[0]) == null) break block1;
            object = object3;
            bl3 = false;
            bl4 = false;
            it = object;
            boolean bl6 = false;
            String path = this.getCacheDir() + File.separator + urlMd5;
            YYFileUtils.copyFile((File)it, (File)YYFileUtils.createNewFile((String)path, (boolean)false));
            MLog.info((Object)TAG, (String)"copyCacheFile success url: %s", (Object[])new Object[]{url});
        }
    }

    private final void getSamplerFilter(Context context, Function1<? super Integer, Unit> action) {
        int sampleFilterHistory = SettingFlags.getIntValue((String)"key_alpha_video_sample_filter", (int)-1);
        MLog.info((Object)TAG, (String)("getSampleFilter history value = " + sampleFilterHistory), (Object[])new Object[0]);
        if (sampleFilterHistory != -1) {
            action.invoke((Object)sampleFilterHistory);
            return;
        }
        AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.CHANNEL_ALPHA_VIDEO_CONFIG);
        if (!(aConfigData instanceof ChannelAlphaVideoConfig)) {
            aConfigData = null;
        }
        ChannelAlphaVideoConfig channelAlphaVideoConfig = (ChannelAlphaVideoConfig)aConfigData;
        List gpuSampleFilterConfig = channelAlphaVideoConfig != null ? channelAlphaVideoConfig.getGpuSampleFilterConfig() : null;
        Collection collection = gpuSampleFilterConfig;
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            SettingFlags.setIntValue((String)"key_alpha_video_sample_filter", (int)VideoPlayerParam.SamplerFilter.Companion.getSAMPLER_FILTER_LINEAR());
            action.invoke((Object)VideoPlayerParam.SamplerFilter.Companion.getSAMPLER_FILTER_LINEAR());
            return;
        }
        ViewExtensionsKt.onUi((Object)this, (Function0)((Function0)new Function0<Unit>(this, context, gpuSampleFilterConfig, action){
            final /* synthetic */ AlphaVideoPlayer this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ List $gpuSampleFilterConfig;
            final /* synthetic */ Function1 $action;

            public final void invoke() {
                AlphaVideoPlayer.access$getSamplerFilterFromConfig(this.this$0, this.$context, this.$gpuSampleFilterConfig, this.$action);
            }
            {
                this.this$0 = alphaVideoPlayer;
                this.$context = context;
                this.$gpuSampleFilterConfig = list;
                this.$action = function1;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void getSamplerFilterFromConfig(Context context, List<ChannelAlphaVideoConfig.GPUSampleFilterConfig> gpuList, Function1<? super Integer, Unit> action) {
        void sampleFilter;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = VideoPlayerParam.SamplerFilter.Companion.getSAMPLER_FILTER_LINEAR();
        GPUInfoManager.INSTANCE.getGPUName(context, (Function1)new Function1<String, Unit>(gpuList, (Ref.IntRef)sampleFilter, action){
            final /* synthetic */ List $gpuList;
            final /* synthetic */ Ref.IntRef $sampleFilter;
            final /* synthetic */ Function1 $action;

            public final void invoke(@NotNull String gpuInfo) {
                Intrinsics.checkParameterIsNotNull((Object)gpuInfo, (String)"gpuInfo");
                Iterable $this$forEach$iv = this.$gpuList;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ChannelAlphaVideoConfig.GPUSampleFilterConfig it = (ChannelAlphaVideoConfig.GPUSampleFilterConfig)element$iv;
                    boolean bl = false;
                    CharSequence charSequence = it.getBrand();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (charSequence == null || charSequence.length() == 0) continue;
                    CharSequence charSequence2 = gpuInfo;
                    String string2 = it.getBrand();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                    int seq = GPUInfoManager.INSTANCE.getSequence(gpuInfo);
                    switch (it.getPass()) {
                        case 0: {
                            if (it.getLevelTwo() < seq && it.getLevelTwo() != -1) {
                                this.$sampleFilter.element = VideoPlayerParam.SamplerFilter.Companion.getSAMPLER_FILTER_BICUBIC();
                                break;
                            }
                            if (it.getLevelOne() < seq && it.getLevelTwo() != -1) {
                                this.$sampleFilter.element = VideoPlayerParam.SamplerFilter.Companion.getSAMPLER_FILTER_HALF_BICUBIC();
                                break;
                            }
                            this.$sampleFilter.element = VideoPlayerParam.SamplerFilter.Companion.getSAMPLER_FILTER_LINEAR();
                            break;
                        }
                        case 1: {
                            VideoPlayerParam.SamplerFilter.Companion.getSAMPLER_FILTER_HALF_BICUBIC();
                            break;
                        }
                        case -1: {
                            VideoPlayerParam.SamplerFilter.Companion.getSAMPLER_FILTER_LINEAR();
                        }
                    }
                }
                this.$action.invoke((Object)this.$sampleFilter.element);
                SettingFlags.setIntValue((String)"key_alpha_video_sample_filter", (int)this.$sampleFilter.element);
            }
            {
                this.$gpuList = list;
                this.$sampleFilter = intRef;
                this.$action = function1;
                super(1);
            }
        });
    }

    private final void reportSuccess(String url, long duration, long fileSize) {
        StatisContent statisContent = new StatisContent();
        boolean bl = false;
        boolean bl2 = false;
        StatisContent $this$apply = statisContent;
        boolean bl3 = false;
        $this$apply.put("act", "hagoperf");
        $this$apply.put("perftype", "alpha_video");
        $this$apply.put("sfield", "success");
        $this$apply.put("sfieldtwo", url);
        $this$apply.put("sfieldthree", String.valueOf(duration));
        $this$apply.put("sfieldfour", AlphaVideoPlayerKt.formatSize(fileSize));
        StatisContent content = statisContent;
        HiidoStatis.reportContent((StatisContent)content);
        ResLoadMetric.report((String)"video", (long)duration, (LoadStatus)LoadStatus.NO_CACHE, (HashMap)MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"url", (Object)url), TuplesKt.to((Object)"fileSize", (Object)AlphaVideoPlayerKt.formatSize(fileSize))}));
    }

    private final void reportFail(String url, long duration, int code, String msg) {
        StatisContent statisContent = new StatisContent();
        boolean bl = false;
        boolean bl2 = false;
        StatisContent $this$apply = statisContent;
        boolean bl3 = false;
        $this$apply.put("act", "hagoperf");
        $this$apply.put("perftype", "alpha_video");
        $this$apply.put("sfield", "fail");
        $this$apply.put("sfieldtwo", url);
        $this$apply.put("sfieldthree", String.valueOf(duration));
        $this$apply.put("ifieldfive", code);
        $this$apply.put("sfieldfive", msg);
        StatisContent content = statisContent;
        HiidoStatis.reportContent((StatisContent)content);
    }

    private final void removeBadFileCache(String url) {
        if (!StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null)) {
            MLog.error((Object)TAG, (String)("removeBadFileCache maybe file bad delete cache file " + url), (Object[])new Object[0]);
            boolean $i$f$onWork = false;
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute((Runnable)new Runnable(url){
                    final /* synthetic */ String $url$inlined;
                    {
                        this.$url$inlined = string2;
                    }

                    public final void run() {
                        boolean bl = false;
                        YYFileUtils.delete((File)new File(this.$url$inlined));
                    }
                });
            } else {
                boolean bl = false;
                YYFileUtils.delete((File)new File(url));
            }
        }
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ void access$playVideo(AlphaVideoPlayer $this, ViewGroup container, String url, int source, IVideoPlayListener listener) {
        $this.playVideo(container, url, source, listener);
    }

    public static final /* synthetic */ void access$reportSuccess(AlphaVideoPlayer $this, String url, long duration, long fileSize) {
        $this.reportSuccess(url, duration, fileSize);
    }

    public static final /* synthetic */ void access$reportFail(AlphaVideoPlayer $this, String url, long duration, int code, String msg) {
        $this.reportFail(url, duration, code, msg);
    }

    public static final /* synthetic */ String access$getCacheDir$p(AlphaVideoPlayer $this) {
        return $this.getCacheDir();
    }

    public static final /* synthetic */ IVideoPlayer access$getPlayer$p(AlphaVideoPlayer $this) {
        return $this.player;
    }

    public static final /* synthetic */ void access$setPlayer$p(AlphaVideoPlayer $this, IVideoPlayer iVideoPlayer) {
        $this.player = iVideoPlayer;
    }

    public static final /* synthetic */ int access$getPlayerCount$cp() {
        return playerCount;
    }

    public static final /* synthetic */ void access$getSamplerFilterFromConfig(AlphaVideoPlayer $this, Context context, List gpuList, Function1 action) {
        $this.getSamplerFilterFromConfig(context, gpuList, (Function1<? super Integer, Unit>)action);
    }

    @JvmStatic
    public static final boolean isSupport() {
        return Companion.isSupport();
    }

    @JvmStatic
    public static final void resetCount() {
        Companion.resetCount();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J\u0019\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J)\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0096\u0001J\u0019\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J!\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0096\u0001J!\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0001J!\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001J!\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/yy/hiyo/channel/base/alphaplayer/AlphaVideoPlayer$ListenerWrap;", "Lcom/yy/hiyo/video/base/player/IVideoPlayListener;", "listener", "url", "", "(Lcom/yy/hiyo/channel/base/alphaplayer/AlphaVideoPlayer;Lcom/yy/hiyo/video/base/player/IVideoPlayListener;Ljava/lang/String;)V", "getListener", "()Lcom/yy/hiyo/video/base/player/IVideoPlayListener;", "getUrl", "()Ljava/lang/String;", "onLoadingProgress", "", "player", "Lcom/yy/hiyo/video/base/player/IVideoPlayer;", "percent", "", "onPlayCacheProgress", "position", "", "onPlayComplete", "onPlayCompleteOneLoop", "onPlayFirstFrameShow", "p1", "p2", "p3", "onPlayProgress", "onPlayerError", "what", "extra", "onPlayerInfo", "onPlayerStateUpdate", "newState", "onVideoSizeChanged", "channel-base_release"})
    public final class ListenerWrap
    implements IVideoPlayListener {
        @NotNull
        private final IVideoPlayListener listener;
        @NotNull
        private final String url;

        public void onPlayComplete(@NotNull IVideoPlayer player) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayComplete(player);
            boolean $i$f$onWork = false;
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute((Runnable)new Runnable(this){
                    final /* synthetic */ ListenerWrap this$0;
                    {
                        this.this$0 = listenerWrap;
                    }

                    public final void run() {
                        boolean bl = false;
                        AlphaVideoPlayer.access$copyCacheFile(this.this$0.AlphaVideoPlayer.this, this.this$0.getUrl());
                    }
                });
            } else {
                boolean bl = false;
                AlphaVideoPlayer.this.copyCacheFile(this.getUrl());
            }
        }

        @NotNull
        public final IVideoPlayListener getListener() {
            return this.listener;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public ListenerWrap(@NotNull IVideoPlayListener listener, String url) {
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            this.listener = listener;
            this.url = url;
        }

        public void onLoadingProgress(@NotNull IVideoPlayer player, int percent) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onLoadingProgress(player, percent);
        }

        public void onPlayCacheProgress(@NotNull IVideoPlayer player, long position) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayCacheProgress(player, position);
        }

        public void onPlayCompleteOneLoop(@NotNull IVideoPlayer player) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayCompleteOneLoop(player);
        }

        public void onPlayFirstFrameShow(@NotNull IVideoPlayer player, int p1, int p2, int p3) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayFirstFrameShow(player, p1, p2, p3);
        }

        public void onPlayProgress(@NotNull IVideoPlayer player, long position) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayProgress(player, position);
        }

        public void onPlayerError(@NotNull IVideoPlayer player, int what, int extra) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayerError(player, what, extra);
        }

        public void onPlayerInfo(@NotNull IVideoPlayer player, int what, long extra) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayerInfo(player, what, extra);
        }

        public void onPlayerStateUpdate(@NotNull IVideoPlayer player, int newState, int p2) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayerStateUpdate(player, newState, p2);
        }

        public void onVideoSizeChanged(@NotNull IVideoPlayer player, int p1, int p2) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onVideoSizeChanged(player, p1, p2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J\u0019\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J)\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0096\u0001J\u0019\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J!\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0012H\u0096\u0001J!\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001J!\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0096\u0001R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/yy/hiyo/channel/base/alphaplayer/AlphaVideoPlayer$PlayerListenerWrap;", "Lcom/yy/hiyo/video/base/player/IVideoPlayListener;", "url", "", "listener", "(Lcom/yy/hiyo/channel/base/alphaplayer/AlphaVideoPlayer;Ljava/lang/String;Lcom/yy/hiyo/video/base/player/IVideoPlayListener;)V", "getListener", "()Lcom/yy/hiyo/video/base/player/IVideoPlayListener;", "getUrl", "()Ljava/lang/String;", "onLoadingProgress", "", "player", "Lcom/yy/hiyo/video/base/player/IVideoPlayer;", "percent", "", "onPlayCacheProgress", "position", "", "onPlayComplete", "onPlayCompleteOneLoop", "onPlayFirstFrameShow", "p1", "p2", "p3", "onPlayProgress", "onPlayerError", "what", "extra", "onPlayerInfo", "onPlayerStateUpdate", "newState", "onVideoSizeChanged", "channel-base_release"})
    private final class PlayerListenerWrap
    implements IVideoPlayListener {
        @NotNull
        private final String url;
        @NotNull
        private final IVideoPlayListener listener;

        public void onPlayerError(@NotNull IVideoPlayer player, int what, int extra) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayerError(player, what, extra);
            AlphaVideoPlayer.this.removeBadFileCache(this.url);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final IVideoPlayListener getListener() {
            return this.listener;
        }

        public PlayerListenerWrap(@NotNull String url, IVideoPlayListener listener) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            this.url = url;
            this.listener = listener;
        }

        public void onLoadingProgress(@NotNull IVideoPlayer player, int percent) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onLoadingProgress(player, percent);
        }

        public void onPlayCacheProgress(@NotNull IVideoPlayer player, long position) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayCacheProgress(player, position);
        }

        public void onPlayComplete(@NotNull IVideoPlayer player) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayComplete(player);
        }

        public void onPlayCompleteOneLoop(@NotNull IVideoPlayer player) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayCompleteOneLoop(player);
        }

        public void onPlayFirstFrameShow(@NotNull IVideoPlayer player, int p1, int p2, int p3) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayFirstFrameShow(player, p1, p2, p3);
        }

        public void onPlayProgress(@NotNull IVideoPlayer player, long position) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayProgress(player, position);
        }

        public void onPlayerInfo(@NotNull IVideoPlayer player, int what, long extra) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayerInfo(player, what, extra);
        }

        public void onPlayerStateUpdate(@NotNull IVideoPlayer player, int newState, int p2) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onPlayerStateUpdate(player, newState, p2);
        }

        public void onVideoSizeChanged(@NotNull IVideoPlayer player, int p1, int p2) {
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            this.listener.onVideoSizeChanged(player, p1, p2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/yy/hiyo/channel/base/alphaplayer/AlphaVideoPlayer$Companion;", "", "()V", "TAG", "", "playerCount", "", "isSupport", "", "resetCount", "", "channel-base_release"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        public final boolean isSupport() {
            if (RuntimeContext.isHagoPartySdk()) return false;
            AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.CHANNEL_ALPHA_VIDEO_CONFIG);
            if (!(aConfigData instanceof ChannelAlphaVideoConfig)) {
                aConfigData = null;
            }
            ChannelAlphaVideoConfig channelAlphaVideoConfig = (ChannelAlphaVideoConfig)aConfigData;
            if (channelAlphaVideoConfig == null) return true;
            boolean bl = channelAlphaVideoConfig.isEnable();
            if (!bl) return false;
            return true;
        }

        @JvmStatic
        public final void resetCount() {
            SettingFlags.removeKey((String)"key_alpha_video_count");
            playerCount = 0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

