/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.base.service;

import android.content.Context;
import androidx.annotation.Nullable;
import com.yy.appbase.common.Callback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.base.bean.AcrossRecommendInfo;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfo;
import com.yy.hiyo.channel.base.bean.ChannelInfoSelector;
import com.yy.hiyo.channel.base.bean.ChannelListData;
import com.yy.hiyo.channel.base.bean.FamilyGateInfo;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelBaseService;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface IDataService
extends IChannelBaseService {
    public void getChannelBaseInfoFromServer(IGetGroupBaseInfoCallBack var1);

    public void getChannelBaseInfo(IGetGroupBaseInfoCallBack var1);

    @Deprecated
    public ChannelDetailInfo getChannelDetailInfo(IGetDetailInfoCallBack var1);

    @Nullable
    public ChannelDetailInfo getCacheDetail();

    public void fetchChannelDetailInfo(IGetDetailInfoCallBack var1);

    public void fetchChannelDetailInfo(IGetDetailInfoCallBack var1, boolean var2);

    public void getChannelDetailInfo(ChannelInfoSelector var1, IGetDetailInfoCallBack var2);

    public void getTopAndSubChannelInfos(IGetTopAndSubInfosCallBack var1);

    public void updateName(String var1, IUpdateNameCallBack var2);

    public void updateAvatar(String var1, IUpdateAvatarCallback var2);

    public void updateCategory(int var1, int var2, boolean var3, @Nullable IUpdateCategoryCallback var4);

    public void updateannouncement(String var1, boolean var2, IUpdateInfoCallBack var3);

    public void updateSpeakMode(int var1, IUpdateInfoCallBack var2);

    public void setOpenPartyPermission(boolean var1, IUpdateInfoCallBack var2);

    public void updateJoinMode(int var1, String var2, int var3, IUpdateInfoCallBack var4);

    public void updatePrivacyMode(boolean var1, IUpdateInfoCallBack var2);

    public void updateRoleJoinMode(int var1, IUpdateInfoCallBack var2);

    public void updateLightEffect(String var1, IUpdateInfoCallBack var2);

    public void changeFamilyGate(FamilyGateInfo var1, IUpdateFamilyGateCallBack var2);

    public void updateOpenVoiceChatMode(int var1, IUpdateInfoCallBack var2);

    public void updateVoiceEnterMode(int var1, IUpdateInfoCallBack var2);

    public void updateGuestSpeakLimit(int var1, IUpdateInfoCallBack var2);

    public void updateTag(ArrayList<String> var1, IUpdateInfoCallBack var2);

    public void linkTag(String var1, @Nullable Callback<Boolean> var2);

    public void unLinkTag(@Nullable Callback<Boolean> var1);

    public String getTagId();

    public void getInviteEnterToken(IGetInviteTokenCallBack var1);

    public void addDataListener(IDataUpdateListener var1);

    public void removeDataListener(IDataUpdateListener var1);

    public void getAcrossRecommendList(String var1, String var2, int var3, @Nullable String var4, boolean var5, IGetAcrossRecommendListCallback var6);

    public boolean useOldRoomStyle();

    public void addChannelExtra(String var1, Object var2);

    public <T> T getChannelExtra(String var1, T var2);

    public void addExtra(String var1, Object var2);

    public <T> T getExtra(String var1, T var2);

    public void updateChannelPostPermission(int var1, int var2, @NotNull IUpdateInfoCallBack var3);

    public void updateChannelPostPermission(int var1, int var2, int var3, @NotNull IUpdateInfoCallBack var4);

    public void isSameRegion(long var1, Callback<Boolean> var3);

    public void updateChannelMemberSwitch(boolean var1);

    public void updateChannelTitleSwitch(boolean var1);

    @Nullable
    public Object getLocalEndPageData();

    public void setLocalEndPageData(Object var1);

    public void updateGroupChatBg(String var1, IUpdateChatBgCallback var2);

    public void clearGroupChatBg(IUpdateChatBgCallback var1);

    public static interface IUpdateChatBgCallback {
        public void onSuccess();

        public void onError(int var1, String var2);
    }

    public static interface IDataUpdateListener {
        default public void onDataUpdate(String channelId, ChannelDetailInfo info) {
        }

        default public void onOnlineNumChangeListener(String channelId, long onlineNum) {
        }

        default public void onTopAndSubGroupListChange(String channelId, ChannelListData data, List<Integer> totalNumList, List<Integer> limitNumList, @Nullable ThemeItemBean partTheme) {
        }

        default public void onRecommendTagUpdate(String channelId, String tagId) {
        }
    }

    public static interface IGetInviteTokenCallBack {
        public void onSuccess(String var1, String var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface ISubscribeCallBack {
        public void onSuccess(IChannel var1, long var2, boolean var4);

        public void onError(IChannel var1, int var2, String var3, Exception var4);
    }

    public static interface IGetAcrossRecommendListCallback {
        public void onSuccess(String var1, @Nullable List<AcrossRecommendInfo> var2);

        default public void onError(String channelId, int code, Exception e) {
        }
    }

    public static interface IGetGroupBaseInfoCallBack {
        public void onSuccess(String var1, ChannelInfo var2);

        default public void onError(String channelId, int errorCode, String errorTips, Exception e) {
        }
    }

    public static interface IGetDetailInfoCallBack {
        public void onSuccess(String var1, ChannelDetailInfo var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IUpdateCategoryCallback {
        public void onSuccess(String var1, int var2, int var3);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IUpdateAvatarCallback {
        public void onSuccess(String var1);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IUpdateNameCallBack {
        public void onSuccess(IChannel var1);

        public void renameLimit(String var1);

        public void onContainSensitiveWord();

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IUpdateFamilyGateCallBack {
        public void onSuccess(IChannel var1);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IUpdateInfoCallBack {
        public void onSuccess(IChannel var1);

        public void onContainSensitiveWord();

        default public void updateLimit(String toast) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)toast, (int)0);
        }

        public void onFailUnauthorized();

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static class UpdateInfoCallBackEx
    implements IUpdateInfoCallBack {
        private IUpdateInfoCallBack mCallBack;

        public UpdateInfoCallBackEx(IUpdateInfoCallBack callBack) {
            this.mCallBack = callBack;
        }

        @Override
        public void onSuccess(IChannel group) {
            if (this.mCallBack != null) {
                this.mCallBack.onSuccess(group);
            }
        }

        @Override
        public void onContainSensitiveWord() {
            if (this.mCallBack != null) {
                this.mCallBack.onContainSensitiveWord();
            }
        }

        @Override
        public void updateLimit(String toast) {
            if (this.mCallBack != null) {
                this.mCallBack.updateLimit(toast);
            }
        }

        @Override
        public void onFailUnauthorized() {
            if (this.mCallBack != null) {
                this.mCallBack.onFailUnauthorized();
            }
        }

        @Override
        public void onError(String channelId, int errorCode, String errorTips, Exception e) {
            if (this.mCallBack != null) {
                this.mCallBack.onError(channelId, errorCode, errorTips, e);
            }
        }
    }

    public static interface IGetTopAndSubBaseInfosCallBack {
        public void onSuccess(String var1, ArrayList<ChannelInfo> var2);

        public void onError(String var1, int var2, String var3, Exception var4);
    }

    public static interface IGetTopAndSubInfosCallBack {
        public void onSuccess(String var1, ChannelListData var2, @Nullable List<Integer> var3, @Nullable List<Integer> var4, @Nullable ThemeItemBean var5);

        public void onError(String var1, int var2, String var3, Exception var4);
    }
}

