/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.widget;

import androidx.annotation.NonNull;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.drakeet.multitype.MultiTypeAdapter;
import me.drakeet.multitype.TypePool;

public class PagingMultiTypeAdapter
extends MultiTypeAdapter {
    public PagingMultiTypeAdapter() {
    }

    public PagingMultiTypeAdapter(@NonNull List<?> items) {
        super(items);
    }

    public PagingMultiTypeAdapter(@NonNull List<?> items, int initialCapacity) {
        super(items, initialCapacity);
    }

    public PagingMultiTypeAdapter(@NonNull List<?> items, @NonNull TypePool pool) {
        super(items, pool);
    }

    public void listRefresh(List<?> refreshItems) {
        if (this.getItems() == null) {
            this.setItems(new CopyOnWriteArrayList());
        }
        List items = this.getItems();
        items.clear();
        if (refreshItems != null) {
            items.addAll(refreshItems);
        }
        this.notifyDataSetChanged();
    }

    public void listAddMore(List<?> moreItems) {
        if (moreItems == null) {
            return;
        }
        if (this.getItems() == null) {
            this.setItems(new CopyOnWriteArrayList());
        }
        List items = this.getItems();
        int stratIndex = items.size();
        int addCount = moreItems.size();
        items.addAll(moreItems);
        this.notifyItemRangeInserted(stratIndex, addCount);
    }

    public void listItemUpdate(Object item) {
        List items;
        int index;
        if (this.getItems() == null) {
            this.setItems(new CopyOnWriteArrayList());
        }
        if ((index = (items = this.getItems()).indexOf(item)) >= 0 && index < items.size()) {
            this.notifyItemChanged(index);
        }
    }
}

