/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.utils.preference;

import android.content.SharedPreferences;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.SharedPreferencesUtils;

public class RoomSetting {
    private static final String NAME = "voice_room";
    private static SharedPreferences mPreferences;
    private static final String VIDEO_SCHEME_SETTING = "VideoSetting";
    private static final String PERMISSION_SCHEME_SETTING = "PermissionSetting";
    private static final String LAST_VIDEO_SETTING = "LastVideoOPen";
    public static boolean useMobileNetWork;
    public static boolean isWhiteListUser;
    private static int LAST_OPEN_VIDEO;
    private static int REMOVE_TIP_SHOW;

    public static SharedPreferences getPreference() {
        long uid = AccountUtil.getUid();
        if (mPreferences == null) {
            mPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, NAME + uid, 0);
        }
        return mPreferences;
    }

    public static boolean lastOpenVideo() {
        return RoomSetting.getPreference().getBoolean(VIDEO_SCHEME_SETTING, false);
    }

    public static void onSaveKtvScheme(boolean openVideo) {
        RoomSetting.getPreference().edit().putBoolean(VIDEO_SCHEME_SETTING, openVideo).apply();
    }

    public static boolean onLastIsWhiteList() {
        boolean showTip = false;
        int lastVideoOpenType = RoomSetting.getPreference().getInt(LAST_VIDEO_SETTING, 0);
        if (isWhiteListUser) {
            if (lastVideoOpenType != REMOVE_TIP_SHOW && lastVideoOpenType != LAST_OPEN_VIDEO) {
                RoomSetting.getPreference().edit().putInt(LAST_VIDEO_SETTING, LAST_OPEN_VIDEO).apply();
            }
        } else if (lastVideoOpenType == LAST_OPEN_VIDEO) {
            showTip = true;
            RoomSetting.getPreference().edit().putInt(LAST_VIDEO_SETTING, REMOVE_TIP_SHOW).apply();
        }
        return showTip;
    }

    public static void onSaveKtvPermission(boolean permission) {
        RoomSetting.getPreference().edit().putBoolean(PERMISSION_SCHEME_SETTING, permission).apply();
    }

    public static boolean getPermission() {
        return RoomSetting.getPreference().getBoolean(PERMISSION_SCHEME_SETTING, false);
    }

    static {
        useMobileNetWork = false;
        isWhiteListUser = false;
        LAST_OPEN_VIDEO = 1;
        REMOVE_TIP_SHOW = 3;
    }
}

