/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.publicscreen.msg;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class PureTextMsg
extends BaseImMsg {
    public static final String kvo_msgText = "msgText";
    @KvoFieldAnnotation(name="msgText")
    private CharSequence msgText;
    private boolean isNotSupportMsg = false;
    public static final String kvo_refreshForce = "refreshForce";
    @KvoFieldAnnotation(name="refreshForce")
    private boolean refreshForce = false;
    private CharSequence sessionTips;
    private String extend;
    private boolean canBeReported = true;
    @Nullable
    private Map<String, Integer> linkMap;

    public PureTextMsg(BaseImMsg msg) {
        super(msg);
    }

    public PureTextMsg() {
    }

    public CharSequence getSessionTips() {
        if (!TextUtils.isEmpty((CharSequence)this.sessionTips)) {
            return this.sessionTips;
        }
        if (this.isRevokeMsg()) {
            return super.getSessionTips();
        }
        return StringUtils.format((String)"%s: %s", (Object[])new Object[]{this.getNick(), this.msgText.toString()});
    }

    public void setSessionTips(CharSequence sessionTips) {
        this.sessionTips = sessionTips;
    }

    public CharSequence getMsgText() {
        return this.msgText;
    }

    public void setMsgText(CharSequence msgText) {
        this.setValue(kvo_msgText, msgText);
    }

    public void forceFreshHolder() {
        this.setRefreshForce(!this.refreshForce);
    }

    private void setRefreshForce(boolean refresh) {
        this.setValue(kvo_refreshForce, refresh);
    }

    public void setMsgTextUnbind(CharSequence msgText) {
        this.msgText = msgText;
    }

    public boolean isNotSupportMsg() {
        return this.isNotSupportMsg;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    @Nullable
    public Map<String, Integer> getLinkMap() {
        return this.linkMap;
    }

    public void setLinkMap(@Nullable Map<String, Integer> linkMap) {
        this.linkMap = linkMap;
    }

    public boolean isCanBeReported() {
        return this.canBeReported;
    }

    public void setCanBeReported(boolean canBeReported) {
        this.canBeReported = canBeReported;
    }

    public String getOriginalContent() {
        List sections = this.getSections();
        if (!FP.empty((Collection)sections)) {
            for (MsgSection section : sections) {
                if (section == null || section.getType() != 1) continue;
                return section.getContent();
            }
        }
        return "";
    }

    public String toString() {
        if (ChannelDefine.sUnEnableLog) {
            return super.toString();
        }
        return "PureTextMsg{msgText='" + this.msgText + '\'' + "isNotSupportMsg='" + this.isNotSupportMsg + '\'' + "super='" + super.toString() + '\'' + '}';
    }

    public boolean isDisposable(boolean isStrongNeed) {
        return isStrongNeed && super.getFrom() != AccountUtil.getUid();
    }

    public String getNoAtContent() {
        String finalResult = this.msgText.toString();
        List sections = this.getSections();
        if (sections != null) {
            for (int i = 0; i < sections.size(); ++i) {
                MsgSection msgSection = (MsgSection)sections.get(i);
                if (msgSection == null || msgSection.getType() != 2005) continue;
                String nick = "";
                try {
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)msgSection.getContent());
                    nick = jsonObject.optString("nick");
                }
                catch (Exception e) {
                    MLog.error((Object)"PureTextMsg", (Throwable)e);
                }
                finalResult = finalResult.replace("@" + nick, "");
            }
        }
        return finalResult;
    }
}

