/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.module.ktv.bean;

import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import java.util.ArrayList;
import java.util.List;
import net.ihago.ktv.api.biz.GetRoomKaraokeInfoRsp;
import net.ihago.ktv.api.biz.KaraokeSongInfo;

public final class KTVRoomOrderedListInfo {
    private List<KTVRoomSongInfo> songInfoList;
    private int cursor;
    private int version;
    private int totalSongsCount;

    private KTVRoomOrderedListInfo(Builder builder) {
        this.songInfoList = builder.songInfoList;
        this.cursor = builder.cursor;
        this.version = builder.version;
        this.totalSongsCount = builder.totalSongsCount;
    }

    public List<KTVRoomSongInfo> getSongInfoList() {
        return this.songInfoList;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getVersion() {
        return this.version;
    }

    public int getTotalSongsCount() {
        return this.totalSongsCount;
    }

    public static KTVRoomOrderedListInfo convertTo(GetRoomKaraokeInfoRsp info) {
        ArrayList<KTVRoomSongInfo> ktvSongInfoList = new ArrayList<KTVRoomSongInfo>();
        List songsList = info.songs;
        for (KaraokeSongInfo songInfo : songsList) {
            ktvSongInfoList.add(KTVRoomSongInfo.convertTo(songInfo));
        }
        return new Builder().songInfoList(ktvSongInfoList).cursor(info.cursor).version(info.version).totalSongsCount(info.total_songs_count).build();
    }

    public static final class Builder {
        private List<KTVRoomSongInfo> songInfoList;
        private int cursor;
        private int version;
        private int totalSongsCount;

        public Builder songInfoList(List<KTVRoomSongInfo> songInfoList) {
            this.songInfoList = songInfoList;
            return this;
        }

        public Builder cursor(int cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder totalSongsCount(int totalSongsCount) {
            this.totalSongsCount = totalSongsCount;
            return this;
        }

        public KTVRoomOrderedListInfo build() {
            return new KTVRoomOrderedListInfo(this);
        }
    }
}

