/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.module.common;

import android.app.Activity;
import android.content.Context;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.util.KeepScreenOnTask;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.channel.base.bean.LiveCodeRateKt;
import com.yy.hiyo.channel.cbase.module.common.AnchorQualityManager;
import com.yy.hiyo.channel.cbase.module.common.BaseLivePresenter;
import com.yy.hiyo.channel.cbase.module.common.CodeRateUtils;
import com.yy.hiyo.channel.cbase.module.common.KtvRoomModel;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvLiveOperator;
import com.yy.hiyo.channel.cbase.module.ktv.live.ILivePresenter;
import com.yy.hiyo.channel.cbase.module.ktv.live.ILiveView;
import com.yy.hiyo.channel.cbase.utils.preference.RoomSetting;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.ktv.api.biz.SwitchAVModeReq;
import net.ihago.ktv.api.biz.SwitchAVModeRsp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013*\u0001%\b\u0016\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010/\u001a\u000200H\u0014J\u0006\u00101\u001a\u000200J\b\u00102\u001a\u000200H\u0016J\b\u00103\u001a\u000204H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u000706H\u0016J\b\u00107\u001a\u00020\u0007H\u0016J\b\u00108\u001a\u000200H\u0016J\u0010\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u0002002\u0006\u0010=\u001a\u00020\u0007H\u0016J\u0010\u0010>\u001a\u0002002\u0006\u0010=\u001a\u00020\u0007H\u0016J\b\u0010?\u001a\u00020\u0007H\u0016J\u0010\u0010@\u001a\u0002002\u0006\u0010A\u001a\u00020\u0014H\u0002J\u0010\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020\u0007H\u0002J\u0010\u0010D\u001a\u0002002\u0006\u0010E\u001a\u00020\u0004H\u0016J\u0010\u0010F\u001a\u0002002\u0006\u0010G\u001a\u00020\u001aH\u0016J\b\u0010H\u001a\u000200H\u0016J\u0018\u0010I\u001a\u0002002\u0006\u0010J\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0010\u0010K\u001a\u0002002\u0006\u0010L\u001a\u00020\u0007H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u0018R\u001a\u0010\u001e\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\t\"\u0004\b \u0010\u000bR\u001a\u0010!\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\t\"\u0004\b#\u0010\u000bR\u0010\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\t\"\u0004\b.\u0010\u000b\u00a8\u0006N"}, d2={"Lcom/yy/hiyo/channel/cbase/module/common/BaseLivePresenter;", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/ILivePresenter;", "Lcom/yy/framework/core/INotify;", "mRoomId", "", "(Ljava/lang/String;)V", "mHasPause", "", "getMHasPause", "()Z", "setMHasPause", "(Z)V", "mHasStart", "getMHasStart", "setMHasStart", "mKeepScreenOnTask", "Lcom/yy/appbase/util/KeepScreenOnTask;", "mLeaveTimeoutTask", "Ljava/lang/Runnable;", "mLiveQualityLevel", "", "getMLiveQualityLevel", "()I", "setMLiveQualityLevel", "(I)V", "mLiveView", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/ILiveView;", "mMode", "getMMode", "setMMode", "mNeedRestoreKtvVideoState", "getMNeedRestoreKtvVideoState", "setMNeedRestoreKtvVideoState", "mOnVideoMode", "getMOnVideoMode", "setMOnVideoMode", "mOperator", "com/yy/hiyo/channel/cbase/module/common/BaseLivePresenter$mOperator$1", "Lcom/yy/hiyo/channel/cbase/module/common/BaseLivePresenter$mOperator$1;", "mPauseBackground", "mVoiceService", "Lcom/yy/hiyo/voice/base/channelvoice/IKtvLiveServiceExtend;", "getMVoiceService", "()Lcom/yy/hiyo/voice/base/channelvoice/IKtvLiveServiceExtend;", "useFront", "getUseFront", "setUseFront", "checkNeedRestoreVideoState", "", "checkNetWork", "destroy", "getContract", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/IKtvLiveOperator;", "isDestroyData", "Landroidx/lifecycle/LiveData;", "isStarted", "noPermisssion", "notify", "notification", "Lcom/yy/framework/core/Notification;", "onSingEnd", "isBackground", "onSingStart", "onVideoMode", "reportLiveQuality", "selectedLevel", "reportVideoSchemeSwitch", "videoScheme", "sendRoomNotify", "content", "setBaseView", "iView", "start", "startLive", "isSwitchToStart", "stopLive", "isSwitchToEnd", "Companion", "cbase_debug"})
public class BaseLivePresenter
implements ILivePresenter,
INotify {
    private ILiveView mLiveView;
    @NotNull
    private final IKtvLiveServiceExtend mVoiceService;
    private boolean mHasStart;
    private boolean mHasPause;
    private boolean mOnVideoMode;
    private boolean mPauseBackground;
    private boolean mNeedRestoreKtvVideoState;
    private KeepScreenOnTask mKeepScreenOnTask;
    private int mMode;
    private boolean useFront;
    private Runnable mLeaveTimeoutTask;
    private int mLiveQualityLevel;
    private final mOperator.1 mOperator;
    private final String mRoomId;
    public static final long LEAVE_TIMEOUT = 60000L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final IKtvLiveServiceExtend getMVoiceService() {
        return this.mVoiceService;
    }

    protected final boolean getMHasStart() {
        return this.mHasStart;
    }

    protected final void setMHasStart(boolean bl) {
        this.mHasStart = bl;
    }

    protected final boolean getMHasPause() {
        return this.mHasPause;
    }

    protected final void setMHasPause(boolean bl) {
        this.mHasPause = bl;
    }

    protected final boolean getMOnVideoMode() {
        return this.mOnVideoMode;
    }

    protected final void setMOnVideoMode(boolean bl) {
        this.mOnVideoMode = bl;
    }

    protected final boolean getMNeedRestoreKtvVideoState() {
        return this.mNeedRestoreKtvVideoState;
    }

    protected final void setMNeedRestoreKtvVideoState(boolean bl) {
        this.mNeedRestoreKtvVideoState = bl;
    }

    protected final int getMMode() {
        return this.mMode;
    }

    protected final void setMMode(int n) {
        this.mMode = n;
    }

    protected final boolean getUseFront() {
        return this.useFront;
    }

    protected final void setUseFront(boolean bl) {
        this.useFront = bl;
    }

    protected final int getMLiveQualityLevel() {
        return this.mLiveQualityLevel;
    }

    protected final void setMLiveQualityLevel(int n) {
        this.mLiveQualityLevel = n;
    }

    protected void checkNeedRestoreVideoState() {
    }

    @Override
    public void startLive(boolean isSwitchToStart, boolean useFront) {
        MLog.info((Object)"BaseLivePresenter", (String)("mHasStart :" + this.mHasStart + ", this:" + this), (Object[])new Object[0]);
        if (this.mHasStart) {
            return;
        }
        this.useFront = useFront;
        this.mOnVideoMode = true;
        ILiveView iLiveView = this.mLiveView;
        if (iLiveView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        iLiveView.adjustPlayPreviewView(true, false);
        StringBuilder stringBuilder = new StringBuilder().append("startLive execute0 , mVoiceService\uff1a").append(this.mVoiceService).append(", view:");
        ILiveView iLiveView2 = this.mLiveView;
        if (iLiveView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        MLog.info((Object)"BaseLivePresenter", (String)stringBuilder.append(iLiveView2).toString(), (Object[])new Object[0]);
        int codeRate = CodeRateUtils.INSTANCE.getCodeRateLevelNumber(this.mLiveQualityLevel);
        ILiveView iLiveView3 = this.mLiveView;
        if (iLiveView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        this.mVoiceService.startLive(iLiveView3.getPreviewView(), useFront, this.mMode, codeRate);
        this.reportLiveQuality(codeRate);
        MLog.info((Object)"BaseLivePresenter", (String)"startLive execute1", (Object[])new Object[0]);
        ILiveView iLiveView4 = this.mLiveView;
        if (iLiveView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        iLiveView4.getPreviewView().post(new Runnable(this){
            final /* synthetic */ BaseLivePresenter this$0;

            public final void run() {
                BaseLivePresenter.access$getMLiveView$p(this.this$0).hideOrShowPreviewView(true);
            }
            {
                this.this$0 = baseLivePresenter;
            }
        });
        this.mHasStart = true;
        this.mHasPause = false;
        this.mPauseBackground = false;
        this.reportVideoSchemeSwitch(true);
        ILiveView iLiveView5 = this.mLiveView;
        if (iLiveView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        this.mKeepScreenOnTask.keepScreenOn(iLiveView5.getActivityContext());
    }

    private final void reportLiveQuality(int selectedLevel) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "livequality");
        statContent.put("ifield", selectedLevel);
        statContent.put("ifieldtwo", AnchorQualityManager.INSTANCE.getSupportHighetQuality());
        int availableHighestQuality = AnchorQualityManager.INSTANCE.isSupportHighQuality() ? AnchorQualityManager.INSTANCE.getSupportHighetQuality() : LiveCodeRateKt.getStandardQuality();
        statContent.put("ifieldthree", availableHighestQuality);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    @Override
    public void stopLive(boolean isSwitchToEnd) {
        MLog.info((Object)"BaseLivePresenter", (String)("stopLive mHasStart:" + this.mHasStart + " , this:" + this), (Object[])new Object[0]);
        if (this.mHasStart) {
            this.mVoiceService.stopLive();
            ILiveView iLiveView = this.mLiveView;
            if (iLiveView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
            }
            iLiveView.hideOrShowPreviewView(false);
            this.mHasStart = false;
            this.mOnVideoMode = false;
            this.reportVideoSchemeSwitch(false);
            ILiveView iLiveView2 = this.mLiveView;
            if (iLiveView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
            }
            this.mKeepScreenOnTask.unDoKeepScreenOn(iLiveView2.getActivityContext());
        }
    }

    @Override
    @NotNull
    public IKtvLiveOperator getContract() {
        return this.mOperator;
    }

    public void start() {
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    public final void checkNetWork() {
        ILiveView iLiveView = this.mLiveView;
        if (iLiveView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        Activity activity = iLiveView.getActivityContext();
        if (NetworkUtils.isWifiActive((Context)RuntimeContext.sApplicationContext) || RoomSetting.useMobileNetWork) {
            this.startLive(false, this.useFront);
        } else {
            KtvRoomModel.INSTANCE.showMobileNetWorkDialogTip((Context)activity, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ BaseLivePresenter this$0;

                public final void invoke() {
                    this.this$0.startLive(false, this.this$0.getUseFront());
                }
                {
                    this.this$0 = baseLivePresenter;
                    super(0);
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ BaseLivePresenter this$0;

                public final void invoke() {
                    BaseLivePresenter.access$getMLiveView$p(this.this$0).resetView();
                }
                {
                    this.this$0 = baseLivePresenter;
                    super(0);
                }
            }));
        }
    }

    @Override
    public void setBaseView(@NotNull ILiveView iView) {
        Intrinsics.checkParameterIsNotNull((Object)iView, (String)"iView");
        this.mLiveView = iView;
        iView.setPresenter(this);
    }

    @Override
    public void onSingEnd(boolean isBackground) {
        MLog.info((Object)"BaseLivePresenter", (String)("onSingEnd,mOnVideoMode:" + this.mOnVideoMode + " mHasPause:" + this.mHasPause + ' ' + "isBackground:" + isBackground), (Object[])new Object[0]);
        if (!this.mHasPause && this.mOnVideoMode) {
            this.stopLive(false);
            this.mHasPause = true;
            this.reportVideoSchemeSwitch(false);
        }
    }

    @Override
    public void onSingStart(boolean isBackground) {
        MLog.info((Object)"BaseLivePresenter", (String)("onSingStart,mOnVideoMode:" + this.mOnVideoMode + " mHasPause:" + this.mHasPause), (Object[])new Object[0]);
        if (this.mHasPause && this.mOnVideoMode) {
            this.startLive(false, this.useFront);
            this.mHasPause = false;
            this.reportVideoSchemeSwitch(true);
        }
    }

    @Override
    public boolean onVideoMode() {
        return this.mOnVideoMode;
    }

    @Override
    public void destroy() {
        MLog.info((Object)"BaseLivePresenter", (String)"destroy", (Object[])new Object[0]);
        YYTaskExecutor.removeTask((Runnable)this.mLeaveTimeoutTask);
        this.stopLive(false);
        ILiveView iLiveView = this.mLiveView;
        if (iLiveView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        iLiveView.removePreviewView();
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    @NotNull
    public LiveData<Boolean> isDestroyData() {
        MutableLiveData mutableLiveData = new MutableLiveData();
        boolean bl = false;
        boolean bl2 = false;
        MutableLiveData $this$apply = mutableLiveData;
        boolean bl3 = false;
        $this$apply.setValue((Object)true);
        return (LiveData)mutableLiveData;
    }

    public void notify(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            Object object = notification.extObj;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            boolean foreground = (Boolean)object;
            if (this.mOnVideoMode || this.mNeedRestoreKtvVideoState) {
                if (foreground) {
                    if (this.mNeedRestoreKtvVideoState) {
                        this.mOnVideoMode = true;
                        this.mNeedRestoreKtvVideoState = false;
                    }
                    YYTaskExecutor.removeTask((Runnable)this.mLeaveTimeoutTask);
                    if (this.mPauseBackground) {
                        this.onSingStart(true);
                        this.mPauseBackground = false;
                    }
                } else if (!foreground && !this.mPauseBackground && !this.mHasPause && this.mHasStart) {
                    YYTaskExecutor.postToMainThread((Runnable)this.mLeaveTimeoutTask, (long)60000L);
                }
            }
        }
    }

    private final void reportVideoSchemeSwitch(boolean videoScheme) {
        if (this.mMode != 1) {
            return;
        }
        SwitchAVModeReq.AVMode mode = videoScheme ? SwitchAVModeReq.AVMode.AVMode_Video : SwitchAVModeReq.AVMode.AVMode_Audio;
        SwitchAVModeReq biz = new SwitchAVModeReq.Builder().mode(mode).build();
        ProtoManager.getInstance().sendRpc(this.mRoomId, (AndroidMessage)biz, (IProtoCallback)new SimpleProtoCallback<SwitchAVModeRsp>(){

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                MLog.info((Object)"BaseLivePresenter", (String)("reportVideoSchemeSwitch onError:" + reason + " code:" + code), (Object[])new Object[0]);
            }

            public void onResponse(@Nullable SwitchAVModeRsp message) {
                super.onResponse((AndroidMessage)message);
                MLog.info((Object)"BaseLivePresenter", (String)("reportVideoSchemeSwitch message:" + message), (Object[])new Object[0]);
            }
        });
    }

    @Override
    public void noPermisssion() {
        ILiveView iLiveView = this.mLiveView;
        if (iLiveView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        iLiveView.resetView();
    }

    @Override
    public boolean isStarted() {
        return this.mHasStart;
    }

    @Override
    public void sendRoomNotify(@NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        MLog.info((Object)"BaseLivePresenter", (String)("sendRoomNotify,[content:" + content + "] "), (Object[])new Object[0]);
    }

    public BaseLivePresenter(@NotNull String mRoomId) {
        Intrinsics.checkParameterIsNotNull((Object)mRoomId, (String)"mRoomId");
        this.mRoomId = mRoomId;
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        IService iService = iServiceManager.getService(IKtvLiveServiceExtend.class);
        if (iService == null) {
            Intrinsics.throwNpe();
        }
        this.mVoiceService = (IKtvLiveServiceExtend)iService;
        this.mKeepScreenOnTask = new KeepScreenOnTask();
        this.mMode = 1;
        this.useFront = true;
        this.mLeaveTimeoutTask = new Runnable(this){
            final /* synthetic */ BaseLivePresenter this$0;

            public final void run() {
                this.this$0.onSingEnd(true);
                BaseLivePresenter.access$setMPauseBackground$p(this.this$0, true);
                this.this$0.checkNeedRestoreVideoState();
            }
            {
                this.this$0 = baseLivePresenter;
            }
        };
        this.mLiveQualityLevel = LiveCodeRateKt.getStandardQuality();
        this.mOperator = new IKtvLiveOperator(){};
    }

    public static final /* synthetic */ ILiveView access$getMLiveView$p(BaseLivePresenter $this) {
        ILiveView iLiveView = $this.mLiveView;
        if (iLiveView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveView");
        }
        return iLiveView;
    }

    public static final /* synthetic */ void access$setMLiveView$p(BaseLivePresenter $this, ILiveView iLiveView) {
        $this.mLiveView = iLiveView;
    }

    public static final /* synthetic */ boolean access$getMPauseBackground$p(BaseLivePresenter $this) {
        return $this.mPauseBackground;
    }

    public static final /* synthetic */ void access$setMPauseBackground$p(BaseLivePresenter $this, boolean bl) {
        $this.mPauseBackground = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/cbase/module/common/BaseLivePresenter$Companion;", "", "()V", "LEAVE_TIMEOUT", "", "cbase_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

