/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.model.bean;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.MediaData;
import com.yy.hiyo.channel.base.bean.SeatData;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.cbase.model.bean.IRoomData;
import com.yy.hiyo.channel.cbase.model.bean.LockInfo;
import com.yy.hiyo.channel.cbase.model.bean.RoomInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.Collection;

@Keep
public class RoomData
implements IRoomData {
    private static final String TAG = "FTVoiceRoom RoomData";
    private RoomInfo mRoomInfo;
    private SeatData mSeatData;
    @NonNull
    private ChannelPluginData mRoomGameInfo = new ChannelPluginData(10, "chat");
    private LockInfo mLockInfo;
    private EnterParam mEnterParam;
    private MediaData mMediaData;
    private String topGroupId;

    public RoomData() {
    }

    private RoomData(Builder builder) {
        this.setTopGroupId(builder.topGroupId);
        this.mRoomInfo = builder.mRoomInfo;
        this.mSeatData = builder.mSeatData;
        this.mRoomGameInfo = builder.mRoomGameInfo;
        this.mLockInfo = builder.mLockInfo;
        this.mEnterParam = builder.mEnterParam;
        this.mMediaData = builder.mMediaData;
    }

    public RoomInfo getRoomInfo() {
        return this.mRoomInfo;
    }

    public void setRoomId(String roomId) {
        if (this.getRoomInfo() != null) {
            this.getRoomInfo().setId(roomId);
        }
    }

    public LockInfo getLockInfo() {
        return this.mLockInfo;
    }

    public EnterParam getEnterParam() {
        return this.mEnterParam;
    }

    public void setEnterParam(EnterParam enterParam) {
        this.mEnterParam = enterParam;
    }

    public String getRoomId() {
        return this.getRoomInfo().getId();
    }

    public SeatData getSeatData() {
        return this.mSeatData;
    }

    @NonNull
    public ChannelPluginData getGameInfo() {
        return this.mRoomGameInfo;
    }

    public boolean isInChessGame() {
        String gameId = this.mRoomGameInfo.getPluginId();
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        return gameInfo != null && gameInfo.isRoomCheesGame();
    }

    public boolean isInAssistGame() {
        if (this.mRoomGameInfo == null) {
            return false;
        }
        String gameId = this.mRoomGameInfo.getPluginId();
        GameInfo gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        return this.mRoomGameInfo.getMode() == 300 && gameInfo != null && gameInfo.isRoomAssistGame();
    }

    public ChannelPluginData getRoomGame() {
        return this.getGameInfo();
    }

    public MediaData getMicData() {
        return this.mMediaData;
    }

    public String getTopGroupId() {
        return this.topGroupId;
    }

    public void setTopGroupId(String topGroupId) {
        this.topGroupId = topGroupId;
    }

    public boolean isPlayManager(long uid) {
        return (this.mRoomInfo.isOwnerOrMaster(uid) || this.mRoomInfo.isAnchor(uid)) && this.mSeatData.isInFirstSeat(uid);
    }

    public boolean isKTVPlayManager(long uid) {
        return this.mRoomInfo.isOwnerOrMaster(uid) || this.mRoomInfo.isAnchor(uid);
    }

    public long getPlayManagerUid() {
        return FP.empty((Collection)this.mSeatData.getSeatUidsList()) ? 0L : (Long)this.mSeatData.getSeatUidsList().get(0);
    }

    public void updateGroupPassword(String password) {
        if (this.mLockInfo != null) {
            this.mLockInfo.setPassword(password);
        }
    }

    public String toString() {
        return "RoomData{mRoomInfo=" + (Object)((Object)this.mRoomInfo) + ", mSeatData=" + this.mSeatData + ", mRoomGameInfo=" + this.mRoomGameInfo + ", mLockInfo=" + this.mLockInfo + ", mEnterParam=" + this.mEnterParam + ", mMediaData=" + this.mMediaData + ", topGroupId=" + this.topGroupId + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private RoomInfo mRoomInfo;
        private SeatData mSeatData;
        private ChannelPluginData mRoomGameInfo;
        private LockInfo mLockInfo;
        private EnterParam mEnterParam;
        private MediaData mMediaData;
        private String topGroupId;

        private Builder() {
        }

        public Builder roomInfo(RoomInfo val) {
            this.mRoomInfo = val;
            return this;
        }

        public Builder seatData(SeatData val) {
            this.mSeatData = val;
            return this;
        }

        public Builder roomGameInfo(ChannelPluginData val) {
            this.mRoomGameInfo = val;
            return this;
        }

        public Builder lockInfo(LockInfo val) {
            this.mLockInfo = val;
            return this;
        }

        public Builder enterParam(EnterParam val) {
            this.mEnterParam = val;
            return this;
        }

        public Builder mediaData(MediaData val) {
            this.mMediaData = val;
            return this;
        }

        public RoomData build() {
            return new RoomData(this);
        }

        public Builder topGroupId(String val) {
            this.topGroupId = val;
            return this;
        }
    }
}

