/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.cbase.context;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.bean.ChannelNotify;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.ChannelPagePresenterLifeDispatcher;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeDispatcher;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.mvp.base.AbsNotifyDispatchService;
import com.yy.hiyo.mvp.base.MvpController;
import com.yy.hiyo.mvp.base.PageMvpContext;
import org.jetbrains.annotations.NotNull;

public class ChannelPageContext<PAGE extends AbsPage>
extends PageMvpContext
implements IChannelPageContext<PAGE> {
    private static final String TAG = "FTVoiceRoom ChannelPageContext";
    private MvpController mParentContext;
    private ChannelPagePresenterLifeDispatcher mPresenterLifeManager;
    private IEnteredChannel channel;
    private AbsNotifyDispatchService<ChannelNotify> notifyDispatcher;
    private EnterParam enterParams;
    private IPageLifeDispatcher pageLifeDispatcher;
    @NonNull
    private final RoomData roomData;
    private static int sIndex = 0;

    public ChannelPageContext(@NonNull MvpController parent, @NonNull IEnteredChannel channel, @NonNull EnterParam enterParams) {
        super((Context)parent.getContext(), TAG);
        this.mParentContext = parent;
        this.channel = channel;
        this.notifyDispatcher = (AbsNotifyDispatchService)channel.getNotifyDispatcher();
        this.enterParams = enterParams;
        this.mPresenterLifeManager = new ChannelPagePresenterLifeDispatcher();
        this.mPresenterLifeManager.setPresenterProvider(this.getPresenterProvider());
        ++sIndex;
        this.roomData = this.createRoomData(this.getPluginData());
        if (this.roomData == null) {
            throw new IllegalStateException(StringUtils.format((String)"roomData is null, channel %s, pluginData %s, enterParam %s, context %s", (Object[])new Object[]{channel.getChannelId(), channel.getPluginService().getCurPluginData(), enterParams, this}));
        }
        MLog.info((Object)TAG, (String)"init:%d", (Object[])new Object[]{sIndex});
    }

    protected RoomData createRoomData(ChannelPluginData pluginData) {
        return (RoomData)pluginData.getExt("voiceroom", (Object)new RoomData());
    }

    public RoomData getRoomData() {
        return this.roomData;
    }

    public void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"onDestroy:%d", (Object[])new Object[]{--sIndex});
        this.mPresenterLifeManager.onDestroy();
        if (this.notifyDispatcher != null) {
            this.notifyDispatcher.clear();
        }
        if (this.getDialogLinkManager() != null) {
            this.getDialogLinkManager().dismissDialog();
        }
    }

    @Override
    public void onViewDetach(PAGE page) {
        MLog.info((Object)TAG, (String)"onViewDetach page: %s", (Object[])new Object[]{page});
        this.mPresenterLifeManager.onPageDetach((AbsPage)page);
    }

    @Override
    public void onViewAttach(PAGE page) {
        MLog.info((Object)TAG, (String)"onViewAttach page: %s", (Object[])new Object[]{page});
        this.mPresenterLifeManager.onPageAttach((AbsPage)page);
    }

    @Override
    public IServiceManager getServiceManager() {
        return this.mParentContext.getServiceManager();
    }

    @Override
    @NotNull
    public FragmentActivity getContext() {
        return this.mParentContext.getContext();
    }

    @Override
    public DeviceManager getDeviceManager() {
        return this.mParentContext.getDeviceManager();
    }

    @Override
    public DialogLinkManager getDialogLinkManager() {
        return this.mParentContext.getDialogLinkManager();
    }

    @Override
    public Environment getEnv() {
        return this.mParentContext.getEnvironment();
    }

    @Override
    @NotNull
    public IEnteredChannel getChannel() {
        return this.channel;
    }

    @Override
    public EnterParam getEnterChannelParams() {
        return this.enterParams;
    }

    @Override
    public ChannelPluginData getPluginData() {
        return this.getChannel().getPluginService().getCurPluginData();
    }

    @Override
    public AbsNotifyDispatchService<ChannelNotify> getNotifyDispatcher() {
        return this.notifyDispatcher;
    }

    @Override
    public IPageLifeDispatcher getPageLifeDispatcher() {
        return this.pageLifeDispatcher;
    }

    @Override
    public void setPageLifeDispatcher(IPageLifeDispatcher pageLifeDispatcher) {
        this.pageLifeDispatcher = pageLifeDispatcher;
    }

    @Override
    public void onFinalExit() {
        this.getPresenterProvider().onFinalExit();
    }
}

