/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.photo;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.DataSource;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.camera.base.ImageOpenLargeHelper;
import com.yy.hiyo.camera.photo.ZoomImageView;

public class ProgressZoomImageView
extends YYFrameLayout {
    private static final String TAG = "ProgressZoomImageView";
    private ZoomImageView mImageView;
    private String mUrl;
    private boolean mHasLoaded;
    private SVGAImageView mSvgaLoading;
    private String mThumbnailUrl;
    private boolean mLoading = false;

    public ProgressZoomImageView(@NonNull Context context) {
        super(context, null);
        this.init(context);
    }

    public void setIconUrl(String url, String thumbnailUrl) {
        MLog.debug((Object)TAG, (String)("url: " + url + ", thumbnail: " + thumbnailUrl), (Object[])new Object[0]);
        if (!StringUtils.equals((String)this.mUrl, (String)url)) {
            this.mHasLoaded = false;
            this.mLoading = false;
            this.mUrl = url;
            this.mThumbnailUrl = thumbnailUrl;
        }
        if (this.mLoading) {
            return;
        }
        if (!this.mHasLoaded) {
            String thumbnail;
            this.mLoading = true;
            Drawable thumbnailDrawable = ImageOpenLargeHelper.INSTANCE.getFromDrawable();
            if (thumbnailDrawable == null) {
                thumbnail = this.mThumbnailUrl;
                this.showLoading();
            } else {
                thumbnail = null;
            }
            int thumbnailSize = ResolutionUtils.dip2Px((float)75.0f);
            ImageLoader.with((ImageView)this.mImageView, (String)this.mUrl).useHeif(true).thumbnail((Object)thumbnail).setThumbnailSize(thumbnailSize, thumbnailSize).placeholder(thumbnailDrawable).setListener((ImageLoader.BaseLoadListener)new ImageLoader.ImageLoadListener(){

                public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                    MLog.debug((Object)ProgressZoomImageView.TAG, (String)"load success url: %s, thumbnail: %s, isFirstResource: %b, dataSource: %s", (Object[])new Object[]{ProgressZoomImageView.this.mUrl, thumbnail, isFirstResource, dataSource});
                    ProgressZoomImageView.this.mLoading = false;
                    ProgressZoomImageView.this.mHasLoaded = true;
                    ProgressZoomImageView.this.hideLoading();
                }

                public void onLoadFailed(Exception e) {
                    MLog.error((Object)ProgressZoomImageView.TAG, (String)"load fail url: %s, thumbnail: %s, exception: %s", (Object[])new Object[]{ProgressZoomImageView.this.mUrl, thumbnail, e});
                    ProgressZoomImageView.this.mLoading = false;
                    ProgressZoomImageView.this.mHasLoaded = false;
                    ProgressZoomImageView.this.hideLoading();
                }
            }).load();
        }
    }

    public ProgressZoomImageView(Context context, AttributeSet attr) {
        this(context, attr, 0);
        this.init(context);
    }

    public ProgressZoomImageView(Context context, AttributeSet attr, int defStyle) {
        super(context, attr, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mImageView = new ZoomImageView(context);
        this.mImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mImageView.setAutoTransformToWebpFlag(false);
        ViewGroup.LayoutParams imageParams = new ViewGroup.LayoutParams(-1, -1);
        this.addView((View)this.mImageView, imageParams);
        this.mSvgaLoading = new SVGAImageView(context);
        this.mSvgaLoading.setLoops(0);
        FrameLayout.LayoutParams loadingLP = new FrameLayout.LayoutParams(ResolutionUtils.dip2Px((float)80.0f), ResolutionUtils.dip2Px((float)45.0f));
        loadingLP.gravity = 17;
        this.addView((View)this.mSvgaLoading, (ViewGroup.LayoutParams)loadingLP);
    }

    public ZoomImageView getImageView() {
        return this.mImageView;
    }

    private void showLoading() {
        if (this.mSvgaLoading != null) {
            SvgaLoader.load((SVGAImageView)this.mSvgaLoading, (String)"loading.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity entity) {
                    if (ProgressZoomImageView.this.mSvgaLoading != null && ProgressZoomImageView.this.mLoading) {
                        ProgressZoomImageView.this.mSvgaLoading.startAnimation();
                    }
                }

                public void onFailed(Exception e) {
                }
            });
        }
    }

    private void hideLoading() {
        if (this.mSvgaLoading != null) {
            this.mSvgaLoading.stopAnimation();
        }
    }
}

