/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.photo;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ViewDimension;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.SimplePermissionListener;
import com.yy.appbase.room.INoRoomMiniWindow;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnCameraCallbak;
import com.yy.appbase.service.callback.OnUpdateCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.BDAConst;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYToolBar;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.camera.R;
import com.yy.hiyo.camera.album.helpers.AlbumUploadUtils;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.camera.base.ImageOpenLargeHelper;
import com.yy.hiyo.camera.base.photo.IPhotoWindowCallback;
import com.yy.hiyo.camera.photo.IPhotoCallback;
import com.yy.hiyo.camera.photo.ImageViewerAdapter;
import com.yy.hiyo.camera.photo.ViewPagerFixed;
import com.yy.hiyo.camera.photo.ZoomImageView;
import com.yy.hiyo.im.base.R;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import okhttp3.Call;

public class PhotoWindow
extends DefaultWindow
implements INoRoomMiniWindow {
    private static final float PHOTO_RATIO = 1.2857143f;
    private Context mContext;
    private IPhotoCallback mCallback;
    private YYToolBar toolBar;
    private View btnBack;
    private YYImageView mIvDelete;
    private YYImageView mIvDownload;
    private YYTextView tvTitle;
    private YYTextView btnAdd;
    private YYTextView btnUploadAvatar;
    private long uid;
    private ImageViewerAdapter adapter;
    private ViewPagerFixed mPager;
    private int mCurrentPosition;
    private List<String> mUrlList;
    private View mRootView;
    private ViewDimension mClickViewDimension;
    private boolean mIfGifHideDownload;
    private static final int ANIM_DURATION = 200;
    private boolean mDisableChannelMini = true;
    private boolean isAddWaterMark = false;
    private IPhotoWindowCallback mIPhotoWindowCallback;
    private int mFromEntrance;
    private OnCameraCallbak mOnCameraCallbak = new OnCameraCallbak(){

        public void onFinish(String path) {
            if (TextUtils.isEmpty((CharSequence)path)) {
                BDAConst.bDAProfileAddAvatar((String)"onAddPhotoClick album photo path is null");
                FeatureLog.i((String)"FTAddAvatarProfile", (String)"onAddPhotoClick album photo path is null", (Object[])new Object[0]);
                ToastUtils.showToast((Context)PhotoWindow.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                return;
            }
            AlbumUploadUtils.uploadPhoto(PhotoWindow.this.mContext, path, new AlbumUploadUtils.AlbumUploadCallback(){

                @Override
                public void onFinish(boolean success) {
                    if (success) {
                        ToastUtils.showToast((Context)PhotoWindow.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_success), (int)0);
                    } else {
                        ToastUtils.showToast((Context)PhotoWindow.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                    }
                }
            });
        }
    };

    public PhotoWindow(Context context, IPhotoCallback callback, ViewDimension info, boolean isAddWaterMark) {
        super(context, (UICallBacks)callback, "Photo");
        this.mClickViewDimension = info;
        this.mContext = context;
        this.mCallback = callback;
        this.isAddWaterMark = isAddWaterMark;
        this.createView();
    }

    public void setIPhotoWindowCallback(IPhotoWindowCallback iPhotoWindowCallback) {
        this.mIPhotoWindowCallback = iPhotoWindowCallback;
        this.adapter.setIPhotoWindowCallback(this.mIPhotoWindowCallback);
        this.adapter.notifyDataSetChanged();
    }

    private void createView() {
        this.mRootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.window_photo, null);
        if (this.mRootView != null) {
            this.mIvDelete = (YYImageView)this.mRootView.findViewById(R.id.iv_delete);
            this.mIvDownload = (YYImageView)this.mRootView.findViewById(R.id.iv_download);
            this.toolBar = (YYToolBar)this.mRootView.findViewById(R.id.toolBar);
            this.btnBack = this.mRootView.findViewById(R.id.backIv);
            this.tvTitle = (YYTextView)this.mRootView.findViewById(R.id.tvTitle);
            this.btnAdd = (YYTextView)this.mRootView.findViewById(R.id.btnAdd);
            this.mPager = (ViewPagerFixed)this.mRootView.findViewById(R.id.iv_view_pager);
            this.mIvDelete.setOnClickListener(v -> this.showDeleteConfirmDialog());
            this.mIvDownload.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!FP.empty((Collection)PhotoWindow.this.mUrlList) && PhotoWindow.this.mCurrentPosition >= 0 && PhotoWindow.this.mCurrentPosition < PhotoWindow.this.mUrlList.size()) {
                        PermissionHelper.checkStoragePermission((Activity)((Activity)PhotoWindow.this.mContext), (IPermissionListener)new SimplePermissionListener(){

                            public void onPermissionGranted(@NonNull String[] permission) {
                                PhotoWindow.this.mCallback.download(PhotoWindow.this.isAddWaterMark, (String)PhotoWindow.this.mUrlList.get(PhotoWindow.this.mCurrentPosition));
                            }
                        });
                    }
                }
            });
            this.btnAdd.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PhotoWindow.this.mUrlList != null) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "add_photo_btn_click").put("num", String.valueOf(PhotoWindow.this.mUrlList.size())));
                    }
                    ((ICameraService)ServiceManagerProxy.getService(ICameraService.class)).pickPhotoWithClip("FTAddAvatarProfile", PhotoWindow.this.mOnCameraCallbak, 2, 1.2857143f);
                }
            });
            this.initToolbar();
        }
        this.getBaseLayer().addView(this.mRootView);
    }

    private void initToolbar() {
        this.btnBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoWindow.this.mCallback.finish();
            }
        });
    }

    @Nullable
    public View getNeedOffsetView() {
        return this.toolBar;
    }

    public void initUI(List<String> urls, List<String> thumbnails, long uid, int pos, boolean hideDownload) {
        this.uid = uid;
        if (uid != AccountUtil.getUid() || this.mFromEntrance != 3 && this.mFromEntrance != 4) {
            this.mIvDelete.setVisibility(8);
            this.btnAdd.setVisibility(8);
        } else {
            if (urls.size() < 9) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "add_photo_btn_show").put("num", String.valueOf(urls.size())));
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "delete_photo_btn_show").put("num", String.valueOf(urls.size())));
        }
        this.mIfGifHideDownload = hideDownload;
        this.mUrlList = urls;
        if (this.mUrlList == null) {
            this.mUrlList = new ArrayList<String>(0);
        }
        this.mCurrentPosition = pos;
        this.adapter = new ImageViewerAdapter(urls, thumbnails);
        this.adapter.setOnPhotoTapListener(new ZoomImageView.OnPhotoTapListener(){

            @Override
            public void onPhotoTap(View view, float x, float y) {
                PhotoWindow.this.mCallback.finish();
            }

            @Override
            public void onClickOutPhoto(View view) {
                PhotoWindow.this.mCallback.finish();
            }
        });
        this.mPager.setAdapter(this.adapter);
        this.mPager.setCurrentItem(pos);
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                PhotoWindow.this.mCurrentPosition = position;
                PhotoWindow.this.changeDownloadVisibility(position);
                PhotoWindow.this.tvTitle.setText((CharSequence)(PhotoWindow.this.mCurrentPosition + 1 + "/" + PhotoWindow.this.mUrlList.size()));
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.changeDownloadVisibility(pos);
        final Rect finalRect = ImageOpenLargeHelper.INSTANCE.getFrom();
        if (finalRect == null) {
            this.mPager.setVisibility(0);
        } else {
            this.mPager.post(new Runnable(){

                @Override
                public void run() {
                    ImageOpenLargeHelper.INSTANCE.startOpenAnim((View)PhotoWindow.this.mPager, finalRect, null);
                }
            });
        }
        this.tvTitle.setText((CharSequence)(pos + 1 + "/" + urls.size()));
        this.btnAdd.setBackgroundResource(urls.size() < 9 ? R.color.color_ffb802 : R.color.color_dedede);
        this.btnAdd.setEnabled(urls.size() < 9);
        if (this.mFromEntrance == 4) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ((ICameraService)ServiceManagerProxy.getService(ICameraService.class)).pickPhotoWithClip("FTAddAvatarProfile", PhotoWindow.this.mOnCameraCallbak, 2, 1.2857143f);
                }
            });
        }
        if (this.mFromEntrance == 5 && uid == AccountUtil.getUid()) {
            this.btnUploadAvatar = (YYTextView)this.findViewById(R.id.btn_upload_avatar);
            this.btnUploadAvatar.setVisibility(0);
            this.btnUploadAvatar.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PhotoWindow.this.openPhotoListAndUpload();
                }
            });
        } else if (this.btnUploadAvatar != null) {
            this.btnUploadAvatar.setVisibility(8);
        }
    }

    private void openPhotoListAndUpload() {
        ((ICameraService)ServiceManagerProxy.getService(ICameraService.class)).pickPhotoWithClip("FTEditAvatarProfile", new OnCameraCallbak(){

            public void onFinish(final String path) {
                if (TextUtils.isEmpty((CharSequence)path)) {
                    ToastUtils.showToast((Context)PhotoWindow.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                    BDAConst.bDAProfileEditAvatar((String)"onChangeAvatarClick avatar path is null");
                    FeatureLog.i((String)"FTEditAvatarProfile", (String)"onChangeAvatarClick avatar path is null", (Object[])new Object[0]);
                    return;
                }
                BDAConst.bDAProfileEditAvatar((String)("onChangeAvatarClick path = " + path));
                FeatureLog.i((String)"FTEditAvatarProfile", (String)("onChangeAvatarClick path = " + path), (Object[])new Object[0]);
                BDAConst.bDAProfileEditAvatar((String)"onChangeAvatarClick start upload image");
                FeatureLog.i((String)"FTEditAvatarProfile", (String)"onChangeAvatarClick start upload image", (Object[])new Object[0]);
                ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).updateAvatar(path, new OnUpdateCallback(){

                    public void onUISuccess(String imageUrl, int id2) {
                        BDAConst.bDAProfileEditAvatar((String)("onChangeAvatarClick upload onUISuccess path = " + path + " imageUrl = " + imageUrl));
                        FeatureLog.i((String)"FTEditAvatarProfile", (String)("onChangeAvatarClick upload onUISuccess path = " + path + " imageUrl = " + imageUrl), (Object[])new Object[0]);
                        PhotoWindow.this.mUrlList.clear();
                        PhotoWindow.this.mUrlList.add(imageUrl);
                        PhotoWindow.this.adapter.notifyDataSetChanged();
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_USER_INFO_UPDATED, (Object)PhotoWindow.this.uid));
                        ToastUtils.showToast((Context)PhotoWindow.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_success), (int)0);
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20027251").put("event", "click").put("element_id", "10015"));
                    }

                    public void onError(Call call, Exception e, int id2) {
                        BDAConst.bDAProfileEditAvatar((String)("onChangeAvatarClick upload onError = " + e));
                        FeatureLog.i((String)"FTEditAvatarProfile", (String)("onChangeAvatarClick upload onError = " + e), (Object[])new Object[0]);
                        ToastUtils.showToast((Context)PhotoWindow.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                    }

                    public void onResponseError(int id2, String message, String response) {
                        BDAConst.bDAProfileEditAvatar((String)("onChangeAvatarClick upload onResponseError response = " + response));
                        FeatureLog.i((String)"FTEditAvatarProfile", (String)("onChangeAvatarClick upload onResponseError response = " + response), (Object[])new Object[0]);
                        ToastUtils.showToast((Context)PhotoWindow.this.mContext, (String)ResourceUtils.getString((int)R.string.upload_failed), (int)0);
                    }
                });
            }
        }, 1);
    }

    public void closeUI(Function0<Unit> callback) {
        Rect toRect = ImageOpenLargeHelper.INSTANCE.getTo();
        if (toRect == null) {
            if (callback != null) {
                callback.invoke();
            }
        } else {
            ImageOpenLargeHelper.INSTANCE.startCloseAnim((View)this.mPager, toRect, callback);
        }
    }

    private void changeDownloadVisibility(int pos) {
        if (pos >= 0 && !FP.empty(this.mUrlList) && pos < FP.size(this.mUrlList)) {
            File file;
            boolean isInVisible;
            String curUrl = this.mUrlList.get(pos);
            boolean bl = isInVisible = this.mIfGifHideDownload && ImageUtil.isGif((String)curUrl);
            if (!(isInVisible || TextUtils.isEmpty((CharSequence)curUrl) || curUrl.startsWith("http") || (file = new File(curUrl)).exists() && file.isFile())) {
                isInVisible = true;
            }
            this.mIvDownload.setVisibility(isInVisible ? 4 : 0);
        }
    }

    public void updatePagers(List<String> urlList) {
        if (urlList == null || urlList.isEmpty()) {
            this.mCallback.finish();
        } else {
            boolean added = false;
            if (urlList.size() > this.mUrlList.size()) {
                added = true;
            }
            this.mUrlList.clear();
            this.mUrlList.addAll(urlList);
            Collections.reverse(this.mUrlList);
            this.adapter.notifyDataSetChanged();
            this.mCurrentPosition = added ? 0 : this.mCurrentPosition % urlList.size();
            this.tvTitle.setText((CharSequence)(this.mCurrentPosition + 1 + "/" + this.mUrlList.size()));
            this.mPager.setCurrentItem(this.mCurrentPosition);
            this.btnAdd.setBackgroundResource(this.mUrlList.size() < 9 ? R.color.color_ffb802 : R.color.color_dedede);
            this.btnAdd.setEnabled(this.mUrlList.size() < 9);
        }
    }

    public void onAttach() {
        super.onAttach();
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    public void onDetached() {
        super.onDetached();
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        ICameraService cameraService = (ICameraService)ServiceManagerProxy.getService(ICameraService.class);
        if (cameraService != null) {
            cameraService.cleanCallback();
        }
    }

    public void onShown() {
        super.onShown();
        if (this.mIPhotoWindowCallback != null) {
            this.mIPhotoWindowCallback.onWindowShown();
        }
    }

    public void onHidden() {
        super.onHidden();
        if (this.mIPhotoWindowCallback != null) {
            this.mIPhotoWindowCallback.onWindowHidden();
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE && notification.extObj instanceof Boolean) {
            boolean isForeground = (Boolean)notification.extObj;
            if (isForeground) {
                if (this.mIPhotoWindowCallback != null) {
                    this.mIPhotoWindowCallback.onWindowShown();
                }
            } else if (this.mIPhotoWindowCallback != null) {
                this.mIPhotoWindowCallback.onWindowHidden();
            }
        }
    }

    public int getStatusBarColor() {
        return -16777216;
    }

    public Animation getPushAnimation() {
        float radio = this.getRadio();
        float startTransX = 0.0f;
        float startTransY = 0.0f;
        if (this.mClickViewDimension != null) {
            float startCenterY = this.mClickViewDimension.location[1] + this.mClickViewDimension.height / 2;
            startTransX = this.mClickViewDimension.location[0];
            startTransY = startCenterY - (float)SystemUtils.getStatusBarHeight((Context)this.getContext()) - (float)((ScreenUtils.getInstance().getHeightPixels() - SystemUtils.getStatusBarHeight((Context)this.getContext())) / 2) * radio;
        }
        ScaleAnimation scaleAnimation = new ScaleAnimation(radio, 1.0f, radio, 1.0f, 0.5f, 0.5f);
        TranslateAnimation translateAnimation = new TranslateAnimation(startTransX, 0.0f, startTransY, 0.0f);
        AnimationSet set = new AnimationSet(true);
        set.setDuration(200L);
        set.setInterpolator((Interpolator)new DecelerateInterpolator());
        set.addAnimation((Animation)scaleAnimation);
        set.addAnimation((Animation)translateAnimation);
        return set;
    }

    private float getRadio() {
        if (this.mClickViewDimension != null) {
            float vRadio = this.mClickViewDimension.height / this.mClickViewDimension.width;
            float sRadio = (float)ScreenUtils.getInstance().getHeightPixels() * 1.0f / (float)ScreenUtils.getInstance().getWidthPixels();
            if (this.mClickViewDimension.width == ScreenUtils.getInstance().getWidthPixels() || this.mClickViewDimension.height == ScreenUtils.getInstance().getHeightPixels() - SystemUtils.getStatusBarHeight((Context)this.getContext())) {
                return 1.0f;
            }
            if (this.mClickViewDimension.height >= this.mClickViewDimension.width) {
                if (vRadio >= sRadio) {
                    return (float)this.mClickViewDimension.height * 1.0f / (float)(ScreenUtils.getInstance().getHeightPixels() - SystemUtils.getStatusBarHeight((Context)this.getContext()));
                }
                return (float)this.mClickViewDimension.width * 1.0f / (float)ScreenUtils.getInstance().getWidthPixels();
            }
            return (float)this.mClickViewDimension.width * 1.0f / (float)ScreenUtils.getInstance().getWidthPixels();
        }
        return 1.0f;
    }

    public void setDisableChannelMini(boolean disable) {
        this.mDisableChannelMini = disable;
    }

    public boolean isDisableChannelMini() {
        return this.mDisableChannelMini;
    }

    public void setFromEntrance(int fromEntrance) {
        this.mFromEntrance = fromEntrance;
    }

    public int getFromEntrance() {
        return this.mFromEntrance;
    }

    public void receiveRevokeMsg(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            int i = this.mUrlList.indexOf(url);
            if (i == this.mCurrentPosition) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.im_img_has_revoked), (int)0);
                this.mCallback.finish();
            } else if (i != -1) {
                this.adapter.remove(i);
                if (this.mCurrentPosition > i) {
                    --this.mCurrentPosition;
                    this.mPager.setCurrentItem(this.mCurrentPosition);
                }
            }
        }
    }

    public boolean isTranslucentBar() {
        return true;
    }

    public int getStatusBarBackgroundColor() {
        return StatusBarManager.COLOR_TRANSLUCENT;
    }

    private void showDeleteConfirmDialog() {
        MLog.info((Object)"AbstractWindow", (String)"showDeleteConfirmDialog", (Object[])new Object[0]);
        DialogLinkManager mDialogLinkManager = new DialogLinkManager(this.mContext);
        OkCancelDialog tipsDialog = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.delete_photo_confirm), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                PhotoWindow.this.performDeletePhoto();
            }
        });
        mDialogLinkManager.showDialog((BaseDialog)tipsDialog);
    }

    private void performDeletePhoto() {
        if (!FP.empty(this.mUrlList) && this.mCurrentPosition >= 0 && this.mCurrentPosition < this.mUrlList.size()) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20042169").put("function_id", "delete_photo_btn_click").put("num", String.valueOf(this.mUrlList.size())));
            this.mCallback.deletePhoto(this.mUrlList.get(this.mCurrentPosition));
        }
    }
}

