/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.photo;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.ViewDimension;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnUpdateCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.camera.R;
import com.yy.hiyo.camera.base.photo.IPhotoWindowCallback;
import com.yy.hiyo.camera.photo.IPhotoCallback;
import com.yy.hiyo.camera.photo.ImgDownloader;
import com.yy.hiyo.camera.photo.PhotoWindow;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

public class PhotoController
extends DefaultController
implements IPhotoCallback {
    private static final String TAG = "PhotoController";
    private PhotoWindow mWindow;
    private IPhotoWindowCallback mIPhotoWindowCallback;
    private long mUid = 0L;

    public PhotoController(Environment env) {
        super(env);
    }

    @Override
    public void finish() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            this.mWindow = null;
            this.mUid = 0L;
        }
    }

    @Override
    public void deletePhoto(final String url) {
        ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).deletePhoto(url, new OnUpdateCallback(){

            public void onUISuccess(String imageUrl, int id2) {
                ToastUtils.showToast((Context)PhotoController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_delete_success), (int)0);
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.UPDATE_ALBUM, (Object)url));
            }

            public void onError(Call call, Exception e, int id2) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showToast((Context)PhotoController.this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                    }
                });
            }

            public void onResponseError(int id2, String message, String response) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ToastUtils.showToast((Context)PhotoController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_delete_failed), (int)0);
                    }
                });
            }
        });
    }

    @Override
    public void download(boolean isAddWaterMark, String url) {
        ImgDownloader.downloadImg(url, isAddWaterMark);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.UPDATE_ALBUM) {
            MLog.debug((Object)TAG, (String)"UPDATE_ALBUM", (Object[])new Object[0]);
            if (this.mWindow != null && this.mUid != 0L) {
                List list = ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).getUserInfo((long)this.mUid).album;
                this.mWindow.updatePagers(list);
            }
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        Bundle bundle = msg.getData();
        if (msg.what == BaseMsgDef.OPEN_WINDOW_PHOTO) {
            this.init(bundle);
        } else if (msg.what == BaseMsgDef.CLOSE_WINDOW_PHOTO) {
            this.finish();
        } else if (msg.what == BaseMsgDef.OPEN_WINDOW_PHOTO_FOR_POST) {
            this.mIPhotoWindowCallback = (IPhotoWindowCallback)msg.obj;
            this.init(bundle);
        } else if (msg.what == BaseMsgDef.CLOSE_WINDOW_PHOTO_WHEN_MSG_REVOKED) {
            MLog.info((Object)TAG, (String)"CLOSE_WINDOW_PHOTO_WHEN_MSG_REVOKED RECEIVED", (Object[])new Object[0]);
            if (this.mWindow == null || this.mWindowMgr.getCurrentWindow() != this.mWindow) {
                MLog.debug((Object)TAG, (String)"\u5f53\u524dphotoWindow\u672a\u5c55\u793a\uff0c \u4e0d\u5904\u7406", (Object[])new Object[0]);
                return;
            }
            if (this.mWindow.getFromEntrance() != bundle.getInt("from_entrance")) {
                MLog.debug((Object)TAG, (String)"\u5f53\u524dphotoWindow\u4e0d\u5c5e\u4e8e\u56fe\u7247\u64a4\u56de\u53d1\u751f\u5730", (Object[])new Object[0]);
                return;
            }
            String url = bundle.getString("url");
            this.mWindow.receiveRevokeMsg(url);
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
            this.mIPhotoWindowCallback = null;
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
    }

    private void init(Bundle bundle) {
        if (bundle != null) {
            long uid = bundle.getLong("uid");
            int index = bundle.getInt("index");
            boolean disableChannelMini = bundle.getBoolean("disable_channel_miniview", true);
            boolean isAddWaterMark = bundle.getBoolean("add_water_mark", false);
            String url = bundle.getString("url");
            String thumbnail = bundle.getString("thumbnail");
            ViewDimension info = (ViewDimension)bundle.getParcelable("view_dimension");
            boolean showThumbnail = bundle.getBoolean("show_thumbnail", true);
            int fromEntrance = bundle.getInt("from_entrance");
            ArrayList urlList = null;
            ArrayList<String> thumbnailList = null;
            if (!StringUtils.isEmpty((String)url)) {
                urlList = new ArrayList(1);
                urlList.add(url);
                if (!StringUtils.isEmpty((String)thumbnail)) {
                    thumbnailList = new ArrayList<String>(1);
                    thumbnailList.add(thumbnail);
                } else if (showThumbnail) {
                    thumbnailList = new ArrayList(1);
                    thumbnailList.add(url);
                }
            } else {
                try {
                    urlList = bundle.getStringArrayList("photo_list");
                    if (bundle.containsKey("thumbnail_list")) {
                        thumbnailList = bundle.getStringArrayList("thumbnail_list");
                    } else if (showThumbnail && urlList != null) {
                        thumbnailList = new ArrayList(urlList.size());
                        thumbnailList.addAll(urlList);
                    }
                }
                catch (Exception ex) {
                    MLog.error((Object)TAG, (Throwable)ex);
                }
            }
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.mUid = uid;
            this.mWindow = new PhotoWindow(this.mContext, this, info, isAddWaterMark);
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            this.mWindow.setFromEntrance(fromEntrance);
            this.mWindow.initUI(urlList, thumbnailList, uid, index, bundle.getBoolean("hide_down_load", false));
            this.mWindow.setDisableChannelMini(disableChannelMini);
            if (this.mIPhotoWindowCallback != null) {
                this.mWindow.setIPhotoWindowCallback(this.mIPhotoWindowCallback);
            }
        }
    }
}

