/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.photo;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.BitmapUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.camera.R;
import java.io.File;
import java.io.OutputStream;
import java.util.UUID;

public class ImgDownloader {
    private static final String TAG = "ImgDownloader";

    private static void downloadImg(final String url) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    File myCaptureFile = null;
                    String fileName = UUID.randomUUID().toString() + ImgDownloader.getSuffix(url);
                    try {
                        if (!SdkVersionUtils.hasScopedStorage()) {
                            File jia = Build.BRAND.equals("Xiaomi") ? new File(Environment.getExternalStorageDirectory().getPath() + "/DCIM/Camera") : new File(Environment.getExternalStorageDirectory().getPath() + "/DCIM");
                            if (!jia.exists()) {
                                jia.mkdirs();
                            }
                            myCaptureFile = new File(jia + "/" + fileName);
                        }
                        ImageLoader.savePhotoSyncToMedia((String)url, myCaptureFile, (String)fileName);
                        if (!SdkVersionUtils.hasScopedStorage()) {
                            RuntimeContext.sApplicationContext.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + myCaptureFile.getAbsolutePath()))));
                        }
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.toast_save_success), (int)0);
                        MLog.debug((Object)ImgDownloader.TAG, (String)"download image success, url: %s, saveTo: %s, file: %s", (Object[])new Object[]{url, myCaptureFile, fileName});
                    }
                    catch (Exception e) {
                        MLog.error((Object)ImgDownloader.TAG, (String)("download image url: " + url + ", saveTo: " + myCaptureFile + ", fileName: " + fileName), (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
        });
    }

    public static void downloadImg(@NonNull String url, boolean withMark) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (withMark) {
            ImgDownloader.downloadImgWithMark(url);
        } else {
            ImgDownloader.downloadImg(url);
        }
    }

    private static void downloadImgWithMark(final String url) {
        final Context context = RuntimeContext.sApplicationContext;
        ImageLoader.loadBitmap((Context)context, (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
                ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.network_error), (int)0);
            }

            public void onResourceReady(Bitmap bitmap) {
                YYTaskExecutor.execute(() -> ImgDownloader.addWaterMark(bitmap, context, url));
            }
        });
    }

    @WorkerThread
    private static void addWaterMark(Bitmap bitmap, final Context context, String url) {
        Bitmap target;
        MLog.info((Object)TAG, (String)"addWaterMark from %d x %d", (Object[])new Object[]{bitmap.getWidth(), bitmap.getHeight()});
        if (bitmap.getWidth() >= 360 && bitmap.getHeight() >= 360) {
            Bitmap markBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.hago_mark_logo);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            int padding = ResolutionUtils.dip2Px((float)10.0f);
            target = BitmapUtils.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(target);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
            int maxWidth = ResolutionUtils.dip2Px((float)50.0f);
            int minWidth = 50;
            int width = bitmap.getWidth() * 110 / 360;
            if (width > maxWidth) {
                width = maxWidth;
            } else if (width < minWidth) {
                width = minWidth;
            }
            int height = (int)((float)width * 34.0f / 110.0f);
            MLog.debug((Object)TAG, (String)"waterMark %d x %d", (Object[])new Object[]{width, height});
            int left = bitmap.getWidth() - width - padding;
            int top = bitmap.getHeight() - height - padding;
            Rect rect = new Rect(left, top, left + width, top + height);
            canvas.drawBitmap(markBitmap, null, rect, paint);
        } else {
            target = bitmap;
        }
        String name = "HAGO_" + Math.abs(url.hashCode()) + ".jpg";
        String path = ImgDownloader.getImageDir(name);
        final ContentResolver cr = RuntimeContext.sApplicationContext.getContentResolver();
        Uri uri = null;
        try {
            ContentValues values = new ContentValues();
            values.put("title", name);
            values.put("description", "");
            values.put("mime_type", ViewImage.InsertImageUtils.getPhotoMimeType((String)(path + "/" + name)));
            values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
            final Uri finalUri = uri = cr.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (target != null) {
                            try (OutputStream imageOut = cr.openOutputStream(finalUri);){
                                target.compress(Bitmap.CompressFormat.JPEG, 100, imageOut);
                            }
                        } else {
                            MLog.error((Object)ImgDownloader.TAG, (String)"Failed to create thumbnail, removing original", (Object[])new Object[0]);
                            if (finalUri != null) {
                                cr.delete(finalUri, null, null);
                            }
                            ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.tips_unknown_error), (int)0);
                            return;
                        }
                        long id2 = ContentUris.parseId((Uri)finalUri);
                        Bitmap miniThumb = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)cr, (long)id2, (int)1, null);
                        Bitmap bitmap = ViewImage.InsertImageUtils.storeThumbnail((ContentResolver)cr, (Bitmap)miniThumb, (long)id2, (float)50.0f, (float)50.0f, (int)3);
                    }
                    catch (Exception e) {
                        MLog.error((Object)ImgDownloader.TAG, (String)"Failed to insert image", (Throwable)e, (Object[])new Object[0]);
                        if (finalUri != null) {
                            cr.delete(finalUri, null, null);
                        }
                        ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.tips_unknown_error), (int)0);
                        return;
                    }
                    String saveUrl = null;
                    if (finalUri == null) {
                        ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.tips_unknown_error), (int)0);
                        return;
                    }
                    saveUrl = finalUri.toString();
                    MLog.debug((Object)ImgDownloader.TAG, (String)("savepahtnew  = " + saveUrl), (Object[])new Object[0]);
                    if (!FP.empty((CharSequence)saveUrl)) {
                        String filePath = null;
                        try {
                            filePath = ImgDownloader.uriToFile(Uri.parse((String)saveUrl), RuntimeContext.sApplicationContext);
                            MLog.debug((Object)ImgDownloader.TAG, (String)("savelocalpaht  = " + filePath), (Object[])new Object[0]);
                        }
                        catch (Exception e) {
                            MLog.warn((Object)ImgDownloader.TAG, (String)"uri to path fail ", (Object[])new Object[0]);
                        }
                        if (!FP.empty((CharSequence)filePath)) {
                            RuntimeContext.sApplicationContext.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)new File(filePath))));
                        }
                    }
                    ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.toast_save_success), (int)0);
                }
            }, (long)2000L);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"Failed to insert image", (Throwable)e, (Object[])new Object[0]);
            if (uri != null) {
                cr.delete(uri, null, null);
            }
            ToastUtils.showToast((Context)context, (String)ResourceUtils.getString((int)R.string.tips_unknown_error), (int)0);
        }
    }

    public static String uriToFile(Uri uri, Context context) {
        String path = null;
        if ("file".equals(uri.getScheme())) {
            path = uri.getEncodedPath();
            if (path != null && new File(path = Uri.decode((String)path)).exists()) {
                return path;
            }
        } else if ("content".equals(uri.getScheme())) {
            String[] proj = new String[]{"_data"};
            Cursor cursor = context.getContentResolver().query(uri, proj, null, null, null);
            if (cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndexOrThrow("_data");
                path = cursor.getString(columnIndex);
            }
            cursor.close();
            if (new File(path).exists()) {
                return path;
            }
        }
        return null;
    }

    private static String getSuffix(String from) {
        if (!TextUtils.isEmpty((CharSequence)from)) {
            String url = from.toLowerCase();
            if (url.endsWith("jpg") || url.endsWith("jpeg")) {
                return ".jpg";
            }
            if (url.endsWith("png")) {
                return ".png";
            }
            if (url.endsWith("gif")) {
                return ".gif";
            }
        }
        return ".jpg";
    }

    private static String getImageDir(String name) {
        File dir = Build.BRAND.equalsIgnoreCase("Xiaomi") ? new File(Environment.getExternalStorageDirectory().getPath() + "/DCIM/Camera") : Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir.getAbsolutePath();
    }
}

