/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.photo;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.yy.base.utils.FP;
import com.yy.hiyo.camera.base.photo.IPhotoWindowCallback;
import com.yy.hiyo.camera.photo.ProgressZoomImageView;
import com.yy.hiyo.camera.photo.ZoomImageView;
import java.util.List;

public class ImageViewerAdapter
extends PagerAdapter {
    private List<String> mUrlList;
    private List<String> mThumbnailList;
    private ZoomImageView.OnPhotoTapListener listener;
    private IPhotoWindowCallback mIPhotoWindowCallback;

    public ImageViewerAdapter(List<String> urls, List<String> thumbnails) {
        this.mUrlList = urls;
        this.mThumbnailList = thumbnails;
    }

    public void setIPhotoWindowCallback(IPhotoWindowCallback iPhotoWindowCallback) {
        this.mIPhotoWindowCallback = iPhotoWindowCallback;
    }

    public int getCount() {
        return this.mUrlList == null ? 0 : this.mUrlList.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public void setOnPhotoTapListener(ZoomImageView.OnPhotoTapListener listener) {
        this.listener = listener;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(container.getWidth(), container.getHeight());
        ProgressZoomImageView v = new ProgressZoomImageView(container.getContext());
        if (this.mIPhotoWindowCallback == null) {
            container.addView((View)v, lp);
            if (v.getImageView() != null) {
                v.getImageView().setOnPhotoTapListener(this.listener);
            }
            String thumbnail = null;
            if (this.mThumbnailList != null && position < this.mThumbnailList.size()) {
                thumbnail = this.mThumbnailList.get(position);
            }
            v.setIconUrl(this.mUrlList.get(position), thumbnail);
            return v;
        }
        ViewGroup viewGroup = this.mIPhotoWindowCallback.createView(container);
        RelativeLayout.LayoutParams relativeLayoutLp = new RelativeLayout.LayoutParams(-1, -1);
        viewGroup.setLayoutParams(lp);
        viewGroup.addView((View)v, (ViewGroup.LayoutParams)relativeLayoutLp);
        container.addView((View)viewGroup, lp);
        if (v.getImageView() != null) {
            v.getImageView().setOnPhotoTapListener(this.listener);
        }
        String thumbnail = null;
        if (this.mThumbnailList != null && position < this.mThumbnailList.size()) {
            thumbnail = this.mThumbnailList.get(position);
        }
        v.setIconUrl(this.mUrlList.get(position), thumbnail);
        return viewGroup;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    public int getItemPosition(@NonNull Object object) {
        return -2;
    }

    public void remove(int position) {
        if (position > 0 && !FP.empty(this.mUrlList) && position < this.mUrlList.size()) {
            this.mUrlList.remove(position);
        }
        if (position > 0 && !FP.empty(this.mThumbnailList) && position < this.mThumbnailList.size()) {
            this.mThumbnailList.remove(position);
        }
        this.notifyDataSetChanged();
    }
}

