/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera.utils.cropper.util;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.view.View;
import android.widget.ImageView;

public class ImageViewUtil {
    public static Bitmap getBitmapFixSize(Bitmap bitmap, View imageView) {
        int viewWidth = imageView.getWidth();
        int viewHeight = imageView.getHeight();
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        double viewToBitmapWidthRatio = (double)viewWidth / (double)bitmapWidth;
        double viewToBitmapHeightRatio = (double)viewHeight / (double)bitmapHeight;
        Matrix matrix = new Matrix();
        double scale = viewToBitmapWidthRatio >= viewToBitmapHeightRatio ? viewToBitmapHeightRatio : viewToBitmapWidthRatio;
        matrix.setScale((float)scale, (float)scale);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmapWidth, (int)bitmapHeight, (Matrix)matrix, (boolean)false);
    }

    public static Matrix getMatrix(Bitmap bitmap, View imageView) {
        int viewWidth = imageView.getWidth();
        int viewHeight = imageView.getHeight();
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        double viewToBitmapWidthRatio = (double)viewWidth / (double)bitmapWidth;
        double viewToBitmapHeightRatio = (double)viewHeight / (double)bitmapHeight;
        Matrix matrix = new Matrix();
        double scale = viewToBitmapWidthRatio >= viewToBitmapHeightRatio ? viewToBitmapHeightRatio : viewToBitmapWidthRatio;
        matrix.setScale((float)scale, (float)scale);
        return matrix;
    }

    public static Rect getBitmapRect(Bitmap bitmap, ImageView imageView) {
        ImageView.ScaleType scaleType = imageView.getScaleType();
        if (scaleType == ImageView.ScaleType.FIT_CENTER) {
            return ImageViewUtil.getBitmapRectFixCenter(bitmap, (View)imageView);
        }
        if (scaleType == ImageView.ScaleType.CENTER_INSIDE) {
            return ImageViewUtil.getBitmapRectCenterInside(bitmap, (View)imageView);
        }
        return null;
    }

    public static Rect getBitmapRectFixCenter(Bitmap bitmap, View view) {
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        return ImageViewUtil.getBitmapRectFixCenterHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
    }

    public static Rect getBitmapRectFixCenter(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight) {
        return ImageViewUtil.getBitmapRectFixCenterHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
    }

    public static Rect getBitmapRectFixCenterHelper(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight) {
        try {
            int resultY;
            int resultX;
            double resultWidth;
            double resultHeight;
            double viewToBitmapWidthRatio = (double)viewWidth / (double)bitmapWidth;
            double viewToBitmapHeightRatio = (double)viewHeight / (double)bitmapHeight;
            if (viewToBitmapWidthRatio > viewToBitmapHeightRatio) {
                resultHeight = viewHeight;
                resultWidth = (double)bitmapWidth / (double)bitmapHeight * resultHeight;
                resultX = (int)(((double)viewWidth - resultWidth) / 2.0);
                resultY = 0;
            } else {
                resultWidth = viewWidth;
                resultHeight = (double)bitmapHeight / (double)bitmapWidth * resultWidth;
                resultY = (int)(((double)viewHeight - resultHeight) / 2.0);
                resultX = 0;
            }
            Rect result = new Rect(resultX, resultY, resultX + (int)Math.ceil(resultWidth), resultY + (int)Math.ceil(resultHeight));
            return result;
        }
        catch (Exception e) {
            return new Rect(0, 0, bitmapWidth, bitmapHeight);
        }
    }

    public static Rect getBitmapRectCenterInside(Bitmap bitmap, View view) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        return ImageViewUtil.getBitmapRectCenterInsideHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
    }

    public static Rect getBitmapRectCenterInside(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight) {
        return ImageViewUtil.getBitmapRectCenterInsideHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
    }

    private static Rect getBitmapRectCenterInsideHelper(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight) {
        int resultY;
        int resultX;
        double resultHeight;
        double resultWidth;
        double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
        double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
        if (viewWidth < bitmapWidth) {
            viewToBitmapWidthRatio = (double)viewWidth / (double)bitmapWidth;
        }
        if (viewHeight < bitmapHeight) {
            viewToBitmapHeightRatio = (double)viewHeight / (double)bitmapHeight;
        }
        if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
            if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                resultWidth = viewWidth;
                resultHeight = (double)bitmapHeight * resultWidth / (double)bitmapWidth;
            } else {
                resultHeight = viewHeight;
                resultWidth = (double)bitmapWidth * resultHeight / (double)bitmapHeight;
            }
        } else {
            resultHeight = bitmapHeight;
            resultWidth = bitmapWidth;
        }
        if (resultWidth == (double)viewWidth) {
            resultX = 0;
            resultY = (int)Math.round(((double)viewHeight - resultHeight) / 2.0);
        } else if (resultHeight == (double)viewHeight) {
            resultX = (int)Math.round(((double)viewWidth - resultWidth) / 2.0);
            resultY = 0;
        } else {
            resultX = (int)Math.round(((double)viewWidth - resultWidth) / 2.0);
            resultY = (int)Math.round(((double)viewHeight - resultHeight) / 2.0);
        }
        Rect result = new Rect(resultX, resultY, resultX + (int)Math.ceil(resultWidth), resultY + (int)Math.ceil(resultHeight));
        return result;
    }
}

