/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.camera.R;
import com.yy.hiyo.camera.camera.AbsCameraPage;
import com.yy.hiyo.camera.camera.CameraPresenter;
import com.yy.hiyo.camera.camera.NewCropImageView;

public class PhotoUploadCropPage
extends AbsCameraPage {
    private static final String TAG = "PhotoUploadWithClipPage";
    private YYTextView mTvSure;
    private YYTextView mTvBack;
    private NewCropImageView mIvPhoto;
    private CameraPresenter mCameraPresenter;
    private int mExpectWidth;
    private int mExceptHeight;
    private View.OnClickListener mCancelClick = new View.OnClickListener(){

        public void onClick(View v) {
            if (PhotoUploadCropPage.this.mCameraPresenter != null) {
                PhotoUploadCropPage.this.mCameraPresenter.onCancel();
            }
        }
    };
    private View.OnClickListener mOkClick = new View.OnClickListener(){

        public void onClick(View v) {
            if (PhotoUploadCropPage.this.mCameraPresenter != null) {
                PhotoUploadCropPage.this.mCameraPresenter.onChoose();
            }
        }
    };

    public PhotoUploadCropPage(Context context, CameraPresenter cameraPresenter) {
        super(context);
        this.mCameraPresenter = cameraPresenter;
        this.createView(context);
        this.mIvPhoto.setOnBitmapSaveCompleteListener(cameraPresenter);
        this.mIvPhoto.setCropRatio(cameraPresenter.getCropRatio());
        this.mExpectWidth = context.getResources().getDisplayMetrics().widthPixels;
        this.mExceptHeight = (int)((float)this.mExpectWidth * 1.0f / cameraPresenter.getCropRatio());
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_photo_crop, (ViewGroup)this);
        this.mIvPhoto = (NewCropImageView)this.findViewById(R.id.iv_photo);
        this.mTvSure = (YYTextView)this.findViewById(R.id.tv_chose);
        this.mTvSure.setOnClickListener(this.mOkClick);
        this.mTvBack = (YYTextView)this.findViewById(R.id.tv_cancel);
        this.mTvBack.setOnClickListener(this.mCancelClick);
        try {
            this.mTvBack.setText((CharSequence)this.mTvBack.getText().toString().toUpperCase());
            this.mTvSure.setText((CharSequence)this.mTvSure.getText().toString().toUpperCase());
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"toUpperCase error ex: %s", (Object[])new Object[]{e});
        }
    }

    @Override
    public void saveMediaToFile() {
        this.mIvPhoto.saveBitmapToFile(this.mExpectWidth, this.mExceptHeight);
    }

    @Override
    public void showPicture(Bitmap bitmap) {
        this.mIvPhoto.setImageBitmap(bitmap);
    }

    @Override
    public void showMediaFromUrl(String url) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mIvPhoto != null) {
            this.mIvPhoto.setOnBitmapSaveCompleteListener(null);
        }
    }
}

