/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.core.view.ViewCompat;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.BitmapUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.camera.R;
import com.yy.hiyo.camera.camera.OnMediaSaveCompleteListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class NewCropImageView
extends RecycleImageView {
    private int mMaskColor = -1358954496;
    private int mBorderColor = Color.parseColor((String)"#ffffff");
    private int mBorderWidth = ResolutionUtils.dip2Px((float)2.0f);
    private int mDivisionColor = Color.parseColor((String)"#80FFFFFF");
    private int mDivisionWidth = ResolutionUtils.dip2Px((float)1.0f);
    private int mFocusWidth;
    private int mFocusHeight;
    private float mCropRatio = 1.0f;
    private Style mStyle = Style.RECTANGLE;
    private Paint mBorderPaint = new Paint();
    private Path mFocusPath = new Path();
    private RectF mFocusRect = new RectF();
    private static final float MAX_SCALE = 4.0f;
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private int mImageWidth;
    private int mImageHeight;
    private Matrix matrix = new Matrix();
    private Matrix savedMatrix = new Matrix();
    private PointF pA = new PointF();
    private PointF pB = new PointF();
    private PointF midPoint = new PointF();
    private PointF mFocusMidPoint = new PointF();
    private int mode = 0;
    private float oldDist = 1.0f;
    private float mMaxScale = 4.0f;
    private boolean mInit = false;
    private boolean mSaving = false;
    private boolean mClipPathExceptionHappened = false;
    private static OnMediaSaveCompleteListener mListener;

    public NewCropImageView(Context context) {
        this(context, null);
    }

    public NewCropImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NewCropImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NewCropImageView);
        float cropRatio = a.getFloat(R.styleable.NewCropImageView_cropRatio, -1.0f);
        if (cropRatio == -1.0f) {
            String cropRatioString = a.getString(R.styleable.NewCropImageView_cropRatio);
            if (cropRatioString != null) {
                String[] wByH = cropRatioString.split(":");
                try {
                    this.mCropRatio = Float.parseFloat(wByH[0]) / Float.parseFloat(wByH[1]);
                }
                catch (Exception exception) {}
            }
        } else {
            this.mCropRatio = cropRatio;
        }
        a.recycle();
    }

    public float getCropRatio() {
        return this.mCropRatio;
    }

    public void setCropRatio(float cropRatio) {
        this.mCropRatio = cropRatio;
        this.initImage();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.initImage();
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.initImage();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.initImage();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.initImage();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mInit = true;
        this.initImage();
    }

    private float getScale(int bitmapWidth, int bitmapHeight, int minWidth, int minHeight, boolean isMinScale) {
        float scaleX = (float)minWidth / (float)bitmapWidth;
        float scaleY = (float)minHeight / (float)bitmapHeight;
        float scale = isMinScale ? (scaleX > scaleY ? scaleX : scaleY) : (scaleX < scaleY ? scaleX : scaleY);
        return scale;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (Build.VERSION.SDK_INT >= 19) {
            this.drawCanvas(canvas);
        } else if (!this.mClipPathExceptionHappened) {
            try {
                this.drawCanvas(canvas);
            }
            catch (UnsupportedOperationException e) {
                MLog.error((Object)"NewCropImageView", (Throwable)e);
                this.mClipPathExceptionHappened = true;
            }
        }
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mBorderPaint.setAntiAlias(true);
        canvas.drawPath(this.mFocusPath, this.mBorderPaint);
        this.mFocusPath.reset();
        this.mBorderPaint.setColor(this.mDivisionColor);
        this.mBorderPaint.setStrokeWidth((float)this.mDivisionWidth);
        canvas.drawLine((float)(this.mFocusWidth / 3) + this.mFocusRect.left, this.mFocusRect.top, (float)(this.mFocusWidth / 3) + this.mFocusRect.left, this.mFocusRect.bottom, this.mBorderPaint);
        canvas.drawLine((float)(this.mFocusWidth / 3 * 2) + this.mFocusRect.left, this.mFocusRect.top, (float)(this.mFocusWidth / 3 * 2) + this.mFocusRect.left, this.mFocusRect.bottom, this.mBorderPaint);
        canvas.drawLine(this.mFocusRect.left, (float)(this.mFocusHeight / 3) + this.mFocusRect.top, this.mFocusRect.right, (float)(this.mFocusHeight / 3) + this.mFocusRect.top, this.mBorderPaint);
        canvas.drawLine(this.mFocusRect.left, (float)(this.mFocusHeight / 3 * 2) + this.mFocusRect.top, this.mFocusRect.right, (float)(this.mFocusHeight / 3 * 2) + this.mFocusRect.top, this.mBorderPaint);
    }

    private void drawCanvas(Canvas canvas) {
        if (Style.RECTANGLE == this.mStyle) {
            this.mFocusPath.addRect(this.mFocusRect, Path.Direction.CCW);
            canvas.save();
            canvas.clipRect(0, 0, this.getWidth(), this.getHeight());
            canvas.clipPath(this.mFocusPath, Region.Op.DIFFERENCE);
            canvas.drawColor(this.mMaskColor);
            canvas.restore();
        } else if (Style.CIRCLE == this.mStyle) {
            float radius = Math.min((this.mFocusRect.right - this.mFocusRect.left) / 2.0f, (this.mFocusRect.bottom - this.mFocusRect.top) / 2.0f);
            this.mFocusPath.addCircle(this.mFocusMidPoint.x, this.mFocusMidPoint.y, radius, Path.Direction.CCW);
            canvas.save();
            canvas.clipRect(0, 0, this.getWidth(), this.getHeight());
            canvas.clipPath(this.mFocusPath, Region.Op.DIFFERENCE);
            canvas.drawColor(this.mMaskColor);
            canvas.restore();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mSaving || null == this.getDrawable()) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.savedMatrix.set(this.matrix);
                this.pA.set(event.getX(), event.getY());
                this.pB.set(event.getX(), event.getY());
                this.mode = 1;
                break;
            }
            case 5: {
                if (event.getActionIndex() > 1 || event.getPointerCount() < 2) break;
                this.pA.set(event.getX(0), event.getY(0));
                this.pB.set(event.getX(1), event.getY(1));
                this.midPoint.set((this.pA.x + this.pB.x) / 2.0f, (this.pA.y + this.pB.y) / 2.0f);
                this.oldDist = this.spacing(this.pA, this.pB);
                this.savedMatrix.set(this.matrix);
                if (!(this.oldDist > 10.0f)) break;
                this.mode = 2;
                break;
            }
            case 2: {
                float newDist;
                if (this.mode == 1) {
                    this.matrix.set(this.savedMatrix);
                    this.matrix.postTranslate(event.getX() - this.pA.x, event.getY() - this.pA.y);
                    this.fixTranslation();
                    this.setImageMatrix(this.matrix);
                    break;
                }
                if (this.mode != 2 || event.getPointerCount() < 2 || !((newDist = this.spacing(event.getX(0), event.getY(0), event.getX(1), event.getY(1))) > 10.0f)) break;
                this.matrix.set(this.savedMatrix);
                float tScale = Math.min(newDist / this.oldDist, this.maxPostScale());
                if (tScale < 1.0f) {
                    RectF imageRect = new RectF(0.0f, 0.0f, (float)this.mImageWidth, (float)this.mImageHeight);
                    this.matrix.mapRect(imageRect);
                    if (imageRect.left >= this.mFocusRect.left && imageRect.right <= this.mFocusRect.right || imageRect.top >= this.mFocusRect.top && imageRect.bottom <= this.mFocusRect.bottom) break;
                }
                if (tScale == 0.0f) break;
                this.matrix.postScale(tScale, tScale, this.midPoint.x, this.midPoint.y);
                this.fixScale();
                this.fixTranslation();
                this.setImageMatrix(this.matrix);
                break;
            }
            case 1: 
            case 6: {
                this.mode = 0;
                break;
            }
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
        return true;
    }

    private void fixScale() {
        float[] imageMatrixValues = new float[9];
        this.matrix.getValues(imageMatrixValues);
        float currentScale = Math.abs(imageMatrixValues[0]) + Math.abs(imageMatrixValues[1]);
        float minScale = this.getScale(this.mImageWidth, this.mImageHeight, this.mFocusWidth, this.mFocusHeight, true);
        this.mMaxScale = minScale * 4.0f;
        if (currentScale < minScale) {
            float scale = minScale / currentScale;
            this.matrix.postScale(scale, scale);
        } else if (currentScale > this.mMaxScale) {
            float scale = this.mMaxScale / currentScale;
            this.matrix.postScale(scale, scale);
        }
    }

    private void initImage() {
        if (Build.VERSION.SDK_INT < 19) {
            this.setLayerType(1, null);
        }
        Drawable d = this.getDrawable();
        if (!this.mInit || d == null) {
            return;
        }
        this.mode = 0;
        this.matrix = this.getImageMatrix();
        this.mImageWidth = d.getIntrinsicWidth();
        this.mImageHeight = d.getIntrinsicHeight();
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        float midPointX = viewWidth / 2;
        float midPointY = viewHeight / 2;
        this.mFocusMidPoint = new PointF(midPointX, midPointY);
        int width = this.getWidth();
        int height = this.getHeight();
        if (width != 0 && height != 0) {
            int cropHeight;
            int cropWidth;
            int interval = ResolutionUtils.dip2Px((float)40.0f);
            if ((float)width < this.mCropRatio * (float)height) {
                cropWidth = width - interval;
                cropHeight = (int)((float)cropWidth * 1.0f / this.mCropRatio);
            } else {
                cropHeight = height - interval;
                cropWidth = (int)((float)cropHeight * this.mCropRatio);
            }
            this.mFocusWidth = cropWidth;
            this.mFocusHeight = cropHeight;
        }
        if (this.mStyle == Style.CIRCLE) {
            int focusSize;
            this.mFocusWidth = focusSize = Math.min(this.mFocusWidth, this.mFocusHeight);
            this.mFocusHeight = focusSize;
        }
        this.mFocusRect.left = this.mFocusMidPoint.x - (float)(this.mFocusWidth / 2);
        this.mFocusRect.right = this.mFocusMidPoint.x + (float)(this.mFocusWidth / 2);
        this.mFocusRect.top = this.mFocusMidPoint.y - (float)(this.mFocusHeight / 2);
        this.mFocusRect.bottom = this.mFocusMidPoint.y + (float)(this.mFocusHeight / 2);
        float fitFocusScale = this.getScale(this.mImageWidth, this.mImageHeight, this.mFocusWidth, this.mFocusHeight, true);
        this.mMaxScale = fitFocusScale * 4.0f;
        float fitViewScale = this.getScale(this.mImageWidth, this.mImageHeight, viewWidth, viewHeight, false);
        float scale = fitViewScale > fitFocusScale ? fitViewScale : fitFocusScale;
        this.matrix.setScale(scale, scale, (float)(this.mImageWidth / 2), (float)(this.mImageHeight / 2));
        float[] mImageMatrixValues = new float[9];
        this.matrix.getValues(mImageMatrixValues);
        float transX = this.mFocusMidPoint.x - (mImageMatrixValues[2] + (float)this.mImageWidth * mImageMatrixValues[0] / 2.0f);
        float transY = this.mFocusMidPoint.y - (mImageMatrixValues[5] + (float)this.mImageHeight * mImageMatrixValues[4] / 2.0f);
        this.matrix.postTranslate(transX, transY);
        this.setImageMatrix(this.matrix);
        this.invalidate();
        MLog.info((Object)"NewCropImageView", (String)"initImage, mFocusRect:%s, matrix:%s", (Object[])new Object[]{this.mFocusRect, this.matrix});
    }

    private float maxPostScale() {
        float[] imageMatrixValues = new float[9];
        this.matrix.getValues(imageMatrixValues);
        float curScale = Math.abs(imageMatrixValues[0]) + Math.abs(imageMatrixValues[1]);
        return this.mMaxScale / curScale;
    }

    private float spacing(float x1, float y1, float x2, float y2) {
        float x = x1 - x2;
        float y = y1 - y2;
        return (float)Math.sqrt(x * x + y * y);
    }

    private float spacing(PointF pA, PointF pB) {
        return this.spacing(pA.x, pA.y, pB.x, pB.y);
    }

    public Bitmap getCropBitmap(int expectWidth, int exceptHeight) {
        if (expectWidth <= 0 || exceptHeight < 0 || !(this.getDrawable() instanceof BitmapDrawable)) {
            return null;
        }
        Bitmap srcBitmap = ((BitmapDrawable)this.getDrawable()).getBitmap();
        return this.makeCropBitmap(srcBitmap, this.mFocusRect, this.getImageMatrixRect(), expectWidth, exceptHeight);
    }

    private RectF getImageMatrixRect() {
        RectF rectF = new RectF();
        rectF.set(0.0f, 0.0f, (float)this.getDrawable().getIntrinsicWidth(), (float)this.getDrawable().getIntrinsicHeight());
        this.matrix.mapRect(rectF);
        return rectF;
    }

    private Bitmap makeCropBitmap(Bitmap bitmap, RectF focusRect, RectF imageMatrixRect, int expectWidth, int exceptHeight) {
        if (imageMatrixRect == null || bitmap == null) {
            return null;
        }
        float scale = imageMatrixRect.width() / (float)bitmap.getWidth();
        int left = (int)((focusRect.left - imageMatrixRect.left) / scale);
        int top = (int)((focusRect.top - imageMatrixRect.top) / scale);
        int width = (int)(focusRect.width() / scale);
        int height = (int)(focusRect.height() / scale);
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        if (left + width > bitmap.getWidth()) {
            width = bitmap.getWidth() - left;
        }
        if (top + height > bitmap.getHeight()) {
            height = bitmap.getHeight() - top;
        }
        try {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)left, (int)top, (int)width, (int)height);
            if (expectWidth != width || exceptHeight != height) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)expectWidth, (int)exceptHeight, (boolean)true);
                if (this.mStyle == Style.CIRCLE) {
                    int length = Math.min(expectWidth, exceptHeight);
                    int radius = length / 2;
                    Bitmap circleBitmap = BitmapUtils.createBitmap((int)length, (int)length, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas canvas = new Canvas(circleBitmap);
                    BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                    Paint paint = new Paint();
                    paint.setShader((Shader)bitmapShader);
                    canvas.drawCircle((float)expectWidth / 2.0f, (float)exceptHeight / 2.0f, (float)radius, paint);
                    bitmap = circleBitmap;
                }
            }
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)"NewCropImageView", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            MLog.error((Object)"NewCropImageView", (Throwable)e);
        }
        return bitmap;
    }

    public void saveBitmapToFile(int expectWidth, int exceptHeight) {
        if (this.mSaving) {
            return;
        }
        this.mSaving = true;
        final Bitmap croppedImage = this.getCropBitmap(expectWidth, exceptHeight);
        Bitmap.CompressFormat outputFormat = Bitmap.CompressFormat.JPEG;
        String mExtension = ".jpg";
        if (this.mStyle == Style.CIRCLE) {
            outputFormat = Bitmap.CompressFormat.PNG;
            mExtension = ".png";
        }
        File saveFile = YYFileUtils.getTempFile((Context)this.getContext(), (String)(AccountUtil.getUid() + "_" + System.currentTimeMillis() + mExtension));
        final Bitmap.CompressFormat finalOutputFormat = outputFormat;
        final File finalSaveFile = saveFile;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                NewCropImageView.this.saveOutput(croppedImage, finalOutputFormat, finalSaveFile);
            }
        });
    }

    private void fixTranslation() {
        RectF imageRect = new RectF(0.0f, 0.0f, (float)this.mImageWidth, (float)this.mImageHeight);
        this.matrix.mapRect(imageRect);
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (imageRect.left > this.mFocusRect.left) {
            deltaX = -imageRect.left + this.mFocusRect.left;
        } else if (imageRect.right < this.mFocusRect.right) {
            deltaX = -imageRect.right + this.mFocusRect.right;
        }
        if (imageRect.top > this.mFocusRect.top) {
            deltaY = -imageRect.top + this.mFocusRect.top;
        } else if (imageRect.bottom < this.mFocusRect.bottom) {
            deltaY = -imageRect.bottom + this.mFocusRect.bottom;
        }
        MLog.info((Object)"NewCropImageView", (String)"fixTranslation, imageRect:%s, matrix:%s", (Object[])new Object[]{imageRect, this.matrix});
        this.matrix.postTranslate(deltaX, deltaY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOutput(Bitmap croppedImage, Bitmap.CompressFormat outputFormat, final File saveFile) {
        OutputStream outputStream = null;
        try {
            outputStream = this.getContext().getContentResolver().openOutputStream(Uri.fromFile((File)saveFile));
            if (outputStream != null) {
                croppedImage.compress(outputFormat, 100, outputStream);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (mListener != null) {
                        mListener.onMediaSaveSuccess(saveFile);
                    }
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (mListener != null) {
                        mListener.onMediaSaveError(saveFile);
                    }
                }
            });
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.mSaving = false;
        croppedImage.recycle();
    }

    public void setOnBitmapSaveCompleteListener(OnMediaSaveCompleteListener listener) {
        mListener = listener;
    }

    public static enum Style {
        RECTANGLE,
        CIRCLE;

    }
}

