/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.CameraMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.camera.base.ablum_select.AlbumConfig;
import com.yy.hiyo.camera.camera.CameraController;
import com.yy.hiyo.camera.camera.CameraWindow;

public class CameraWindowController
extends DefaultWindowController {
    public static final String TAG = "CameraWindowController";
    private CameraWindow mCameraWindow;
    private CameraController mCameraController;

    public CameraWindowController(Environment env) {
        super(env);
        this.registerMessage(CameraMsgDef.MSG_HIDE_WINDOW_PHOTO_PICK);
        this.registerMessage(CameraMsgDef.MSG_PHTOT_RESULT_FOR_WINDOW);
        this.registerMessage(CameraMsgDef.MSG_PHOTO_BACK_HANDLER);
    }

    public void showWindow(int requestCode, int method, int style2, float cropRatio, int from, String featureLogTAG, AlbumConfig config) {
        MLog.info((Object)TAG, (String)"MSG_SHOW_WINDOW_PHOTO_PICK, style: %s, method: %s, requestCode: %s, from: %s", (Object[])new Object[]{style2, method, requestCode, from});
        this.mCameraController = new CameraController(this.getEnvironment(), requestCode, method, style2, cropRatio, from, featureLogTAG, config);
        this.mCameraController.setOnReceivedPhotoPathListener(new OnReceivedPhotoPathListener(){

            @Override
            public void onReceived(String path) {
                MLog.info((Object)CameraWindowController.TAG, (String)"handle photo pick  %s!", (Object[])new Object[]{path});
                if (CameraWindowController.this.mCameraWindow != null) {
                    CameraWindowController.this.mWindowMgr.popWindow(false, (AbstractWindow)CameraWindowController.this.mCameraWindow);
                }
                CameraWindowController.this.mCameraWindow = new CameraWindow(CameraWindowController.this.mContext, CameraWindowController.this.mCameraController);
                CameraWindowController.this.mWindowMgr.pushWindow((AbstractWindow)CameraWindowController.this.mCameraWindow, false);
            }
        });
        this.mCameraController.setOnWindowChangedListener(new OnWindowChangedLister(){

            @Override
            public void onDetach(AbstractWindow abstractWindow) {
                if (abstractWindow == CameraWindowController.this.mCameraWindow) {
                    CameraWindowController.this.mCameraWindow = null;
                }
            }
        });
    }

    public Object handleMessageSync(final Message msg) {
        if (msg.what == CameraMsgDef.MSG_HIDE_WINDOW_PHOTO_PICK) {
            MLog.info((Object)TAG, (String)"MSG_HIDE_WINDOW_PHOTO_PICK", (Object[])new Object[0]);
            if (this.mCameraWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mCameraWindow);
            }
            this.mCameraWindow = null;
        } else if (msg.what == CameraMsgDef.MSG_PHTOT_RESULT_FOR_WINDOW) {
            MLog.info((Object)TAG, (String)"MSG_PHTOT_RESULT_FOR_WINDOW", (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (CameraWindowController.this.mCameraController != null) {
                        Bundle bundle = msg.getData();
                        CameraWindowController.this.mCameraController.onActivityResult(bundle.getInt("requestCode"), bundle.getInt("resultCode"), (Intent)bundle.getParcelable("data"));
                    }
                }
            });
        } else if (msg.what == CameraMsgDef.MSG_PHOTO_BACK_HANDLER) {
            MLog.info((Object)TAG, (String)"MSG_PHOTO_BACK_HANDLER", (Object[])new Object[0]);
            if (this.mCameraController != null) {
                this.mCameraController.getPhoto();
            }
        }
        return super.handleMessageSync(msg);
    }

    public static interface OnWindowChangedLister {
        public void onDetach(AbstractWindow var1);
    }

    public static interface OnReceivedPhotoPathListener {
        public void onReceived(String var1);
    }
}

