/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import androidx.annotation.NonNull;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.RecordVideoInfo;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.SimplePermissionListener;
import com.yy.appbase.service.callback.OnCameraCallbak;
import com.yy.appbase.service.callback.OnPhotoDeleteCallbak;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.CameraMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.camera.R;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.camera.base.ablum_select.AlbumConfig;
import com.yy.hiyo.camera.base.ablum_select.listener.OnCameraPathListCallback;
import com.yy.hiyo.camera.camera.BottomSelectDialog;
import com.yy.hiyo.camera.camera.CameraWindowController;
import com.yy.hiyo.camera.camera.UserInfoEditAvatarDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CameraService
extends DefaultController
implements ICameraService {
    public static final String TAG = "CameraService";
    private Environment mEnv;
    private OnCameraCallbak mCallbak;
    private OnPhotoDeleteCallbak mDelCallback;
    private OnCameraPathListCallback mOnCameraPathListCallback;
    private CameraWindowController mCameraWindowController;
    private boolean mIsPath = false;
    private List<String> mPaths = new ArrayList<String>();
    private List<String> mStringList = new ArrayList<String>();
    private int mFileSize = 1;
    private BaseDialog mDialog;

    public CameraService(Environment env) {
        super(env);
        this.mEnv = env;
        this.registerMessage(CameraMsgDef.MSG_PHOTO_FINISH_RESULT);
        this.registerMessage(BaseMsgDef.ALBUM_SELECTED_COUNT);
        this.registerMessage(BaseMsgDef.ALBUM_SELECTED_VIDEO);
        this.registerMessage(CameraMsgDef.MSG_PATCH_HANDLE_BACK);
        this.registerMessage(CameraMsgDef.MSG_RECORD_VIDEO_RESULT);
        this.registerMessage(CameraMsgDef.MSG_RECORDPAGE_CANNEL_BACKPRESS);
        this.registerMessage(CameraMsgDef.MSG_ALBUM_SELECT_BACKPRESS);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.mCameraWindowController != null) return;
        Class<CameraService> clazz = CameraService.class;
        synchronized (CameraService.class) {
            this.mCameraWindowController = new CameraWindowController(this.mEnv);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void pickPhoto(String featureLogTAG, OnCameraCallbak cameraCallbak, int from) {
        boolean style = true;
        this.mCallbak = cameraCallbak;
        this.mIsPath = false;
        this.mFileSize = 1;
        this.show(1, 1.0f, from, featureLogTAG);
    }

    public void pickPhotoWithClip(String featureLogTAG, OnCameraCallbak cameraCallbak, int from) {
        this.pickPhotoWithClip(featureLogTAG, cameraCallbak, from, 1.0f);
    }

    public void pickPhotoForUserAvatarWithClip(final String featureLogTAG, OnCameraCallbak cameraCallbak, final int from) {
        int style2 = 2;
        this.mCallbak = cameraCallbak;
        this.mIsPath = false;
        this.mFileSize = 1;
        new UserInfoEditAvatarDialog(this.mContext, new View.OnClickListener(){

            public void onClick(View v) {
                PermissionHelper.requestCameraPermission((Activity)CameraService.this.getActivity(), (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        CameraService.this.mCameraWindowController.showWindow(0, 1, 2, 1.0f, from, featureLogTAG, AlbumConfig.getDefault());
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                    }
                });
            }
        }, new View.OnClickListener(){

            public void onClick(View v) {
                PermissionHelper.checkStoragePermission((Activity)CameraService.this.getActivity(), (IPermissionListener)new SimplePermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        CameraService.this.mCameraWindowController.showWindow(0, 2, 2, 1.0f, from, featureLogTAG, AlbumConfig.getDefault());
                    }
                });
            }
        }).show();
    }

    public void pickPhotoWithClip(String featureLogTAG, OnCameraCallbak cameraCallbak, int from, float cropRatio) {
        int style2 = 2;
        this.mCallbak = cameraCallbak;
        this.mIsPath = false;
        this.mFileSize = 1;
        this.show(2, cropRatio, from, featureLogTAG);
    }

    public void pickAlbumPhotoWithClip(final String featureLogTAG, OnCameraCallbak cameraCallbak, final int from, final float cropRatio) {
        int style2 = 2;
        this.mCallbak = cameraCallbak;
        this.mIsPath = false;
        this.mFileSize = 1;
        new UserInfoEditAvatarDialog(this.mContext, new View.OnClickListener(){

            public void onClick(View v) {
                PermissionHelper.requestCameraPermission((Activity)CameraService.this.getActivity(), (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        CameraService.this.mCameraWindowController.showWindow(0, 1, 2, cropRatio, from, featureLogTAG, AlbumConfig.getDefault());
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                    }
                });
            }
        }, new View.OnClickListener(){

            public void onClick(View v) {
                PermissionHelper.checkStoragePermission((Activity)CameraService.this.getActivity(), (IPermissionListener)new SimplePermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        CameraService.this.mCameraWindowController.showWindow(0, 2, 2, cropRatio, from, featureLogTAG, AlbumConfig.getDefault());
                    }
                });
            }
        }).show();
    }

    public void pickPhotoOnAlbumPhoto(String featureLogTAG, OnCameraCallbak cameraCallbak, OnPhotoDeleteCallbak deleteCallbak) {
        boolean style2 = true;
        this.mCallbak = cameraCallbak;
        this.mDelCallback = deleteCallbak;
        this.mIsPath = false;
        this.mFileSize = 1;
        this.show(1, 1.0f, 4, featureLogTAG);
    }

    public void pickPhotoOnAlbumPhotoWithClip(String featureLogTAG, OnCameraCallbak cameraCallbak, OnPhotoDeleteCallbak deleteCallbak, float cropRatio) {
        int style2 = 2;
        this.mCallbak = cameraCallbak;
        this.mDelCallback = deleteCallbak;
        this.mIsPath = false;
        this.mFileSize = 1;
        this.show(2, cropRatio, 4, featureLogTAG);
    }

    public void takePhoto(final String featureLogTAG, final OnCameraCallbak cameraCallbak) {
        this.mIsPath = false;
        this.mFileSize = 1;
        PermissionHelper.requestCameraPermission((Activity)this.getActivity(), (IPermissionListener)new IPermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                boolean style = true;
                float cropRatio = 1.0f;
                CameraService.this.mCallbak = cameraCallbak;
                CameraService.this.mCameraWindowController.showWindow(0, 1, 1, 1.0f, 3, featureLogTAG, AlbumConfig.getDefault());
            }

            public void onPermissionDenied(@NonNull String[] permission) {
            }
        });
    }

    public void chooseFromGallery(String featureLogTAG, int from, int showType, OnCameraCallbak cameraCallbak) {
        AlbumConfig config = AlbumConfig.getDefault();
        config.styleType = showType;
        this.chooseFromGallery(featureLogTAG, from, config, cameraCallbak);
    }

    public void chooseFromGallery(final String featureLogTAG, final int from, final AlbumConfig config, OnCameraCallbak cameraCallbak) {
        boolean style2 = true;
        float cropRatio = 1.0f;
        this.mCallbak = cameraCallbak;
        this.mIsPath = false;
        this.mFileSize = 1;
        PermissionHelper.checkStoragePermission((Activity)this.getActivity(), (IPermissionListener)new SimplePermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                if (config.styleType == 4) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_feedback_video_select_too_large, (int)0);
                }
                CameraService.this.mCameraWindowController.showWindow(0, 2, 1, 1.0f, from, featureLogTAG, config);
            }
        });
    }

    public void chooseFromGalleryWithClip(final String featureLogTAG, final int from, int showType, final float cropRatio, OnCameraCallbak cameraCallbak) {
        int style2 = 2;
        this.mCallbak = cameraCallbak;
        this.mIsPath = false;
        this.mFileSize = 1;
        final AlbumConfig config = AlbumConfig.getDefault();
        config.styleType = showType;
        PermissionHelper.checkStoragePermission((Activity)this.getActivity(), (IPermissionListener)new SimplePermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                CameraService.this.mCameraWindowController.showWindow(0, 2, 2, cropRatio, from, featureLogTAG, config);
            }
        });
    }

    public void chooseFromGallery(AlbumConfig config, OnCameraPathListCallback cameraPathListCallback) {
        MLog.info((Object)TAG, (String)"chooseFromGallery for bbs", (Object[])new Object[0]);
        this.chooseFromGalleryNew("FTBBSAlbum", 7, config, cameraPathListCallback);
    }

    public void chooseFromGalleryNew(final String featureLogTAG, final int from, final AlbumConfig config, OnCameraPathListCallback cameraPathListCallback) {
        MLog.info((Object)TAG, (String)"chooseFromGallery from:%s", (Object[])new Object[]{from});
        this.mIsPath = true;
        this.mFileSize = 1;
        this.mPaths.clear();
        this.mStringList.clear();
        this.mOnCameraPathListCallback = cameraPathListCallback;
        PermissionHelper.requestStoreAndCameraPermission((Activity)this.getActivity(), (IPermissionListener)new SimplePermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                MLog.info((Object)CameraService.TAG, (String)"chooseFromGallery request audiopre", (Object[])new Object[0]);
                PermissionHelper.requestRecordAudioPermission((Activity)CameraService.this.getActivity(), (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        CameraService.this.mCameraWindowController.showWindow(0, 2, 1, 1.0f, from, featureLogTAG, config);
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                        ToastUtils.showToast((Context)CameraService.this.mContext, (String)ResourceUtils.getString((int)R.string.permission_record_audio_access_instructions), (int)0);
                        MLog.warn((Object)CameraService.TAG, (String)" audio onPermissionDenied is fail", (Object[])new Object[0]);
                    }
                });
            }

            public void onPermissionDenied(@NonNull String[] permission) {
                ToastUtils.showToast((Context)CameraService.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_no_camera_permission), (int)0);
                MLog.warn((Object)CameraService.TAG, (String)" store camera onPermissionDenied is fail", (Object[])new Object[0]);
                if (CameraService.this.mOnCameraPathListCallback != null) {
                    CameraService.this.mOnCameraPathListCallback.onPermissionDeny();
                }
            }
        });
    }

    public void setCameraPathListCallback(OnCameraPathListCallback cameraPathListCallback) {
        this.mOnCameraPathListCallback = cameraPathListCallback;
    }

    public void takeRecordVideo(int pageFrom, int timeSecMax, OnCameraPathListCallback cameraPathListCallback) {
        MLog.info((Object)TAG, (String)"takeRecordVideo for bbs", (Object[])new Object[0]);
        AlbumConfig config = AlbumConfig.getDefault();
        config.mFocusMediaTab = 2;
        config.mMediaMode = 9;
        config.toolMap.put("TOOL_ONE_TAB", "true");
        config.toolMap.put("MAX_RECORD_TIME", timeSecMax);
        config.toolMap.put("PAGESOURCE", String.valueOf(pageFrom));
        this.chooseFromGallery(config, cameraPathListCallback);
    }

    public void takeMtvVideoForChannel(String songId, String songName, String localMusicPath, String localLyricPath, OnCameraPathListCallback cameraPathListCallback) {
        MLog.info((Object)TAG, (String)"takeMtvVideoForChannel for bbs", (Object[])new Object[0]);
        AlbumConfig config = AlbumConfig.getDefault();
        config.mFocusMediaTab = 8;
        config.mMediaMode = 10;
        config.toolMap.put("songId", songId);
        config.toolMap.put("MTV_SONG_NAME", songName);
        config.toolMap.put("MTV_LOCALMUSIC", localMusicPath);
        config.toolMap.put("MTV_LOCALLYRIC", localLyricPath);
        config.toolMap.put("TOOL_ONE_TAB", "true");
        config.toolMap.put("TOOL_RECORD_AUDIO_ENABLE", "false");
        config.toolMap.put("TOOL_RECORD_EXIT_CHANNEL", "false");
        config.toolMap.put("PAGESOURCE", String.valueOf(11));
        this.chooseFromGallery(config, cameraPathListCallback);
    }

    public void takeRecordPhoto(int pageFrom, OnCameraPathListCallback cameraPathListCallback) {
        MLog.info((Object)TAG, (String)"takeRecordPhoto for bbs", (Object[])new Object[0]);
        AlbumConfig config = AlbumConfig.getDefault();
        config.mFocusMediaTab = 1;
        config.mMediaMode = 11;
        config.toolMap.put("TOOL_ONE_TAB", "true");
        config.toolMap.put("PAGESOURCE", String.valueOf(pageFrom));
        this.chooseFromGallery(config, cameraPathListCallback);
    }

    private void show(final int style2, final float cropRatio, final int from, final String featureLogTAG) {
        ArrayList<ButtonItem> buttonItems = new ArrayList<ButtonItem>();
        if (from == 4) {
            ButtonItem buttonDelItem = new ButtonItem(ResourceUtils.getString((int)R.string.button_delete), 3, new ButtonItem.OnClickListener(){

                public void onClick() {
                    if (CameraService.this.mDelCallback != null) {
                        CameraService.this.mDelCallback.onDelete();
                        CameraService.this.mDelCallback = null;
                    }
                }
            });
            buttonItems.add(buttonDelItem);
        } else if (from == 12) {
            ButtonItem buttonDelItem = new ButtonItem(ResourceUtils.getString((int)R.string.choose_video), 3, new ButtonItem.OnClickListener(){

                public void onClick() {
                    PermissionHelper.checkStoragePermission((Activity)CameraService.this.getActivity(), (IPermissionListener)new SimplePermissionListener(){

                        public void onPermissionGranted(@NonNull String[] permission) {
                            CameraService.this.mCameraWindowController.showWindow(0, 4, 2, cropRatio, from, featureLogTAG, AlbumConfig.getDefault());
                        }
                    });
                }
            });
            buttonItems.add(buttonDelItem);
        }
        buttonItems.add(new ButtonItem(ResourceUtils.getString((int)R.string.choose_photo), 3, new ButtonItem.OnClickListener(){

            public void onClick() {
                PermissionHelper.checkStoragePermission((Activity)CameraService.this.getActivity(), (IPermissionListener)new SimplePermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        CameraService.this.mCameraWindowController.showWindow(0, 2, style2, cropRatio, from, featureLogTAG, AlbumConfig.getDefault());
                    }
                });
            }
        }));
        buttonItems.add(new ButtonItem(ResourceUtils.getString((int)R.string.take_photo), 3, new ButtonItem.OnClickListener(){

            public void onClick() {
                PermissionHelper.requestCameraPermission((Activity)CameraService.this.getActivity(), (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        CameraService.this.mCameraWindowController.showWindow(0, 1, style2, cropRatio, from, featureLogTAG, AlbumConfig.getDefault());
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                    }
                });
            }
        }));
        switch (from) {
            case 1: {
                if (this.mDialog == null) {
                    this.mDialog = new BottomSelectDialog(this.mContext, ResourceUtils.getString((int)R.string.complete_photo_info), buttonItems, "");
                }
                this.mDialogLinkManager.showDialog(this.mDialog);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.mDialogLinkManager.showCommonPopupDialog(buttonItems, true, true);
                break;
            }
            case 4: {
                this.mDialogLinkManager.showCommonPopupDialog(buttonItems, true, true);
                break;
            }
            default: {
                this.mDialogLinkManager.showCommonPopupDialog(buttonItems, true, true);
            }
        }
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == CameraMsgDef.MSG_PHOTO_FINISH_RESULT) {
            int result;
            Bundle bundle = msg.getData();
            if (bundle != null && (result = bundle.getInt("key_result")) != 3) {
                String path = bundle.getString("key_image_path", "");
                if (this.mIsPath) {
                    this.mPaths.add(path);
                    if (this.mOnCameraPathListCallback != null) {
                        this.mOnCameraPathListCallback.onFinish(path);
                    }
                    if (this.mOnCameraPathListCallback != null && this.mPaths.size() >= this.mFileSize) {
                        this.mOnCameraPathListCallback.onPatchPathBack(this.mPaths);
                    }
                } else if (this.mCallbak != null) {
                    this.mCallbak.onFinish(path);
                }
            }
        } else if (msg.what == CameraMsgDef.MSG_PATCH_HANDLE_BACK) {
            if (msg.obj instanceof CopyOnWriteArrayList) {
                CopyOnWriteArrayList mObjs = (CopyOnWriteArrayList)msg.obj;
                ArrayList<BasicMediaInfo> mPhotos = new ArrayList<BasicMediaInfo>();
                for (Object obj : mObjs) {
                    if (!(obj instanceof BasicMediaInfo)) continue;
                    mPhotos.add((BasicMediaInfo)obj);
                }
                MLog.info((Object)TAG, (String)"MSG_PATCH_HANDLE_BACK", (Object[])new Object[0]);
                if (this.mOnCameraPathListCallback != null) {
                    this.mOnCameraPathListCallback.onPatchInfoBack(mPhotos);
                }
            }
        } else if (msg.what == CameraMsgDef.MSG_RECORD_VIDEO_RESULT) {
            MLog.info((Object)TAG, (String)"MSG_RECORD_VIDEO_RESULT", (Object[])new Object[0]);
            if (msg.obj instanceof RecordVideoInfo) {
                if (this.mOnCameraPathListCallback != null) {
                    YYTaskExecutor.postToMainThread(() -> this.mOnCameraPathListCallback.onRecordVideoPath((RecordVideoInfo)msg.obj));
                }
            } else {
                MLog.error((Object)TAG, (String)"msg param is error", (Object[])new Object[0]);
            }
        }
        return super.handleMessageSync(msg);
    }

    public void handleMessage(Message msg) {
        if (msg.what == BaseMsgDef.ALBUM_SELECTED_COUNT) {
            this.mStringList.clear();
            if (msg.obj instanceof List) {
                this.mStringList.addAll((Collection)msg.obj);
            }
            if (msg.arg1 > 0) {
                this.mFileSize = msg.arg1;
                if (this.mOnCameraPathListCallback != null) {
                    this.mOnCameraPathListCallback.onGallarySelect(this.mFileSize);
                }
            }
        } else if (msg.what == CameraMsgDef.MSG_RECORDPAGE_CANNEL_BACKPRESS) {
            if (this.mOnCameraPathListCallback != null) {
                this.mOnCameraPathListCallback.onBackPress();
            } else if (this.mCallbak != null) {
                this.mCallbak.onBackPress();
            }
        } else if (msg.what == CameraMsgDef.MSG_ALBUM_SELECT_BACKPRESS) {
            if (this.mCallbak != null) {
                this.mCallbak.onBackPress();
            }
        } else if (msg.what == BaseMsgDef.ALBUM_SELECTED_VIDEO) {
            MLog.info((Object)TAG, (String)"ALBUM_SELECTED_VIDEO", (Object[])new Object[0]);
            if (msg.obj instanceof BasicMediaInfo) {
                BasicMediaInfo basicMediaInfo = (BasicMediaInfo)msg.obj;
                RecordVideoInfo recordVideoInfo = new RecordVideoInfo();
                recordVideoInfo.duration = basicMediaInfo.duration;
                recordVideoInfo.path = basicMediaInfo.path;
                recordVideoInfo.width = basicMediaInfo.width;
                recordVideoInfo.height = basicMediaInfo.height;
                recordVideoInfo.type = basicMediaInfo.type;
                recordVideoInfo.compressPath = basicMediaInfo.compressPath;
                recordVideoInfo.bitRate = basicMediaInfo.bitRate;
                recordVideoInfo.videoCodec = basicMediaInfo.videoCodec;
                if (this.mCallbak instanceof OnCameraPathListCallback) {
                    ((OnCameraPathListCallback)this.mCallbak).onAlbumSelectVideo(recordVideoInfo);
                }
            }
        }
        super.handleMessage(msg);
    }

    public void cleanCallback() {
        MLog.info((Object)TAG, (String)"Clean callback %s,%s,%s", (Object[])new Object[]{this.mCallbak, this.mDelCallback, this.mOnCameraPathListCallback});
        this.mCallbak = null;
        this.mDelCallback = null;
        this.mOnCameraPathListCallback = null;
    }
}

