/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.image.compress.OnCompressListener;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.camera.R;
import com.yy.hiyo.camera.camera.CameraController;
import com.yy.hiyo.camera.camera.ICameraView;
import com.yy.hiyo.camera.camera.OnMediaSaveCompleteListener;
import com.yy.hiyo.videorecord.IVideoRecordService;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Nullable;

public class CameraPresenter
implements OnMediaSaveCompleteListener {
    private static final String TAG = "CameraPresenter";
    private CameraController mController;
    private ICameraView mView;
    private boolean upload = true;
    private String mImageUrls;
    private boolean mCanProcess = true;
    private CopyOnWriteArrayList<BasicMediaInfo> mPhotoList = new CopyOnWriteArrayList();

    public CameraPresenter(@NonNull CameraController controller, boolean upload) {
        this.mController = controller;
        this.upload = upload;
    }

    public void setCameraView(ICameraView view) {
        this.mView = view;
    }

    public void onCancel() {
        MLog.info((Object)TAG, (String)"onCancel", (Object[])new Object[0]);
        FeatureLog.i((String)this.mController.mCurFeatureLogTAG, (String)"onCancel", (Object[])new Object[0]);
        this.mController.onBackHandler();
        this.mPhotoList.clear();
    }

    public void handleResult(String[] paths, int requestCode) {
        if (paths == null || paths.length == 0 || TextUtils.isEmpty((CharSequence)paths[0])) {
            MLog.info((Object)TAG, (String)"handleResult paths is error", (Object[])new Object[0]);
            FeatureLog.i((String)this.mController.mCurFeatureLogTAG, (String)"handleResult paths is error", (Object[])new Object[0]);
            this.mController.sendResultFailed();
            return;
        }
        this.mImageUrls = paths[0];
        if (this.upload) {
            this.handlerUploadPage();
            return;
        }
        this.showPicture();
    }

    private void handlerUploadPage() {
        this.mPhotoList.clear();
        FeatureLog.i((String)this.mController.mCurFeatureLogTAG, (String)"handlerUploadPage", (Object[])new Object[0]);
        this.mController.compress(this.mImageUrls, new OnCompressListener(){

            public void onStart() {
                CameraPresenter.this.mController.showLoadingDialog();
            }

            public void onSuccess(File file) {
                CameraPresenter.this.mController.hideLoadingDialog();
                CameraPresenter.this.mImageUrls = file.getPath();
                boolean isTakePhoto = CameraPresenter.this.mController.getIsTakePhoto();
                FeatureLog.i((String)((CameraPresenter)CameraPresenter.this).mController.mCurFeatureLogTAG, (String)("handlerUploadPage onSelected is TakePhoto = " + isTakePhoto), (Object[])new Object[0]);
                if (isTakePhoto) {
                    CameraPresenter.this.upload();
                    return;
                }
                CameraPresenter.this.showPicture();
            }

            public void onError(Throwable e) {
                FeatureLog.i((String)((CameraPresenter)CameraPresenter.this).mController.mCurFeatureLogTAG, (String)("handlerUploadPage onError e = " + e), (Object[])new Object[0]);
                CameraPresenter.this.mController.hideLoadingDialog();
                CameraPresenter.this.mController.sendResultFailed();
            }

            public void onPatchCompressFinish(CopyOnWriteArrayList<BasicMediaInfo> photos) {
                CameraPresenter.this.mPhotoList.clear();
                for (int i = 0; i < photos.size(); ++i) {
                    if (photos.get((int)i).width == 0) {
                        photos.get((int)i).width = ResolutionUtils.getScreenWidth();
                    }
                    if (photos.get((int)i).height != 0) continue;
                    photos.get((int)i).height = ResolutionUtils.getScreenHeight();
                }
                CameraPresenter.this.mPhotoList.addAll(photos);
            }
        });
    }

    private void showPicture() {
        FeatureLog.i((String)this.mController.mCurFeatureLogTAG, (String)"showPicture", (Object[])new Object[0]);
        if (this.mController != null && this.mController.getMethod() == 4) {
            double duration = ((IVideoRecordService)ServiceManagerProxy.getService(IVideoRecordService.class)).getVideoDuration(this.mImageUrls);
            if (duration > 5.0) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.toast_video_duration_10s, (int)0);
                this.mController.sendResultFailed();
            } else if (this.mView != null) {
                this.mView.showMediaFromUrl(this.mImageUrls);
            }
        } else if (this.upload) {
            if (this.mView != null) {
                this.mView.showMediaFromUrl(this.mImageUrls);
            }
        } else {
            Bitmap bitmap = ImageUtil.decodeSampledBitmapFile((String)this.mImageUrls, (ImageConfig)ImageConfig.fullImageConfig(), (boolean)true);
            if (bitmap == null) {
                FeatureLog.i((String)this.mController.mCurFeatureLogTAG, (String)"showPicture bitmap is null", (Object[])new Object[0]);
                this.mController.sendResultFailed();
                return;
            }
            if (this.mView != null) {
                this.mView.showPicture(bitmap);
            }
        }
    }

    public void onImageLoadFailed() {
        this.mController.sendResultFailed();
    }

    public void onChoose() {
        if (!this.mCanProcess) {
            return;
        }
        this.mCanProcess = false;
        if (this.upload) {
            this.mController.checkLowQuality(this.mImageUrls);
        } else {
            if (this.needShowLoading()) {
                this.mController.showLoadingDialog();
            }
            this.mView.saveMediaToFile();
        }
        this.mController.sendPatchPathsOk(this.mPhotoList);
    }

    private boolean needShowLoading() {
        return this.mController.getFrom() != 2 || this.mController.getStyle() != 2;
    }

    public void upload() {
        FeatureLog.i((String)this.mController.mCurFeatureLogTAG, (String)("upload mImageUrls = " + this.mImageUrls), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)this.mImageUrls)) {
            MLog.info((Object)TAG, (String)"upload imageUrl is empty", (Object[])new Object[0]);
            this.mController.sendResultFailed();
            return;
        }
        Bundle data = new Bundle();
        data.putString("key_image_path", this.mImageUrls);
        this.mController.sendResultOk(data, false);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                CameraPresenter.this.mCanProcess = true;
            }
        }, (long)1000L);
    }

    public float getCropRatio() {
        return this.mController.getCropRatio();
    }

    @Override
    public void onMediaSaveSuccess(@Nullable File file) {
        if (file == null) {
            MLog.info((Object)TAG, (String)"onBitmapSaveSuccess file is null", (Object[])new Object[0]);
            this.mController.sendResultFailed();
            return;
        }
        if (this.mController != null && this.mController.getMethod() == 4) {
            this.mController.hideLoadingDialog();
            this.mImageUrls = file.getPath();
            this.mController.checkLowQuality(this.mImageUrls);
            return;
        }
        final String bmpTmpPath = file.getPath();
        this.mController.compress(bmpTmpPath, new OnCompressListener(){

            public void onStart() {
                if (CameraPresenter.this.needShowLoading()) {
                    CameraPresenter.this.mController.showLoadingDialog();
                }
            }

            public void onSuccess(File file) {
                CameraPresenter.this.mController.hideLoadingDialog();
                CameraPresenter.this.mImageUrls = file.getPath();
                CameraPresenter.this.mController.checkLowQuality(CameraPresenter.this.mImageUrls);
                if (!StringUtils.equalsIgnoreCase((String)bmpTmpPath, (String)CameraPresenter.this.mImageUrls)) {
                    CameraPresenter.this.deleteTempImage(bmpTmpPath);
                }
            }

            public void onError(Throwable e) {
                CameraPresenter.this.mController.hideLoadingDialog();
                CameraPresenter.this.mController.sendResultFailed();
            }

            public void onPatchCompressFinish(CopyOnWriteArrayList<BasicMediaInfo> photos) {
            }
        });
    }

    @Override
    public void onMediaSaveError(@Nullable File file) {
        MLog.info((Object)TAG, (String)"onBitmapSaveError", (Object[])new Object[0]);
        this.mController.sendResultFailed();
        this.mController.hideLoadingDialog();
    }

    private void deleteTempImage(String bmpTmpPath) {
        if (bmpTmpPath != null) {
            MLog.debug((Object)this, (String)("deleteTempImage path=" + bmpTmpPath), (Object[])new Object[0]);
            YYFileUtils.removeFile((String)bmpTmpPath);
        }
    }
}

