/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.SimplePermissionListener;
import com.yy.appbase.service.IModuleProxyService;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.HagoFileProvider;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.BDAConst;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.image.compress.Luban;
import com.yy.base.image.compress.OnCompressListener;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.CameraMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.camera.R;
import com.yy.hiyo.camera.base.ablum_select.AlbumConfig;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.HagoAlbum;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.MimeType;
import com.yy.hiyo.camera.camera.CameraPresenter;
import com.yy.hiyo.camera.camera.CameraWindowController;
import com.yy.hiyo.main.base.PartySdkActivityProxy;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class CameraController
extends DefaultController
implements INotify,
UICallBacks {
    private static final String TAG = "CameraController";
    private static final long SIZE_LOW_QUALITY = 10240L;
    private int mStyle;
    private int mMethod;
    private String mCameraCapturingName;
    private boolean mTakePhoto;
    private int mRequestCode;
    private int mFrom;
    private float mCropRatio;
    private AlbumConfig mAlbumConfig;
    public String mCurFeatureLogTAG = "FTAddAvatarProfile";
    private CameraPresenter mPresenter;
    private CameraWindowController.OnReceivedPhotoPathListener mPhotoPathListener;
    private CameraWindowController.OnWindowChangedLister mWindowChangedListener;
    private OkCancelDialog mDialog = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.low_quality_photo_upload), (CharSequence)ResourceUtils.getString((int)R.string.btn_no), (CharSequence)ResourceUtils.getString((int)R.string.str_upload), true, false, new OkCancelDialogListener(){

        public void onCancel() {
            if (CameraController.this.mPresenter != null) {
                CameraController.this.mPresenter.upload();
                MLog.info((Object)CameraController.TAG, (String)"low quality dialog, click ok", (Object[])new Object[0]);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026515").put("function_id", "continue_upload"));
            }
        }

        public void onOk() {
            MLog.info((Object)CameraController.TAG, (String)"low quality dialog, click cancel", (Object[])new Object[0]);
            CameraController.this.finish();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026515").put("function_id", "cancle_upload"));
        }
    });

    public void setPresenter(CameraPresenter presenter) {
        this.mPresenter = presenter;
    }

    public CameraController(Environment env, int requestCode, int method, int style2, float cropRatio, int from, String featureLogTAG, AlbumConfig config) {
        super(env);
        if (!StringUtils.isEmpty((String)featureLogTAG)) {
            this.mCurFeatureLogTAG = featureLogTAG;
        }
        this.mStyle = style2;
        this.mMethod = method;
        this.mRequestCode = requestCode;
        this.mFrom = from;
        this.mAlbumConfig = config;
        this.mCropRatio = cropRatio;
        this.getPhoto();
    }

    public void setOnReceivedPhotoPathListener(CameraWindowController.OnReceivedPhotoPathListener listener) {
        this.mPhotoPathListener = listener;
    }

    public void setOnWindowChangedListener(CameraWindowController.OnWindowChangedLister listener) {
        this.mWindowChangedListener = listener;
    }

    private Activity getActivityContext() {
        Activity context = null;
        if (RuntimeContext.isHagoPartySdk()) {
            context = PartySdkActivityProxy.INSTANCE.getPartySdkActivity();
        }
        if (context == null) {
            context = (Activity)this.getCurrentWindow().getContext();
        }
        return context;
    }

    public void getPhoto() {
        switch (this.mMethod) {
            case 1: {
                this.takePhoto();
                break;
            }
            case 2: {
                this.proSelectPhoto();
                break;
            }
            case 4: {
                this.preSelectVideo();
                break;
            }
        }
    }

    private void preSelectVideo() {
        String s = "select system photo";
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
        this.adaTag(s);
        this.mTakePhoto = false;
        Intent intent = new Intent();
        intent.setType("video/*");
        intent.setAction("android.intent.action.PICK");
        try {
            this.getActivityContext().startActivityForResult(intent, 4);
        }
        catch (Exception ex) {
            FeatureLog.e((String)this.mCurFeatureLogTAG, (String)("select system vidwo fail " + ex), (Object[])new Object[0]);
        }
        s = "select system video method: video album";
        MLog.info((Object)TAG, (String)s, (Object[])new Object[0]);
        this.adaTag(s);
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
    }

    private void proSelectPhoto() {
        boolean isUseHagoPhoto;
        int flag = SettingFlags.getIntValue((String)"hago_photo_switch", (int)1);
        boolean bl = isUseHagoPhoto = SettingFlags.getIntValue((String)"hago_photo_location", (int)0) == 1;
        if ((0 == flag && isUseHagoPhoto || 1 == flag) && (this.mFrom == 5 || this.mFrom == 6 || this.mFrom == 7 || this.mFrom == 10)) {
            final String enter = this.mFrom == 6 ? "1" : (this.mFrom == 5 ? "2" : (this.mFrom == 7 ? "3" : "0"));
            HagoAlbum.OnChannelReport onSelect = new HagoAlbum.OnChannelReport(){

                public HiidoEvent getHiidoEvent() {
                    if (CameraController.this.getServiceManager().getService(IModuleProxyService.class) == null) {
                        return HiidoEvent.obtain();
                    }
                    return ((IModuleProxyService)CameraController.this.getServiceManager().getService(IModuleProxyService.class)).getPicStatEvent().put("picture_send_enter", enter);
                }

                public void onSelect(List<String> paths) {
                    Message message = Message.obtain();
                    message.what = BaseMsgDef.ALBUM_SELECTED_COUNT;
                    message.obj = paths;
                    message.arg1 = paths.size();
                    CameraController.this.sendMessage(message);
                    if (paths.size() > 0) {
                        CameraController.this.handleResult(paths.toArray(new String[paths.size()]), -1);
                    }
                    ((IModuleProxyService)CameraController.this.getServiceManager().getService(IModuleProxyService.class)).onPicSendClickStat(paths.size(), enter);
                }
            };
            if (this.mFrom == 7) {
                this.checkPermissionAndOpenPublishTools(this.mAlbumConfig, (HagoAlbum.OnSelect)onSelect);
            } else if (this.mFrom == 6) {
                if (this.mAlbumConfig.mMediaMode == 4) {
                    this.selectHagoPhoto((HagoAlbum.OnSelect)onSelect);
                } else {
                    this.checkPermissionAndOpenPublishTools(this.mAlbumConfig, (HagoAlbum.OnSelect)onSelect);
                }
            } else {
                this.selectHagoPhoto((HagoAlbum.OnSelect)onSelect);
            }
        } else {
            this.selectPhoto();
        }
    }

    private void checkPermissionAndOpenPublishTools(final AlbumConfig albumConfig, final HagoAlbum.OnSelect onSelect) {
        PermissionHelper.requestStoreAndCameraPermission((Activity)this.getActivity(), (IPermissionListener)new SimplePermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                PermissionHelper.requestRecordAudioPermission((Activity)CameraController.this.getActivity(), (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        CameraController.this.openNewPublishTools(albumConfig, onSelect);
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                        ToastUtils.showToast((Context)CameraController.this.mContext, (String)ResourceUtils.getString((int)R.string.permission_record_audio_access_instructions), (int)0);
                        MLog.warn((Object)CameraController.TAG, (String)" audio onPermissionDenied is fail", (Object[])new Object[0]);
                    }
                });
            }

            public void onPermissionDenied(@NonNull String[] permission) {
                ToastUtils.showToast((Context)CameraController.this.mContext, (String)ResourceUtils.getString((int)R.string.toast_no_camera_permission), (int)0);
                MLog.warn((Object)CameraController.TAG, (String)" store camera onPermissionDenied is fail", (Object[])new Object[0]);
            }
        });
    }

    private void openNewPublishTools(AlbumConfig albumConfig, HagoAlbum.OnSelect onSelect) {
        long defaultMode;
        HashMap<String, Long> bundle = new HashMap<String, Long>();
        switch (albumConfig.mFocusMediaTab) {
            case 2: {
                defaultMode = 4L;
                break;
            }
            case 1: {
                defaultMode = 2L;
                break;
            }
            case 8: {
                defaultMode = 8L;
                break;
            }
            default: {
                defaultMode = 1L;
            }
        }
        long enableMode = 15L;
        if (albumConfig.mMediaMode == 12) {
            enableMode = 3L;
        } else if (albumConfig.mMediaMode == 5) {
            enableMode = 13L;
        } else if (albumConfig.mMediaMode == 9) {
            enableMode = 4L;
        } else if (albumConfig.mMediaMode == 10) {
            enableMode = 8L;
        } else if (albumConfig.mMediaMode == 11) {
            enableMode = 2L;
        } else if (albumConfig.mMediaMode == 16) {
            enableMode = 14L;
        }
        if (albumConfig.toolMap.size() > 0) {
            String value;
            if (albumConfig.toolMap.containsKey("onlyVideo")) {
                value = albumConfig.toolMap.get("onlyVideo").toString();
                if ("1".equalsIgnoreCase(value)) {
                    albumConfig.mMediaMode = 5;
                    albumConfig.type = 3;
                    enableMode = 13L;
                } else if ("2".equalsIgnoreCase(value)) {
                    enableMode = 12L;
                }
            }
            if (albumConfig.toolMap.containsKey("onlyOneTab") && Boolean.valueOf(value = albumConfig.toolMap.get("onlyOneTab").toString()).booleanValue()) {
                enableMode = defaultMode;
            }
        }
        bundle.put("extra_record_mode", defaultMode);
        bundle.put("extra_enable_mode", enableMode);
        bundle.put("extra_album_argument", (Long)albumConfig);
        bundle.put("extra_album_onselect_callback", (Long)onSelect);
        MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.MSG_OPEN_NEW_RECORD_WINDOW, bundle);
    }

    private void selectHagoPhoto(HagoAlbum.OnSelect onSelect) {
        Set types = this.mAlbumConfig.type == 1 ? MimeType.ofAll() : (this.mAlbumConfig.type == 6 ? MimeType.ofExclusiveGif() : (this.mAlbumConfig.type == 5 ? MimeType.ofImageExclusiveGif() : (this.mAlbumConfig.type == 3 ? MimeType.ofVideo() : MimeType.ofImage())));
        HagoAlbum.from((Activity)this.getEnvironment().getActivity()).mimeTypes(types).spanCount(4).maxSelectable(this.mAlbumConfig.maxCount).originalMaxSize(this.mAlbumConfig.originalMaxSize).disableChannelMini(true).setShowType(this.mAlbumConfig.styleType).setMediaMode(this.mAlbumConfig.mMediaMode).from(this.mFrom).singleSelectMode(this.mAlbumConfig.singleSelectMode).config(this.mAlbumConfig).build(onSelect);
    }

    private void adaTag(String result) {
        switch (this.mCurFeatureLogTAG) {
            case "FTEditAvatarProfile": {
                BDAConst.bDAProfileEditAvatar((String)result);
                break;
            }
            case "FTModifyProfile": {
                BDAConst.bDAProfileModifyProfile((String)result);
                break;
            }
            case "FTAddAvatarProfile": {
                BDAConst.bDAProfileAddAvatar((String)result);
                break;
            }
        }
    }

    private void selectPhoto() {
        String s = "select system photo";
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
        this.adaTag(s);
        this.mTakePhoto = false;
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.PICK");
        try {
            this.getActivityContext().startActivityForResult(intent, 2);
        }
        catch (Exception ex) {
            FeatureLog.e((String)this.mCurFeatureLogTAG, (String)("select system photo fail " + ex), (Object[])new Object[0]);
            MLog.error((Object)((Object)this), (String)"selectPhoto fail, %s", (Throwable)ex, (Object[])new Object[0]);
            Intent retryIntent = new Intent();
            retryIntent.setType("image/*");
            retryIntent.setAction("android.intent.action.GET_CONTENT");
            try {
                this.getActivityContext().startActivityForResult(intent, 2);
            }
            catch (Exception exception) {
                FeatureLog.e((String)this.mCurFeatureLogTAG, (String)("select system photo retry fail " + ex), (Object[])new Object[0]);
                MLog.error((Object)((Object)this), (String)"selectPhoto retry fail, %s", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        s = "select system photo method: gallery";
        MLog.info((Object)TAG, (String)s, (Object[])new Object[0]);
        this.adaTag(s);
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
    }

    public boolean getIsTakePhoto() {
        return this.mTakePhoto;
    }

    private void takePhoto() {
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)"invoke system take photo", (Object[])new Object[0]);
        this.adaTag("invoke system take photo");
        this.mTakePhoto = true;
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.mCameraCapturingName = AccountUtil.getUid() + "_" + System.currentTimeMillis() + ".jpg";
        File out = YYFileUtils.getTempFile((Context)this.getCurrentWindow().getContext(), (String)this.mCameraCapturingName);
        out.delete();
        Uri uri = this.getUriForFile(out);
        intent.putExtra("output", (Parcelable)uri);
        try {
            this.getActivityContext().startActivityForResult(intent, 1);
        }
        catch (Exception ex) {
            FeatureLog.i((String)this.mCurFeatureLogTAG, (String)("invoke system take photo fail " + ex), (Object[])new Object[0]);
            MLog.error((Object)TAG, (String)"takePotoFromCamera fail, %s", (Throwable)ex, (Object[])new Object[0]);
        }
        MLog.info((Object)TAG, (String)"pick photo method: take photo", (Object[])new Object[0]);
        this.adaTag("invoke system take photo  method: take photo");
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)"invoke system take photo  method: take photo", (Object[])new Object[0]);
    }

    private Uri getUriForFile(@NonNull File file) {
        Uri uri;
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                uri = HagoFileProvider.getUriForFile((Context)this.mContext, (String)(AppKeysDef.getAppPackageName() + ".fileprovider"), (File)file);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                uri = Uri.fromFile((File)file);
            }
        } else {
            uri = Uri.fromFile((File)file);
        }
        return uri;
    }

    public int getStyle() {
        return this.mStyle;
    }

    public int getMethod() {
        return this.mMethod;
    }

    public float getCropRatio() {
        return this.mCropRatio;
    }

    public int getFrom() {
        return this.mFrom;
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindowChangedListener != null) {
            this.mWindowChangedListener.onDetach(abstractWindow);
        }
        this.mPresenter = null;
    }

    public void finish() {
        this.sendMessageSync(CameraMsgDef.MSG_HIDE_WINDOW_PHOTO_PICK);
    }

    private void handleResult(String[] paths, int requestCode) {
        if (this.mAlbumConfig.styleType == 2 || this.mAlbumConfig.styleType == 3 || this.mAlbumConfig.styleType == 4) {
            if (paths.length == 1) {
                if (!this.validateImages(paths[0])) {
                    this.handleVideoTypeResult(paths, requestCode);
                } else {
                    this.handlePhotoTypeResult(paths, requestCode);
                }
            } else {
                this.handlePhotoTypeResult(paths, requestCode);
            }
        } else {
            this.handlePhotoTypeResult(paths, requestCode);
        }
    }

    private void handlePhotoTypeResult(String[] paths, int requestCode) {
        if (this.mPresenter != null) {
            this.mPresenter.handleResult(paths, requestCode);
        } else {
            this.compressBatch(paths, null);
        }
    }

    private void handleVideoTypeResult(String[] paths, int requestCode) {
        if (paths.length == 1) {
            Bundle data = new Bundle();
            data.putString("key_image_path", paths[0]);
            this.sendResultOk(data, true);
        }
    }

    public void sendResultOk(final Bundle data, boolean isVideo) {
        final String filePath = data.getString("key_image_path");
        if (SdkVersionUtils.hasScopedStorage() && YYFileUtils.isContentUri((String)filePath)) {
            final File imageFile = YYFileUtils.getTempFile((Context)this.mContext, (String)(AccountUtil.getUid() + "_" + System.currentTimeMillis() + (isVideo ? ".mp4" : ".jpg")));
            this.showLoadingDialog();
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    YYFileUtils.copyFileFromUri((Uri)Uri.parse((String)filePath), (String)imageFile.getPath());
                    data.putString("key_image_path", imageFile.getAbsolutePath());
                    final Message msg = Message.obtain();
                    data.putInt("key_request_code", CameraController.this.mRequestCode);
                    data.putInt("key_result", 1);
                    msg.what = CameraMsgDef.MSG_PHOTO_FINISH_RESULT;
                    msg.setData(data);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CameraController.this.sendMessageSync(msg);
                            CameraController.this.hideLoadingDialog();
                            CameraController.this.finish();
                        }
                    });
                }
            });
        } else {
            Message msg = Message.obtain();
            data.putInt("key_request_code", this.mRequestCode);
            data.putInt("key_result", 1);
            msg.what = CameraMsgDef.MSG_PHOTO_FINISH_RESULT;
            msg.setData(data);
            this.sendMessageSync(msg);
            this.finish();
        }
    }

    public void sendPatchPathsOk(CopyOnWriteArrayList<BasicMediaInfo> photos) {
        Message msg = Message.obtain();
        msg.what = CameraMsgDef.MSG_PATCH_HANDLE_BACK;
        msg.obj = photos;
        this.sendMessageSync(msg);
    }

    public void sendResultFailed() {
        Message msg = Message.obtain();
        Bundle data = new Bundle();
        data.putInt("key_request_code", this.mRequestCode);
        data.putInt("key_result", 2);
        msg.what = CameraMsgDef.MSG_PHOTO_FINISH_RESULT;
        msg.setData(data);
        this.sendMessageSync(msg);
        this.finish();
    }

    public void sendResultCanceled() {
        Message msg = Message.obtain();
        Bundle data = new Bundle();
        data.putInt("key_request_code", this.mRequestCode);
        data.putInt("key_result", 3);
        msg.what = CameraMsgDef.MSG_PHOTO_FINISH_RESULT;
        msg.setData(data);
        this.sendMessageSync(msg);
        this.finish();
    }

    public void onBackHandler() {
        this.sendMessageSync(CameraMsgDef.MSG_PHOTO_BACK_HANDLER);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CameraController.this.finish();
            }
        }, (long)800L);
    }

    public void compress(String path, final OnCompressListener listener) {
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)("compress patch = " + path), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)path) || !this.validateImages(path)) {
            MLog.info((Object)TAG, (String)"path is null or is not image", (Object[])new Object[0]);
            this.sendMessage(BaseMsgDef.MSG_CHECK_STORAGE);
            return;
        }
        String ext = YYFileUtils.getFileExtension((String)path);
        if (TextUtils.isEmpty((CharSequence)ext)) {
            File imageFile = YYFileUtils.getTempFile((Context)this.mContext, (String)(AccountUtil.getUid() + "_" + System.currentTimeMillis() + ".jpg"));
            YYFileUtils.copyFile((String)path, (String)imageFile.getAbsolutePath());
            path = imageFile.getPath();
        }
        File temp = YYFileUtils.getTempFile((Context)this.mContext, (String)"");
        String tempPath = temp.getPath();
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)("compress target path = " + tempPath), (Object[])new Object[0]);
        MLog.info((Object)TAG, (String)("compress target path: " + tempPath), (Object[])new Object[0]);
        Luban.with((Context)this.mContext).load(path).setTargetDir(tempPath).filter(path1 -> !TextUtils.isEmpty((CharSequence)path1) && !path1.toLowerCase().endsWith(".gif")).setCompressListener(new OnCompressListener(){

            public void onStart() {
                CameraController.this.adaTag("compress onStart");
                FeatureLog.i((String)CameraController.this.mCurFeatureLogTAG, (String)"compress onStart", (Object[])new Object[0]);
                MLog.info((Object)CameraController.TAG, (String)"compress started", (Object[])new Object[0]);
                if (listener != null) {
                    listener.onStart();
                }
            }

            public void onSuccess(File file) {
                if (!YYImageUtils.isImage((File)file)) {
                    CameraController.this.adaTag("compress onSelected, but file don`t image, fail");
                    FeatureLog.i((String)CameraController.this.mCurFeatureLogTAG, (String)"compress onSelected, but file don`t image, fail", (Object[])new Object[0]);
                    MLog.error((Object)CameraController.TAG, (String)"compress failed", (Object[])new Object[0]);
                    YYFileUtils.delete((File)file);
                    return;
                }
                CameraController.this.adaTag("compress onSelected");
                FeatureLog.i((String)CameraController.this.mCurFeatureLogTAG, (String)"compress onSelected", (Object[])new Object[0]);
                MLog.info((Object)CameraController.TAG, (String)"compress success", (Object[])new Object[0]);
                if (listener != null) {
                    listener.onSuccess(file);
                }
            }

            public void onError(Throwable e) {
                CameraController.this.adaTag("compress onError due = " + e);
                FeatureLog.i((String)CameraController.this.mCurFeatureLogTAG, (String)("compress onError due = " + e), (Object[])new Object[0]);
                MLog.error((Object)CameraController.TAG, (String)("compress error : " + e.toString()), (Object[])new Object[0]);
                CameraController.this.sendMessage(BaseMsgDef.MSG_CHECK_STORAGE);
                if (listener != null) {
                    listener.onError(e);
                }
            }

            public void onPatchCompressFinish(CopyOnWriteArrayList<BasicMediaInfo> photos) {
                if (listener != null) {
                    listener.onPatchCompressFinish(photos);
                }
            }
        }).launch();
    }

    public void compressBatch(String[] paths, final OnCompressListener listener) {
        for (String path2 : paths) {
            FeatureLog.i((String)this.mCurFeatureLogTAG, (String)("compressBatch patch = " + path2), (Object[])new Object[0]);
            if (!TextUtils.isEmpty((CharSequence)path2) && this.validateImages(path2)) continue;
            MLog.info((Object)TAG, (String)"compressBatch, path is null or is not image", (Object[])new Object[0]);
            this.sendMessage(BaseMsgDef.MSG_CHECK_STORAGE);
            return;
        }
        File temp = new File(YYFileUtils.getYYTempDir() + File.separator + AccountUtil.getUid() + File.separator + "image");
        if (!temp.exists()) {
            temp.mkdirs();
        }
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)("compressBatch target path = " + temp), (Object[])new Object[0]);
        Luban.with((Context)this.mContext).load(Arrays.asList(paths)).setTargetDir(temp.getAbsolutePath()).filter(path -> !TextUtils.isEmpty((CharSequence)path) && !path.toLowerCase().endsWith(".gif")).setCompressListener(new OnCompressListener(){

            public void onStart() {
                CameraController.this.adaTag("compressBatch onStart");
                FeatureLog.i((String)CameraController.this.mCurFeatureLogTAG, (String)"compressBatch onStart", (Object[])new Object[0]);
                if (listener != null) {
                    listener.onStart();
                }
            }

            public void onSuccess(File file) {
                if (!YYImageUtils.isImage((File)file)) {
                    CameraController.this.adaTag("compressBatch onSelected, but file don`t image, fail");
                    FeatureLog.i((String)CameraController.this.mCurFeatureLogTAG, (String)"compressBatch onSelected, but file don`t image, fail", (Object[])new Object[0]);
                    return;
                }
                CameraController.this.adaTag("compressBatch onSelected");
                FeatureLog.i((String)CameraController.this.mCurFeatureLogTAG, (String)"compressBatch onSuccess", (Object[])new Object[0]);
                Bundle data = new Bundle();
                data.putString("key_image_path", file.getAbsolutePath());
                CameraController.this.sendResultOk(data, false);
                if (listener != null) {
                    listener.onSuccess(file);
                }
            }

            public void onError(Throwable e) {
                CameraController.this.adaTag("compressBatch onError due = " + e);
                FeatureLog.i((String)CameraController.this.mCurFeatureLogTAG, (String)("compressBatch onError due = " + e), (Object[])new Object[0]);
                CameraController.this.sendMessage(BaseMsgDef.MSG_CHECK_STORAGE);
                CameraController.this.sendResultFailed();
                if (listener != null) {
                    listener.onError(e);
                }
            }

            public void onPatchCompressFinish(CopyOnWriteArrayList<BasicMediaInfo> photos) {
                CameraController.this.sendPatchPathsOk(photos);
            }
        }).launch();
    }

    public void checkLowQuality(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        if (this.mMethod == 4) {
            if (this.mPresenter != null) {
                this.mPresenter.upload();
            }
            return;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        YYImageUtils.decodeFile((String)path, (BitmapFactory.Options)options);
        int size = options.outHeight < options.outWidth ? options.outHeight : options.outWidth;
        if (this.mFrom != 3 && this.mFrom != 5) {
            if (YYFileUtils.getFileLength((String)path) < 10240L || size < 300) {
                MLog.info((Object)TAG, (String)"show low quality dialog", (Object[])new Object[0]);
                this.mDialogLinkManager.showDialog((BaseDialog)this.mDialog);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026515").put("function_id", "show"));
            } else if (this.mPresenter != null) {
                this.mPresenter.upload();
            }
        } else if (this.mPresenter != null) {
            this.mPresenter.upload();
        }
    }

    public void onActivityResult(final int requestCode, final int resultCode, final Intent data) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                CameraController.this.onActivityResultBg(requestCode, resultCode, data);
            }
        });
    }

    private void onActivityResultBg(final int requestCode, int resultCode, Intent data) {
        String s = "onActivityResult requestCode " + requestCode + "  resultCode = " + resultCode;
        this.adaTag(s);
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
        String[] paths = null;
        if (resultCode == -1) {
            if (requestCode == 240) {
                if (data != null) {
                    ArrayList pathList = data.getStringArrayListExtra("result_params_selected_paths");
                    paths = new String[pathList.size()];
                    pathList.toArray(paths);
                }
                s = "onActivityResult PhotoPickConst.Method.GALLERY_MULTI paths size = " + (paths != null ? paths.length : 0);
                this.adaTag(s);
                FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
            } else {
                Uri uri;
                String filePath;
                boolean hasPath = false;
                if (requestCode == 1) {
                    File file = YYFileUtils.getTempFile((Context)this.getCurrentWindow().getContext(), (String)this.mCameraCapturingName);
                    filePath = file.getPath();
                    s = "onActivityResult CAMERA file path = " + filePath;
                    this.adaTag(s);
                    FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
                    if (YYImageUtils.isImage((File)file)) {
                        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)"onActivityResult CAMERA file is Image = true", (Object[])new Object[0]);
                        paths = new String[]{filePath};
                        hasPath = true;
                    }
                } else if (requestCode == 3) {
                    filePath = data.getStringExtra("key_image_path");
                    hasPath = true;
                    paths = new String[]{filePath};
                } else if ((requestCode == 2 || requestCode == 4) && SdkVersionUtils.hasScopedStorage()) {
                    uri = data.getData();
                    if (!YYFileUtils.isContentUri((String)uri.toString())) {
                        return;
                    }
                    filePath = YYFileUtils.getRealValidPath((Uri)uri);
                    paths = new String[]{filePath};
                    hasPath = true;
                }
                if (!hasPath && data != null) {
                    uri = data.getData();
                    s = "onActivityResult data.getData() uri = " + uri + "  uri.getPath() = " + (uri != null ? uri.getPath() : "uri is null") + "  uri.toString() = " + (uri != null ? uri.toString() : "uri is null") + " uri.getScheme()" + (uri != null ? uri.getScheme() : "uri is null");
                    this.adaTag(s);
                    FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
                    paths = new String[]{YYFileUtils.getFilePathFromUri((Context)this.getCurrentWindow().getContext(), (Uri)uri)};
                    s = "onActivityResult data.getData() paths = " + paths[0];
                    this.adaTag(s);
                    FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
                    if (StringUtils.isEmpty((String)paths[0])) {
                        SettingFlags.setIntValue((String)"hago_photo_location", (int)1);
                        this.statSelectPhoteFail(uri);
                    }
                }
            }
            if (paths != null && paths.length > 0) {
                s = "onActivityResult paths length = " + paths.length;
                this.adaTag(s);
                FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
                final String path = paths[0];
                s = "onActivityResult onReceived paths[0] = " + path;
                this.adaTag(s);
                FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
                final String[] pathsArray = paths;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (CameraController.this.mPhotoPathListener != null) {
                            CameraController.this.mPhotoPathListener.onReceived(path);
                        }
                        CameraController.this.handleResult(pathsArray, requestCode);
                    }
                });
            } else {
                if (paths == null) {
                    s = "onActivityResult sendResultFailed paths = " + paths;
                    this.adaTag(s);
                    FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
                } else {
                    s = "onActivityResult sendResultFailed paths is not image";
                    this.adaTag(s);
                    FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CameraController.this.sendResultFailed();
                    }
                });
            }
        } else if (resultCode == 0) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CameraController.this.sendResultCanceled();
                }
            });
        }
        s = "onActivityResult paths = " + paths;
        this.adaTag(s);
        FeatureLog.i((String)this.mCurFeatureLogTAG, (String)s, (Object[])new Object[0]);
    }

    private void statSelectPhoteFail(Uri uri) {
        String uriNull = "uri null";
        String path = uri != null ? uri.getPath() : uriNull;
        String toString = uri != null ? uri.toString() : uriNull;
        String scheme = uri != null ? uri.getScheme() : uriNull;
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("sfield", path);
        statContent.put("sfieldtwo", toString);
        statContent.put("sfieldthree", scheme);
        statContent.put("perftype", "selectphoto");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public boolean validateImages(String path) {
        String[] paths = new String[]{path};
        return this.validateImages(paths);
    }

    public boolean validateImages(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (YYImageUtils.isImage((String)path)) continue;
            return false;
        }
        return true;
    }

    public void showLoadingDialog() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager(this.mContext);
        }
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.str_tips_processing), true, false, null));
    }

    public void hideLoadingDialog() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
        }
    }

    protected boolean onWindowBackKeyEvent() {
        MLog.info((Object)TAG, (String)"onWindowBackKeyEvent", (Object[])new Object[0]);
        if (this.mPresenter != null) {
            this.mPresenter.onCancel();
        }
        return true;
    }
}

