/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.R;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.camera.R;
import java.util.List;

public class BottomSelectDialog
implements BaseDialog {
    protected ViewGroup mContentView;
    private TextView mCancelBtn;
    private TextView mTitle;
    private List<ButtonItem> buttons;
    private String title;
    private ButtonItem bottomButton;
    private boolean outsideCancelable = true;
    private boolean cancelable = true;
    private Context mContext;

    public BottomSelectDialog(Context context, String title, List<ButtonItem> buttons, String cancelBtnText) {
        this(context, title, buttons, new ButtonItem(cancelBtnText, null));
    }

    public BottomSelectDialog(Context context, String title, List<ButtonItem> buttons, ButtonItem bottomButton) {
        this.mContext = context;
        this.buttons = buttons;
        this.title = title;
        this.bottomButton = bottomButton;
    }

    public void init(final Dialog dialog) {
        Window window = dialog.getWindow();
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.outsideCancelable);
        if (window == null) {
            return;
        }
        window.setContentView(R.layout.layout_bottom_select_dialog);
        this.mContentView = (ViewGroup)window.findViewById(R.id.ll_more);
        this.mTitle = (TextView)window.findViewById(R.id.tv_title);
        this.mCancelBtn = (TextView)window.findViewById(R.id.btn_cancel);
        this.mCancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BottomSelectDialog.this.bottomButton != null && ((BottomSelectDialog)BottomSelectDialog.this).bottomButton.mClickListener != null) {
                    ((BottomSelectDialog)BottomSelectDialog.this).bottomButton.mClickListener.onClick();
                }
                dialog.dismiss();
            }
        });
        WindowManager.LayoutParams params = window.getAttributes();
        params.height = -2;
        params.width = -1;
        window.setGravity(80);
        window.setAttributes(params);
        window.setWindowAnimations(R.style.DialogAnimation);
        if (this.buttons != null && this.buttons.size() > 0) {
            if (this.title != null && !this.title.isEmpty()) {
                this.mTitle.setVisibility(0);
                this.mTitle.setText((CharSequence)this.title);
            }
            this.mContentView.setVisibility(0);
            for (int i = 0; i < this.buttons.size(); ++i) {
                if (i == 0) {
                    if (this.title != null && !this.title.isEmpty()) {
                        this.addDivider();
                    }
                } else {
                    this.addDivider();
                }
                this.addItem(this.buttons.get(i), dialog);
            }
        }
    }

    public void addDivider() {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, 1);
        YYView view = new YYView(this.mContext);
        view.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_eeeeee));
        view.setLayoutParams(layoutParams);
        this.mContentView.addView((View)view, this.mContentView.getChildCount());
    }

    public void addItem(final ButtonItem buttonItem, final Dialog dialog) {
        if (buttonItem == null) {
            return;
        }
        YYTextView item = new YYTextView(this.mContext);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, ResolutionUtils.dip2Px((float)60.0f));
        item.setLayoutParams(layoutParams);
        item.setGravity(8388627);
        item.setPadding(ResolutionUtils.dip2Px((float)15.0f), 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 17) {
            item.setTextAlignment(5);
            item.setPaddingRelative(ResolutionUtils.dip2Px((float)15.0f), 0, 0, 0);
        }
        item.setBackgroundResource(R.drawable.popup_dialog_btn_color_cancel);
        item.setTextSize(0, (float)ResourceUtils.getDimen((int)R.dimen.bottom_select_item_size));
        item.setTextColor(ResourceUtils.getColor((int)R.color.black_0b0505));
        item.setText((CharSequence)buttonItem.mText);
        item.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (buttonItem.mClickListener != null) {
                    buttonItem.mClickListener.onClick();
                }
                dialog.dismiss();
            }
        });
        this.mContentView.addView((View)item, this.mContentView.getChildCount());
    }

    public int getId() {
        return DialogId.BottomSelectDialog;
    }
}

