/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.view;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.room.INoRoomMiniWindow;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.AlbumSelectMsgDef;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.HagoAlbum;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.IncapableCause;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Item;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model.SelectedItemCollection;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter.PreviewAdapter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.CheckView;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.PreviewViewPager;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.utils.PhotoMetadataUtils;
import java.util.ArrayList;
import java.util.List;

public class SelectPreviewMain
extends DefaultWindow
implements INoRoomMiniWindow,
View.OnClickListener,
ViewPager.OnPageChangeListener {
    private YYImageView mYYImageViewBack;
    private CheckView mCheckView;
    private RelativeLayout mRlTop;
    private YYFrameLayout mYYFrameLayoutSend;
    private PreviewViewPager mPreviewViewPager;
    private PreviewAdapter mPreviewAdapter;
    private Bundle mBundle;
    private SelectedItemCollection mSelectedItemCollection;
    protected int mPreviousPos = -1;
    private HagoAlbum.OnSelect mOnSelect;
    private boolean isDisableChannelMini;
    private final int mFrom;

    public SelectPreviewMain(Context context, UICallBacks callBacks, Bundle bundle, SelectedItemCollection selectedItemCollection, HagoAlbum.OnSelect onSelect, Boolean isDisableChannelMini, int from) {
        super(context, callBacks, "SelectPreviewMain");
        this.isDisableChannelMini = isDisableChannelMini;
        this.mBundle = bundle;
        this.mSelectedItemCollection = selectedItemCollection;
        this.mOnSelect = onSelect;
        this.mFrom = from;
        this.init();
    }

    private void init() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.album_preview_main, null);
        this.mYYImageViewBack = (YYImageView)view.findViewById(R.id.simple_title_left_image);
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.icon_nav_back);
        drawable2.setColorFilter(ColorUtils.parseColor((String)"#ffffff"), PorterDuff.Mode.SRC_IN);
        this.mYYImageViewBack.setImageDrawable(drawable2);
        this.mYYImageViewBack.setOnClickListener(v -> MsgDispatcher.getInstance().sendMessage(AlbumSelectMsgDef.MSG_CLOSE_PREVIEW_SELECT));
        this.mRlTop = (RelativeLayout)view.findViewById(R.id.rl_top);
        this.mCheckView = (CheckView)view.findViewById(R.id.check_view);
        this.mYYFrameLayoutSend = (YYFrameLayout)view.findViewById(R.id.album_fl_send);
        this.mYYFrameLayoutSend.setOnClickListener((View.OnClickListener)this);
        this.mPreviewViewPager = (PreviewViewPager)view.findViewById(R.id.pager);
        this.mPreviewViewPager.addOnPageChangeListener(this);
        this.getBaseLayer().addView(view);
        this.mPreviewAdapter = new PreviewAdapter(this.getContext());
        this.mPreviewViewPager.setAdapter(this.mPreviewAdapter);
        SelectionSpec.getInstance().countable = true;
        this.mCheckView.setOnClickListener(v -> {
            Item item = this.mPreviewAdapter.getMediaItem(this.mPreviewViewPager.getCurrentItem());
            if (this.mSelectedItemCollection.isSelected(item)) {
                this.mSelectedItemCollection.remove(item);
                if (SelectionSpec.getInstance().countable) {
                    this.mCheckView.setCheckedNum(Integer.MIN_VALUE);
                } else {
                    this.mCheckView.setChecked(false);
                }
            } else if (this.assertAddSelection(item)) {
                this.mSelectedItemCollection.add(item);
                if (SelectionSpec.getInstance().countable) {
                    this.mCheckView.setCheckedNum(this.mSelectedItemCollection.checkedNumOf(item));
                } else {
                    this.mCheckView.setChecked(true);
                }
            }
            MsgDispatcher.getInstance().sendMessageSync(AlbumSelectMsgDef.MSG_NOTIFY_ABLUM_SELECT);
            MsgDispatcher.getInstance().sendMessageSync(AppbaseMsgDef.MSG_FRESH_ALBUM_SELECTINFO);
            this.updateApplyButton();
        });
        ArrayList selected = this.mBundle.getParcelableArrayList("state_selection");
        int selectPostion = this.mBundle.getInt("cur_select_position");
        this.mPreviewAdapter.addAll(selected);
        this.mPreviewAdapter.notifyDataSetChanged();
        this.mPreviewViewPager.setCurrentItem(selectPostion, true);
        this.mCheckView.setCountable(true);
        if (SelectionSpec.getInstance().countable) {
            this.mCheckView.setCheckedNum(selectPostion + 1);
        } else {
            this.mCheckView.setChecked(true);
        }
    }

    public int getStatusBarColor() {
        return -16777216;
    }

    public boolean isTranslucentBar() {
        return true;
    }

    public View getNeedOffsetView() {
        return this.mRlTop;
    }

    private boolean assertAddSelection(Item item) {
        IncapableCause cause = this.mSelectedItemCollection.isAcceptable(item);
        IncapableCause.handleCause(this.getContext(), cause);
        return cause == null;
    }

    private void updateApplyButton() {
        int selectedCount = this.mSelectedItemCollection.count();
        if (selectedCount == 0) {
            this.mYYFrameLayoutSend.setEnabled(false);
        } else if (selectedCount == 1 && SelectionSpec.getInstance().singleSelectionModeEnabled()) {
            this.mYYFrameLayoutSend.setEnabled(true);
        } else {
            this.mYYFrameLayoutSend.setEnabled(true);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.album_fl_send) {
            MsgDispatcher.getInstance().sendMessage(AlbumSelectMsgDef.MSG_CLOSE_PREVIEW_SELECT);
            List<String> pathList = this.mSelectedItemCollection.asListOfString();
            if (!FP.empty(pathList)) {
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.MSG_OPEN_NEW_RECORE_IMGEDIT_WINDOW, pathList);
            } else {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.select_file_not_exist);
            }
        }
    }

    private void fixPhotoInfoAndNotify(List<Item> selectedList) {
        YYTaskExecutor.execute(() -> {
            ArrayList<BasicMediaInfo> mPhotos = new ArrayList<BasicMediaInfo>();
            for (int i = 0; i < selectedList.size(); ++i) {
                BasicMediaInfo basicMediaInfo = new BasicMediaInfo();
                basicMediaInfo.path = YYFileUtils.getFilePathFromUri((Context)this.getContext(), (Uri)((Item)selectedList.get((int)i)).uri);
                if (!YYFileUtils.isFileExisted((String)basicMediaInfo.path)) continue;
                basicMediaInfo.width = ((Item)selectedList.get((int)i)).width;
                basicMediaInfo.height = ((Item)selectedList.get((int)i)).height;
                if (basicMediaInfo.width == 0 && basicMediaInfo.height == 0) {
                    Point point = YYImageUtils.getBitmapBound((ContentResolver)this.getContext().getContentResolver(), (Uri)((Item)selectedList.get((int)i)).uri);
                    basicMediaInfo.width = point.x;
                    basicMediaInfo.height = point.y;
                }
                MLog.info((Object)"AbstractWindow", (String)(" photo need index=" + i + "\uff0cphoto size:" + basicMediaInfo.width + " " + basicMediaInfo.height), (Object[])new Object[0]);
                boolean isRatate = PhotoMetadataUtils.shouldRotate(basicMediaInfo.path);
                if (isRatate) {
                    basicMediaInfo.height = ((Item)selectedList.get((int)i)).width;
                    basicMediaInfo.width = ((Item)selectedList.get((int)i)).height;
                    MLog.info((Object)"AbstractWindow", (String)(" photo need rotate index=" + i + " " + basicMediaInfo.width + " " + basicMediaInfo.height), (Object[])new Object[0]);
                }
                mPhotos.add(basicMediaInfo);
            }
            YYTaskExecutor.postToMainThread(() -> {
                Message message = Message.obtain();
                message.what = AlbumSelectMsgDef.MSG_NOTIFY_SELECTED_INFO;
                message.obj = mPhotos;
                message.arg1 = 1;
                MsgDispatcher.getInstance().sendMessage(message);
            });
        });
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mPreviousPos != -1 && this.mPreviousPos != position) {
            this.mPreviewAdapter.resetView((ViewGroup)this.mPreviewViewPager, this.mPreviousPos);
            Item item = this.mPreviewAdapter.getMediaItem(position);
            if (SelectionSpec.getInstance().countable) {
                int checkedNum = this.mSelectedItemCollection.checkedNumOf(item);
                this.mCheckView.setCheckedNum(checkedNum);
                if (checkedNum > 0) {
                    this.mCheckView.setEnabled(true);
                } else {
                    this.mCheckView.setEnabled(!this.mSelectedItemCollection.maxSelectableReached());
                }
            } else {
                boolean checked = this.mSelectedItemCollection.isSelected(item);
                this.mCheckView.setChecked(checked);
                if (checked) {
                    this.mCheckView.setEnabled(true);
                } else {
                    this.mCheckView.setEnabled(!this.mSelectedItemCollection.maxSelectableReached());
                }
            }
        }
        this.mPreviousPos = position;
    }

    public void onPageSelected(int position) {
    }

    public void onPageScrollStateChanged(int state) {
    }

    public boolean isDisableChannelMini() {
        return this.isDisableChannelMini;
    }
}

