/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.view;

import android.content.Context;
import android.database.Cursor;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYRecyclerView;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.AlbumAdapterConfig;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Album;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Item;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model.AlbumMediaCollection;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model.SelectedItemCollection;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter.AlbumMediaAdapter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.MediaGridInset;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.utils.UIUtils;

public class MediaSelectionView
extends YYFrameLayout
implements AlbumMediaCollection.AlbumMediaCallbacks,
AlbumMediaAdapter.CheckStateListener,
AlbumMediaAdapter.OnCameraClick {
    private final AlbumMediaCollection mAlbumMediaCollection = new AlbumMediaCollection();
    private RecyclerView mRecyclerView;
    private AlbumMediaAdapter mAdapter;
    private AlbumMediaAdapter.CheckStateListener mCheckStateListener;
    private String mId;
    private int mShowType;
    private int mMdeiaMode;
    private AlbumAdapterConfig mAlbumAdapterConfig;

    public MediaSelectionView(int showType, int mediaMode, Context context, Album album, AlbumAdapterConfig config, AlbumMediaAdapter.CheckStateListener checkStateListener, SelectedItemCollection selectedItemCollection) {
        super(context);
        this.mShowType = showType;
        this.mAlbumAdapterConfig = config;
        this.mId = album.getId();
        this.mCheckStateListener = checkStateListener;
        this.mMdeiaMode = mediaMode;
        this.init(album, selectedItemCollection);
    }

    public String getAlbumId() {
        return this.mId;
    }

    private void init(Album album, SelectedItemCollection selectedItemCollection) {
        this.mRecyclerView = new YYRecyclerView(this.getContext(), "MediaSelectionView");
        this.addView((View)this.mRecyclerView, (ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -1));
        this.mAdapter = new AlbumMediaAdapter(this.mShowType, this.mAlbumAdapterConfig, selectedItemCollection, this.mRecyclerView);
        this.mAdapter.registerCheckStateListener(this);
        this.mAdapter.registerCameraClickListener(this);
        this.mRecyclerView.setHasFixedSize(true);
        SelectionSpec selectionSpec = SelectionSpec.getInstance();
        int spanCount = selectionSpec.gridExpectedSize > 0 ? UIUtils.spanCount(this.getContext(), selectionSpec.gridExpectedSize) : selectionSpec.spanCount;
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), spanCount));
        int spacing = this.getResources().getDimensionPixelSize(R.dimen.media_grid_spacing);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new MediaGridInset(spanCount, spacing, false));
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mAlbumMediaCollection.onCreate((FragmentActivity)this.getContext(), this);
        this.mAlbumMediaCollection.load(album, SelectionSpec.getInstance().capture);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAlbumMediaCollection.onDestroy();
        this.mAdapter.unregisterCheckStateListener();
    }

    @Override
    public void onAlbumMediaLoad(Cursor cursor) {
        MLog.error((Object)"vanda", (String)"onAlbumMediaLoad", (Object[])new Object[0]);
        this.mAdapter.swapCursor(cursor);
    }

    @Override
    public void onAlbumMediaReset() {
        MLog.error((Object)"vanda", (String)"onAlbumMediaReset", (Object[])new Object[0]);
        this.mAdapter.swapCursor(null);
    }

    @Override
    public void onUpdate() {
        if (this.mCheckStateListener != null) {
            this.mCheckStateListener.onUpdate();
        }
    }

    @Override
    public Boolean onMediaClick(Album album, Item item, int adapterPosition) {
        if (this.mCheckStateListener != null) {
            return this.mCheckStateListener.onMediaClick(album, item, adapterPosition);
        }
        return false;
    }

    @Override
    public void onSelectItem(Item item, int position) {
        if (this.mCheckStateListener != null) {
            this.mCheckStateListener.onSelectItem(item, position);
        }
    }

    public void notifyDataSetChanged() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onCameraClick(int type) {
        if (this.mShowType == 2 || this.mShowType == 3 || this.mShowType == 4) {
            if (this.mCheckStateListener != null && this.mCheckStateListener instanceof AlbumMediaAdapter.OnCameraClick) {
                ((AlbumMediaAdapter.OnCameraClick)((Object)this.mCheckStateListener)).onCameraClick(type);
            } else {
                MLog.error((Object)"MediaSelectionView", (String)"No Callback??", (Object[])new Object[0]);
            }
        } else {
            Message message = Message.obtain();
            message.what = AppbaseMsgDef.MSG_OPEN_VIDEO_RECORD_WINDOW;
            message.arg1 = this.mMdeiaMode;
            MsgDispatcher.getInstance().sendMessage(message);
        }
    }
}

