/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.view;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.room.INoRoomMiniWindow;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.AlbumSelectMsgDef;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.AlbumAdapterConfig;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.HagoAlbum;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.MimeType;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Album;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Item;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model.AlbumCollection;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.model.SelectedItemCollection;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter.AlbumMediaAdapter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter.AlbumsAdapter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.AlbumsSpinner;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.utils.PhotoMetadataUtils;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.view.MediaSelectionView;
import com.yy.hiyo.videorecord.IVideoRecordService;
import com.yy.hiyo.videorecord.bean.SdkMediaInfoWrapper;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

public class AlbumSelectPage
extends YYLinearLayout
implements AdapterView.OnItemSelectedListener,
INoRoomMiniWindow,
AlbumCollection.AlbumCallbacks,
AlbumMediaAdapter.CheckStateListener,
View.OnClickListener,
AlbumMediaAdapter.OnCameraClick {
    private static final String TAG = "AlbumSelectPage";
    private AlbumsSpinner mAlbumsSpinner;
    private AlbumsAdapter mAlbumsAdapter;
    private SimpleTitleBar mSimpleTitleBar;
    private MediaSelectionView mMediaSelectionView;
    private RelativeLayout mRelativeLayout;
    private final AlbumCollection mAlbumCollection = new AlbumCollection();
    private final SelectedItemCollection mSelectedItemCollection = new SelectedItemCollection(this.getContext());
    private YYTextView mSendView;
    private HagoAlbum.OnSelect mOnSelect;
    private boolean isDisableChannelMini;
    private int mShowType;
    private int mMediaMode;
    private AlbumAdapterConfig mAlbumAdapterConfig;
    private AlbumMediaAdapter.OnCameraClick mCameraClick = null;

    public AlbumSelectPage(Context context, AlbumAdapterConfig config) {
        super(context);
        this.mOnSelect = config.mOnSelect;
        this.mShowType = config.mShowType;
        this.mMediaMode = config.mMediaMode;
        this.mAlbumAdapterConfig = config;
        this.isDisableChannelMini = config.mIsDisableChannelMini;
        this.initParam();
        this.init();
    }

    private void initParam() {
        this.mSelectedItemCollection.onCreate(null);
    }

    private void init() {
        this.setBackgroundColor(this.getResources().getColor(R.color.common_widget_bg));
        this.setOrientation(1);
        this.mSimpleTitleBar = new SimpleTitleBar(this.getContext());
        this.mSimpleTitleBar.setLeftBtn(R.drawable.icon_nav_back, v -> MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.MSG_CLOSE_NEW_RECORD_WINDOW, 1000));
        this.mSimpleTitleBar.setRightBtn((CharSequence)ResourceUtils.getString((int)R.string.btn_create_samecity_next), (View.OnClickListener)this);
        this.mAlbumsAdapter = new AlbumsAdapter(this.getContext(), null, false);
        this.mAlbumsSpinner = new AlbumsSpinner(this.getContext());
        this.mAlbumsSpinner.setOnItemSelectedListener(this);
        this.mAlbumsSpinner.setSelectedTextView(this.mSimpleTitleBar.getLeftTextView());
        this.mAlbumsSpinner.setPopupAnchorView((View)this.mSimpleTitleBar);
        this.mAlbumsSpinner.setAdapter(this.mAlbumsAdapter);
        this.mAlbumsSpinner.setOnSelectedClickListener(() -> {
            if (this.mOnSelect instanceof HagoAlbum.OnChannelReport && ((HagoAlbum.OnChannelReport)this.mOnSelect).getHiidoEvent() != null) {
                HiidoStatis.reportEvent((HiidoEvent)((HagoAlbum.OnChannelReport)this.mOnSelect).getHiidoEvent().put("function_id", "choose_photo_album_click"));
            }
        });
        this.mAlbumCollection.onCreate((FragmentActivity)this.getContext(), this);
        this.mAlbumCollection.loadAlbums();
        this.addView((View)this.mSimpleTitleBar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)48.0f)));
        this.mRelativeLayout = new YYRelativeLayout(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0);
        layoutParams.weight = 1.0f;
        layoutParams.bottomMargin = ResolutionUtils.dip2Px((float)70.0f);
        this.addView((View)this.mRelativeLayout, (ViewGroup.LayoutParams)layoutParams);
        this.mSendView = (YYTextView)this.mSimpleTitleBar.getRightView();
        int paddingV = this.getResources().getDimensionPixelOffset(R.dimen.dist_6dp);
        int paddingH = this.getResources().getDimensionPixelOffset(R.dimen.dist_12dp);
        this.mSendView.setPadding(paddingH, paddingV, paddingH, paddingV);
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mSendView.getLayoutParams();
        params.setMarginEnd(paddingH);
        this.mSendView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mSendView.setTextColor(-1);
        this.mSendView.setBackgroundResource(R.drawable.selector_radius_rectangle_action_btn_16);
        this.mSendView.setEnabled(false);
        this.mSendView.setOnClickListener((View.OnClickListener)this);
        this.updateBottomStatuBar();
    }

    public void setCameraClick(AlbumMediaAdapter.OnCameraClick cameraClick) {
        this.mCameraClick = cameraClick;
    }

    @Override
    public void onCameraClick(int type) {
        if (this.mCameraClick != null) {
            this.mCameraClick.onCameraClick(type);
        }
    }

    private void load(Album album) {
        if (album == null) {
            return;
        }
        if (this.mMediaSelectionView != null) {
            if (StringUtils.equalsIgnoreCase((String)album.getId(), (String)this.mMediaSelectionView.getAlbumId())) {
                return;
            }
            this.mRelativeLayout.removeView((View)this.mMediaSelectionView);
            this.mMediaSelectionView = null;
        }
        this.mMediaSelectionView = new MediaSelectionView(this.mShowType, this.mMediaMode, this.getContext(), album, this.mAlbumAdapterConfig, this, this.mSelectedItemCollection);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.mRelativeLayout.addView((View)this.mMediaSelectionView, (ViewGroup.LayoutParams)layoutParams);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAlbumCollection.onDestroy();
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.mAlbumCollection.setStateCurrentSelection(position);
        this.mAlbumsAdapter.getCursor().moveToPosition(position);
        Album album = Album.valueOf(this.mAlbumsAdapter.getCursor());
        if (album.isAll() && SelectionSpec.getInstance().capture) {
            album.addCaptureCount();
        }
        this.onAlbumSelected(album);
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    @Override
    public void onAlbumLoad(Cursor cursor) {
        this.mAlbumsAdapter.swapCursor(cursor);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(() -> {
            if (cursor.isClosed()) {
                return;
            }
            cursor.moveToPosition(this.mAlbumCollection.getCurrentSelection());
            this.mAlbumsSpinner.setSelection(this.getContext(), this.mAlbumCollection.getCurrentSelection());
            Album album = Album.valueOf(cursor);
            if (album.isAll() && SelectionSpec.getInstance().capture) {
                album.addCaptureCount();
            }
            this.onAlbumSelected(album);
        });
    }

    @Override
    public void onAlbumReset() {
        this.mAlbumsAdapter.swapCursor(null);
    }

    private void onAlbumSelected(Album album) {
        if (!album.isAll() || !album.isEmpty()) {
            this.load(album);
        }
    }

    @Override
    public void onUpdate() {
        this.updateBottomStatuBar();
    }

    @Override
    public Boolean onMediaClick(Album album, Item item, int adapterPosition) {
        if (this.mSelectedItemCollection.isSelected(item)) {
            Object[] objects = new Object[]{this.mSelectedItemCollection.getDataWithBundle(item), this.mSelectedItemCollection, this.mOnSelect};
            Message msg = Message.obtain();
            Bundle bundle = new Bundle();
            if (MimeType.isVideo(item.mimeType)) {
                msg.what = AppbaseMsgDef.MSG_OPEN_VIDEO_PREVIEW_WINDOW;
                msg.arg1 = 1;
                String videoFilePath = SdkVersionUtils.hasScopedStorage() ? YYFileUtils.getRealValidPath((Uri)item.uri) : YYFileUtils.getFilePathFromUri((Context)this.getContext(), (Uri)item.uri);
                bundle.putString("url", videoFilePath);
                bundle.putFloat("width", (float)item.width);
                bundle.putFloat("height", (float)item.height);
                bundle.putInt("dataSource", 2);
                msg.obj = bundle;
            } else {
                bundle.putBoolean("disable_channel_mini", this.isDisableChannelMini);
                msg.what = AlbumSelectMsgDef.MSG_SHOW_PREVIEW_SELECT;
                msg.obj = objects;
                msg.setData(bundle);
            }
            MsgDispatcher.getInstance().sendMessage(msg);
            return true;
        }
        return false;
    }

    @Override
    public void onSelectItem(Item item, int position) {
    }

    private void updateBottomStatuBar() {
        int selectedCount = this.mSelectedItemCollection.count();
        if (selectedCount == 0) {
            this.mSendView.setEnabled(false);
        } else {
            this.mSendView.setEnabled(true);
        }
    }

    public void onClick(View v) {
        if (v == this.mSendView) {
            List<Item> selectedList = this.mSelectedItemCollection.asList();
            if (selectedList.size() == 1 && MimeType.isVideo(selectedList.get((int)0).mimeType)) {
                MsgDispatcher.getInstance().sendMessage(AlbumSelectMsgDef.MSG_CLOSE_PREVIEW_SELECT);
                MsgDispatcher.getInstance().sendMessage(AlbumSelectMsgDef.MSG_CLOSE_ABLUM_SELECT);
                this.notifySelectedInfo();
                if (this.mOnSelect != null) {
                    this.mOnSelect.onSelect(this.mSelectedItemCollection.asListOfString());
                }
                MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.MSG_CLOSE_NEW_RECORD_WINDOW);
            } else {
                List<String> pathList = this.mSelectedItemCollection.asListOfString();
                if (!FP.empty(pathList)) {
                    MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.MSG_OPEN_NEW_RECORE_IMGEDIT_WINDOW, pathList);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.select_file_not_exist);
                }
            }
        }
    }

    private void notifySelectedInfo() {
        if (this.mShowType == 2 || this.mShowType == 3 || this.mShowType == 4) {
            List<Item> selectedList = this.mSelectedItemCollection.asList();
            if (selectedList.size() == 1 && MimeType.isVideo(selectedList.get((int)0).mimeType)) {
                Item item = selectedList.get(0);
                this.fixVideoInfoAndNotify(item);
            } else {
                this.fixPhotoInfoAndNotify(selectedList);
            }
        }
    }

    private void fixVideoInfoAndNotify(Item item) {
        if (item == null) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            SdkMediaInfoWrapper mediaInfo = null;
            String path = YYFileUtils.getFilePathFromUri((Context)this.getContext(), (Uri)item.getContentUri());
            if (!TextUtils.isEmpty((CharSequence)path)) {
                mediaInfo = ((IVideoRecordService)ServiceManagerProxy.getService(IVideoRecordService.class)).getVideoInfo(path);
            }
            BasicMediaInfo basicMediaInfo = new BasicMediaInfo();
            basicMediaInfo.duration = (int)(item.duration / 1000L);
            basicMediaInfo.width = item.width;
            basicMediaInfo.height = item.height;
            basicMediaInfo.bitRate = mediaInfo.bitRate;
            basicMediaInfo.videoCodec = mediaInfo.videoCodecName;
            if (mediaInfo != null && mediaInfo.width > 0 && mediaInfo.height > 0) {
                if (Math.abs(mediaInfo.rotate) == 90.0 || Math.abs(mediaInfo.rotate) == 270.0) {
                    basicMediaInfo.width = mediaInfo.height;
                    basicMediaInfo.height = mediaInfo.width;
                    MLog.info((Object)TAG, (String)(" vedio need rotate=" + basicMediaInfo.width + " " + basicMediaInfo.height), (Object[])new Object[0]);
                } else {
                    basicMediaInfo.width = mediaInfo.width;
                    basicMediaInfo.height = mediaInfo.height;
                }
            }
            YYTaskExecutor.postToMainThread(() -> {
                Message message = Message.obtain();
                message.what = AlbumSelectMsgDef.MSG_NOTIFY_SELECTED_INFO;
                message.obj = basicMediaInfo;
                MsgDispatcher.getInstance().sendMessage(message);
            });
        });
    }

    private void fixPhotoInfoAndNotify(List<Item> selectedList) {
        YYTaskExecutor.execute(() -> {
            ArrayList<BasicMediaInfo> mPhotos = new ArrayList<BasicMediaInfo>();
            for (int i = 0; i < selectedList.size(); ++i) {
                BasicMediaInfo basicMediaInfo = new BasicMediaInfo();
                basicMediaInfo.path = YYFileUtils.getFilePathFromUri((Context)this.getContext(), (Uri)((Item)selectedList.get((int)i)).uri);
                if (!YYFileUtils.isFileExisted((String)basicMediaInfo.path)) continue;
                basicMediaInfo.width = ((Item)selectedList.get((int)i)).width;
                basicMediaInfo.height = ((Item)selectedList.get((int)i)).height;
                if (basicMediaInfo.width == 0 && basicMediaInfo.height == 0) {
                    Point point = YYImageUtils.getBitmapBound((ContentResolver)this.getContext().getContentResolver(), (Uri)((Item)selectedList.get((int)i)).uri);
                    basicMediaInfo.width = point.x;
                    basicMediaInfo.height = point.y;
                }
                MLog.info((Object)TAG, (String)(" photo need index=" + i + "\uff0cphoto size:" + basicMediaInfo.width + " " + basicMediaInfo.height), (Object[])new Object[0]);
                boolean isRotate = PhotoMetadataUtils.shouldRotate(basicMediaInfo.path);
                if (isRotate) {
                    basicMediaInfo.width ^= basicMediaInfo.height;
                    basicMediaInfo.height ^= basicMediaInfo.width;
                    basicMediaInfo.width ^= basicMediaInfo.height;
                    MLog.info((Object)TAG, (String)(" photo need rotate index=" + i + "\uff0cphoto size:" + basicMediaInfo.width + " " + basicMediaInfo.height), (Object[])new Object[0]);
                }
                mPhotos.add(basicMediaInfo);
            }
            if (mPhotos.size() > 0) {
                YYTaskExecutor.postToMainThread(() -> {
                    Message message = Message.obtain();
                    message.what = AlbumSelectMsgDef.MSG_NOTIFY_SELECTED_INFO;
                    message.obj = mPhotos;
                    message.arg1 = 1;
                    MsgDispatcher.getInstance().sendMessage(message);
                });
            } else {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.select_file_not_exist);
                MLog.warn((Object)TAG, (String)"photoFile is empty", (Object[])new Object[0]);
            }
        });
    }

    public void notifyDataSetChanged() {
        if (this.mMediaSelectionView != null) {
            this.mMediaSelectionView.notifyDataSetChanged();
        }
        this.updateBottomStatuBar();
    }

    public boolean isDisableChannelMini() {
        return this.isDisableChannelMini;
    }
}

