/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.net.Uri;
import android.util.DisplayMetrics;
import androidx.exifinterface.media.ExifInterface;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ExifInterfaceCompat;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.MimeType;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.filter.Filter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.IncapableCause;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Item;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.SelectionSpec;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public final class PhotoMetadataUtils {
    private static final String TAG = PhotoMetadataUtils.class.getSimpleName();
    private static final int MAX_WIDTH = 1600;
    private static final String SCHEME_CONTENT = "content";

    private PhotoMetadataUtils() {
        throw new AssertionError((Object)"oops! the utility class is about to be instantiated...");
    }

    public static int getPixelsCount(ContentResolver resolver, Uri uri) {
        Point size = PhotoMetadataUtils.getBitmapBound(resolver, uri);
        return size.x * size.y;
    }

    public static Point getBitmapSize(Uri uri, Activity activity) {
        ContentResolver resolver = activity.getContentResolver();
        Point imageSize = PhotoMetadataUtils.getBitmapBound(resolver, uri);
        int w = imageSize.x;
        int h = imageSize.y;
        if (PhotoMetadataUtils.shouldRotate(resolver, uri)) {
            w = imageSize.y;
            h = imageSize.x;
        }
        if (h == 0) {
            return new Point(1600, 1600);
        }
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        float screenWidth = metrics.widthPixels;
        float screenHeight = metrics.heightPixels;
        float widthScale = screenWidth / (float)w;
        float heightScale = screenHeight / (float)h;
        if (widthScale > heightScale) {
            return new Point((int)((float)w * widthScale), (int)((float)h * heightScale));
        }
        return new Point((int)((float)w * widthScale), (int)((float)h * heightScale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getBitmapBound(ContentResolver resolver, Uri uri) {
        InputStream is = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            is = resolver.openInputStream(uri);
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            int width = options.outWidth;
            int height = options.outHeight;
            Point point = new Point(width, height);
            return point;
        }
        catch (FileNotFoundException e) {
            MLog.error((Object)TAG, (String)"getBitmapBound error", (Throwable)e, (Object[])new Object[0]);
            Point point = new Point(0, 0);
            return point;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPath(ContentResolver resolver, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (SCHEME_CONTENT.equals(uri.getScheme())) {
            try (Cursor cursor = null;){
                cursor = resolver.query(uri, new String[]{"_data"}, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) {
                    String string2 = null;
                    return string2;
                }
                String string3 = cursor.getString(cursor.getColumnIndex("_data"));
                return string3;
            }
        }
        return uri.getPath();
    }

    public static IncapableCause isAcceptable(Context context, Item item) {
        if (!PhotoMetadataUtils.isSelectableType(context, item)) {
            return new IncapableCause(context.getString(R.string.error_file_type));
        }
        if (SelectionSpec.getInstance().filters != null) {
            for (Filter filter : SelectionSpec.getInstance().filters) {
                IncapableCause incapableCause = filter.filter(context, item);
                if (incapableCause == null) continue;
                return incapableCause;
            }
        }
        return null;
    }

    private static boolean isSelectableType(Context context, Item item) {
        if (context == null) {
            return false;
        }
        ContentResolver resolver = context.getContentResolver();
        for (MimeType type : SelectionSpec.getInstance().mimeTypeSet) {
            if (!type.checkType(resolver, item.getContentUri())) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldRotate(ContentResolver resolver, Uri uri) {
        ExifInterface exif;
        try {
            exif = ExifInterfaceCompat.newInstance((String)PhotoMetadataUtils.getPath(resolver, uri));
        }
        catch (Exception e) {
            MLog.warn((Object)TAG, (String)("could not read exif info of the image: " + uri), (Object[])new Object[0]);
            return false;
        }
        int orientation = exif.getAttributeInt("Orientation", -1);
        return orientation == 6 || orientation == 8;
    }

    public static boolean shouldRotate(String localPath) {
        ExifInterface exif;
        try {
            exif = ExifInterfaceCompat.newInstance((String)localPath);
        }
        catch (Exception e) {
            MLog.warn((Object)TAG, (String)("could not read exif info of the image: " + localPath), (Object[])new Object[0]);
            return false;
        }
        int orientation = exif.getAttributeInt("Orientation", -1);
        return orientation == 6 || orientation == 8;
    }

    public static float getSizeInMB(long sizeInBytes) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        df.applyPattern("0.0");
        String result = df.format((float)sizeInBytes / 1024.0f / 1024.0f);
        MLog.warn((Object)TAG, (String)("getSizeInMB: " + result), (Object[])new Object[0]);
        result = result.replaceAll(",", ".");
        return Float.valueOf(result).floatValue();
    }
}

