/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.imagetouch;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ViewConfiguration;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.imagetouch.graphics.FastBitmapDrawable;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget.imagetouch.utils.IDisposable;

public abstract class ImageViewTouchBase
extends YYImageView
implements IDisposable {
    public static final String VERSION = "1.0";
    public static final float MIN_SCALE_DIFF = 0.1f;
    public static final String TAG = "ImageViewTouchBase";
    protected static boolean DEBUG = false;
    public static final float ZOOM_INVALID = -1.0f;
    protected Matrix mBaseMatrix = new Matrix();
    protected Matrix mSuppMatrix = new Matrix();
    protected Matrix mNextMatrix;
    protected Runnable mLayoutRunnable = null;
    protected boolean mUserScaled = false;
    protected float mMaxZoom = -1.0f;
    protected float mMinZoom = -1.0f;
    protected boolean mMaxZoomDefined;
    protected boolean mMinZoomDefined;
    protected final Matrix mDisplayMatrix = new Matrix();
    protected final float[] mMatrixValues = new float[9];
    protected DisplayType mScaleType = DisplayType.FIT_IF_BIGGER;
    protected boolean mScaleTypeChanged;
    protected boolean mBitmapChanged;
    protected int mDefaultAnimationDuration;
    protected int mMinFlingVelocity;
    protected int mMaxFlingVelocity;
    protected PointF mCenter = new PointF();
    protected RectF mBitmapRect = new RectF();
    protected RectF mBitmapRectTmp = new RectF();
    protected RectF mCenterRect = new RectF();
    protected PointF mScrollPoint = new PointF();
    protected RectF mViewPort = new RectF();
    protected RectF mViewPortOld = new RectF();
    private Animator mCurrentAnimation;
    private OnDrawableChangeListener mDrawableChangeListener;
    private OnLayoutChangeListener mOnLayoutChangeListener;

    public ImageViewTouchBase(Context context) {
        this(context, null);
    }

    public ImageViewTouchBase(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageViewTouchBase(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    public boolean getBitmapChanged() {
        return this.mBitmapChanged;
    }

    public void setOnDrawableChangedListener(OnDrawableChangeListener listener) {
        this.mDrawableChangeListener = listener;
    }

    public void setOnLayoutChangeListener(OnLayoutChangeListener listener) {
        this.mOnLayoutChangeListener = listener;
    }

    protected void init(Context context, AttributeSet attrs, int defStyle) {
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mMinFlingVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mDefaultAnimationDuration = this.getResources().getInteger(0x10E0000);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public void clear() {
        this.setImageBitmap(null);
    }

    public void setDisplayType(DisplayType type) {
        if (type != this.mScaleType) {
            if (DEBUG) {
                Log.i((String)TAG, (String)("setDisplayType: " + (Object)((Object)type)));
            }
            this.mUserScaled = false;
            this.mScaleType = type;
            this.mScaleTypeChanged = true;
            this.requestLayout();
        }
    }

    public DisplayType getDisplayType() {
        return this.mScaleType;
    }

    protected void setMinScale(float value) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("setMinZoom: " + value));
        }
        this.mMinZoom = value;
    }

    protected void setMaxScale(float value) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("setMaxZoom: " + value));
        }
        this.mMaxZoom = value;
    }

    protected void onViewPortChanged(float left, float top, float right, float bottom) {
        this.mViewPort.set(left, top, right, bottom);
        this.mCenter.x = this.mViewPort.centerX();
        this.mCenter.y = this.mViewPort.centerY();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        Drawable drawable2;
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (changed) {
            this.mViewPortOld.set(this.mViewPort);
            this.onViewPortChanged(left, top, right, bottom);
            deltaX = this.mViewPort.width() - this.mViewPortOld.width();
            deltaY = this.mViewPort.height() - this.mViewPortOld.height();
        }
        super.onLayout(changed, left, top, right, bottom);
        Runnable r = this.mLayoutRunnable;
        if (r != null) {
            this.mLayoutRunnable = null;
            r.run();
        }
        if ((drawable2 = this.getDrawable()) != null) {
            if (changed || this.mScaleTypeChanged || this.mBitmapChanged) {
                if (this.mBitmapChanged) {
                    this.mUserScaled = false;
                    this.mBaseMatrix.reset();
                    if (!this.mMinZoomDefined) {
                        this.mMinZoom = -1.0f;
                    }
                    if (!this.mMaxZoomDefined) {
                        this.mMaxZoom = -1.0f;
                    }
                }
                float scale = 1.0f;
                float oldDefaultScale = this.getDefaultScale(this.getDisplayType());
                float oldMatrixScale = this.getScale(this.mBaseMatrix);
                float oldScale = this.getScale();
                float oldMinScale = Math.min(1.0f, 1.0f / oldMatrixScale);
                this.getProperBaseMatrix(drawable2, this.mBaseMatrix, this.mViewPort);
                float newMatrixScale = this.getScale(this.mBaseMatrix);
                if (DEBUG) {
                    Log.d((String)TAG, (String)("old matrix scale: " + oldMatrixScale));
                    Log.d((String)TAG, (String)("new matrix scale: " + newMatrixScale));
                    Log.d((String)TAG, (String)("old min scale: " + oldMinScale));
                    Log.d((String)TAG, (String)("old scale: " + oldScale));
                }
                if (this.mBitmapChanged || this.mScaleTypeChanged) {
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("display type: " + (Object)((Object)this.getDisplayType())));
                        Log.d((String)TAG, (String)("newMatrix: " + this.mNextMatrix));
                    }
                    if (this.mNextMatrix != null) {
                        this.mSuppMatrix.set(this.mNextMatrix);
                        this.mNextMatrix = null;
                        scale = this.getScale();
                    } else {
                        this.mSuppMatrix.reset();
                        scale = this.getDefaultScale(this.getDisplayType());
                    }
                    this.setImageMatrix(this.getImageViewMatrix());
                    if (scale != this.getScale()) {
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("scale != getScale: " + scale + " != " + this.getScale()));
                        }
                        this.zoomTo(scale);
                    }
                } else if (changed) {
                    if (!this.mMinZoomDefined) {
                        this.mMinZoom = -1.0f;
                    }
                    if (!this.mMaxZoomDefined) {
                        this.mMaxZoom = -1.0f;
                    }
                    this.setImageMatrix(this.getImageViewMatrix());
                    this.postTranslate(-deltaX, -deltaY);
                    if (!this.mUserScaled) {
                        scale = this.getDefaultScale(this.getDisplayType());
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("!userScaled. scale=" + scale));
                        }
                        this.zoomTo(scale);
                    } else {
                        if (Math.abs(oldScale - oldMinScale) > 0.1f) {
                            scale = oldMatrixScale / newMatrixScale * oldScale;
                        }
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("userScaled. scale=" + scale));
                        }
                        this.zoomTo(scale);
                    }
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("old min scale: " + oldDefaultScale));
                        Log.d((String)TAG, (String)("old scale: " + oldScale));
                        Log.d((String)TAG, (String)("new scale: " + scale));
                    }
                }
                if (scale > this.getMaxScale() || scale < this.getMinScale()) {
                    this.zoomTo(scale);
                }
                this.center(true, true);
                if (this.mBitmapChanged) {
                    this.onDrawableChanged(drawable2);
                }
                if (changed || this.mBitmapChanged || this.mScaleTypeChanged) {
                    this.onLayoutChanged(left, top, right, bottom);
                }
                if (this.mScaleTypeChanged) {
                    this.mScaleTypeChanged = false;
                }
                if (this.mBitmapChanged) {
                    this.mBitmapChanged = false;
                }
                if (DEBUG) {
                    Log.d((String)TAG, (String)("scale: " + this.getScale() + ", minScale: " + this.getMinScale() + ", maxScale: " + this.getMaxScale()));
                }
            }
        } else {
            if (this.mBitmapChanged) {
                this.onDrawableChanged(drawable2);
            }
            if (changed || this.mBitmapChanged || this.mScaleTypeChanged) {
                this.onLayoutChanged(left, top, right, bottom);
            }
            if (this.mBitmapChanged) {
                this.mBitmapChanged = false;
            }
            if (this.mScaleTypeChanged) {
                this.mScaleTypeChanged = false;
            }
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (DEBUG) {
            Log.i((String)TAG, (String)("onConfigurationChanged. scale: " + this.getScale() + ", minScale: " + this.getMinScale() + ", mUserScaled: " + this.mUserScaled));
        }
        if (this.mUserScaled) {
            boolean bl = this.mUserScaled = Math.abs(this.getScale() - this.getMinScale()) > 0.1f;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("mUserScaled: " + this.mUserScaled));
        }
    }

    public void resetDisplay() {
        this.mBitmapChanged = true;
        this.requestLayout();
    }

    public void resetMatrix() {
        if (DEBUG) {
            Log.i((String)TAG, (String)"resetMatrix");
        }
        this.mSuppMatrix = new Matrix();
        float scale = this.getDefaultScale(this.getDisplayType());
        this.setImageMatrix(this.getImageViewMatrix());
        if (DEBUG) {
            Log.d((String)TAG, (String)("default scale: " + scale + ", scale: " + this.getScale()));
        }
        if (scale != this.getScale()) {
            this.zoomTo(scale);
        }
        this.postInvalidate();
    }

    protected float getDefaultScale(DisplayType type) {
        if (type == DisplayType.FIT_TO_SCREEN) {
            return 1.0f;
        }
        if (type == DisplayType.FIT_IF_BIGGER) {
            return Math.min(1.0f, 1.0f / this.getScale(this.mBaseMatrix));
        }
        return 1.0f / this.getScale(this.mBaseMatrix);
    }

    public void setImageResource(int resId) {
        this.setImageDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setImageBitmap(bitmap, null, -1.0f, -1.0f);
    }

    public void setImageBitmap(Bitmap bitmap, Matrix matrix, float minZoom, float maxZoom) {
        if (bitmap != null) {
            this.setImageDrawable(new FastBitmapDrawable(bitmap), matrix, minZoom, maxZoom);
        } else {
            this.setImageDrawable(null, matrix, minZoom, maxZoom);
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        this.setImageDrawable(drawable2, null, -1.0f, -1.0f);
    }

    public void setImageDrawable(final Drawable drawable2, final Matrix initialMatrix, final float minZoom, final float maxZoom) {
        int viewWidth = this.getWidth();
        if (viewWidth <= 0) {
            this.mLayoutRunnable = new Runnable(){

                @Override
                public void run() {
                    ImageViewTouchBase.this.setImageDrawable(drawable2, initialMatrix, minZoom, maxZoom);
                }
            };
            return;
        }
        this.setImageDrawableInternal(drawable2, initialMatrix, minZoom, maxZoom);
    }

    protected void setImageDrawableInternal(Drawable drawable2, Matrix initialMatrix, float minZoom, float maxZoom) {
        this.mBaseMatrix.reset();
        super.setImageDrawable(drawable2);
        if (minZoom != -1.0f && maxZoom != -1.0f) {
            minZoom = Math.min(minZoom, maxZoom);
            maxZoom = Math.max(minZoom, maxZoom);
            this.mMinZoom = minZoom;
            this.mMaxZoom = maxZoom;
            this.mMinZoomDefined = true;
            this.mMaxZoomDefined = true;
            if (this.getDisplayType() == DisplayType.FIT_TO_SCREEN || this.getDisplayType() == DisplayType.FIT_IF_BIGGER) {
                if (this.mMinZoom >= 1.0f) {
                    this.mMinZoomDefined = false;
                    this.mMinZoom = -1.0f;
                }
                if (this.mMaxZoom <= 1.0f) {
                    this.mMaxZoomDefined = true;
                    this.mMaxZoom = -1.0f;
                }
            }
        } else {
            this.mMinZoom = -1.0f;
            this.mMaxZoom = -1.0f;
            this.mMinZoomDefined = false;
            this.mMaxZoomDefined = false;
        }
        if (initialMatrix != null) {
            this.mNextMatrix = new Matrix(initialMatrix);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("mMinZoom: " + this.mMinZoom + ", mMaxZoom: " + this.mMaxZoom));
        }
        this.mBitmapChanged = true;
        this.updateDrawable(drawable2);
        this.requestLayout();
    }

    protected void updateDrawable(Drawable newDrawable) {
        if (null != newDrawable) {
            this.mBitmapRect.set(0.0f, 0.0f, (float)newDrawable.getIntrinsicWidth(), (float)newDrawable.getIntrinsicHeight());
        } else {
            this.mBitmapRect.setEmpty();
        }
    }

    protected void onDrawableChanged(Drawable drawable2) {
        if (DEBUG) {
            Log.i((String)TAG, (String)"onDrawableChanged");
            Log.v((String)TAG, (String)("scale: " + this.getScale() + ", minScale: " + this.getMinScale()));
        }
        this.fireOnDrawableChangeListener(drawable2);
    }

    protected void fireOnLayoutChangeListener(int left, int top, int right, int bottom) {
        if (null != this.mOnLayoutChangeListener) {
            this.mOnLayoutChangeListener.onLayoutChanged(true, left, top, right, bottom);
        }
    }

    protected void fireOnDrawableChangeListener(Drawable drawable2) {
        if (null != this.mDrawableChangeListener) {
            this.mDrawableChangeListener.onDrawableChanged(drawable2);
        }
    }

    protected void onLayoutChanged(int left, int top, int right, int bottom) {
        if (DEBUG) {
            Log.i((String)TAG, (String)"onLayoutChanged");
        }
        this.fireOnLayoutChangeListener(left, top, right, bottom);
    }

    protected float computeMaxZoom() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return 1.0f;
        }
        float fw = this.mBitmapRect.width() / this.mViewPort.width();
        float fh = this.mBitmapRect.height() / this.mViewPort.height();
        float scale = Math.max(fw, fh) * 4.0f;
        if (DEBUG) {
            Log.i((String)TAG, (String)("computeMaxZoom: " + scale));
        }
        return scale;
    }

    protected float computeMinZoom() {
        Drawable drawable2;
        if (DEBUG) {
            Log.i((String)TAG, (String)"computeMinZoom");
        }
        if ((drawable2 = this.getDrawable()) == null) {
            return 1.0f;
        }
        float scale = this.getScale(this.mBaseMatrix);
        scale = Math.min(1.0f, 1.0f / scale);
        if (DEBUG) {
            Log.i((String)TAG, (String)("computeMinZoom: " + scale));
        }
        return scale;
    }

    public float getMaxScale() {
        if (this.mMaxZoom == -1.0f) {
            this.mMaxZoom = this.computeMaxZoom();
        }
        return this.mMaxZoom;
    }

    public float getMinScale() {
        if (DEBUG) {
            Log.i((String)TAG, (String)("getMinScale, mMinZoom: " + this.mMinZoom));
        }
        if (this.mMinZoom == -1.0f) {
            this.mMinZoom = this.computeMinZoom();
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("mMinZoom: " + this.mMinZoom));
        }
        return this.mMinZoom;
    }

    public Matrix getImageViewMatrix() {
        return this.getImageViewMatrix(this.mSuppMatrix);
    }

    public Matrix getImageViewMatrix(Matrix supportMatrix) {
        this.mDisplayMatrix.set(this.mBaseMatrix);
        this.mDisplayMatrix.postConcat(supportMatrix);
        return this.mDisplayMatrix;
    }

    public void setImageMatrix(Matrix matrix) {
        Matrix current = this.getImageMatrix();
        boolean needUpdate = false;
        if (matrix == null && !current.isIdentity() || matrix != null && !current.equals((Object)matrix)) {
            needUpdate = true;
        }
        super.setImageMatrix(matrix);
        if (needUpdate) {
            this.onImageMatrixChanged();
        }
    }

    protected void onImageMatrixChanged() {
    }

    public Matrix getDisplayMatrix() {
        return new Matrix(this.mSuppMatrix);
    }

    protected void getProperBaseMatrix(Drawable drawable2, Matrix matrix, RectF rect) {
        float w = this.mBitmapRect.width();
        float h = this.mBitmapRect.height();
        matrix.reset();
        float widthScale = rect.width() / w;
        float heightScale = rect.height() / h;
        float scale = Math.min(widthScale, heightScale);
        matrix.postScale(scale, scale);
        matrix.postTranslate(rect.left, rect.top);
        float tw = (rect.width() - w * scale) / 2.0f;
        float th = (rect.height() - h * scale) / 2.0f;
        matrix.postTranslate(tw, th);
        this.printMatrix(matrix);
    }

    protected float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    public void printMatrix(Matrix matrix) {
        float scalex = this.getValue(matrix, 0);
        float scaley = this.getValue(matrix, 4);
        float tx = this.getValue(matrix, 2);
        float ty = this.getValue(matrix, 5);
        Log.d((String)TAG, (String)("matrix: { x: " + tx + ", y: " + ty + ", scalex: " + scalex + ", scaley: " + scaley + " }"));
    }

    public RectF getBitmapRect() {
        return this.getBitmapRect(this.mSuppMatrix);
    }

    protected RectF getBitmapRect(Matrix supportMatrix) {
        Matrix m = this.getImageViewMatrix(supportMatrix);
        m.mapRect(this.mBitmapRectTmp, this.mBitmapRect);
        return this.mBitmapRectTmp;
    }

    protected float getScale(Matrix matrix) {
        return this.getValue(matrix, 0);
    }

    @SuppressLint(value={"Override"})
    public float getRotation() {
        return 0.0f;
    }

    public float getScale() {
        return this.getScale(this.mSuppMatrix);
    }

    public float getBaseScale() {
        return this.getScale(this.mBaseMatrix);
    }

    protected void center(boolean horizontal, boolean vertical) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        RectF rect = this.getCenter(this.mSuppMatrix, horizontal, vertical);
        if (rect.left != 0.0f || rect.top != 0.0f) {
            this.postTranslate(rect.left, rect.top);
        }
    }

    protected RectF getCenter(Matrix supportMatrix, boolean horizontal, boolean vertical) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.mCenterRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        RectF rect = this.getBitmapRect(supportMatrix);
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (vertical) {
            if (height < this.mViewPort.height()) {
                deltaY = (this.mViewPort.height() - height) / 2.0f - (rect.top - this.mViewPort.top);
            } else if (rect.top > this.mViewPort.top) {
                deltaY = -(rect.top - this.mViewPort.top);
            } else if (rect.bottom < this.mViewPort.bottom) {
                deltaY = this.mViewPort.bottom - rect.bottom;
            }
        }
        if (horizontal) {
            if (width < this.mViewPort.width()) {
                deltaX = (this.mViewPort.width() - width) / 2.0f - (rect.left - this.mViewPort.left);
            } else if (rect.left > this.mViewPort.left) {
                deltaX = -(rect.left - this.mViewPort.left);
            } else if (rect.right < this.mViewPort.right) {
                deltaX = this.mViewPort.right - rect.right;
            }
        }
        this.mCenterRect.set(deltaX, deltaY, 0.0f, 0.0f);
        return this.mCenterRect;
    }

    protected void postTranslate(float deltaX, float deltaY) {
        if (deltaX != 0.0f || deltaY != 0.0f) {
            this.mSuppMatrix.postTranslate(deltaX, deltaY);
            this.setImageMatrix(this.getImageViewMatrix());
        }
    }

    protected void postScale(float scale, float centerX, float centerY) {
        this.mSuppMatrix.postScale(scale, scale, centerX, centerY);
        this.setImageMatrix(this.getImageViewMatrix());
    }

    protected PointF getCenter() {
        return this.mCenter;
    }

    protected void zoomTo(float scale) {
        if (DEBUG) {
            Log.i((String)TAG, (String)("zoomTo: " + scale));
        }
        if (scale > this.getMaxScale()) {
            scale = this.getMaxScale();
        }
        if (scale < this.getMinScale()) {
            scale = this.getMinScale();
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)("sanitized scale: " + scale));
        }
        PointF center = this.getCenter();
        this.zoomTo(scale, center.x, center.y);
    }

    public void zoomTo(float scale, long durationMs) {
        PointF center = this.getCenter();
        this.zoomTo(scale, center.x, center.y, durationMs);
    }

    protected void zoomTo(float scale, float centerX, float centerY) {
        if (scale > this.getMaxScale()) {
            scale = this.getMaxScale();
        }
        float oldScale = this.getScale();
        float deltaScale = scale / oldScale;
        this.postScale(deltaScale, centerX, centerY);
        this.onZoom(this.getScale());
        this.center(true, true);
    }

    protected void onZoom(float scale) {
    }

    protected void onZoomAnimationCompleted(float scale) {
    }

    public void scrollBy(float x, float y) {
        this.panBy(x, y);
    }

    protected void panBy(double dx, double dy) {
        RectF rect = this.getBitmapRect();
        this.mScrollPoint.set((float)dx, (float)dy);
        this.updateRect(rect, this.mScrollPoint);
        if (this.mScrollPoint.x != 0.0f || this.mScrollPoint.y != 0.0f) {
            this.postTranslate(this.mScrollPoint.x, this.mScrollPoint.y);
            this.center(true, true);
        }
    }

    protected void updateRect(RectF bitmapRect, PointF scrollRect) {
        if (bitmapRect == null) {
            return;
        }
    }

    protected void stopAllAnimations() {
        if (null != this.mCurrentAnimation) {
            this.mCurrentAnimation.cancel();
            this.mCurrentAnimation = null;
        }
    }

    protected void scrollBy(float distanceX, float distanceY, long durationMs) {
        final ValueAnimator anim1 = ValueAnimator.ofFloat((float[])new float[]{0.0f, distanceX}).setDuration(durationMs);
        final ValueAnimator anim2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, distanceY}).setDuration(durationMs);
        this.stopAllAnimations();
        this.mCurrentAnimation = new AnimatorSet();
        ((AnimatorSet)this.mCurrentAnimation).playTogether(new Animator[]{anim1, anim2});
        this.mCurrentAnimation.setDuration(durationMs);
        this.mCurrentAnimation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mCurrentAnimation.start();
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            float oldValueX = 0.0f;
            float oldValueY = 0.0f;

            public void onAnimationUpdate(ValueAnimator animation) {
                float valueX = ((Float)anim1.getAnimatedValue()).floatValue();
                float valueY = ((Float)anim2.getAnimatedValue()).floatValue();
                ImageViewTouchBase.this.panBy(valueX - this.oldValueX, valueY - this.oldValueY);
                this.oldValueX = valueX;
                this.oldValueY = valueY;
                if (Build.VERSION.SDK_INT >= 16) {
                    ImageViewTouchBase.this.postInvalidateOnAnimation();
                } else {
                    ImageViewTouchBase.this.postInvalidate();
                }
            }
        });
        this.mCurrentAnimation.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                RectF centerRect = ImageViewTouchBase.this.getCenter(ImageViewTouchBase.this.mSuppMatrix, true, true);
                if (centerRect.left != 0.0f || centerRect.top != 0.0f) {
                    ImageViewTouchBase.this.scrollBy(centerRect.left, centerRect.top);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    protected void zoomTo(float scale, float centerX, float centerY, long durationMs) {
        if (scale > this.getMaxScale()) {
            scale = this.getMaxScale();
        }
        float oldScale = this.getScale();
        Matrix m = new Matrix(this.mSuppMatrix);
        m.postScale(scale, scale, centerX, centerY);
        RectF rect = this.getCenter(m, true, true);
        float finalScale = scale;
        final float destX = centerX + rect.left * scale;
        final float destY = centerY + rect.top * scale;
        this.stopAllAnimations();
        ValueAnimator animation = ValueAnimator.ofFloat((float[])new float[]{oldScale, finalScale});
        animation.setDuration(durationMs);
        animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        animation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                ImageViewTouchBase.this.zoomTo(value, destX, destY);
                if (Build.VERSION.SDK_INT >= 16) {
                    ImageViewTouchBase.this.postInvalidateOnAnimation();
                } else {
                    ImageViewTouchBase.this.postInvalidate();
                }
            }
        });
        animation.start();
    }

    @Override
    public void dispose() {
        this.clear();
    }

    protected void onDraw(Canvas canvas) {
        if (this.getScaleType() == ImageView.ScaleType.FIT_XY) {
            Drawable drawable2 = this.getDrawable();
            if (null != drawable2) {
                drawable2.draw(canvas);
            }
        } else {
            super.onDraw(canvas);
        }
    }

    public static enum DisplayType {
        NONE,
        FIT_TO_SCREEN,
        FIT_IF_BIGGER;

    }

    public static interface OnLayoutChangeListener {
        public void onLayoutChanged(boolean var1, int var2, int var3, int var4, int var5);
    }

    public static interface OnDrawableChangeListener {
        public void onDrawableChanged(Drawable var1);
    }
}

