/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.widget;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CursorAdapter;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.ListPopupWindow;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.Album;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.utils.Platform;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.view.SelectViewMain;

public class AlbumsSpinner {
    private static final int MAX_SHOWN_COUNT = 7;
    private CursorAdapter mAdapter;
    private TextView mSelected;
    private ListPopupWindow mListPopupWindow;
    private AdapterView.OnItemSelectedListener mOnItemSelectedListener;
    private SelectViewMain.OnSelectClickListener mOnSelectClickListenerClickListener;

    public AlbumsSpinner(@NonNull Context context) {
        this.mListPopupWindow = new ListPopupWindow(context, null, R.attr.listPopupWindowStyle);
        this.mListPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)"#ffffff")));
        this.mListPopupWindow.setModal(true);
        this.mListPopupWindow.setContentWidth(context.getResources().getDisplayMetrics().widthPixels);
        this.mListPopupWindow.setHorizontalOffset(0);
        this.mListPopupWindow.setHeight(context.getResources().getDisplayMetrics().heightPixels - ResolutionUtils.dip2Px((float)72.0f));
        this.mListPopupWindow.setOnItemClickListener((parent, view, position, id2) -> {
            boolean success = this.onItemSelected(parent.getContext(), position);
            if (success && this.mOnItemSelectedListener != null) {
                this.mOnItemSelectedListener.onItemSelected(parent, view, position, id2);
            }
        });
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    public void setOnSelectedClickListener(SelectViewMain.OnSelectClickListener listener) {
        this.mOnSelectClickListenerClickListener = listener;
    }

    public void setSelection(Context context, int position) {
        this.mListPopupWindow.setSelection(position);
        this.onItemSelected(context, position);
    }

    private boolean onItemSelected(Context context, int position) {
        this.mListPopupWindow.dismiss();
        Cursor cursor = null;
        try {
            cursor = this.mAdapter.getCursor();
        }
        catch (Exception e) {
            MLog.error((Object)"AlbumsSpinner", (String)("onItemSelected\uff0c" + e.toString()), (Object[])new Object[0]);
        }
        if (cursor == null) {
            return false;
        }
        cursor.moveToPosition(position);
        Album album = Album.valueOf(cursor);
        String displayName = album.getDisplayName(context);
        if (this.mSelected.getVisibility() == 0) {
            this.mSelected.setText((CharSequence)displayName);
        } else if (Platform.hasICS()) {
            this.mSelected.setAlpha(0.0f);
            this.mSelected.setVisibility(0);
            this.mSelected.setText((CharSequence)displayName);
            this.mSelected.animate().alpha(1.0f).setDuration((long)context.getResources().getInteger(17694722)).start();
        } else {
            this.mSelected.setVisibility(0);
            this.mSelected.setText((CharSequence)displayName);
        }
        return true;
    }

    public void setAdapter(CursorAdapter adapter) {
        this.mListPopupWindow.setAdapter((ListAdapter)adapter);
        this.mAdapter = adapter;
    }

    public void setSelectedTextView(TextView textView) {
        this.mSelected = textView;
        this.mSelected.setCompoundDrawablesWithIntrinsicBounds(null, null, this.mSelected.getResources().getDrawable(R.drawable.ic_arrow_drop_down_white_24dp), null);
        Drawable[] drawables = this.mSelected.getCompoundDrawables();
        Drawable right = drawables[2];
        right.setColorFilter(Color.parseColor((String)"#0b0505"), PorterDuff.Mode.SRC_IN);
        this.mSelected.setVisibility(8);
        this.mSelected.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlbumsSpinner.this.mListPopupWindow.show();
                AlbumsSpinner.this.mOnSelectClickListenerClickListener.onSelectClick();
            }
        });
        this.mSelected.setOnTouchListener(this.mListPopupWindow.createDragToOpenListener((View)this.mSelected));
    }

    public void setPopupAnchorView(View view) {
        this.mListPopupWindow.setAnchorView(view);
    }
}

