/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.ui.adapter;

import android.database.Cursor;
import androidx.recyclerview.widget.RecyclerView;

public abstract class RecyclerViewCursorAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private Cursor mCursor;
    private int mRowIDColumn;
    protected int mShowType;
    protected static final int VIEW_TYPE_CAPTURE = 1;
    protected static final int VIEW_TYPE_MEDIA = 2;
    protected static final int VIEW_TYPE_OPEN_CAMERA = 3;

    RecyclerViewCursorAdapter(Cursor c) {
        this.setHasStableIds(true);
        this.swapCursor(c);
    }

    protected abstract void onBindViewHolder(VH var1, Cursor var2);

    public void onBindViewHolder(VH holder, int position) {
        this.checkCursorPosition(position);
        this.onBindViewHolder(holder, this.mCursor);
    }

    private void checkCursorPosition(int position) {
        int reallyPosition = position;
        if (this.mShowType == 2) {
            --reallyPosition;
        }
        if (this.mShowType == 2 && position == 0) {
            return;
        }
        if (!this.mCursor.moveToPosition(reallyPosition)) {
            throw new IllegalStateException("Could not move cursor to position " + position + " when trying to get an item id");
        }
    }

    public int getItemViewType(int position) {
        if (this.mShowType == 2) {
            if (position == 0) {
                return 3;
            }
            this.checkCursorPosition(position);
            return this.getItemViewType(position, this.mCursor);
        }
        this.checkCursorPosition(position);
        return this.getItemViewType(position, this.mCursor);
    }

    protected abstract int getItemViewType(int var1, Cursor var2);

    public int getItemCount() {
        if (this.isDataValid(this.mCursor)) {
            if (this.mShowType == 2) {
                return this.mCursor.getCount() + 1;
            }
            return this.mCursor.getCount();
        }
        return 0;
    }

    public long getItemId(int position) {
        if (!this.isDataValid(this.mCursor)) {
            throw new IllegalStateException("Cannot lookup item id when cursor is in invalid state.");
        }
        this.checkCursorPosition(position);
        if (this.mShowType == 2) {
            if (position == 0) {
                return position;
            }
            return this.mCursor.getLong(this.mRowIDColumn);
        }
        return this.mCursor.getLong(this.mRowIDColumn);
    }

    public void swapCursor(Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return;
        }
        if (newCursor != null) {
            this.mCursor = newCursor;
            this.mRowIDColumn = this.mCursor.getColumnIndexOrThrow("_id");
            this.notifyDataSetChanged();
        } else {
            this.notifyItemRangeRemoved(0, this.getItemCount());
            this.mCursor = null;
            this.mRowIDColumn = -1;
        }
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    private boolean isDataValid(Cursor cursor) {
        return cursor != null && !cursor.isClosed();
    }
}

