/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity;

import androidx.annotation.StyleRes;
import com.yy.hiyo.camera.base.ablum_select.listener.OnCheckedListener;
import com.yy.hiyo.camera.base.ablum_select.listener.OnSelectedListener;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.MimeType;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.engine.ImageEngine;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.engine.impl.GlideEngine;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.filter.Filter;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity.CaptureStrategy;
import java.util.List;
import java.util.Set;

public final class SelectionSpec {
    public Set<MimeType> mimeTypeSet;
    public boolean mediaTypeExclusive;
    public boolean showSingleMediaType;
    @StyleRes
    public int themeId;
    public int orientation;
    public boolean countable = true;
    public int maxSelectable = 9;
    public int maxImageSelectable;
    public int maxVideoSelectable;
    public List<Filter> filters;
    public boolean capture;
    public CaptureStrategy captureStrategy;
    public int spanCount = 4;
    public int gridExpectedSize;
    public float thumbnailScale;
    public ImageEngine imageEngine = new GlideEngine();
    public boolean hasInited;
    public OnSelectedListener onSelectedListener;
    public boolean originalable;
    public boolean autoHideToobar;
    public int originalMaxSize;
    public OnCheckedListener onCheckedListener;
    public boolean singleSelectMode;

    private SelectionSpec() {
    }

    public static SelectionSpec getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static SelectionSpec getCleanInstance() {
        SelectionSpec selectionSpec = SelectionSpec.getInstance();
        selectionSpec.reset();
        return selectionSpec;
    }

    private void reset() {
        this.mimeTypeSet = null;
        this.mediaTypeExclusive = true;
        this.showSingleMediaType = false;
        this.orientation = 0;
        this.countable = true;
        this.maxSelectable = 1;
        this.maxImageSelectable = 0;
        this.maxVideoSelectable = 0;
        this.filters = null;
        this.capture = false;
        this.captureStrategy = null;
        this.spanCount = 3;
        this.gridExpectedSize = 0;
        this.thumbnailScale = 0.5f;
        this.imageEngine = new GlideEngine();
        this.hasInited = true;
        this.originalable = false;
        this.autoHideToobar = false;
        this.originalMaxSize = Integer.MAX_VALUE;
        this.singleSelectMode = false;
    }

    public boolean singleSelectionModeEnabled() {
        return !this.countable && (this.maxSelectable == 1 || this.maxImageSelectable == 1 && this.maxVideoSelectable == 1);
    }

    public boolean needOrientationRestriction() {
        return this.orientation != -1;
    }

    public boolean onlyShowImages() {
        return this.showSingleMediaType && MimeType.ofImage().containsAll(this.mimeTypeSet);
    }

    public boolean onlyShowVideos() {
        return this.showSingleMediaType && MimeType.ofVideo().containsAll(this.mimeTypeSet);
    }

    private static final class InstanceHolder {
        private static final SelectionSpec INSTANCE = new SelectionSpec();

        private InstanceHolder() {
        }
    }
}

