/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.entity;

import android.content.Context;
import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.yy.hiyo.camera.base.R;
import com.yy.hiyo.camera.base.ablum_select.mulitablumselect.internal.utils.CursorUtils;

public class Album
implements Parcelable {
    public static final Parcelable.Creator<Album> CREATOR = new Parcelable.Creator<Album>(){

        @Nullable
        public Album createFromParcel(Parcel source) {
            return new Album(source);
        }

        public Album[] newArray(int size) {
            return new Album[size];
        }
    };
    public static final String ALBUM_ID_ALL = String.valueOf(-1);
    public static final String ALBUM_NAME_ALL = "All";
    private final String mId;
    private final String mCoverPath;
    private final String mDisplayName;
    private long mCount;

    Album(String id2, String coverPath, String albumName, long count) {
        this.mId = id2;
        this.mCoverPath = coverPath;
        this.mDisplayName = albumName;
        this.mCount = count;
    }

    Album(Parcel source) {
        this.mId = source.readString();
        this.mCoverPath = source.readString();
        this.mDisplayName = source.readString();
        this.mCount = source.readLong();
    }

    public static Album valueOf(Cursor cursor) {
        return new Album(CursorUtils.getString(cursor, "bucket_id"), CursorUtils.getString(cursor, "uri"), CursorUtils.getString(cursor, "bucket_display_name"), CursorUtils.getLong(cursor, "count"));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeString(this.mCoverPath);
        dest.writeString(this.mDisplayName);
        dest.writeLong(this.mCount);
    }

    public String getId() {
        return this.mId;
    }

    public String getCoverPath() {
        return this.mCoverPath;
    }

    public long getCount() {
        return this.mCount;
    }

    public void addCaptureCount() {
        ++this.mCount;
    }

    public String getDisplayName(Context context) {
        if (this.isAll()) {
            return context.getString(R.string.album_name_all);
        }
        return this.mDisplayName;
    }

    public boolean isAll() {
        return ALBUM_ID_ALL.equals(this.mId);
    }

    public boolean isEmpty() {
        return this.mCount == 0L;
    }
}

