/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page;

import android.graphics.Typeface;
import android.os.CountDownTimer;
import androidx.lifecycle.LifecycleOwner;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.AbsPreparePanelPage;

public class AutoStartPanelPage
extends AbsPreparePanelPage {
    private static final long TOTAL_TIME = 5200L;
    private static final long INTERVAL_TIME = 1000L;
    private CountDownTimer mCountDownTimer;
    private PageCallback mCallback;

    public void setCallback(PageCallback callback) {
        this.mCallback = callback;
    }

    @Override
    protected void onInitViews() {
        this.mStartBtn.setVisibility(8);
        this.mTvTips.setTypeface(Typeface.defaultFromStyle((int)1));
        this.mTvTips.setTextSize(1, 15.0f);
        this.mReadyBtn.setOnClickListener(v -> {
            if (this.mCallback == null) {
                return;
            }
            Boolean readyRequesting = (Boolean)WealthDataService.INSTANCE.getWealthDataModel().getReadyRequestingData().getValue();
            if (readyRequesting != null && readyRequesting.booleanValue()) {
                return;
            }
            Boolean hasReady = (Boolean)WealthDataService.INSTANCE.getWealthDataModel().getSelfJoinStatus().getValue();
            if (hasReady != null && hasReady.booleanValue()) {
                this.mCallback.onCancelReadyClick();
            } else {
                this.mCallback.onReadyClick();
            }
        });
        WealthDataService.INSTANCE.getWealthDataModel().getSelfJoinStatus().observe((LifecycleOwner)this.mLifeCycleOwner, selfJoin -> {
            if (selfJoin != null && selfJoin.booleanValue()) {
                if (this.mReadyBtn != null) {
                    this.mReadyBtn.setText(R.string.btn_bocai_cancel_ready);
                }
            } else if (this.mReadyBtn != null) {
                this.mReadyBtn.setText(R.string.btn_bocai_ready);
            }
        });
        WealthDataService.INSTANCE.getWealthDataModel().getReadyRequestingData().observe((LifecycleOwner)this.mLifeCycleOwner, result -> {
            if (result != null && result.booleanValue()) {
                this.mReadyBtn.setLoading(true);
            } else {
                this.mReadyBtn.setLoading(false);
            }
        });
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
            this.mCountDownTimer = null;
        }
        this.mCountDownTimer = new CountDownTimer(5200L, 1000L){

            public void onTick(long millisUntilFinished) {
                if (AutoStartPanelPage.this.mTvTips != null) {
                    int remainingSecond = (int)(millisUntilFinished / 1000L);
                    AutoStartPanelPage.this.mTvTips.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_bocai_ready_countdown, (Object[])new Object[]{remainingSecond}));
                }
            }

            public void onFinish() {
                AutoStartPanelPage.this.mCountDownTimer = null;
            }
        }.start();
    }

    @Override
    protected void onRemoveViews() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
    }

    public static interface PageCallback {
        public void onReadyClick();

        public void onCancelReadyClick();
    }
}

