/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.diamondsetting;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import java.util.ArrayList;
import java.util.List;

public class DiamondSettingAdapter
extends RecyclerView.Adapter<DiamondSettingViewHolder> {
    private List<WealthConfigData> mData = new ArrayList<WealthConfigData>();
    private List<Boolean> mIsClicks;
    private int mSelectIndex = 0;

    public DiamondSettingAdapter(List<WealthConfigData> list) {
        this.mData.clear();
        this.mData.addAll(list);
        this.mIsClicks = new ArrayList<Boolean>();
    }

    @NonNull
    public DiamondSettingViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_diamond_setting_channel, parent, false);
        DiamondSettingViewHolder viewHolder = new DiamondSettingViewHolder(view);
        return viewHolder;
    }

    public void onBindViewHolder(final @NonNull DiamondSettingViewHolder holder, final int position) {
        WealthConfigData data = this.mData.get(position);
        if (data != null) {
            Drawable drawable2 = ResourceUtils.getDrawable((int)R.drawable.icon_diamond_36);
            drawable2.setBounds(0, 0, ResolutionUtils.dip2Px((float)18.0f), ResolutionUtils.dip2Px((float)18.0f));
            holder.mTvDiamond.setCompoundDrawables(null, null, drawable2, null);
            holder.mTvDiamond.setText((CharSequence)(data.getDiamond() + ""));
            holder.mTvDiamond.setCompoundDrawablePadding(ResolutionUtils.dip2Px((float)5.0f));
            FontUtils.setFontType((TextView)holder.mTvDiamond, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
            holder.mFlDiamond.setBackgroundResource(R.drawable.shape_1affffff_4dp);
            if (this.mIsClicks.size() > position && this.mIsClicks.get(position).booleanValue()) {
                holder.mFlDiamond.setBackgroundResource(R.drawable.shape_1affffff_4dp_press);
            }
            holder.mFlDiamond.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int length = DiamondSettingAdapter.this.mData.size();
                    for (int i = 0; i < length; ++i) {
                        DiamondSettingAdapter.this.mIsClicks.set(i, false);
                    }
                    DiamondSettingAdapter.this.mIsClicks.set(position, true);
                    holder.mFlDiamond.setBackgroundResource(R.drawable.shape_1affffff_4dp_press);
                    DiamondSettingAdapter.this.notifyDataSetChanged();
                    DiamondSettingAdapter.this.mSelectIndex = position;
                    SettingFlags.setIntValue((String)"key_wealth_config_select", (int)position);
                }
            });
        }
    }

    public int getSelectIndex() {
        return this.mSelectIndex;
    }

    public WealthConfigData getData(int index) {
        if (this.mData == null) {
            return null;
        }
        if (this.mData.size() <= index) {
            return null;
        }
        return this.mData.get(index);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void setSelectIndex(int selectIndex) {
        this.mSelectIndex = selectIndex;
        int length = this.mData.size();
        for (int i = 0; i < length; ++i) {
            if (i == this.mSelectIndex) {
                this.mIsClicks.add(true);
                continue;
            }
            this.mIsClicks.add(false);
        }
    }

    public class DiamondSettingViewHolder
    extends RecyclerView.ViewHolder {
        TextView mTvDiamond;
        FrameLayout mFlDiamond;

        public DiamondSettingViewHolder(View itemView) {
            super(itemView);
            this.mTvDiamond = (TextView)itemView.findViewById(R.id.tv_diamond);
            this.mFlDiamond = (FrameLayout)itemView.findViewById(R.id.fl_diamond);
        }
    }
}

