/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.util.RemoveViewUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.plugins.bocai.DR;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.base.OnAnimFinishCallback;
import com.yy.hiyo.channel.plugins.bocai.base.SimpleSvgaCallback;
import com.yy.hiyo.channel.plugins.bocai.data.bean.ResultGiftItemData;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.ResultWaitPanelPage;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.view.ResultGiftListView;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;
import com.yy.hiyo.game.service.IGameAudioService;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class ResultPublishPanelPage
extends ResultWaitPanelPage {
    private static final String TAG = "FTWealthResultPublishPanelPage";
    private static final DResource[] GIFT_TO_GOLD_SVGA_KEYS = new DResource[]{DR.gift_to_gold_1, DR.gift_to_gold_2, DR.gift_to_gold_3};
    private static final int GOLD_MAX_SIZE = ResolutionUtils.dip2Px((float)12.0f);
    private static final int GOLD_FLY_MIN_DURATION = 430;
    private static final int GOLD_FLY_MAX_DURATION = 560;
    private static final int GOLD_ABSORB_SVGA_SIZE = ResolutionUtils.dip2Px((float)60.0f);
    private static final int WINNER_AVATAR_SHOW_DURATION = 330;
    private int mCurrTotalValue = 0;
    private ResultGiftItemData mCurrWinResult;
    private int mCurrResultCount = 0;
    private ImageView mIvWinnerRing;
    private ImageView mIvWinnerCrown;
    private final List<View> mAnimViewList = new LinkedList<View>();
    private Random mRandom = new Random(System.currentTimeMillis());
    private SVGAImageView mWinnerRibbonSvgaView;

    public void setResultCount(int count) {
        if (this.mGiftListView != null) {
            this.mGiftListView.setItemCount(count);
        }
        this.mCurrResultCount = count;
    }

    public void addResultGiftItem(ResultGiftItemData data) {
        if (data == null) {
            return;
        }
        this.mCurrTotalValue += data.getGameResultInfo().getPrice();
        this.setTotalGiftValue(this.mCurrTotalValue);
        if (this.mCurrWinResult != null) {
            if (this.mCurrWinResult.getGameResultInfo().getPrice() < data.getGameResultInfo().getPrice()) {
                this.mCurrWinResult = data;
                this.updateWinPlayer(data.getGameResultInfo().getUid(), data.isInSeat());
            }
        } else {
            this.mCurrWinResult = data;
            this.updateWinPlayer(data.getGameResultInfo().getUid(), data.isInSeat());
        }
        this.mGiftListView.addResultGiftItem(data);
    }

    public void setResultGiftItemList(List<ResultGiftItemData> dataList) {
        if (dataList == null) {
            return;
        }
        this.mCurrTotalValue = 0;
        this.mCurrWinResult = null;
        for (ResultGiftItemData itemData : dataList) {
            this.mCurrTotalValue += itemData.getGameResultInfo().getPrice();
            if (this.mCurrWinResult == null) {
                this.mCurrWinResult = itemData;
                continue;
            }
            if (this.mCurrWinResult.getGameResultInfo().getPrice() >= itemData.getGameResultInfo().getPrice()) continue;
            this.mCurrWinResult = itemData;
        }
        this.setTotalGiftValue(this.mCurrTotalValue);
        if (this.mCurrWinResult != null) {
            this.updateWinPlayer(this.mCurrWinResult.getGameResultInfo().getUid(), this.mCurrWinResult.isInSeat());
        }
        this.mGiftListView.setResultGiftItems(dataList);
    }

    private void updateWinPlayer(final long uid, final boolean isInSeat) {
        ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).requestUserInfoFromServer(uid, new OnKSProfileListCallback(){

            public void onUISuccess(@NonNull List<UserInfoKS> userInfos) {
                if (userInfos.isEmpty()) {
                    MLog.error((Object)ResultPublishPanelPage.TAG, (String)"updateWinPlayer uid=%d, getUserInfo empty", (Object[])new Object[]{uid});
                    return;
                }
                UserInfoKS userInfo = userInfos.get(0);
                String avatarUrl = userInfo.avatar + YYImageUtils.getThumbnailPostfix((int)38);
                ImageLoader.loadBitmap((Context)ResultPublishPanelPage.this.mAvatarSwitcher.getContext(), (String)avatarUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        if (!RemoveViewUtils.isViewRecycled((View)ResultPublishPanelPage.this.mAvatarSwitcher)) {
                            ResultPublishPanelPage.this.mAvatarSwitcher.setImageResource(R.drawable.ic_bocai_default_avatar);
                        }
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (!RemoveViewUtils.isViewRecycled((View)ResultPublishPanelPage.this.mAvatarSwitcher)) {
                            ResultPublishPanelPage.this.mAvatarSwitcher.setImageDrawable((Drawable)new BitmapDrawable(bitmap));
                        }
                    }
                });
                ResultPublishPanelPage.this.mTvNick.setText((CharSequence)userInfo.nick);
                if (isInSeat) {
                    ResultPublishPanelPage.this.mTvAvatarLeaveTips.setVisibility(8);
                } else {
                    ResultPublishPanelPage.this.mTvAvatarLeaveTips.setVisibility(0);
                }
            }

            public void onError(@NonNull String reason, long code) {
                MLog.error((Object)ResultPublishPanelPage.TAG, (String)"updateWinPlayer uid=%d, getUserInfo error", (Object[])new Object[]{uid});
            }
        });
    }

    public void startWinnerAnim() {
        this.mIvWinnerRing.setVisibility(0);
        this.mIvWinnerCrown.setVisibility(0);
        this.playGiftToGoldAnim(new OnGiftToGoldAnimCallback(){

            @Override
            public void onGiftToGold() {
                ResultPublishPanelPage.this.playGoldFlyAnim(() -> ResultPublishPanelPage.this.playWinnerShowAnim());
            }

            @Override
            public void onAnimFinish() {
            }
        });
    }

    private void playGiftToGoldAnim(final OnGiftToGoldAnimCallback callback) {
        if (!this.isAttached()) {
            return;
        }
        if (this.mAttachedPanel == null || this.mGiftListView == null) {
            return;
        }
        RelativeLayout rootContainer = this.mAttachedPanel.getRootPanelView();
        final LinkedList<SVGAImageView> svgaImageViewList = new LinkedList<SVGAImageView>();
        List<ResultGiftListView.GiftViewHolder> viewHolderList = this.mGiftListView.getViewHolderList();
        ISvgaLoadCallback svgaLoadCallback = new ISvgaLoadCallback(){
            private int finishCount = 0;
            private boolean giftToGoldCalled = false;

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                ++this.finishCount;
                this.checkAllFinish();
            }

            public void onFailed(Exception e) {
                ++this.finishCount;
                this.checkAllFinish();
            }

            private void checkAllFinish() {
                if (this.finishCount == svgaImageViewList.size()) {
                    this.onAllSvgaLoadFinish();
                }
            }

            private void onAllSvgaLoadFinish() {
                for (SVGAImageView svgaImageView : svgaImageViewList) {
                    svgaImageView.startAnimation();
                }
                SVGAImageView svgaImageView = (SVGAImageView)svgaImageViewList.get(svgaImageViewList.size() - 1);
                svgaImageView.setCallback((SVGACallback)new SimpleSvgaCallback(){

                    @Override
                    public void onFinished() {
                        if (callback != null) {
                            if (!giftToGoldCalled) {
                                callback.onGiftToGold();
                            }
                            callback.onAnimFinish();
                        }
                    }

                    @Override
                    public void onStep(int i, double v) {
                        if (i == 40) {
                            if (callback != null) {
                                callback.onGiftToGold();
                            }
                            giftToGoldCalled = true;
                        }
                    }
                });
                if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)) {
                    ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).play("wealth_winner");
                }
            }
        };
        for (int i = 0; i < viewHolderList.size(); ++i) {
            ResultGiftListView.GiftViewHolder viewHolder = viewHolderList.get(i);
            SVGAImageView svgaImageView = this.addGiftToGoldSvgaImageView(rootContainer, viewHolder);
            DResource svgaKey = GIFT_TO_GOLD_SVGA_KEYS[i % GIFT_TO_GOLD_SVGA_KEYS.length];
            DyResLoader.INSTANCE.loadSvga(svgaImageView, svgaKey, svgaLoadCallback);
            svgaImageViewList.add(svgaImageView);
            this.mAnimViewList.add((View)svgaImageView);
        }
        if (svgaImageViewList.size() == 0 && callback != null) {
            callback.onAnimFinish();
        }
    }

    private SVGAImageView addGiftToGoldSvgaImageView(RelativeLayout rootContainer, ResultGiftListView.GiftViewHolder giftViewHolder) {
        RecycleImageView giftView = giftViewHolder.getGiftView();
        int[] giftViewLocationInWindow = new int[2];
        giftView.getLocationInWindow(giftViewLocationInWindow);
        int[] rootLocationInWindow = new int[2];
        rootContainer.getLocationInWindow(rootLocationInWindow);
        SVGAImageView svgaImageView = new SVGAImageView(rootContainer.getContext());
        svgaImageView.setLoops(1);
        int giftWidth = giftView.getMeasuredWidth();
        int giftHeight = giftView.getMeasuredHeight();
        int svgaWidth = giftViewHolder.getItemView().getMeasuredWidth() + ResolutionUtils.dip2Px((float)5.0f);
        int svgaHeight = svgaWidth * 4 / 3;
        int[] svgaLocationInRoot = new int[]{giftViewLocationInWindow[0] + giftWidth / 2 - svgaWidth / 2 - rootLocationInWindow[0], giftViewLocationInWindow[1] + giftHeight / 2 - svgaHeight / 2 - rootLocationInWindow[1]};
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(svgaWidth, svgaHeight);
        lp.leftMargin = svgaLocationInRoot[0];
        lp.topMargin = svgaLocationInRoot[1];
        if (Build.VERSION.SDK_INT >= 17) {
            lp.setMarginStart(svgaLocationInRoot[0]);
        }
        rootContainer.addView((View)svgaImageView, (ViewGroup.LayoutParams)lp);
        return svgaImageView;
    }

    private void playGoldFlyAnim(final OnAnimFinishCallback callback) {
        if (!this.isAttached()) {
            return;
        }
        if (this.mAttachedPanel == null || this.mGiftListView == null) {
            return;
        }
        RelativeLayout rootContainer = this.mAttachedPanel.getRootPanelView();
        int[] rootViewLocationInWindow = new int[2];
        rootContainer.getLocationInWindow(rootViewLocationInWindow);
        int[] avatarViewLocationInWindow = new int[2];
        this.mAvatarContainer.getLocationInWindow(avatarViewLocationInWindow);
        int[] avatarViewCenterLocationInRoot = new int[]{avatarViewLocationInWindow[0] + this.mAvatarContainer.getMeasuredWidth() / 2 - rootViewLocationInWindow[0], avatarViewLocationInWindow[1] + this.mAvatarContainer.getMeasuredHeight() / 2 - rootViewLocationInWindow[1]};
        final SVGAImageView goldAbsorbSvgaImageView = new SVGAImageView(rootContainer.getContext());
        RelativeLayout.LayoutParams goldAbsorbLp = new RelativeLayout.LayoutParams(GOLD_ABSORB_SVGA_SIZE, GOLD_ABSORB_SVGA_SIZE);
        int left = avatarViewCenterLocationInRoot[0] - GOLD_ABSORB_SVGA_SIZE / 2;
        int right = avatarViewCenterLocationInRoot[1] - GOLD_ABSORB_SVGA_SIZE / 2;
        goldAbsorbLp.leftMargin = left;
        goldAbsorbLp.topMargin = right;
        if (Build.VERSION.SDK_INT >= 17) {
            goldAbsorbLp.setMarginStart(left);
            goldAbsorbLp.setMarginEnd(right);
        }
        rootContainer.addView((View)goldAbsorbSvgaImageView, (ViewGroup.LayoutParams)goldAbsorbLp);
        this.mAnimViewList.add((View)goldAbsorbSvgaImageView);
        List<ResultGiftListView.GiftViewHolder> viewHolderList = this.mGiftListView.getViewHolderList();
        AnimatorSet giftAlphaAnimSet = new AnimatorSet();
        for (ResultGiftListView.GiftViewHolder viewHolder : viewHolderList) {
            ObjectAnimator giftAlphaAnimator = ObjectAnimator.ofFloat((Object)viewHolder.getItemView(), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            giftAlphaAnimSet.playTogether(new Animator[]{giftAlphaAnimator});
            int[] goldViewCenterLocationInRoot = new int[2];
            final ImageView goldFlyImageView = this.addGoldFlyImageView(rootContainer, viewHolder, goldViewCenterLocationInRoot);
            this.mAnimViewList.add((View)goldFlyImageView);
            int transX = avatarViewCenterLocationInRoot[0] - goldViewCenterLocationInRoot[0];
            int transY = avatarViewCenterLocationInRoot[1] - goldViewCenterLocationInRoot[1];
            if (LanguageUtils.isRtl()) {
                transX = -transX;
            }
            ObjectAnimator transXAnim = ObjectAnimator.ofFloat((Object)goldFlyImageView, (String)"translationX", (float[])new float[]{0.0f, transX});
            ObjectAnimator transYAnim = ObjectAnimator.ofFloat((Object)goldFlyImageView, (String)"translationY", (float[])new float[]{0.0f, transY});
            AnimatorSet goldFlyAnimSet = new AnimatorSet();
            goldFlyAnimSet.playTogether(new Animator[]{transXAnim, transYAnim});
            goldFlyAnimSet.setDuration((long)(430 + this.mRandom.nextInt(130)));
            goldFlyAnimSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    goldFlyImageView.setVisibility(8);
                }
            });
            goldFlyAnimSet.start();
        }
        giftAlphaAnimSet.setDuration(430L);
        giftAlphaAnimSet.start();
        YYTaskExecutor.postToMainThread(() -> {
            DyResLoader.INSTANCE.loadSvga(goldAbsorbSvgaImageView, DR.gold_absorb, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    goldAbsorbSvgaImageView.startAnimation();
                }

                public void onFailed(Exception e) {
                }
            });
            goldAbsorbSvgaImageView.setLoops(1);
            goldAbsorbSvgaImageView.setCallback((SVGACallback)new SimpleSvgaCallback(){

                @Override
                public void onFinished() {
                    if (callback != null) {
                        callback.onAnimFinish();
                    }
                }
            });
        }, (long)560L);
    }

    private ImageView addGoldFlyImageView(RelativeLayout rootContainer, ResultGiftListView.GiftViewHolder giftViewHolder, int[] centerLocationInRoot) {
        int[] giftViewLocationInWindow = new int[2];
        giftViewHolder.getGiftView().getLocationInWindow(giftViewLocationInWindow);
        int[] rootViewLocationInWindow = new int[2];
        rootContainer.getLocationInWindow(rootViewLocationInWindow);
        int goldSize = GOLD_MAX_SIZE * (80 + this.mRandom.nextInt(20)) / 100;
        int[] goldViewLocationInRoot = new int[]{giftViewLocationInWindow[0] + giftViewHolder.getGiftView().getMeasuredWidth() / 2 - goldSize / 2 - rootViewLocationInWindow[0], giftViewLocationInWindow[1] + giftViewHolder.getGiftView().getMeasuredHeight() / 2 - goldSize / 2 - rootViewLocationInWindow[1]};
        if (centerLocationInRoot != null) {
            if (centerLocationInRoot.length > 0) {
                centerLocationInRoot[0] = goldViewLocationInRoot[0] + goldSize / 2;
            }
            if (centerLocationInRoot.length > 1) {
                centerLocationInRoot[1] = goldViewLocationInRoot[1] + goldSize / 2;
            }
        }
        RecycleImageView goldImageView = new RecycleImageView(rootContainer.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(goldSize, goldSize);
        lp.leftMargin = goldViewLocationInRoot[0];
        lp.topMargin = goldViewLocationInRoot[1];
        if (Build.VERSION.SDK_INT >= 17) {
            lp.setMarginStart(goldViewLocationInRoot[0]);
        }
        rootContainer.addView((View)goldImageView, (ViewGroup.LayoutParams)lp);
        goldImageView.setImageResource(R.drawable.ic_bocai_gold);
        return goldImageView;
    }

    private void playWinnerShowAnim() {
        if (!this.isAttached()) {
            return;
        }
        if (this.mAttachedPanel == null || this.mGiftListView == null) {
            return;
        }
        final AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(330L);
        ObjectAnimator resultBoxTransYAnim = ObjectAnimator.ofFloat((Object)this.mRlResultContainer, (String)"translationY", (float[])new float[]{0.0f, this.mRlResultContainer.getMeasuredHeight()});
        ObjectAnimator resultBoxAlphaAnim = ObjectAnimator.ofFloat((Object)this.mRlResultContainer, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        animatorSet.playTogether(new Animator[]{resultBoxTransYAnim, resultBoxAlphaAnim});
        int avatarTransY = ResolutionUtils.dip2Px((float)32.0f);
        ObjectAnimator avatarTransYAnim = ObjectAnimator.ofFloat((Object)this.mAvatarContainer, (String)"translationY", (float[])new float[]{0.0f, avatarTransY});
        ObjectAnimator avatarScaleXAnim = ObjectAnimator.ofFloat((Object)this.mAvatarContainer, (String)"scaleX", (float[])new float[]{1.0f, 1.6f});
        ObjectAnimator avatarScaleYAnim = ObjectAnimator.ofFloat((Object)this.mAvatarContainer, (String)"scaleY", (float[])new float[]{1.0f, 1.6f});
        animatorSet.playTogether(new Animator[]{avatarTransYAnim, avatarScaleXAnim, avatarScaleYAnim});
        int nickTransY = ResolutionUtils.dip2Px((float)46.0f);
        ObjectAnimator nickTransYAnim = ObjectAnimator.ofFloat((Object)this.mTvNick, (String)"translationY", (float[])new float[]{0.0f, nickTransY});
        animatorSet.playTogether(new Animator[]{nickTransYAnim});
        FrameLayout bgContainer = this.mAttachedPanel.getBgContainer();
        if (this.mWinnerRibbonSvgaView != null) {
            bgContainer.removeView((View)this.mWinnerRibbonSvgaView);
        }
        this.mWinnerRibbonSvgaView = new SVGAImageView(bgContainer.getContext());
        this.mWinnerRibbonSvgaView.setLoops(1);
        bgContainer.addView((View)this.mWinnerRibbonSvgaView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        DyResLoader.INSTANCE.loadSvga(this.mWinnerRibbonSvgaView, DR.winner_ribbon, new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (ResultPublishPanelPage.this.mWinnerRibbonSvgaView != null) {
                    ResultPublishPanelPage.this.mWinnerRibbonSvgaView.startAnimation();
                }
                animatorSet.start();
            }

            public void onFailed(Exception e) {
            }
        });
    }

    @Override
    protected void onInitViews() {
        this.mIvWinnerRing = (ImageView)this.mAvatarContainer.findViewById(R.id.iv_winner_ring);
        this.mIvWinnerCrown = (ImageView)this.mAvatarContainer.findViewById(R.id.iv_winner_crown);
        this.setTotalGiftValue(0);
        this.mTvWaittingTips.setVisibility(8);
        this.mTvAvatarLeaveTips.setVisibility(8);
        int availWidth = ResolutionUtils.getScreenWidth((Context)this.mGiftListView.getContext()) - ResolutionUtils.dip2Px((float)40.0f);
        this.mGiftListView.setAvailableWidth(availWidth);
        this.mGiftListView.setItemCount(this.mCurrResultCount);
        this.mTvAvatarLeaveTips.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
    }

    @Override
    protected void onRemoveViews() {
        if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)) {
            ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).stopAudio("wealth_winner");
        }
        RelativeLayout rootContainer = this.mAttachedPanel.getRootPanelView();
        try {
            for (int i = 0; i < this.mAnimViewList.size(); ++i) {
                View view = this.mAnimViewList.get(i);
                rootContainer.removeView(view);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)("onRemoveViews error, " + e.getMessage()), (Object[])new Object[0]);
        }
        this.mAnimViewList.clear();
        FrameLayout bgContainer = this.mAttachedPanel.getBgContainer();
        if (this.mWinnerRibbonSvgaView != null) {
            bgContainer.removeView((View)this.mWinnerRibbonSvgaView);
        }
        this.mWinnerRibbonSvgaView = null;
    }

    static interface OnGiftToGoldAnimCallback
    extends OnAnimFinishCallback {
        public void onGiftToGold();
    }
}

