/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.data.proto;

import android.text.TextUtils;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import com.yy.hiyo.channel.plugins.bocai.data.proto.INotifyHandlerListener;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.spinach.AutoStartInfo;
import net.ihago.money.api.spinach.CancelInfo;
import net.ihago.money.api.spinach.CloseInfo;
import net.ihago.money.api.spinach.JoinInfo;
import net.ihago.money.api.spinach.MemberResult;
import net.ihago.money.api.spinach.NotPaidInfo;
import net.ihago.money.api.spinach.OpenInfo;
import net.ihago.money.api.spinach.ResultInfo;
import net.ihago.money.api.spinach.SpinachNotify;
import net.ihago.money.api.spinach.Uri;

public class WealthNotifyHandler {
    private INotifyHandlerListener mListener;

    public WealthNotifyHandler(INotifyHandlerListener listener) {
        this.mListener = listener;
    }

    public void handle(SpinachNotify notify) {
        ResultInfo resultInfo;
        if (notify == null) {
            FeatureLog.i((String)"FTWealth", (String)"handle notify null", (Object[])new Object[0]);
            return;
        }
        if (this.mListener == null) {
            FeatureLog.i((String)"FTWealth", (String)"handle listener null", (Object[])new Object[0]);
            return;
        }
        FeatureLog.i((String)"FTWealth", (String)"receive notify:%s", (Object[])new Object[]{notify.uri});
        if (notify.uri == Uri.UriAutoStart) {
            AutoStartInfo autoStartInfo = notify.auto_start_info;
            if (autoStartInfo != null) {
                WealthConfigData wealthConfigData = WealthConfigData.createWealthConfigData(autoStartInfo.diamond, autoStartInfo.conf_id);
                this.mListener.onNotifyAutoStart(autoStartInfo.rid, autoStartInfo.record_id, wealthConfigData);
            }
        } else if (notify.uri == Uri.UriCancel) {
            CancelInfo cancelInfo = notify.cancel_info;
            FeatureLog.i((String)"FTWealth", (String)"WealthNotifyHandler handle cancel, roomId:%s, recordId:%s, result:%s", (Object[])new Object[]{cancelInfo.rid, cancelInfo.record_id, cancelInfo.members});
            if (cancelInfo != null) {
                this.mListener.onNotifyCancel(cancelInfo.rid, cancelInfo.uid, cancelInfo.record_id, cancelInfo.members);
            }
        } else if (notify.uri == Uri.UriClose) {
            CloseInfo closeInfo = notify.close_info;
            if (closeInfo != null) {
                this.mListener.onNotifyClose(closeInfo.rid, closeInfo.record_id);
            }
        } else if (notify.uri == Uri.UriJoin) {
            JoinInfo joinInfo = notify.join_info;
            FeatureLog.i((String)"FTWealth", (String)"WealthNotifyHandler handle join, roomId:%s, recordId:%s, result:%s", (Object[])new Object[]{joinInfo.rid, joinInfo.record_id, joinInfo.members});
            if (joinInfo != null) {
                this.mListener.onNotifyJoin(joinInfo.rid, joinInfo.uid, joinInfo.record_id, joinInfo.members);
            }
        } else if (notify.uri == Uri.UriNotPaid) {
            NotPaidInfo notPaidInfo = notify.not_paid_info;
            FeatureLog.i((String)"FTWealth", (String)"WealthNotifyHandler handle notPaid, uri:%s", (Object[])new Object[]{notPaidInfo.type});
            if (notPaidInfo != null) {
                this.mListener.onNotifyNoEnoughMoney(notPaidInfo.rid, notPaidInfo.record_id, notPaidInfo.uid, notPaidInfo.getTypeValue());
            }
        } else if (notify.uri == Uri.UriOpen) {
            OpenInfo openInfo = notify.open_info;
            if (openInfo != null) {
                WealthConfigData wealthConfigData = WealthConfigData.createWealthConfigData(openInfo.diamond, openInfo.conf_id);
                this.mListener.onNotifyOpen(openInfo.rid, openInfo.record_id, wealthConfigData);
            }
        } else if (notify.uri == Uri.UriResult && (resultInfo = notify.result_info) != null) {
            ArrayList<GameResultInfo> list = new ArrayList<GameResultInfo>();
            List resultList = resultInfo.results;
            if (resultList != null) {
                for (MemberResult result : resultList) {
                    GiftItemInfo giftItemInfo;
                    if (result == null) continue;
                    GameResultInfo gameResultInfo = GameResultInfo.createFromMemberResult(result);
                    if (TextUtils.isEmpty((CharSequence)gameResultInfo.getGiftUrl()) && (giftItemInfo = ((IGiftService)ServiceManagerProxy.getServiceManager().getService(IGiftService.class)).getGift(GiftChannel.USER_ALL_CHANNEL.getChannel(), result.prop_id.intValue())) != null) {
                        gameResultInfo.setGiftUrl(giftItemInfo.getStaticIcon());
                    }
                    list.add(gameResultInfo);
                }
            }
            FeatureLog.i((String)"FTWealth", (String)"WealthNotifyHandler handle result, roomId:%s, recordId:%s, result:%s", (Object[])new Object[]{resultInfo.rid, resultInfo.record_id, list});
            if (list.size() == 0) {
                FeatureLog.i((String)"FTWealth", (String)"WealthNotifyHandler handle result, roomId:%s, recordId:%s, result null", (Object[])new Object[]{resultInfo.rid, resultInfo.record_id});
                return;
            }
            this.mListener.onNotifyResult(resultInfo.rid, resultInfo.record_id, list, resultInfo.time);
        }
    }
}

