/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page;

import android.content.Context;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageSwitcher;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.Size;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.IGamePanel;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.page.BasePanelPage;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.view.ResultGiftListView;

public class ResultWaitPanelPage
extends BasePanelPage {
    protected FrameLayout mAvatarContainer;
    protected ImageSwitcher mAvatarSwitcher;
    protected TextView mTvNick;
    protected TextView mTvAvatarLeaveTips;
    protected RelativeLayout mRlResultContainer;
    protected TextView mTvJackpot;
    protected TextView mTvGiftValue;
    protected TextView mTvWaittingTips;
    protected ResultGiftListView mGiftListView;

    @Override
    public void onAttachToPanel(IGamePanel panel) {
        super.onAttachToPanel(panel);
        this.createView();
    }

    @Override
    public void onDetachFromPanel(IGamePanel panel) {
        this.removeView();
        super.onDetachFromPanel(panel);
    }

    private void createView() {
        if (this.mAttachedPanel == null) {
            return;
        }
        RelativeLayout container = this.mAttachedPanel.getRootPanelView();
        LayoutInflater.from((Context)container.getContext()).inflate(R.layout.layout_bocai_result_panel_channel, (ViewGroup)container);
        this.mAvatarContainer = (FrameLayout)container.findViewById(R.id.fl_avatar_container);
        this.mAvatarSwitcher = (ImageSwitcher)container.findViewById(R.id.switcher_avatar);
        this.mTvAvatarLeaveTips = (TextView)container.findViewById(R.id.tv_avatar_leave_tips);
        this.mTvNick = (TextView)container.findViewById(R.id.tv_nick);
        this.mRlResultContainer = (RelativeLayout)container.findViewById(R.id.rl_result_container);
        this.mTvJackpot = (TextView)container.findViewById(R.id.tv_jackpot);
        this.mTvGiftValue = (TextView)container.findViewById(R.id.tv_gift_value);
        this.mTvWaittingTips = (TextView)container.findViewById(R.id.tv_waitting_tips);
        this.mGiftListView = (ResultGiftListView)container.findViewById(R.id.view_result_gift_list);
        int totalWidth = ResolutionUtils.getScreenWidth((Context)container.getContext()) - ResolutionUtils.dip2Px((float)40.0f);
        this.mTvNick.setMaxWidth((int)((double)totalWidth * 0.22));
        this.mTvGiftValue.setMaxWidth((int)((double)totalWidth * 0.33));
        this.mTvJackpot.setMaxWidth((int)((double)totalWidth * 0.33));
        this.onInitViews();
    }

    protected void onInitViews() {
        this.mAvatarSwitcher.setImageResource(R.drawable.ic_bocai_default_avatar);
        this.mTvAvatarLeaveTips.setVisibility(8);
        this.mTvNick.setText(R.string.short_title_bocai_readying);
        this.setTotalGiftValue(0);
        this.mTvWaittingTips.setText(R.string.short_title_bocai_wait_result);
        this.mGiftListView.setVisibility(8);
    }

    private void removeView() {
        if (this.mAttachedPanel == null) {
            return;
        }
        this.onRemoveViews();
        RelativeLayout container = this.mAttachedPanel.getRootPanelView();
        container.removeView((View)this.mAvatarContainer);
        container.removeView((View)this.mTvNick);
        container.removeView((View)this.mRlResultContainer);
    }

    protected void onRemoveViews() {
    }

    protected void setTotalGiftValue(int totalValue) {
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)R.string.short_title_bocai_total_gift_value)).append((CharSequence)" ").append((CharSequence)String.valueOf(totalValue), new Object[]{new ForegroundColorSpan(ColorUtils.parseColor((String)"#FAFF00"))}).append((CharSequence)" ").append(R.drawable.icon_diamond, Size.of((int)ResolutionUtils.dip2Px((float)10.0f), (int)ResolutionUtils.dip2Px((float)10.0f))).onFinish(spannable -> {
            if (this.mTvGiftValue != null) {
                this.mTvGiftValue.setText((CharSequence)spannable);
            }
        }).build();
    }
}

