/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.game;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.IGameContainerListener;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.IGameStatusChangeListener;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.IGameViewManager;
import com.yy.hiyo.channel.plugins.bocai.ui.view.game.panel.BocaiGamePanel;
import java.util.List;

public class GameViewManager
implements IGameViewManager {
    private IGameContainerListener mGameContainerListener;
    private IGameStatusChangeListener mGameStatusChangeListener;
    private FrameLayout mContainer;
    private BocaiGamePanel mBocaiGamePanel;

    public GameViewManager(FrameLayout container) {
        this.mContainer = container;
    }

    @Override
    public void show(int status) {
        WealthConfigData configData;
        if (this.mContainer == null) {
            return;
        }
        if (this.mBocaiGamePanel == null) {
            int horMargin;
            this.mBocaiGamePanel = new BocaiGamePanel(this.mContainer.getContext());
            this.mBocaiGamePanel.setStatusListener(this.mGameStatusChangeListener);
            this.mBocaiGamePanel.setContainerListener(this.mGameContainerListener);
            if (this.mBocaiGamePanel.getParent() != null && this.mBocaiGamePanel.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.mBocaiGamePanel.getParent()).removeView((View)this.mBocaiGamePanel);
            }
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)140.0f));
            lp.leftMargin = horMargin = ResolutionUtils.dip2Px((float)10.0f);
            lp.rightMargin = horMargin;
            if (Build.VERSION.SDK_INT >= 17) {
                lp.setMarginStart(horMargin);
                lp.setMarginEnd(horMargin);
            }
            this.mContainer.addView((View)this.mBocaiGamePanel, (ViewGroup.LayoutParams)lp);
        }
        if ((configData = WealthDataService.INSTANCE.getWealthDataModel().getConfigData()) == null) {
            this.mBocaiGamePanel.setDimondConfig(0);
        } else {
            this.mBocaiGamePanel.setDimondConfig(configData.getDiamond());
        }
        if (status != 2) {
            boolean isRoomOwner = WealthDataService.INSTANCE.getWealthDataModel().isRoomOwner();
            this.mBocaiGamePanel.setCloseVisibility(isRoomOwner);
        } else {
            this.mBocaiGamePanel.setCloseVisibility(false);
        }
        this.mBocaiGamePanel.updateStatus(status);
    }

    @Override
    public void hide() {
        if (this.mBocaiGamePanel != null) {
            if (this.mContainer != null) {
                this.mContainer.removeView((View)this.mBocaiGamePanel);
            }
            this.mBocaiGamePanel.destroy();
            this.mBocaiGamePanel = null;
        }
    }

    @Override
    public void destroy() {
        if (this.mBocaiGamePanel != null) {
            if (this.mContainer != null) {
                this.mContainer.removeView((View)this.mBocaiGamePanel);
            }
            this.mBocaiGamePanel.destroy();
            this.mBocaiGamePanel = null;
        }
    }

    @Override
    public void showGameResult(GameResultInfo resultInfo, boolean isLast) {
        if (this.mBocaiGamePanel == null) {
            return;
        }
        this.mBocaiGamePanel.showGameResult(resultInfo, isLast);
    }

    @Override
    public void setGameContainerListener(IGameContainerListener listener) {
        this.mGameContainerListener = listener;
    }

    @Override
    public void setGameStatusChangeListener(IGameStatusChangeListener listener) {
        this.mGameStatusChangeListener = listener;
    }

    @Override
    public void showGameResultList(List<GameResultInfo> gameResultInfoList) {
        if (this.mBocaiGamePanel == null) {
            return;
        }
        this.mBocaiGamePanel.showAllGameResult(gameResultInfoList);
    }

    @Override
    public void reset(int status) {
        this.hide();
        this.show(status);
    }

    @Override
    public void showWinner() {
        if (this.mBocaiGamePanel != null) {
            this.mBocaiGamePanel.showWinnerAnim();
        }
    }
}

