/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.cbase.tools.ISeatLocationProvider;
import com.yy.hiyo.channel.common.FacePoint;
import com.yy.hiyo.channel.component.seat.SeatLocationPresenter;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.base.AbsWealthPlayManager;
import com.yy.hiyo.channel.plugins.bocai.base.BocaiStatis;
import com.yy.hiyo.channel.plugins.bocai.base.DefaultWealthViewManager;
import com.yy.hiyo.channel.plugins.bocai.base.IWealthViewManager;
import com.yy.hiyo.channel.plugins.bocai.base.WealthPlayManager;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.data.bean.GameResultInfo;
import com.yy.hiyo.channel.plugins.bocai.data.bean.WealthConfigData;
import com.yy.hiyo.channel.plugins.bocai.data.proto.ProtoServiceManager;
import com.yy.hiyo.channel.plugins.bocai.seat.WealthSeatPresenter;
import com.yy.hiyo.channel.plugins.bocai.ui.view.diamondsetting.DiamondSettingViewManager;
import com.yy.hiyo.channel.plugins.bocai.ui.view.diamondsetting.IDiamondSettingListener;
import com.yy.hiyo.channel.plugins.bocai.ui.view.diamondsetting.IDiamondSettingViewManager;
import com.yy.hiyo.channel.plugins.voiceroom.AbsRoomPage;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.AbsPluginPresenter;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.IPlugin;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.game.prepare.GamePreparePresenter;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameAudioService;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class WealthPlayPresenter
extends AbsPluginPresenter
implements ISeatUpdateListener {
    private IDiamondSettingViewManager mDiamondSettingViewManager;
    private AbsWealthPlayManager mWealthPlayManager;
    private IWealthViewManager mWealthViewManager;
    private ISeatLocationProvider mCallback;
    private boolean mIsCancelRequesting = false;
    @SuppressLint(value={"StaticFieldLeak"})
    private FrameLayout mViewContainer;
    private boolean hasEnterGame = false;
    private IPageLifeCycle mRoomLife = new IPageLifeCycle(){

        public void onShown() {
            if (!WealthPlayPresenter.this.hasEnterGame && WealthPlayPresenter.this.getPage().isPageVisible() && WealthPlayPresenter.this.mWealthPlayManager != null) {
                WealthPlayPresenter.this.mWealthPlayManager.enterGame(WealthPlayPresenter.this.getChannel().getChannelId());
                WealthPlayPresenter.this.hasEnterGame = true;
            }
        }

        public void onAttach() {
            if (!WealthPlayPresenter.this.hasEnterGame && WealthPlayPresenter.this.getPage().isPageVisible() && WealthPlayPresenter.this.mWealthPlayManager != null) {
                WealthPlayPresenter.this.mWealthPlayManager.enterGame(WealthPlayPresenter.this.getChannel().getChannelId());
                WealthPlayPresenter.this.hasEnterGame = true;
            }
        }
    };

    public void onInit(@Nonnull IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.mViewContainer = new YYFrameLayout((Context)mvpContext.getContext());
    }

    public void setContainer(View placeHolderView) {
        if (!(placeHolderView instanceof YYPlaceHolderView)) {
            return;
        }
        ((YYPlaceHolderView)placeHolderView).inflate((View)this.mViewContainer);
    }

    public void handleModeChange(long mode) {
        super.handleModeChange(mode);
        FeatureLog.i((String)"FTWealth", (String)"handleModeChange:%s", (Object[])new Object[]{mode});
        if (this.getChannel() == null) {
            FeatureLog.i((String)"FTWealth", (String)"onPageAttach roomData null", (Object[])new Object[0]);
            return;
        }
        this.initSeatLocationPresenter();
        this.mViewContainer.removeAllViews();
        if (this.mWealthViewManager == null) {
            this.mWealthViewManager = new DefaultWealthViewManager((WealthSeatPresenter)this.getPresenter(SeatPresenter.class));
        }
        if (this.mWealthPlayManager == null) {
            this.mWealthPlayManager = new WealthPlayManager((IChannelPageContext)this.getMvpContext());
        }
        if (!this.hasEnterGame && this.getPage().isPageVisible()) {
            this.mWealthPlayManager.enterGame(this.getChannel().getChannelId());
            this.hasEnterGame = true;
        }
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().addLifeListener(this.mRoomLife);
        this.mWealthPlayManager.bind((IChannelPageContext)this.getMvpContext(), (AbsRoomPage)this.getPage(), this.mViewContainer, this.mWealthViewManager);
        this.mWealthViewManager.setSeatLocationCallback((IChannelPageContext)this.getMvpContext(), this.mCallback);
        WealthDataService.INSTANCE.getWealthDataModel().setRoomData((IChannel)this.getChannel());
        this.setGameContainerVisibility(true);
        ((GamePreparePresenter)this.getPresenter(GamePreparePresenter.class)).onGameStateChanged("GAMING");
        this.getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
    }

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        FeatureLog.i((String)"FTWealth", (String)"onPageAttach", (Object[])new Object[0]);
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        FeatureLog.i((String)"FTWealth", (String)"onPageDetach", (Object[])new Object[0]);
    }

    public boolean interceptModeChange() {
        super.interceptModeChange();
        FeatureLog.i((String)"FTWealth", (String)"interceptModeChange", (Object[])new Object[0]);
        if (this.mWealthPlayManager != null) {
            this.mWealthPlayManager.onDestroy();
        }
        if (this.mWealthViewManager != null) {
            this.mWealthViewManager.destroy();
        }
        this.getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
        if ((this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid()) || this.getChannel().getRoleService().isMeAnchor()) && WealthDataService.INSTANCE.getWealthDataModel().getGameStatus() != 6) {
            this.closeGame();
        }
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().removeLifeListener(this.mRoomLife);
        return false;
    }

    public void resumePlugin() {
        super.resumePlugin();
        FeatureLog.i((String)"FTWealth", (String)"resumePlugin", (Object[])new Object[0]);
        this.getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
        this.initSeatLocationPresenter();
    }

    private void initSeatLocationPresenter() {
        ((IChannelPageContext)this.getMvpContext()).getPresenter(SeatLocationPresenter.class);
    }

    public void closeGame() {
        long recordId = WealthDataService.INSTANCE.getWealthDataModel().getRecordId();
        WealthDataService.INSTANCE.getProtoServiceManager().close(this.getChannel().getChannelId(), recordId, new ProtoServiceManager.IWealthCommonCallback(){

            @Override
            public void onSuccess(String roomId, long recordId) {
                WealthDataService.INSTANCE.getWealthDataModel().setGameStatus(6);
                WealthPlayPresenter.this.hasEnterGame = false;
                FeatureLog.i((String)"FTWealth", (String)"closeGame success, roomId:%s, recordId:%s", (Object[])new Object[]{roomId, recordId});
            }

            @Override
            public void onFail(long code, String reason) {
                FeatureLog.i((String)"FTWealth", (String)"closeGame fail, code:%s, reason:%s", (Object[])new Object[]{code, reason});
            }
        });
    }

    public void openDiamondSetting(final IWealthOpenCallback callback) {
        if (this.mDiamondSettingViewManager == null) {
            this.mDiamondSettingViewManager = new DiamondSettingViewManager();
        }
        WealthDataService.INSTANCE.getProtoServiceManager().getConfig(new ProtoServiceManager.IGetConfigCallback(){

            @Override
            public void onSuccess(List<WealthConfigData> list, int minMember, int maxMember) {
                if (WealthPlayPresenter.this.mDiamondSettingViewManager != null) {
                    WealthPlayPresenter.this.mDiamondSettingViewManager.show((DefaultWindow)WealthPlayPresenter.this.getWindow(), list, new IDiamondSettingListener(){

                        @Override
                        public void onConfigSelected(WealthConfigData data) {
                            BocaiStatis.reportSelectLevelClick(WealthPlayPresenter.this.getChannel().getChannelId(), data.getDiamond());
                            FeatureLog.i((String)"FTWealth", (String)"onConfigSelected:%s", (Object[])new Object[]{data});
                            WealthDataService.INSTANCE.getWealthDataModel().setConfigData(data);
                            WealthDataService.INSTANCE.getProtoServiceManager().open(WealthPlayPresenter.this.getChannel().getChannelId(), data.getConfigId(), new ProtoServiceManager.IOpenCallback(){

                                @Override
                                public void onSuccess(String roomId, int confId, long recordId) {
                                    WealthDataService.INSTANCE.getWealthDataModel().setRecordId(recordId);
                                    if (callback != null) {
                                        callback.onSwitch();
                                    }
                                }

                                @Override
                                public void onFail(long code, String reason) {
                                    WealthDataService.INSTANCE.getProtoServiceManager().getInfo(WealthPlayPresenter.this.getChannel().getChannelId(), new ProtoServiceManager.IGetInfoCallback(){

                                        @Override
                                        public void onSuccess(String roomId, long recordId, long stateChangedSec, WealthConfigData wealthConfigData, List<GameResultInfo> list, int status, int maxDiamond) {
                                            WealthDataService.INSTANCE.getWealthDataModel().setConfigData(wealthConfigData);
                                            WealthDataService.INSTANCE.getWealthDataModel().setMaxDiamond(maxDiamond);
                                            if ((4 == status || 1 == status || 3 == status) && callback != null) {
                                                FeatureLog.i((String)"FTWealth", (String)"switch dayingjia", (Object[])new Object[0]);
                                                callback.onSwitch();
                                            }
                                        }

                                        @Override
                                        public void onFail(long code, String reason) {
                                            ToastUtils.showToast((Context)((IChannelPageContext)WealthPlayPresenter.this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            }

            @Override
            public void onFail(long code, String reason) {
                ToastUtils.showToast((Context)((IChannelPageContext)WealthPlayPresenter.this.getMvpContext()).getContext(), (int)R.string.check_network_and_retry);
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
        FeatureLog.i((String)"FTWealth", (String)"WealthPlayPresenter onDestroy", (Object[])new Object[0]);
        if (this.mWealthPlayManager != null) {
            this.mWealthPlayManager.onDestroy();
        }
        if (this.mWealthViewManager != null) {
            this.mWealthViewManager.destroy();
        }
        this.cancelJoin();
        WealthDataService.INSTANCE.clear();
        this.getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().removeLifeListener(this.mRoomLife);
        if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)) {
            ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).stopAudio("wealth_open");
            ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).stopAudio("wealth_winner");
        }
    }

    private void cancelJoin() {
        if (this.mIsCancelRequesting) {
            FeatureLog.i((String)"FTWealth", (String)"cancelJoin requesting", (Object[])new Object[0]);
            return;
        }
        long recordId = WealthDataService.INSTANCE.getWealthDataModel().getRecordId();
        if (recordId == 0L) {
            FeatureLog.i((String)"FTWealth", (String)"cancelJoin recordId 0", (Object[])new Object[0]);
            return;
        }
        if (WealthDataService.INSTANCE.getWealthDataModel().getGameStatus() == 0 || WealthDataService.INSTANCE.getWealthDataModel().getGameStatus() == 6) {
            FeatureLog.i((String)"FTWealth", (String)"cancelJoin status none , close", (Object[])new Object[0]);
            return;
        }
        Boolean canStart = (Boolean)WealthDataService.INSTANCE.getWealthDataModel().getCanStart().getValue();
        if (canStart != null && !canStart.booleanValue()) {
            FeatureLog.i((String)"FTWealth", (String)"cancelJoin not join", (Object[])new Object[0]);
            return;
        }
        Boolean selfJoinStatus = (Boolean)WealthDataService.INSTANCE.getWealthDataModel().getSelfJoinStatus().getValue();
        if (selfJoinStatus != null && !selfJoinStatus.booleanValue()) {
            FeatureLog.i((String)"FTWealth", (String)"cancelJoin had canceled", (Object[])new Object[0]);
            return;
        }
        this.mIsCancelRequesting = true;
        WealthDataService.INSTANCE.getProtoServiceManager().cancel(this.getChannel().getChannelId(), recordId, new ProtoServiceManager.IWealthCommonCallback(){

            @Override
            public void onSuccess(String roomId, long recordId) {
                WealthPlayPresenter.this.mIsCancelRequesting = false;
                FeatureLog.i((String)"FTWealth", (String)"cancelJoin cancel success, roomId:%s, recordId:%s", (Object[])new Object[]{roomId, recordId});
                WealthDataService.INSTANCE.getWealthDataModel().setSelfJoin(false);
            }

            @Override
            public void onFail(long code, String reason) {
                WealthPlayPresenter.this.mIsCancelRequesting = false;
                FeatureLog.i((String)"FTWealth", (String)"cancelJoin cancel fail, code:%s, reason:%s", (Object[])new Object[]{code, reason});
            }
        });
    }

    public IPlugin.InterceptPluginChange canBeRemoveWhileRunning(@Nullable GameInfo cur, @Nullable GameInfo next) {
        IPlugin.InterceptPluginChange intercept = new IPlugin.InterceptPluginChange();
        intercept.canChange = WealthDataService.INSTANCE.getWealthDataModel() == null ? true : WealthDataService.INSTANCE.getWealthDataModel().getGameStatus() != 2;
        return intercept;
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        int gameStatus = WealthDataService.INSTANCE.getWealthDataModel().getGameStatus();
        if (this.mWealthViewManager != null && gameStatus != 2 && gameStatus != 3) {
            this.mWealthViewManager.reset(WealthDataService.INSTANCE.getWealthDataModel().getGameStatus());
        }
        List seatUids = this.getChannel().getSeatService().getSeatData().getSeatUidsList();
        boolean isInSeat = false;
        Iterator iterator = seatUids.iterator();
        while (iterator.hasNext()) {
            long uid = (Long)iterator.next();
            if (AccountUtil.getUid() != uid) continue;
            isInSeat = true;
            break;
        }
        if (!isInSeat) {
            this.cancelJoin();
        }
    }

    public void setSeatLocationCallback(ISeatLocationProvider callback) {
        this.mCallback = callback;
    }

    public boolean canChangeSeat() {
        return true;
    }

    public boolean haveSelfFaceLocation() {
        return false;
    }

    public MutableLiveData<Map<Long, FacePoint>> getFaceLocation() {
        return null;
    }

    public boolean interceptRunningState() {
        return false;
    }

    public static interface IWealthOpenCallback {
        public void onSwitch();
    }
}

